'use strict';
const MANIFEST = 'flutter-app-manifest';
const TEMP = 'flutter-temp-cache';
const CACHE_NAME = 'flutter-app-cache';

const RESOURCES = {"assets/AssetManifest.bin": "4d64dc9a16c73d3f976a1cce3b4b4356",
"assets/AssetManifest.bin.json": "e56bdbb6cbce24cc82c30e3a87cb304e",
"assets/AssetManifest.json": "2e0cde389fcc1c7e53550fafa6cece97",
"assets/FontManifest.json": "673664f9bad978bd1910393e3824bb76",
"assets/fonts/MaterialIcons-Regular.otf": "a6340637556215e8c422f4698ba41ff4",
"assets/NOTICES": "cb763c7301e155b3026974ef5d832961",
"assets/packages/comum/assets/fonts/Oxygen-Bold.ttf": "3ada7a9482cb9a123ad501e45053adb3",
"assets/packages/comum/assets/fonts/Oxygen-Regular.ttf": "61d9daf063ba38f2d05f8adb7267e6fd",
"assets/packages/comum/assets/fundo.png": "0fef78c2e14f1f2bca0e0bf3bbb525e4",
"assets/packages/comum/assets/img/no-image.png": "82907bfea9fe97e84861e2ee7c5b4f5b",
"assets/packages/comum/assets/logo.svg": "759e829e899711520da9db5be3fa61e3",
"assets/packages/comum/assets/logo_dark.svg": "b376590e23984fb2c4bbfb395fa9ef79",
"assets/packages/comum/assets/logo_full.svg": "fd89bbec1944440044acfb50f86c5576",
"assets/packages/comum/assets/logo_light.svg": "0d160035f252b9cbf8fb478c9ad4dc74",
"assets/packages/comum/assets/logo_min.svg": "a915c0865457d0433e9048e06c3936e2",
"assets/packages/comum/assets/logo_sat.png": "c3a041833a8af78cfde9c3cfb2030735",
"assets/packages/comum/assets/svg/add.svg": "09f49659865bfbb733f1903cfb7670c7",
"assets/packages/comum/assets/svg/add_barcode.svg": "4d391f3a584c08a660607259e2387183",
"assets/packages/comum/assets/svg/alternate.svg": "3e21e10688de90da17b250807d539526",
"assets/packages/comum/assets/svg/arrow_up.svg": "1e324def391c3e55b06dd9aa6542fc07",
"assets/packages/comum/assets/svg/arrow_upward.svg": "aa4c923e9da0c4e08bace3bec3486439",
"assets/packages/comum/assets/svg/barcode.svg": "9c8f077eb4deff3f48d09f29662545a0",
"assets/packages/comum/assets/svg/calculator.svg": "56efe1f200f78674c63b8fb10a145b22",
"assets/packages/comum/assets/svg/calendar.svg": "008a5df01825a9af793d5a17ac202802",
"assets/packages/comum/assets/svg/camera.svg": "fb35a7748a58cf2b844259573f7e5531",
"assets/packages/comum/assets/svg/cancel.svg": "b855823c6098aa9464f48564e205496d",
"assets/packages/comum/assets/svg/cancel_circle.svg": "bfd16fecd66cfa1b7dfa5dd47096803e",
"assets/packages/comum/assets/svg/card.svg": "9b3e79d1355622c1a1f05986ab09b074",
"assets/packages/comum/assets/svg/cash_receivement.svg": "41a168abd7dea88e2fe0a4abeabdc2f5",
"assets/packages/comum/assets/svg/change.svg": "40000c8cb551fe5517462465343d98d5",
"assets/packages/comum/assets/svg/check.svg": "7b4767abe43cd20fcb4d01c79dd756fa",
"assets/packages/comum/assets/svg/checked.svg": "3cf44b7a02e43105756358b170b9cea6",
"assets/packages/comum/assets/svg/check_balance.svg": "ae19d57ea8d42eb13875a524170a1e08",
"assets/packages/comum/assets/svg/check_circle.svg": "34d590bb75d13209c6714e0d5e55c98e",
"assets/packages/comum/assets/svg/check_orders.svg": "21a3e976833076f5ef30d677c10d04ff",
"assets/packages/comum/assets/svg/consult.svg": "7afebb58c67906c35adafc83d7630305",
"assets/packages/comum/assets/svg/copy.svg": "fbed2fcae08ef4d5c07d5d77d9510a45",
"assets/packages/comum/assets/svg/copy2.svg": "d00dec950f6a6a7754576085d8413169",
"assets/packages/comum/assets/svg/cost.svg": "9279995ea835d53c4537acf1da4d29ce",
"assets/packages/comum/assets/svg/db_update.svg": "7018d1be70eee047b007cf873b366fa0",
"assets/packages/comum/assets/svg/delete.svg": "f11dff2f8143e85bdf435fc185807eef",
"assets/packages/comum/assets/svg/delivery_product.svg": "99175752576b4ac99a2c0f8042b74199",
"assets/packages/comum/assets/svg/description.svg": "21a5348cc27d9ce89d23b555103dd415",
"assets/packages/comum/assets/svg/detailed_description.svg": "d9bcc306b4b369793b04b0064d2d52e4",
"assets/packages/comum/assets/svg/discount.svg": "f62b03dfad8ca0b7536ecdcc622b9d49",
"assets/packages/comum/assets/svg/discounts.svg": "196e61a5772f0026debe799b52f164bf",
"assets/packages/comum/assets/svg/discount_nf_e.svg": "ca1d7e3dd085bedc1f17aff9f4179c75",
"assets/packages/comum/assets/svg/dollar_sign.svg": "da6ce899220ebb680c3cefe11b595dee",
"assets/packages/comum/assets/svg/edit.svg": "722fe02acd1bb53958319373c93fd470",
"assets/packages/comum/assets/svg/edit_orange.svg": "0bce69838c6748d2ecee767b6b26fbb5",
"assets/packages/comum/assets/svg/email.svg": "b57ffa83a12456a7498428de7ffb06c4",
"assets/packages/comum/assets/svg/eraser.svg": "fad528b1e69bdf6d05cbe5e846169326",
"assets/packages/comum/assets/svg/export.svg": "255aded5ed5f8d7ab45ad1229ed1b034",
"assets/packages/comum/assets/svg/first.svg": "2f28846e51d462c8ac9b6ad5cbdf6fa1",
"assets/packages/comum/assets/svg/hour.svg": "1793e7699a9c5aed9b07ed8140244cbc",
"assets/packages/comum/assets/svg/import.svg": "8a482fc2e821ec9b2c6a0e462b3e6832",
"assets/packages/comum/assets/svg/import2.svg": "43b2c274608f956e6ad9914d077c443a",
"assets/packages/comum/assets/svg/import_xml.svg": "2edc99d17832484b499af96f46db7ec3",
"assets/packages/comum/assets/svg/info.svg": "32e540f52b1b5b0d514e4ba0b9534622",
"assets/packages/comum/assets/svg/insert.svg": "ce5d9c63fcf74a8f8b117997df53f3a9",
"assets/packages/comum/assets/svg/insert_item.svg": "70efcd014cdcbffe4e6148450fe0e2df",
"assets/packages/comum/assets/svg/insert_payment.svg": "efe16315c4ce6dc1410d6277c2d82ef0",
"assets/packages/comum/assets/svg/insert_product.svg": "fd4df90e3d055058b25c2338a85836ac",
"assets/packages/comum/assets/svg/insert_something.svg": "915c6af5ae048219531a2b92b42c5be6",
"assets/packages/comum/assets/svg/insert_st.svg": "82e8be8d7c5a4d81655b27f06ba4937e",
"assets/packages/comum/assets/svg/last.svg": "cb0fbeb77c7b11414b9232d6e3f7d3c9",
"assets/packages/comum/assets/svg/leftovers.svg": "5d7610376bf5acc222b5a35b2f5e9109",
"assets/packages/comum/assets/svg/letter.svg": "b57ffa83a12456a7498428de7ffb06c4",
"assets/packages/comum/assets/svg/like.svg": "851fb5c04a9f6a8e858d0a4ab556589e",
"assets/packages/comum/assets/svg/list.svg": "962adafc1b232c1096b4e10054e6e453",
"assets/packages/comum/assets/svg/log.svg": "bd079ed61edca323bec321316f31c675",
"assets/packages/comum/assets/svg/marketing_structure.svg": "fea59d8d6976261a20468d282c558273",
"assets/packages/comum/assets/svg/menu.svg": "4fa62a6ba60195412cc9be34106269b7",
"assets/packages/comum/assets/svg/monetization.svg": "d1eefb4ac6dac7c6780761edb0f914d7",
"assets/packages/comum/assets/svg/money_report.svg": "0b87e0d436137de93abc141bf9157fa1",
"assets/packages/comum/assets/svg/new_file.svg": "bb76d16d0b79309ed454f2f979a7b657",
"assets/packages/comum/assets/svg/new_printer.svg": "504f6847c641c2912399001c300f701a",
"assets/packages/comum/assets/svg/new_product.svg": "5200b60405baa648a17bca713101a9e6",
"assets/packages/comum/assets/svg/next.svg": "5aa4178625572a1f74a34ab6540a8ab3",
"assets/packages/comum/assets/svg/nf_e.svg": "835df158cf2179eafbf8627e1dceae84",
"assets/packages/comum/assets/svg/nf_e_cancel.svg": "133f16919cb98eb95b29b40cc84293ae",
"assets/packages/comum/assets/svg/nf_e_reprint.svg": "2fce66efe076cce67e02e1937e189155",
"assets/packages/comum/assets/svg/on_off.svg": "d41d8cd98f00b204e9800998ecf8427e",
"assets/packages/comum/assets/svg/order.svg": "77e1a0e8b3a2bedd58b9670a2c95350c",
"assets/packages/comum/assets/svg/order_of.svg": "52f4568b51abb6f00aa0aa6fd7a5b827",
"assets/packages/comum/assets/svg/order_status.svg": "1d2287fb44d12ef2a52c028e54887c7f",
"assets/packages/comum/assets/svg/pen.svg": "98a3dd918c7d6014bd114ac397eae985",
"assets/packages/comum/assets/svg/percentage.svg": "7a3060a1733c8b27ae072453a0495782",
"assets/packages/comum/assets/svg/percentage_x.svg": "6646fcba3476ef58b1f30b09f143edd8",
"assets/packages/comum/assets/svg/previous.svg": "5aa4178625572a1f74a34ab6540a8ab3",
"assets/packages/comum/assets/svg/print4.svg": "986f6d623628ed5185da122a3392627e",
"assets/packages/comum/assets/svg/printer.svg": "016cd03ad89db9c6a1e1892b76c1528e",
"assets/packages/comum/assets/svg/profit.svg": "c24bdf39093c1f424bc081b95d348133",
"assets/packages/comum/assets/svg/red_check.svg": "9b7e1d018c206f3ccba6da4fc3cb1405",
"assets/packages/comum/assets/svg/refund.svg": "0c9e9b9f44c945f38efce145cf4f0115",
"assets/packages/comum/assets/svg/register.svg": "c76eec9696d4cff02ed5139e7f499951",
"assets/packages/comum/assets/svg/remove.svg": "187ee133d248737e4a6b519385025f37",
"assets/packages/comum/assets/svg/remover.svg": "1129d8a7b757eed6f869a8abca9a882a",
"assets/packages/comum/assets/svg/reorder.svg": "fce1295bde283d42480091290bc7940a",
"assets/packages/comum/assets/svg/report.svg": "c76eec9696d4cff02ed5139e7f499951",
"assets/packages/comum/assets/svg/reprint.svg": "3ba43bca00ea309d41186000c9311807",
"assets/packages/comum/assets/svg/restore.svg": "86d92c537a4caf1a80fecdfe35f3464c",
"assets/packages/comum/assets/svg/reverse.svg": "504da25cff3f46f040ea99f0310e7050",
"assets/packages/comum/assets/svg/save.svg": "0c2af1905c67baefcc096884c7fc0786",
"assets/packages/comum/assets/svg/schedule.svg": "3213ab7f505fe90360dd06607e165a4e",
"assets/packages/comum/assets/svg/search.svg": "a1ff72fd514c57948dbc12a368d8dd60",
"assets/packages/comum/assets/svg/search_blue.svg": "086ac4eca8407fcfb4a8af63b13a2441",
"assets/packages/comum/assets/svg/search_show.svg": "5809e78e311d7779991b6ac84d630712",
"assets/packages/comum/assets/svg/seller.svg": "c71e0a34c4a84f6e3ded8797f4849051",
"assets/packages/comum/assets/svg/send_history.svg": "87dcd1f46c67016b23d52a6670cbc057",
"assets/packages/comum/assets/svg/service_order.svg": "07b324260ff5953ae5a56b01e29fec6b",
"assets/packages/comum/assets/svg/show_customer_register.svg": "6e40e12d7293aeae0d4bd294e5ec7fae",
"assets/packages/comum/assets/svg/store.svg": "c70c76220d8817d7b61dec510506f744",
"assets/packages/comum/assets/svg/supply_bleed.svg": "1b7d149687802173c8395d06a924d22c",
"assets/packages/comum/assets/svg/throw.svg": "b7fdffad7b311c692b88a1a1c54796fe",
"assets/packages/comum/assets/svg/throw_away.svg": "cc4137c88545738f5f21596057dc3a8c",
"assets/packages/comum/assets/svg/ticket.svg": "0a22263480cb3c3b5dde537e9e2d1ff2",
"assets/packages/comum/assets/svg/trash.svg": "8c39e882f95a1373db54850b3f9ee0fc",
"assets/packages/comum/assets/svg/trash2.svg": "b2af04f4f6f4c562599a241910d5a3ab",
"assets/packages/comum/assets/svg/update_report.svg": "1d2287fb44d12ef2a52c028e54887c7f",
"assets/packages/comum/assets/svg/user_check.svg": "a0fe6d9e07b67d47171a600c814801ec",
"assets/packages/comum/assets/svg/warehouse_car.svg": "6a9aeca3a4641f177f9d16f5a43118d4",
"assets/packages/comum/assets/teste.jpg": "1d40b867cfe30c688ed70c14978ad60f",
"assets/packages/cupertino_icons/assets/CupertinoIcons.ttf": "33b7d9392238c04c131b6ce224e13711",
"assets/packages/simple_barcode_scanner/assets/barcode.html": "55dd479b440ade30760a1b3a4db300f1",
"assets/packages/simple_barcode_scanner/assets/html5-qrcode.min.js": "d88d3200cb547c9e86ee972975561dcd",
"assets/shaders/ink_sparkle.frag": "ecc85a2e95f5e9f53123dcaf8cb9b6ce",
"canvaskit/canvaskit.js": "728b2d477d9b8c14593d4f9b82b484f3",
"canvaskit/canvaskit.js.symbols": "bdcd3835edf8586b6d6edfce8749fb77",
"canvaskit/canvaskit.wasm": "7a3f4ae7d65fc1de6a6e7ddd3224bc93",
"canvaskit/chromium/canvaskit.js": "8191e843020c832c9cf8852a4b909d4c",
"canvaskit/chromium/canvaskit.js.symbols": "b61b5f4673c9698029fa0a746a9ad581",
"canvaskit/chromium/canvaskit.wasm": "f504de372e31c8031018a9ec0a9ef5f0",
"canvaskit/skwasm.js": "ea559890a088fe28b4ddf70e17e60052",
"canvaskit/skwasm.js.symbols": "e72c79950c8a8483d826a7f0560573a1",
"canvaskit/skwasm.wasm": "39dd80367a4e71582d234948adc521c0",
"favicon.png": "afe4f9584a603dadfaa9e3b1609e7d4e",
"flutter.js": "83d881c1dbb6d6bcd6b42e274605b69c",
"flutter_bootstrap.js": "1ad1ed66bc94028d295a62a4f85a6790",
"icons/Icon-192.png": "ac9a721a12bbc803b44f645561ecb1e1",
"icons/Icon-512.png": "96e752610906ba2a93c65f8abe1645f1",
"icons/Icon-maskable-192.png": "c457ef57daa1d16f64b27b786ec2ea3c",
"icons/Icon-maskable-512.png": "301a7604d45b3e739efc881eb04896ea",
"index.html": "067d7a0ad5ef9765bab93873074d0069",
"/": "067d7a0ad5ef9765bab93873074d0069",
"Loading.gif": "6647707d5b408bc6fcec0d4b835438a1",
"main.dart.js": "d7c4a92ccbfe26278d8e127853d311ac",
"manifest.json": "9e8c21f9fc6e054d0a5e68e64f1e5aaa",
"version.json": "cf77aedec3d3792bb8ffd1677a611b65"};
// The application shell files that are downloaded before a service worker can
// start.
const CORE = ["main.dart.js",
"index.html",
"flutter_bootstrap.js",
"assets/AssetManifest.bin.json",
"assets/FontManifest.json"];

// During install, the TEMP cache is populated with the application shell files.
self.addEventListener("install", (event) => {
  self.skipWaiting();
  return event.waitUntil(
    caches.open(TEMP).then((cache) => {
      return cache.addAll(
        CORE.map((value) => new Request(value, {'cache': 'reload'})));
    })
  );
});
// During activate, the cache is populated with the temp files downloaded in
// install. If this service worker is upgrading from one with a saved
// MANIFEST, then use this to retain unchanged resource files.
self.addEventListener("activate", function(event) {
  return event.waitUntil(async function() {
    try {
      var contentCache = await caches.open(CACHE_NAME);
      var tempCache = await caches.open(TEMP);
      var manifestCache = await caches.open(MANIFEST);
      var manifest = await manifestCache.match('manifest');
      // When there is no prior manifest, clear the entire cache.
      if (!manifest) {
        await caches.delete(CACHE_NAME);
        contentCache = await caches.open(CACHE_NAME);
        for (var request of await tempCache.keys()) {
          var response = await tempCache.match(request);
          await contentCache.put(request, response);
        }
        await caches.delete(TEMP);
        // Save the manifest to make future upgrades efficient.
        await manifestCache.put('manifest', new Response(JSON.stringify(RESOURCES)));
        // Claim client to enable caching on first launch
        self.clients.claim();
        return;
      }
      var oldManifest = await manifest.json();
      var origin = self.location.origin;
      for (var request of await contentCache.keys()) {
        var key = request.url.substring(origin.length + 1);
        if (key == "") {
          key = "/";
        }
        // If a resource from the old manifest is not in the new cache, or if
        // the MD5 sum has changed, delete it. Otherwise the resource is left
        // in the cache and can be reused by the new service worker.
        if (!RESOURCES[key] || RESOURCES[key] != oldManifest[key]) {
          await contentCache.delete(request);
        }
      }
      // Populate the cache with the app shell TEMP files, potentially overwriting
      // cache files preserved above.
      for (var request of await tempCache.keys()) {
        var response = await tempCache.match(request);
        await contentCache.put(request, response);
      }
      await caches.delete(TEMP);
      // Save the manifest to make future upgrades efficient.
      await manifestCache.put('manifest', new Response(JSON.stringify(RESOURCES)));
      // Claim client to enable caching on first launch
      self.clients.claim();
      return;
    } catch (err) {
      // On an unhandled exception the state of the cache cannot be guaranteed.
      console.error('Failed to upgrade service worker: ' + err);
      await caches.delete(CACHE_NAME);
      await caches.delete(TEMP);
      await caches.delete(MANIFEST);
    }
  }());
});
// The fetch handler redirects requests for RESOURCE files to the service
// worker cache.
self.addEventListener("fetch", (event) => {
  if (event.request.method !== 'GET') {
    return;
  }
  var origin = self.location.origin;
  var key = event.request.url.substring(origin.length + 1);
  // Redirect URLs to the index.html
  if (key.indexOf('?v=') != -1) {
    key = key.split('?v=')[0];
  }
  if (event.request.url == origin || event.request.url.startsWith(origin + '/#') || key == '') {
    key = '/';
  }
  // If the URL is not the RESOURCE list then return to signal that the
  // browser should take over.
  if (!RESOURCES[key]) {
    return;
  }
  // If the URL is the index.html, perform an online-first request.
  if (key == '/') {
    return onlineFirst(event);
  }
  event.respondWith(caches.open(CACHE_NAME)
    .then((cache) =>  {
      return cache.match(event.request).then((response) => {
        // Either respond with the cached resource, or perform a fetch and
        // lazily populate the cache only if the resource was successfully fetched.
        return response || fetch(event.request).then((response) => {
          if (response && Boolean(response.ok)) {
            cache.put(event.request, response.clone());
          }
          return response;
        });
      })
    })
  );
});
self.addEventListener('message', (event) => {
  // SkipWaiting can be used to immediately activate a waiting service worker.
  // This will also require a page refresh triggered by the main worker.
  if (event.data === 'skipWaiting') {
    self.skipWaiting();
    return;
  }
  if (event.data === 'downloadOffline') {
    downloadOffline();
    return;
  }
});
// Download offline will check the RESOURCES for all files not in the cache
// and populate them.
async function downloadOffline() {
  var resources = [];
  var contentCache = await caches.open(CACHE_NAME);
  var currentContent = {};
  for (var request of await contentCache.keys()) {
    var key = request.url.substring(origin.length + 1);
    if (key == "") {
      key = "/";
    }
    currentContent[key] = true;
  }
  for (var resourceKey of Object.keys(RESOURCES)) {
    if (!currentContent[resourceKey]) {
      resources.push(resourceKey);
    }
  }
  return contentCache.addAll(resources);
}
// Attempt to download the resource online before falling back to
// the offline cache.
function onlineFirst(event) {
  return event.respondWith(
    fetch(event.request).then((response) => {
      return caches.open(CACHE_NAME).then((cache) => {
        cache.put(event.request, response.clone());
        return response;
      });
    }).catch((error) => {
      return caches.open(CACHE_NAME).then((cache) => {
        return cache.match(event.request).then((response) => {
          if (response != null) {
            return response;
          }
          throw error;
        });
      });
    })
  );
}
