/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jpos.config;

import com.ibm.jpos.config.ASCII_CharStream;
import com.ibm.jpos.config.ConfigParserConstants;
import com.ibm.jpos.config.ConfigParserTokenManager;
import com.ibm.jpos.config.ParseException;
import com.ibm.jpos.config.Token;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import jpos.config.simple.SimpleEntry;

class ConfigParser
implements ConfigParserConstants {
    private ObjectOutputStream outStream = null;
    private PrintWriter logWriter = null;
    private SimpleEntry businessCard = null;
    private Hashtable attrs = new Hashtable();
    private boolean inBusinessCard = false;
    private boolean inBusinessCardAttrs = false;
    private boolean inPropertyAttrs = false;
    public ConfigParserTokenManager token_source;
    ASCII_CharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private Token jj_scanpos;
    private Token jj_lastpos;
    private int jj_la;
    public boolean lookingAhead = false;
    private boolean jj_semLA;
    private int jj_gen;
    private final int[] jj_la1 = new int[13];
    private final int[] jj_la1_0 = new int[]{1438, 1438, 2048, 4096, 98304, 2048, 8192, 16384, 30720, 30720, 98304, 0x3400000, 0x3400000};
    private final JJCalls[] jj_2_rtns = new JJCalls[2];
    private boolean jj_rescan = false;
    private int jj_gc = 0;
    private Vector jj_expentries = new Vector();
    private int[] jj_expentry;
    private int jj_kind = -1;
    private int[] jj_lasttokens = new int[100];
    private int jj_endpos;

    ConfigParser(InputStream inputStream, OutputStream outputStream, OutputStream outputStream2) throws IOException {
        this(inputStream);
        this.outStream = new ObjectOutputStream(outputStream);
        this.logWriter = new PrintWriter(outputStream2, true);
    }

    void start() throws ParseException {
        this.HTMLDocument();
        try {
            this.outStream.close();
        }
        catch (IOException iOException) {
            throw new ParseException("i/o exception while closing output stream");
        }
    }

    String stringPropertyValue(String string) throws ParseException {
        return string;
    }

    Integer integerPropertyValue(String string) throws ParseException {
        long l = 0L;
        Integer n = null;
        try {
            l = string.length() > 2 && string.substring(0, 2).toLowerCase().equals("0x") ? Long.parseLong(string.substring(2), 16) : Long.parseLong(string);
            n = new Integer((int)(l & 0xFFFFFFFFFFFFFFFFL));
        }
        catch (NumberFormatException numberFormatException) {
            throw new ParseException("illegal Integer VALUE: " + string);
        }
        return n;
    }

    Long longPropertyValue(String string) throws ParseException {
        Long l = null;
        try {
            l = string.length() > 2 && string.substring(0, 2).toLowerCase().equals("0x") ? Long.valueOf(string.substring(2), 16) : Long.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new ParseException("illegal Long VALUE: " + string);
        }
        return l;
    }

    Float floatPropertyValue(String string) throws ParseException {
        Object var2_2 = null;
        try {
            return new Float(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new ParseException("illegal Float VALUE: " + string);
        }
    }

    Boolean booleanPropertyValue(String string) throws ParseException {
        Boolean bl = null;
        if (!string.toLowerCase().equals("true") && !string.toLowerCase().equals("false")) {
            throw new ParseException("illegal VALUE: expected \"true\" or \"false\"");
        }
        bl = new Boolean(string);
        return bl;
    }

    Character characterPropertyValue(String string) throws ParseException {
        if (string.length() != 1) {
            throw new ParseException("illegal Character VALUE: " + string);
        }
        return new Character(string.charAt(0));
    }

    Byte bytePropertyValue(String string) throws ParseException {
        long l = 0L;
        Byte by = null;
        try {
            l = string.length() > 2 && string.substring(0, 2).toLowerCase().equals("0x") ? Long.parseLong(string.substring(2), 16) : Long.parseLong(string);
            by = new Byte((byte)(l & 0xFFL));
        }
        catch (NumberFormatException numberFormatException) {
            throw new ParseException("illegal Integer VALUE: " + string);
        }
        return by;
    }

    URL urlPropertyValue(String string) throws ParseException {
        URL uRL = null;
        try {
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            throw new ParseException("illegal VALUE: " + string);
        }
        return uRL;
    }

    public final void HTMLDocument() throws ParseException {
        block13: {
            block12: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 7: 
                    case 8: 
                    case 10: {
                        break;
                    }
                    default: {
                        this.jj_la1[0] = this.jj_gen;
                        break block13;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 1: {
                        this.Tag();
                        continue block12;
                    }
                    case 2: {
                        this.Decl();
                        continue block12;
                    }
                    case 3: {
                        this.CommentTag();
                        continue block12;
                    }
                    case 4: {
                        this.jj_consume_token(4);
                        continue block12;
                    }
                    case 7: {
                        this.jj_consume_token(7);
                        continue block12;
                    }
                    case 10: {
                        this.jj_consume_token(10);
                        continue block12;
                    }
                    case 8: {
                        this.jj_consume_token(8);
                        continue block12;
                    }
                }
                break;
            }
            this.jj_la1[1] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        this.jj_consume_token(0);
    }

    public final Token Tag() throws ParseException {
        String string;
        String string2;
        Token token;
        block59: {
            token = null;
            String string3 = null;
            Token token2 = null;
            Token token3 = null;
            token = this.jj_consume_token(1);
            string3 = token.image.substring(1, token.image.length()).trim().toUpperCase();
            if (string3.toUpperCase().equals("BUSINESSCARD") || string3.toUpperCase().equals("JPOSENTRY")) {
                if (this.inBusinessCard) {
                    throw new ParseException("nested <JPOSENTRY>");
                }
                this.logWriter.println("Start of JposEntry");
                this.businessCard = new SimpleEntry();
                this.attrs.clear();
                this.inBusinessCard = true;
                this.inBusinessCardAttrs = true;
            } else if (this.inBusinessCard && string3.toUpperCase().equals("PROPERTY")) {
                this.logWriter.println("  Property:");
                this.attrs.clear();
                this.inPropertyAttrs = true;
            } else if (string3.toUpperCase().equals("/BUSINESSCARD") || string3.toUpperCase().equals("/JPOSENTRY")) {
                if (!this.inBusinessCard) {
                    if (string3.toUpperCase().equals("/BUSINESSCARD")) {
                        throw new ParseException("</BUSINESSCARD> without <BUSINESSCARD>");
                    }
                    throw new ParseException("</JPOSENTRY> without <JPOSENTRY>");
                }
                this.logWriter.println("End of JposEntry\n");
                this.inBusinessCard = false;
                try {
                    this.outStream.writeObject(this.businessCard);
                    this.outStream.flush();
                }
                catch (IOException iOException) {
                    throw new ParseException("i/o exception while writing to output stream");
                }
            }
            while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 11: {
                        break;
                    }
                    default: {
                        this.jj_la1[2] = this.jj_gen;
                        break block59;
                    }
                }
                token2 = this.jj_consume_token(11);
                token3 = null;
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 12: {
                        this.jj_consume_token(12);
                        token3 = this.AttrValue();
                        break;
                    }
                    default: {
                        this.jj_la1[3] = this.jj_gen;
                    }
                }
                if (this.inBusinessCardAttrs) {
                    this.logWriter.print("  ");
                } else if (this.inPropertyAttrs) {
                    this.logWriter.print("    ");
                }
                if (this.inBusinessCardAttrs || this.inPropertyAttrs) {
                    this.logWriter.print(token2.image + "=");
                    if (token3 == null) {
                        this.logWriter.println("");
                        throw new ParseException("attribute requires value: " + token2.image.toUpperCase());
                    }
                    this.logWriter.println(token3.image);
                }
                if (this.inPropertyAttrs) {
                    string2 = token2.image.toLowerCase();
                    string = token3.image;
                    if (string2.equals("name")) {
                        this.attrs.put(string2, this.stringPropertyValue(string));
                        continue;
                    }
                    if (string2.equals("type")) {
                        if ((string = string.toLowerCase()).equals("string") || string.equals("integer") || string.equals("long") || string.equals("float") || string.equals("boolean") || string.equals("character") || string.equals("byte") || string.equals("url")) {
                            this.attrs.put(string2, string);
                            continue;
                        }
                        throw new ParseException("illegal type: expected String, Integer, Long, Float, Boolean, Character, Byte, or URL");
                    }
                    if (string2.equals("value")) {
                        this.attrs.put(string2, this.stringPropertyValue(string));
                        continue;
                    }
                    throw new ParseException("unknown attribute: " + token2.image);
                }
                if (!this.inBusinessCardAttrs) continue;
                string2 = token2.image.toLowerCase();
                string = token3.image;
                if (string2.equals("serviceclass")) {
                    this.logWriter.println("Warning: deprecated attribute: serviceClass: converting to <PROPERTY>");
                    this.attrs.put(string2, this.stringPropertyValue(string));
                    continue;
                }
                if (string2.equals("logicalName".toLowerCase())) {
                    this.attrs.put(string2, this.stringPropertyValue(string));
                    continue;
                }
                if (!string2.equals("serviceInstanceFactoryClass".toLowerCase())) break;
                this.attrs.put(string2, this.stringPropertyValue(string));
            }
            throw new ParseException("unknown attribute: " + token2.image);
        }
        if (this.inPropertyAttrs) {
            string2 = (String)this.attrs.get("name");
            string = (String)this.attrs.get("type");
            String string4 = (String)this.attrs.get("value");
            if (string2 == null) {
                throw new ParseException("missing attribute: name");
            }
            if (string == null) {
                string = "string";
            }
            if (string4 == null) {
                throw new ParseException("missing attribute: value");
            }
            Object object = null;
            if (string.equals("string")) {
                object = this.stringPropertyValue(string4);
            } else if (string.equals("integer")) {
                object = this.integerPropertyValue(string4);
            } else if (string.equals("long")) {
                object = this.longPropertyValue(string4);
            } else if (string.equals("float")) {
                object = this.floatPropertyValue(string4);
            } else if (string.equals("boolean")) {
                object = this.booleanPropertyValue(string4);
            } else if (string.equals("character")) {
                object = this.characterPropertyValue(string4);
            } else if (string.equals("byte")) {
                object = this.bytePropertyValue(string4);
            } else if (string.equals("url")) {
                object = this.urlPropertyValue(string4);
            } else {
                throw new ParseException("illegal TYPE: " + string);
            }
            this.businessCard.addProperty(string2, object);
        } else if (this.inBusinessCardAttrs) {
            if (!this.attrs.containsKey("logicalName".toLowerCase())) {
                throw new ParseException("missing JposEntry.LOGICAL_NAME_PROP_NAME");
            }
            this.businessCard.addProperty("logicalName", this.attrs.get("logicalName".toLowerCase()));
            if (this.attrs.containsKey("serviceInstanceFactoryClass".toLowerCase())) {
                this.businessCard.addProperty("serviceInstanceFactoryClass", this.attrs.get("serviceInstanceFactoryClass".toLowerCase()));
            } else {
                this.logWriter.println("Warning: missing attribute: serviceInstanceFactoryClass.\n\tDefaulting to com.ibm.jpos.services.IBMJposServiceInstanceFactory");
                this.businessCard.addProperty("serviceInstanceFactoryClass", (Object)"com.ibm.jpos.services.IBMJposServiceInstanceFactory");
            }
            if (this.attrs.containsKey("serviceclass")) {
                this.businessCard.addProperty("serviceClass", this.attrs.get("serviceclass"));
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 15: {
                this.jj_consume_token(15);
                break;
            }
            case 16: {
                this.jj_consume_token(16);
                break;
            }
            default: {
                this.jj_la1[4] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        this.inBusinessCardAttrs = false;
        this.inPropertyAttrs = false;
        return token;
    }

    public final Token AttrValue() throws ParseException {
        Token token = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 11: {
                token = this.jj_consume_token(11);
                return token;
            }
        }
        this.jj_la1[5] = this.jj_gen;
        if (this.jj_2_1(2)) {
            this.jj_consume_token(13);
            token = this.jj_consume_token(18);
            this.jj_consume_token(19);
            return token;
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 13: {
                this.jj_consume_token(13);
                this.jj_consume_token(19);
                return token;
            }
        }
        this.jj_la1[6] = this.jj_gen;
        if (this.jj_2_2(2)) {
            this.jj_consume_token(14);
            token = this.jj_consume_token(20);
            this.jj_consume_token(21);
            return token;
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 14: {
                this.jj_consume_token(14);
                this.jj_consume_token(21);
                return token;
            }
        }
        this.jj_la1[7] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final Token Decl() throws ParseException {
        Token token;
        block12: {
            token = this.jj_consume_token(2);
            block11: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 11: 
                    case 12: 
                    case 13: 
                    case 14: {
                        break;
                    }
                    default: {
                        this.jj_la1[8] = this.jj_gen;
                        break block12;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 11: 
                    case 13: 
                    case 14: {
                        this.AttrValue();
                        continue block11;
                    }
                    case 12: {
                        this.jj_consume_token(12);
                        continue block11;
                    }
                }
                break;
            }
            this.jj_la1[9] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 15: {
                this.jj_consume_token(15);
                break;
            }
            case 16: {
                this.jj_consume_token(16);
                break;
            }
            default: {
                this.jj_la1[10] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return token;
    }

    public final void CommentTag() throws ParseException {
        this.jj_consume_token(3);
        block8: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 22: {
                    this.jj_consume_token(22);
                    break;
                }
                case 25: {
                    this.jj_consume_token(25);
                    break;
                }
                case 24: {
                    this.jj_consume_token(24);
                    break;
                }
                default: {
                    this.jj_la1[11] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 22: 
                case 24: 
                case 25: {
                    continue block8;
                }
            }
            break;
        }
        this.jj_la1[12] = this.jj_gen;
        this.jj_consume_token(23);
    }

    private final boolean jj_2_1(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean bl = !this.jj_3_1();
        this.jj_save(0, n);
        return bl;
    }

    private final boolean jj_2_2(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean bl = !this.jj_3_2();
        this.jj_save(1, n);
        return bl;
    }

    private final boolean jj_3_2() {
        if (this.jj_scan_token(14)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(20)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_1() {
        if (this.jj_scan_token(13)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(18)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    public ConfigParser(InputStream inputStream) {
        this.jj_input_stream = new ASCII_CharStream(inputStream, 1, 1);
        this.token_source = new ConfigParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int n = 0;
        while (n < 13) {
            this.jj_la1[n] = -1;
            ++n;
        }
        int n2 = 0;
        while (n2 < this.jj_2_rtns.length) {
            this.jj_2_rtns[n2] = new JJCalls();
            ++n2;
        }
    }

    public void ReInit(InputStream inputStream) {
        this.jj_input_stream.ReInit(inputStream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int n = 0;
        while (n < 13) {
            this.jj_la1[n] = -1;
            ++n;
        }
        int n2 = 0;
        while (n2 < this.jj_2_rtns.length) {
            this.jj_2_rtns[n2] = new JJCalls();
            ++n2;
        }
    }

    public ConfigParser(Reader reader) {
        this.jj_input_stream = new ASCII_CharStream(reader, 1, 1);
        this.token_source = new ConfigParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int n = 0;
        while (n < 13) {
            this.jj_la1[n] = -1;
            ++n;
        }
        int n2 = 0;
        while (n2 < this.jj_2_rtns.length) {
            this.jj_2_rtns[n2] = new JJCalls();
            ++n2;
        }
    }

    public void ReInit(Reader reader) {
        this.jj_input_stream.ReInit(reader, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int n = 0;
        while (n < 13) {
            this.jj_la1[n] = -1;
            ++n;
        }
        int n2 = 0;
        while (n2 < this.jj_2_rtns.length) {
            this.jj_2_rtns[n2] = new JJCalls();
            ++n2;
        }
    }

    public ConfigParser(ConfigParserTokenManager configParserTokenManager) {
        this.token_source = configParserTokenManager;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int n = 0;
        while (n < 13) {
            this.jj_la1[n] = -1;
            ++n;
        }
        int n2 = 0;
        while (n2 < this.jj_2_rtns.length) {
            this.jj_2_rtns[n2] = new JJCalls();
            ++n2;
        }
    }

    public void ReInit(ConfigParserTokenManager configParserTokenManager) {
        this.token_source = configParserTokenManager;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int n = 0;
        while (n < 13) {
            this.jj_la1[n] = -1;
            ++n;
        }
        int n2 = 0;
        while (n2 < this.jj_2_rtns.length) {
            this.jj_2_rtns[n2] = new JJCalls();
            ++n2;
        }
    }

    private final Token jj_consume_token(int n) throws ParseException {
        Token token = this.token;
        this.token = token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == n) {
            ++this.jj_gen;
            if (++this.jj_gc > 100) {
                this.jj_gc = 0;
                int n2 = 0;
                while (n2 < this.jj_2_rtns.length) {
                    JJCalls jJCalls = this.jj_2_rtns[n2];
                    while (jJCalls != null) {
                        if (jJCalls.gen < this.jj_gen) {
                            jJCalls.first = null;
                        }
                        jJCalls = jJCalls.next;
                    }
                    ++n2;
                }
            }
            return this.token;
        }
        this.token = token;
        this.jj_kind = n;
        throw this.generateParseException();
    }

    private final boolean jj_scan_token(int n) {
        if (this.jj_scanpos == this.jj_lastpos) {
            --this.jj_la;
            if (this.jj_scanpos.next == null) {
                this.jj_scanpos = this.jj_scanpos.next = this.token_source.getNextToken();
                this.jj_lastpos = this.jj_scanpos.next;
            } else {
                this.jj_lastpos = this.jj_scanpos = this.jj_scanpos.next;
            }
        } else {
            this.jj_scanpos = this.jj_scanpos.next;
        }
        if (this.jj_rescan) {
            int n2 = 0;
            Token token = this.token;
            while (token != null && token != this.jj_scanpos) {
                ++n2;
                token = token.next;
            }
            if (token != null) {
                this.jj_add_error_token(n, n2);
            }
        }
        return this.jj_scanpos.kind != n;
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int n) {
        Token token = this.lookingAhead ? this.jj_scanpos : this.token;
        int n2 = 0;
        while (n2 < n) {
            token = token.next != null ? token.next : (token.next = this.token_source.getNextToken());
            ++n2;
        }
        return token;
    }

    private final int jj_ntk() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    private void jj_add_error_token(int n, int n2) {
        if (n2 >= 100) {
            return;
        }
        if (n2 == this.jj_endpos + 1) {
            this.jj_lasttokens[this.jj_endpos++] = n;
        } else if (this.jj_endpos != 0) {
            this.jj_expentry = new int[this.jj_endpos];
            int n3 = 0;
            while (n3 < this.jj_endpos) {
                this.jj_expentry[n3] = this.jj_lasttokens[n3];
                ++n3;
            }
            boolean bl = false;
            Enumeration enumeration = this.jj_expentries.elements();
            while (enumeration.hasMoreElements()) {
                int[] nArray = (int[])enumeration.nextElement();
                if (nArray.length != this.jj_expentry.length) continue;
                bl = true;
                int n4 = 0;
                while (n4 < this.jj_expentry.length) {
                    if (nArray[n4] != this.jj_expentry[n4]) {
                        bl = false;
                        break;
                    }
                    ++n4;
                }
                if (bl) break;
            }
            if (!bl) {
                this.jj_expentries.addElement(this.jj_expentry);
            }
            if (n2 != 0) {
                this.jj_endpos = n2;
                this.jj_lasttokens[this.jj_endpos - 1] = n;
            }
        }
    }

    public final ParseException generateParseException() {
        int n;
        this.jj_expentries.removeAllElements();
        boolean[] blArray = new boolean[26];
        int n2 = 0;
        while (n2 < 26) {
            blArray[n2] = false;
            ++n2;
        }
        if (this.jj_kind >= 0) {
            blArray[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        int n3 = 0;
        while (n3 < 13) {
            if (this.jj_la1[n3] == this.jj_gen) {
                n = 0;
                while (n < 32) {
                    if ((this.jj_la1_0[n3] & 1 << n) != 0) {
                        blArray[n] = true;
                    }
                    ++n;
                }
            }
            ++n3;
        }
        n = 0;
        while (n < 26) {
            if (blArray[n]) {
                this.jj_expentry = new int[1];
                this.jj_expentry[0] = n;
                this.jj_expentries.addElement(this.jj_expentry);
            }
            ++n;
        }
        this.jj_endpos = 0;
        this.jj_rescan_token();
        this.jj_add_error_token(0, 0);
        int[][] nArrayArray = new int[this.jj_expentries.size()][];
        int n4 = 0;
        while (n4 < this.jj_expentries.size()) {
            nArrayArray[n4] = (int[])this.jj_expentries.elementAt(n4);
            ++n4;
        }
        return new ParseException(this.token, nArrayArray, ConfigParserConstants.tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    private final void jj_rescan_token() {
        this.jj_rescan = true;
        int n = 0;
        while (n < 2) {
            JJCalls jJCalls = this.jj_2_rtns[n];
            do {
                if (jJCalls.gen <= this.jj_gen) continue;
                this.jj_la = jJCalls.arg;
                this.jj_lastpos = this.jj_scanpos = jJCalls.first;
                switch (n) {
                    case 0: {
                        this.jj_3_1();
                        break;
                    }
                    case 1: {
                        this.jj_3_2();
                    }
                }
            } while ((jJCalls = jJCalls.next) != null);
            ++n;
        }
        this.jj_rescan = false;
    }

    private final void jj_save(int n, int n2) {
        JJCalls jJCalls = this.jj_2_rtns[n];
        while (jJCalls.gen > this.jj_gen) {
            if (jJCalls.next == null) {
                jJCalls = jJCalls.next = new JJCalls();
                break;
            }
            jJCalls = jJCalls.next;
        }
        jJCalls.gen = this.jj_gen + n2 - this.jj_la;
        jJCalls.first = this.token;
        jJCalls.arg = n2;
    }

    static final class JJCalls {
        int gen;
        Token first;
        int arg;
        JJCalls next;

        JJCalls() {
        }
    }
}

