/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jpos.config.auto;

import com.ibm.jpos.config.auto.DefaultLogicalNameFactory;
import com.ibm.jpos.config.auto.DevInfo;
import com.ibm.jpos.config.auto.EntryFactory;
import com.ibm.jpos.config.auto.JposEntryRegUtility;
import com.ibm.jpos.config.auto.LogicalNameFactory;
import com.ibm.jpos.config.auto.PosAutoConfigEvent;
import com.ibm.jpos.config.auto.PosAutoConfigListener;
import com.ibm.jpos.config.auto.PosDevId;
import com.ibm.jpos.config.auto.PosDevIdFactory;
import com.ibm.jpos.config.auto.PosDevInfo;
import com.ibm.jpos.config.auto.PosDevInfoFactory;
import com.ibm.jpos.config.auto.PosDeviceRegistry;
import com.ibm.poss.PosSubsystem;
import com.ibm.poss.SystemEventListener;
import java.util.Vector;

public final class PosAutoConfig {
    SystemEventListener systemEventListener = null;
    PosDeviceRegistry posDeviceRegistry = new PosDeviceRegistry();
    private LogicalNameFactory sioLogicalNameFactory;
    private LogicalNameFactory usbLogicalNameFactory = this.sioLogicalNameFactory = new DefaultLogicalNameFactory();
    private Vector posAutoConfigEventListeners = new Vector();
    private static boolean started = false;
    private static PosAutoConfig instance = null;

    private PosAutoConfig() {
    }

    public String toString() {
        return "PosAutoConfig, registry:\n" + this.getPosDeviceRegistry().toString();
    }

    public boolean isStarted() {
        return started;
    }

    public void setSIOLogicalNameFactory(LogicalNameFactory logicalNameFactory) {
        this.sioLogicalNameFactory = logicalNameFactory;
    }

    public void setUSBLogicalNameFactory(LogicalNameFactory logicalNameFactory) {
        this.usbLogicalNameFactory = logicalNameFactory;
    }

    public synchronized void addPosAutoConfigListener(PosAutoConfigListener posAutoConfigListener) {
        this.posAutoConfigEventListeners.addElement(posAutoConfigListener);
    }

    public void removePosAutoConfigListener(PosAutoConfigListener posAutoConfigListener) {
        this.posAutoConfigEventListeners.removeElement(posAutoConfigListener);
    }

    private void init() {
        PosSubsystem.addSystemEventListener(this.getSystemEventListener());
    }

    private void exit() {
        PosSubsystem.removeSystemEventListener(this.getSystemEventListener());
    }

    protected void firePosAutoConfigEventDeviceOnline(PosAutoConfigEvent posAutoConfigEvent) {
        Vector vector = null;
        PosAutoConfig posAutoConfig = this;
        synchronized (posAutoConfig) {
            vector = (Vector)this.posAutoConfigEventListeners.clone();
        }
        int n = 0;
        while (n < vector.size()) {
            ((PosAutoConfigListener)vector.elementAt(n)).deviceOnline(posAutoConfigEvent);
            ++n;
        }
    }

    protected void firePosAutoConfigEventDeviceOffline(PosAutoConfigEvent posAutoConfigEvent) {
        Vector vector = null;
        PosAutoConfig posAutoConfig = this;
        synchronized (posAutoConfig) {
            vector = (Vector)this.posAutoConfigEventListeners.clone();
        }
        int n = 0;
        while (n < vector.size()) {
            ((PosAutoConfigListener)vector.elementAt(n)).deviceOffline(posAutoConfigEvent);
            ++n;
        }
    }

    protected void firePosAutoConfigEventDeviceConfigured(PosAutoConfigEvent posAutoConfigEvent) {
        Vector vector = null;
        PosAutoConfig posAutoConfig = this;
        synchronized (posAutoConfig) {
            vector = (Vector)this.posAutoConfigEventListeners.clone();
        }
        int n = 0;
        while (n < vector.size()) {
            ((PosAutoConfigListener)vector.elementAt(n)).deviceConfigured(posAutoConfigEvent);
            ++n;
        }
    }

    private void createAndAddEntryToJposEntryReg(PosDevInfo posDevInfo) {
        if (!JposEntryRegUtility.hasJposEntryFor(posDevInfo)) {
            String string = "";
            if (posDevInfo.getBus() == 1) {
                string = this.sioLogicalNameFactory.createLogicalName(posDevInfo);
                posDevInfo.setLogicalName(string);
                JposEntryRegUtility.addJposEntryToRegistry(EntryFactory.createEntry(posDevInfo, posDevInfo.getLogicalName()));
                this.firePosAutoConfigEventDeviceConfigured(new PosAutoConfigEvent(this, posDevInfo));
            } else {
                string = this.usbLogicalNameFactory.createLogicalName(posDevInfo);
                posDevInfo.setLogicalName(string);
                JposEntryRegUtility.addJposEntryToRegistry(EntryFactory.createEntry(posDevInfo, posDevInfo.getLogicalName()));
                this.firePosAutoConfigEventDeviceConfigured(new PosAutoConfigEvent(this, posDevInfo));
            }
        } else {
            posDevInfo.setLogicalName(JposEntryRegUtility.getLogicalNameFor(posDevInfo));
        }
    }

    private void posmSysDeviceOnline(int n, int n2, int n3, byte by, byte by2) {
        String string = PosDevId.createUniqueKey(n, n2, n3, by, by2);
        if (this.getPosDeviceRegistry().containsKey(string)) {
            PosDevInfo[] posDevInfoArray = (PosDevInfo[])this.getPosDeviceRegistry().get(string);
            int n4 = 0;
            while (n4 < posDevInfoArray.length) {
                posDevInfoArray[n4].setOnline(true);
                this.firePosAutoConfigEventDeviceOnline(new PosAutoConfigEvent(this, posDevInfoArray[n4]));
                ++n4;
            }
        } else {
            PosDevId posDevId = PosDevIdFactory.createPosDevId(n, n2, n3, by, by2);
            DevInfo[] devInfoArray = PosDevInfoFactory.createPosDevInfos(posDevId);
            int n5 = 0;
            while (n5 < devInfoArray.length) {
                devInfoArray[n5].setOnline(true);
                this.createAndAddEntryToJposEntryReg((PosDevInfo)devInfoArray[n5]);
                this.firePosAutoConfigEventDeviceOnline(new PosAutoConfigEvent(this, devInfoArray[n5]));
                ++n5;
            }
            this.getPosDeviceRegistry().add(posDevId.getUniqueKey(), devInfoArray);
        }
    }

    private void posmSysDeviceOffline(int n, int n2, int n3, byte by, byte by2) {
        String string = PosDevId.createUniqueKey(n, n2, n3, by, by2);
        if (this.getPosDeviceRegistry().containsKey(string)) {
            PosDevInfo[] posDevInfoArray = (PosDevInfo[])this.getPosDeviceRegistry().get(string);
            int n4 = 0;
            while (n4 < posDevInfoArray.length) {
                posDevInfoArray[n4].setOnline(false);
                this.firePosAutoConfigEventDeviceOffline(new PosAutoConfigEvent(this, posDevInfoArray[n4]));
                ++n4;
            }
        } else {
            PosDevId posDevId = PosDevIdFactory.createPosDevId(n, n2, n3, by, by2);
            DevInfo[] devInfoArray = PosDevInfoFactory.createPosDevInfos(posDevId);
            int n5 = 0;
            while (n5 < devInfoArray.length) {
                devInfoArray[n5].setOnline(false);
                this.createAndAddEntryToJposEntryReg((PosDevInfo)devInfoArray[n5]);
                this.firePosAutoConfigEventDeviceOffline(new PosAutoConfigEvent(this, devInfoArray[n5]));
                ++n5;
            }
            this.getPosDeviceRegistry().add(posDevId.getUniqueKey(), devInfoArray);
        }
    }

    private SystemEventListener getSystemEventListener() {
        if (this.systemEventListener == null) {
            this.systemEventListener = new SystemEventListener(){

                public void posmSysDeviceOffline(int n, int n2, int n3, byte by, byte by2) {
                    PosAutoConfig.this.posmSysDeviceOffline(n, n2, n3, by, by2);
                }

                public void posmSysDeviceOnline(int n, int n2, int n3, byte by, byte by2) {
                    PosAutoConfig.this.posmSysDeviceOnline(n, n2, n3, by, by2);
                }
            };
        }
        return this.systemEventListener;
    }

    private PosDeviceRegistry getPosDeviceRegistry() {
        return this.posDeviceRegistry;
    }

    public static PosAutoConfig getInstance() {
        if (instance == null) {
            instance = new PosAutoConfig();
        }
        return instance;
    }

    public static void start() {
        if (!started) {
            PosAutoConfig.getInstance().init();
            started = true;
        }
    }

    public static void end() {
        if (started) {
            PosAutoConfig.getInstance().exit();
            started = false;
        }
    }

    public static void main(String[] stringArray) {
        PosAutoConfig.start();
        try {
            Thread.currentThread();
            Thread.sleep(2000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        System.out.println(PosAutoConfig.getInstance().getPosDeviceRegistry().toString());
    }
}

