/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jpos.services.poss;

import com.ibm.jpos.services.DeviceServiceAbstraction;
import com.ibm.jpos.services.poss.POSSPOSKeyboardServiceImp;
import com.ibm.jpos.services.poss.SystemPOSKeyboardMap;
import com.ibm.poss.CapsLock;
import com.ibm.poss.PS2Keyboard;
import com.ibm.poss.PosException;
import com.ibm.poss.PosSubsystem;
import com.ibm.poss.SystemEventListener;
import jpos.JposException;

public final class POSKeyboardPS2Imp
extends POSSPOSKeyboardServiceImp {
    private boolean eatNumLockKeys = false;
    private boolean capsLockOn = false;
    private int lastKey = 0;
    private static final int NOTHING = 0;
    private static final int SHIFT = 1;
    private static final int ALT = 2;
    private static final int CTRL = 4;
    private static int state = 0;
    private static final int CAPS_LOCK_KEY = 58;
    private static final int NUM_LOCK_KEY = 69;
    private static final int LEFT_SHIFT_KEY_SC = 42;
    private static final int RIGHT_SHIFT_KEY_SC = 54;
    private static final int ALT_KEY_SC = 56;
    private static final int CTRL_KEY_SC = 29;
    private static final int ZERO_KEY_SC = 11;
    private static final int KEY_99_SC = 119;
    private static final int KEY_99_DOWN_RAW_SC = 0x770001;
    private static final int KEY_99_UP_RAW_SC = -1065943039;
    private static boolean firstRun = true;
    private static boolean sendDoubleZeroFlag = false;
    private static boolean debugKeys = false;
    private static final String KEYBOARD_TYPEMATIC_PROPERTY = "com.ibm.jpos.sdi.config.POSKeyboard.Typematic";
    private static final String KEYBOARD_DOUBLE_ZERO_PROPERTY = "com.ibm.jpos.sdi.config.POSKeyboard.DoubleZero";
    private static final String KEYBOARD_DEBUG_KEYS_PROPERTY = "com.ibm.jpos.sdi.config.POSKeyboard.TGNDebugKeys";

    protected POSKeyboardPS2Imp(DeviceServiceAbstraction deviceServiceAbstraction) throws JposException {
        super(deviceServiceAbstraction);
        PosSubsystem.addSystemEventListener(new POSKeyboardSystemEventListener());
    }

    public void setDeviceEnabled(boolean bl) throws JposException {
        Boolean bl2;
        super.setDeviceEnabled(bl);
        boolean bl3 = true;
        if (bl && !this.serviceState.getDeviceEnabled()) {
            bl3 = PS2Keyboard.hookKeyboard(this, this.keyTable);
        } else if (!bl && this.serviceState.getDeviceEnabled()) {
            bl3 = PS2Keyboard.unhookKeyboard();
        }
        if (!bl3) {
            throw new JposException(111);
        }
        if (this.getJposEntry().hasPropertyWithName(KEYBOARD_TYPEMATIC_PROPERTY)) {
            bl2 = (Boolean)this.getJposEntry().getPropertyValue(KEYBOARD_TYPEMATIC_PROPERTY);
            this.doTypematic(bl2);
        }
        sendDoubleZeroFlag = false;
        if (this.getJposEntry().hasPropertyWithName(KEYBOARD_DOUBLE_ZERO_PROPERTY)) {
            bl2 = (Boolean)this.getJposEntry().getPropertyValue(KEYBOARD_DOUBLE_ZERO_PROPERTY);
            sendDoubleZeroFlag = bl2;
        }
        debugKeys = false;
        if (this.getJposEntry().hasPropertyWithName(KEYBOARD_DEBUG_KEYS_PROPERTY)) {
            bl2 = (Boolean)this.getJposEntry().getPropertyValue(KEYBOARD_DEBUG_KEYS_PROPERTY);
            debugKeys = bl2;
        }
    }

    protected void doTypematic(boolean bl) throws JposException {
        try {
            if (bl) {
                this.getPosDevice().ioctl(4707);
            } else {
                this.getPosDevice().ioctl(4706);
            }
        }
        catch (PosException posException) {
            if (posException.getErrorCode() == 317) {
                throw new JposException(108);
            }
            throw new JposException(111, posException.getMessage(), (Exception)posException);
        }
    }

    protected void makePOSKeyboardMap(String string) {
        this.kbdMap = new SystemPOSKeyboardMap(string);
    }

    public boolean processKey(int n, int n2, int n3, int n4) {
        if (firstRun) {
            this.capsLockOn = CapsLock.getCapsLock(true);
            firstRun = false;
        }
        if (debugKeys) {
            System.err.println("\n keyData 0x" + Integer.toHexString(n) + "\n keyEventType 0x" + Integer.toHexString(n2) + "\n repCount 0x" + Integer.toHexString(n3) + "\n rawValue 0x" + Integer.toHexString(n4));
        }
        if (this.eatNumLockKeys && n == 69) {
            boolean bl = true;
            return bl;
        }
        boolean bl = n2 == 2 ? this.handleKeyUp(n, n2, n3, n4) : this.handleKeyDown(n, n2, n3, n4);
        return bl;
    }

    private boolean handleKeyDown(int n, int n2, int n3, int n4) {
        boolean bl = false;
        this.lastKey = n;
        if (n == 42 || n == 54) {
            state |= 1;
        } else if (n == 56) {
            state |= 2;
        } else if (n == 29) {
            state |= 4;
        } else if (n == 58) {
            this.capsLockOn = CapsLock.getCapsLock(true);
        } else if (1 == (state & 1)) {
            if (this.capsLockOn) {
                if (!this.a2zKeys(n)) {
                    this.sendShiftKey();
                }
            } else {
                this.sendShiftKey();
            }
            bl = this.sendKeyData(n, n2, n3, n4);
        } else if (4 == (state & 4)) {
            this.sendCtrlKey();
            bl = this.sendKeyData(n, n2, n3, n4);
        } else if (2 == (state & 2)) {
            this.sendAltKey();
            bl = this.sendKeyData(n, n2, n3, n4);
        } else if (n == 119 && sendDoubleZeroFlag && n4 == 0x770001) {
            this.sendZeroKey();
            this.sendZeroKey();
        } else {
            if (this.capsLockOn && this.a2zKeys(n)) {
                this.sendShiftKey();
            }
            bl = this.sendKeyData(n, n2, n3, n4);
        }
        return bl;
    }

    private boolean handleKeyUp(int n, int n2, int n3, int n4) {
        boolean bl = false;
        if (n == 58) {
            this.capsLockOn = CapsLock.getCapsLock(true);
        } else if (1 == (state & 1) && (this.lastKey == 42 || this.lastKey == 54)) {
            state &= 0xFFFFFFFE;
        } else if (2 == (state & 2) && this.lastKey == 56) {
            state &= 0xFFFFFFFD;
        } else if (4 == (state & 4) && this.lastKey == 29) {
            state &= 0xFFFFFFFB;
        } else if (this.lastKey == 58) {
            this.capsLockOn = CapsLock.getCapsLock(true);
        } else if (state == 0) {
            if (n != 119 || !sendDoubleZeroFlag || n4 != -1065943039) {
                bl = this.sendKeyData(n, n2, n3, n4);
            }
        } else if ((n == 42 || n == 54) && 1 == (state & 1)) {
            state &= 0xFFFFFFFE;
        } else if (n == 56 && 2 == (state & 2)) {
            state &= 0xFFFFFFFD;
        } else if (n == 29 && 4 == (state & 4)) {
            state &= 0xFFFFFFFB;
        } else if (n != 119 || !sendDoubleZeroFlag || n4 != -1065943039) {
            bl = this.sendKeyData(n, n2, n3, n4);
        }
        return bl;
    }

    private boolean sendKeyData(int n, int n2, int n3, int n4) {
        if (n2 == 2 && this.serviceState.getEventTypes() == 1) {
            return false;
        }
        this.sendToAppl(n, n4, n3, n2);
        return true;
    }

    private void sendToAppl(int n, int n2, int n3, int n4) {
        if (this.kbdMapLen == 0) {
            n = this.processWindowsExtendedKeys(n, n2);
            this.sendKey(n, n4, 1, 0);
        } else {
            n = this.processWindowsExtendedKeys(n, n2);
            int[][] nArray = this.kbdMap.lookupScancodes(n, n4);
            int n5 = 0;
            while (n5 < nArray.length) {
                this.sendKey(nArray[n5][0], nArray[n5][1], 1, 0);
                ++n5;
            }
        }
    }

    private void sendShiftKey() {
        this.sendKeyData(42, 1, 1, 2752513);
        this.sendKeyData(42, 2, 1, -1070989311);
    }

    private void sendCtrlKey() {
        this.sendKeyData(29, 1, 1, 0x1D0001);
        this.sendKeyData(29, 2, 1, -1071841279);
    }

    private void sendAltKey() {
        this.sendKeyData(56, 1, 1, 540540929);
        this.sendKeyData(56, 2, 1, -1070071807);
    }

    private void sendZeroKey() {
        this.sendKeyData(11, 1, 1, 720897);
        this.sendKeyData(11, 2, 1, -1073020927);
    }

    private boolean a2zKeys(int n) {
        if (n >= 16 && n <= 25) {
            return true;
        }
        if (n >= 30 && n <= 38) {
            return true;
        }
        return n >= 44 && n <= 50;
    }

    private int processWindowsExtendedKeys(int n, int n2) {
        if (0x1000000 == (n2 & 0x1000000)) {
            n |= 0x100;
        }
        return n;
    }

    private class POSKeyboardSystemEventListener
    implements SystemEventListener {
        private POSKeyboardSystemEventListener() {
        }

        public void posmSysDeviceOffline(int n, int n2, int n3, byte by, byte by2) {
        }

        public void posmSysDeviceOnline(int n, int n2, int n3, byte by, byte by2) {
            if (n == 129 && by2 == 15) {
                POSKeyboardPS2Imp.this.eatNumLockKeys = true;
            }
        }
    }
}

