/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.mbeanserver;

import com.sun.jmx.mbeanserver.DefaultMXBeanMappingFactory;
import com.sun.jmx.mbeanserver.Introspector;
import com.sun.jmx.mbeanserver.MXBeanLookup;
import com.sun.jmx.mbeanserver.MXBeanMapping;
import com.sun.jmx.mbeanserver.MXBeanMappingFactory;
import java.io.InvalidObjectException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import javax.management.Descriptor;
import javax.management.MBeanException;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;

final class ConvertingMethod {
    private static final String[] noStrings = new String[0];
    private final Method method;
    private final MXBeanMapping returnMapping;
    private final MXBeanMapping[] paramMappings;
    private final boolean paramConversionIsIdentity;

    static ConvertingMethod from(Method method) {
        try {
            return new ConvertingMethod(method);
        }
        catch (OpenDataException openDataException) {
            String string = "Method " + method.getDeclaringClass().getName() + "." + method.getName() + " has parameter or return type that " + "cannot be translated into an open type";
            throw new IllegalArgumentException(string, openDataException);
        }
    }

    Method getMethod() {
        return this.method;
    }

    Descriptor getDescriptor() {
        return Introspector.descriptorForElement(this.method);
    }

    Type getGenericReturnType() {
        return this.method.getGenericReturnType();
    }

    Type[] getGenericParameterTypes() {
        return this.method.getGenericParameterTypes();
    }

    String getName() {
        return this.method.getName();
    }

    OpenType<?> getOpenReturnType() {
        return this.returnMapping.getOpenType();
    }

    OpenType<?>[] getOpenParameterTypes() {
        OpenType[] openTypeArray = new OpenType[this.paramMappings.length];
        for (int i = 0; i < this.paramMappings.length; ++i) {
            openTypeArray[i] = this.paramMappings[i].getOpenType();
        }
        return openTypeArray;
    }

    void checkCallFromOpen() {
        try {
            for (MXBeanMapping mXBeanMapping : this.paramMappings) {
                mXBeanMapping.checkReconstructible();
            }
        }
        catch (InvalidObjectException invalidObjectException) {
            throw new IllegalArgumentException(invalidObjectException);
        }
    }

    void checkCallToOpen() {
        try {
            this.returnMapping.checkReconstructible();
        }
        catch (InvalidObjectException invalidObjectException) {
            throw new IllegalArgumentException(invalidObjectException);
        }
    }

    String[] getOpenSignature() {
        if (this.paramMappings.length == 0) {
            return noStrings;
        }
        String[] stringArray = new String[this.paramMappings.length];
        for (int i = 0; i < this.paramMappings.length; ++i) {
            stringArray[i] = this.paramMappings[i].getOpenClass().getName();
        }
        return stringArray;
    }

    final Object toOpenReturnValue(MXBeanLookup mXBeanLookup, Object object) throws OpenDataException {
        return this.returnMapping.toOpenValue(object);
    }

    final Object fromOpenReturnValue(MXBeanLookup mXBeanLookup, Object object) throws InvalidObjectException {
        return this.returnMapping.fromOpenValue(object);
    }

    final Object[] toOpenParameters(MXBeanLookup mXBeanLookup, Object[] objectArray) throws OpenDataException {
        if (this.paramConversionIsIdentity || objectArray == null) {
            return objectArray;
        }
        Object[] objectArray2 = new Object[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray2[i] = this.paramMappings[i].toOpenValue(objectArray[i]);
        }
        return objectArray2;
    }

    final Object[] fromOpenParameters(Object[] objectArray) throws InvalidObjectException {
        if (this.paramConversionIsIdentity || objectArray == null) {
            return objectArray;
        }
        Object[] objectArray2 = new Object[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray2[i] = this.paramMappings[i].fromOpenValue(objectArray[i]);
        }
        return objectArray2;
    }

    final Object toOpenParameter(MXBeanLookup mXBeanLookup, Object object, int n) throws OpenDataException {
        return this.paramMappings[n].toOpenValue(object);
    }

    final Object fromOpenParameter(MXBeanLookup mXBeanLookup, Object object, int n) throws InvalidObjectException {
        return this.paramMappings[n].fromOpenValue(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object invokeWithOpenReturn(MXBeanLookup mXBeanLookup, Object object, Object[] objectArray) throws MBeanException, IllegalAccessException, InvocationTargetException {
        MXBeanLookup mXBeanLookup2 = MXBeanLookup.getLookup();
        try {
            MXBeanLookup.setLookup(mXBeanLookup);
            Object object2 = this.invokeWithOpenReturn(object, objectArray);
            return object2;
        }
        finally {
            MXBeanLookup.setLookup(mXBeanLookup2);
        }
    }

    private Object invokeWithOpenReturn(Object object, Object[] objectArray) throws MBeanException, IllegalAccessException, InvocationTargetException {
        Object[] objectArray2;
        try {
            objectArray2 = this.fromOpenParameters(objectArray);
        }
        catch (InvalidObjectException invalidObjectException) {
            String string = this.methodName() + ": cannot convert parameters " + "from open values: " + invalidObjectException;
            throw new MBeanException(invalidObjectException, string);
        }
        Object object2 = this.method.invoke(object, objectArray2);
        try {
            return this.returnMapping.toOpenValue(object2);
        }
        catch (OpenDataException openDataException) {
            String string = this.methodName() + ": cannot convert return " + "value to open value: " + openDataException;
            throw new MBeanException(openDataException, string);
        }
    }

    private String methodName() {
        return this.method.getDeclaringClass() + "." + this.method.getName();
    }

    private ConvertingMethod(Method method) throws OpenDataException {
        this.method = method;
        MXBeanMappingFactory mXBeanMappingFactory = MXBeanMappingFactory.DEFAULT;
        this.returnMapping = mXBeanMappingFactory.mappingForType(method.getGenericReturnType(), mXBeanMappingFactory);
        Type[] typeArray = method.getGenericParameterTypes();
        this.paramMappings = new MXBeanMapping[typeArray.length];
        boolean bl = true;
        for (int i = 0; i < typeArray.length; ++i) {
            this.paramMappings[i] = mXBeanMappingFactory.mappingForType(typeArray[i], mXBeanMappingFactory);
            bl &= DefaultMXBeanMappingFactory.isIdentity(this.paramMappings[i]);
        }
        this.paramConversionIsIdentity = bl;
    }
}

