/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.cosnaming;

import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import javax.naming.CompositeName;
import javax.naming.CompoundName;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameParser;
import javax.naming.NamingException;
import org.omg.CosNaming.NameComponent;

public final class CNNameParser
implements NameParser {
    private static final Properties mySyntax = new Properties();
    private static final char kindSeparator = '.';
    private static final char compSeparator = '/';
    private static final char escapeChar = '\\';

    @Override
    public Name parse(String string) throws NamingException {
        Vector vector = CNNameParser.insStringToStringifiedComps(string);
        return new CNCompoundName(vector.elements());
    }

    static NameComponent[] nameToCosName(Name name) throws InvalidNameException {
        int n = name.size();
        if (n == 0) {
            return new NameComponent[0];
        }
        NameComponent[] nameComponentArray = new NameComponent[n];
        for (int i = 0; i < n; ++i) {
            nameComponentArray[i] = CNNameParser.parseComponent(name.get(i));
        }
        return nameComponentArray;
    }

    static String cosNameToInsString(NameComponent[] nameComponentArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < nameComponentArray.length; ++i) {
            if (i > 0) {
                stringBuffer.append('/');
            }
            stringBuffer.append(CNNameParser.stringifyComponent(nameComponentArray[i]));
        }
        return stringBuffer.toString();
    }

    static Name cosNameToName(NameComponent[] nameComponentArray) {
        CompositeName compositeName = new CompositeName();
        for (int i = 0; nameComponentArray != null && i < nameComponentArray.length; ++i) {
            try {
                compositeName.add(CNNameParser.stringifyComponent(nameComponentArray[i]));
                continue;
            }
            catch (InvalidNameException invalidNameException) {
                // empty catch block
            }
        }
        return compositeName;
    }

    private static Vector insStringToStringifiedComps(String string) throws InvalidNameException {
        int n = string.length();
        Vector<String> vector = new Vector<String>(10);
        char[] cArray = new char[n];
        char[] cArray2 = new char[n];
        int n2 = 0;
        while (n2 < n) {
            int n3 = 0;
            int n4 = 0;
            boolean bl = true;
            while (n2 < n && string.charAt(n2) != '/') {
                if (string.charAt(n2) == '\\') {
                    if (n2 + 1 >= n) {
                        throw new InvalidNameException(string + ": unescaped \\ at end of component");
                    }
                    if (CNNameParser.isMeta(string.charAt(n2 + 1))) {
                        ++n2;
                        if (bl) {
                            cArray[n4++] = string.charAt(n2++);
                            continue;
                        }
                        cArray2[n3++] = string.charAt(n2++);
                        continue;
                    }
                    throw new InvalidNameException(string + ": invalid character being escaped");
                }
                if (bl && string.charAt(n2) == '.') {
                    ++n2;
                    bl = false;
                    continue;
                }
                if (bl) {
                    cArray[n4++] = string.charAt(n2++);
                    continue;
                }
                cArray2[n3++] = string.charAt(n2++);
            }
            vector.addElement(CNNameParser.stringifyComponent(new NameComponent(new String(cArray, 0, n4), new String(cArray2, 0, n3))));
            if (n2 >= n) continue;
            ++n2;
        }
        return vector;
    }

    private static NameComponent parseComponent(String string) throws InvalidNameException {
        int n;
        NameComponent nameComponent = new NameComponent();
        int n2 = -1;
        int n3 = string.length();
        int n4 = 0;
        char[] cArray = new char[n3];
        boolean bl = false;
        for (n = 0; n < n3 && n2 < 0; ++n) {
            if (bl) {
                cArray[n4++] = string.charAt(n);
                bl = false;
                continue;
            }
            if (string.charAt(n) == '\\') {
                if (n + 1 >= n3) {
                    throw new InvalidNameException(string + ": unescaped \\ at end of component");
                }
                if (CNNameParser.isMeta(string.charAt(n + 1))) {
                    bl = true;
                    continue;
                }
                throw new InvalidNameException(string + ": invalid character being escaped");
            }
            if (string.charAt(n) == '.') {
                n2 = n;
                continue;
            }
            cArray[n4++] = string.charAt(n);
        }
        nameComponent.id = new String(cArray, 0, n4);
        if (n2 < 0) {
            nameComponent.kind = "";
        } else {
            n4 = 0;
            bl = false;
            for (n = n2 + 1; n < n3; ++n) {
                if (bl) {
                    cArray[n4++] = string.charAt(n);
                    bl = false;
                    continue;
                }
                if (string.charAt(n) == '\\') {
                    if (n + 1 >= n3) {
                        throw new InvalidNameException(string + ": unescaped \\ at end of component");
                    }
                    if (CNNameParser.isMeta(string.charAt(n + 1))) {
                        bl = true;
                        continue;
                    }
                    throw new InvalidNameException(string + ": invalid character being escaped");
                }
                cArray[n4++] = string.charAt(n);
            }
            nameComponent.kind = new String(cArray, 0, n4);
        }
        return nameComponent;
    }

    private static String stringifyComponent(NameComponent nameComponent) {
        StringBuffer stringBuffer = new StringBuffer(CNNameParser.escape(nameComponent.id));
        if (nameComponent.kind != null && !nameComponent.kind.equals("")) {
            stringBuffer.append('.' + CNNameParser.escape(nameComponent.kind));
        }
        if (stringBuffer.length() == 0) {
            return ".";
        }
        return stringBuffer.toString();
    }

    private static String escape(String string) {
        if (string.indexOf(46) < 0 && string.indexOf(47) < 0 && string.indexOf(92) < 0) {
            return string;
        }
        int n = string.length();
        int n2 = 0;
        char[] cArray = new char[n + n];
        for (int i = 0; i < n; ++i) {
            if (CNNameParser.isMeta(string.charAt(i))) {
                cArray[n2++] = 92;
            }
            cArray[n2++] = string.charAt(i);
        }
        return new String(cArray, 0, n2);
    }

    private static boolean isMeta(char c) {
        switch (c) {
            case '.': 
            case '/': 
            case '\\': {
                return true;
            }
        }
        return false;
    }

    static {
        mySyntax.put("jndi.syntax.direction", "left_to_right");
        mySyntax.put("jndi.syntax.separator", "/");
        mySyntax.put("jndi.syntax.escape", "\\");
    }

    static final class CNCompoundName
    extends CompoundName {
        private static final long serialVersionUID = -6599252802678482317L;

        CNCompoundName(Enumeration enumeration) {
            super(enumeration, mySyntax);
        }

        @Override
        public Object clone() {
            return new CNCompoundName(this.getAll());
        }

        @Override
        public Name getPrefix(int n) {
            Enumeration<String> enumeration = super.getPrefix(n).getAll();
            return new CNCompoundName(enumeration);
        }

        @Override
        public Name getSuffix(int n) {
            Enumeration<String> enumeration = super.getSuffix(n).getAll();
            return new CNCompoundName(enumeration);
        }

        @Override
        public String toString() {
            try {
                return CNNameParser.cosNameToInsString(CNNameParser.nameToCosName(this));
            }
            catch (InvalidNameException invalidNameException) {
                return super.toString();
            }
        }
    }
}

