/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.ModelTransform;

public class ModelStandardTransform
implements ModelTransform {
    public static final boolean DIRECTION_MIN2MAX = false;
    public static final boolean DIRECTION_MAX2MIN = true;
    public static final boolean POLARITY_UNIPOLAR = false;
    public static final boolean POLARITY_BIPOLAR = true;
    public static final int TRANSFORM_LINEAR = 0;
    public static final int TRANSFORM_CONCAVE = 1;
    public static final int TRANSFORM_CONVEX = 2;
    public static final int TRANSFORM_SWITCH = 3;
    public static final int TRANSFORM_ABSOLUTE = 4;
    private boolean direction = false;
    private boolean polarity = false;
    private int transform = 0;

    public ModelStandardTransform() {
    }

    public ModelStandardTransform(boolean bl) {
        this.direction = bl;
    }

    public ModelStandardTransform(boolean bl, boolean bl2) {
        this.direction = bl;
        this.polarity = bl2;
    }

    public ModelStandardTransform(boolean bl, boolean bl2, int n) {
        this.direction = bl;
        this.polarity = bl2;
        this.transform = n;
    }

    @Override
    public double transform(double d) {
        if (this.direction) {
            d = 1.0 - d;
        }
        if (this.polarity) {
            d = d * 2.0 - 1.0;
        }
        switch (this.transform) {
            case 1: {
                double d2 = Math.signum(d);
                double d3 = Math.abs(d);
                d3 = -(0.4166666666666667 / Math.log(10.0)) * Math.log(1.0 - d3);
                if (d3 < 0.0) {
                    d3 = 0.0;
                } else if (d3 > 1.0) {
                    d3 = 1.0;
                }
                return d2 * d3;
            }
            case 2: {
                double d4 = Math.signum(d);
                double d5 = Math.abs(d);
                d5 = 1.0 + 0.4166666666666667 / Math.log(10.0) * Math.log(d5);
                if (d5 < 0.0) {
                    d5 = 0.0;
                } else if (d5 > 1.0) {
                    d5 = 1.0;
                }
                return d4 * d5;
            }
            case 3: {
                if (this.polarity) {
                    return d > 0.0 ? 1.0 : -1.0;
                }
                return d > 0.5 ? 1.0 : 0.0;
            }
            case 4: {
                return Math.abs(d);
            }
        }
        return d;
    }

    public boolean getDirection() {
        return this.direction;
    }

    public void setDirection(boolean bl) {
        this.direction = bl;
    }

    public boolean getPolarity() {
        return this.polarity;
    }

    public void setPolarity(boolean bl) {
        this.polarity = bl;
    }

    public int getTransform() {
        return this.transform;
    }

    public void setTransform(int n) {
        this.transform = n;
    }
}

