/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTEvent;
import java.awt.ActiveEvent;
import java.awt.Component;
import java.awt.Conditional;
import java.awt.EventDispatchThread;
import java.awt.EventFilter;
import java.awt.MenuComponent;
import java.awt.Queue;
import java.awt.Rectangle;
import java.awt.SecondaryLoop;
import java.awt.SentEvent;
import java.awt.SequencedEvent;
import java.awt.Toolkit;
import java.awt.TrayIcon;
import java.awt.WaitDispatchSupport;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.InputEvent;
import java.awt.event.InputMethodEvent;
import java.awt.event.InvocationEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.PaintEvent;
import java.awt.event.WindowEvent;
import java.awt.peer.ComponentPeer;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.EmptyStackException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import sun.awt.AWTAccessor;
import sun.awt.AWTAutoShutdown;
import sun.awt.AppContext;
import sun.awt.EventQueueItem;
import sun.awt.PeerEvent;
import sun.awt.SunToolkit;
import sun.awt.dnd.SunDropTargetEvent;
import sun.misc.JavaSecurityAccess;
import sun.misc.SharedSecrets;
import sun.util.logging.PlatformLogger;

public class EventQueue {
    private static final AtomicInteger threadInitNumber = new AtomicInteger(0);
    private static final int LOW_PRIORITY = 0;
    private static final int NORM_PRIORITY = 1;
    private static final int HIGH_PRIORITY = 2;
    private static final int ULTIMATE_PRIORITY = 3;
    private static final int NUM_PRIORITIES = 4;
    private Queue[] queues = new Queue[4];
    private EventQueue nextQueue;
    private EventQueue previousQueue;
    private final Lock pushPopLock;
    private final Condition pushPopCond;
    private static final Runnable dummyRunnable = new Runnable(){

        @Override
        public void run() {
        }
    };
    private EventDispatchThread dispatchThread;
    private final ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
    private final ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
    private long mostRecentEventTime = System.currentTimeMillis();
    private WeakReference currentEvent;
    private volatile int waitForID;
    private final String name = "AWT-EventQueue-" + threadInitNumber.getAndIncrement();
    private static final PlatformLogger eventLog = PlatformLogger.getLogger("java.awt.event.EventQueue");
    private static final int PAINT = 0;
    private static final int UPDATE = 1;
    private static final int MOVE = 2;
    private static final int DRAG = 3;
    private static final int PEER = 4;
    private static final int CACHE_LENGTH = 5;
    private static final JavaSecurityAccess javaSecurityAccess;

    public EventQueue() {
        for (int i = 0; i < 4; ++i) {
            this.queues[i] = new Queue();
        }
        this.pushPopLock = (Lock)AppContext.getAppContext().get(AppContext.EVENT_QUEUE_LOCK_KEY);
        this.pushPopCond = (Condition)AppContext.getAppContext().get(AppContext.EVENT_QUEUE_COND_KEY);
    }

    public void postEvent(AWTEvent aWTEvent) {
        SunToolkit.flushPendingEvents();
        this.postEventPrivate(aWTEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void postEventPrivate(AWTEvent aWTEvent) {
        aWTEvent.isPosted = true;
        this.pushPopLock.lock();
        try {
            if (this.nextQueue != null) {
                this.nextQueue.postEventPrivate(aWTEvent);
                return;
            }
            if (this.dispatchThread == null) {
                if (aWTEvent.getSource() == AWTAutoShutdown.getInstance()) {
                    return;
                }
                this.initDispatchThread();
            }
            this.postEvent(aWTEvent, EventQueue.getPriority(aWTEvent));
        }
        finally {
            this.pushPopLock.unlock();
        }
    }

    private static int getPriority(AWTEvent aWTEvent) {
        int n;
        if (aWTEvent instanceof PeerEvent) {
            PeerEvent peerEvent = (PeerEvent)aWTEvent;
            if ((peerEvent.getFlags() & 2L) != 0L) {
                return 3;
            }
            if ((peerEvent.getFlags() & 1L) != 0L) {
                return 2;
            }
            if ((peerEvent.getFlags() & 4L) != 0L) {
                return 0;
            }
        }
        if ((n = aWTEvent.getID()) >= 800 && n <= 801) {
            return 0;
        }
        return 1;
    }

    private void postEvent(AWTEvent aWTEvent, int n) {
        boolean bl;
        if (this.coalesceEvent(aWTEvent, n)) {
            return;
        }
        EventQueueItem eventQueueItem = new EventQueueItem(aWTEvent);
        this.cacheEQItem(eventQueueItem);
        boolean bl2 = bl = aWTEvent.getID() == this.waitForID;
        if (this.queues[n].head == null) {
            boolean bl3 = this.noEvents();
            this.queues[n].head = this.queues[n].tail = eventQueueItem;
            if (bl3) {
                if (aWTEvent.getSource() != AWTAutoShutdown.getInstance()) {
                    AWTAutoShutdown.getInstance().notifyThreadBusy(this.dispatchThread);
                }
                this.pushPopCond.signalAll();
            } else if (bl) {
                this.pushPopCond.signalAll();
            }
        } else {
            this.queues[n].tail.next = eventQueueItem;
            this.queues[n].tail = eventQueueItem;
            if (bl) {
                this.pushPopCond.signalAll();
            }
        }
    }

    private boolean coalescePaintEvent(PaintEvent paintEvent) {
        PaintEvent paintEvent2;
        EventQueueItem[] eventQueueItemArray;
        ComponentPeer componentPeer = ((Component)paintEvent.getSource()).peer;
        if (componentPeer != null) {
            componentPeer.coalescePaintEvent(paintEvent);
        }
        if ((eventQueueItemArray = ((Component)paintEvent.getSource()).eventCache) == null) {
            return false;
        }
        int n = EventQueue.eventToCacheIndex(paintEvent);
        if (n != -1 && eventQueueItemArray[n] != null && (paintEvent2 = this.mergePaintEvents(paintEvent, (PaintEvent)eventQueueItemArray[n].event)) != null) {
            eventQueueItemArray[n].event = paintEvent2;
            return true;
        }
        return false;
    }

    private PaintEvent mergePaintEvents(PaintEvent paintEvent, PaintEvent paintEvent2) {
        Rectangle rectangle = paintEvent.getUpdateRect();
        Rectangle rectangle2 = paintEvent2.getUpdateRect();
        if (rectangle2.contains(rectangle)) {
            return paintEvent2;
        }
        if (rectangle.contains(rectangle2)) {
            return paintEvent;
        }
        return null;
    }

    private boolean coalesceMouseEvent(MouseEvent mouseEvent) {
        if (mouseEvent instanceof SunDropTargetEvent) {
            return false;
        }
        EventQueueItem[] eventQueueItemArray = ((Component)mouseEvent.getSource()).eventCache;
        if (eventQueueItemArray == null) {
            return false;
        }
        int n = EventQueue.eventToCacheIndex(mouseEvent);
        if (n != -1 && eventQueueItemArray[n] != null) {
            eventQueueItemArray[n].event = mouseEvent;
            return true;
        }
        return false;
    }

    private boolean coalescePeerEvent(PeerEvent peerEvent) {
        EventQueueItem[] eventQueueItemArray = ((Component)peerEvent.getSource()).eventCache;
        if (eventQueueItemArray == null) {
            return false;
        }
        int n = EventQueue.eventToCacheIndex(peerEvent);
        if (n != -1 && eventQueueItemArray[n] != null) {
            if ((peerEvent = peerEvent.coalesceEvents((PeerEvent)eventQueueItemArray[n].event)) != null) {
                eventQueueItemArray[n].event = peerEvent;
                return true;
            }
            eventQueueItemArray[n] = null;
        }
        return false;
    }

    private boolean coalesceOtherEvent(AWTEvent aWTEvent, int n) {
        int n2 = aWTEvent.getID();
        Component component = (Component)aWTEvent.getSource();
        EventQueueItem eventQueueItem = this.queues[n].head;
        while (eventQueueItem != null) {
            AWTEvent aWTEvent2;
            if (eventQueueItem.event.getSource() == component && eventQueueItem.event.getID() == n2 && (aWTEvent2 = component.coalesceEvents(eventQueueItem.event, aWTEvent)) != null) {
                eventQueueItem.event = aWTEvent2;
                return true;
            }
            eventQueueItem = eventQueueItem.next;
        }
        return false;
    }

    private boolean coalesceEvent(AWTEvent aWTEvent, int n) {
        if (!(aWTEvent.getSource() instanceof Component)) {
            return false;
        }
        if (aWTEvent instanceof PeerEvent) {
            return this.coalescePeerEvent((PeerEvent)aWTEvent);
        }
        if (((Component)aWTEvent.getSource()).isCoalescingEnabled() && this.coalesceOtherEvent(aWTEvent, n)) {
            return true;
        }
        if (aWTEvent instanceof PaintEvent) {
            return this.coalescePaintEvent((PaintEvent)aWTEvent);
        }
        if (aWTEvent instanceof MouseEvent) {
            return this.coalesceMouseEvent((MouseEvent)aWTEvent);
        }
        return false;
    }

    private void cacheEQItem(EventQueueItem eventQueueItem) {
        if (eventQueueItem.event instanceof SunDropTargetEvent) {
            return;
        }
        int n = EventQueue.eventToCacheIndex(eventQueueItem.event);
        if (n != -1 && eventQueueItem.event.getSource() instanceof Component) {
            Component component = (Component)eventQueueItem.event.getSource();
            if (component.eventCache == null) {
                component.eventCache = new EventQueueItem[5];
            }
            component.eventCache[n] = eventQueueItem;
        }
    }

    private void uncacheEQItem(EventQueueItem eventQueueItem) {
        int n = EventQueue.eventToCacheIndex(eventQueueItem.event);
        if (n != -1 && eventQueueItem.event.getSource() instanceof Component) {
            Component component = (Component)eventQueueItem.event.getSource();
            if (component.eventCache == null) {
                return;
            }
            component.eventCache[n] = null;
        }
    }

    private static int eventToCacheIndex(AWTEvent aWTEvent) {
        switch (aWTEvent.getID()) {
            case 800: {
                return 0;
            }
            case 801: {
                return 1;
            }
            case 503: {
                return 2;
            }
            case 506: {
                return 3;
            }
        }
        return aWTEvent instanceof PeerEvent ? 4 : -1;
    }

    private boolean noEvents() {
        for (int i = 0; i < 4; ++i) {
            if (this.queues[i].head == null) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AWTEvent getNextEvent() throws InterruptedException {
        while (true) {
            SunToolkit.flushPendingEvents();
            this.pushPopLock.lock();
            try {
                AWTEvent aWTEvent = this.getNextEventPrivate();
                if (aWTEvent != null) {
                    AWTEvent aWTEvent2 = aWTEvent;
                    return aWTEvent2;
                }
                AWTAutoShutdown.getInstance().notifyThreadFree(this.dispatchThread);
                this.pushPopCond.await();
                continue;
            }
            finally {
                this.pushPopLock.unlock();
                continue;
            }
            break;
        }
    }

    AWTEvent getNextEventPrivate() throws InterruptedException {
        for (int i = 3; i >= 0; --i) {
            if (this.queues[i].head == null) continue;
            EventQueueItem eventQueueItem = this.queues[i].head;
            this.queues[i].head = eventQueueItem.next;
            if (eventQueueItem.next == null) {
                this.queues[i].tail = null;
            }
            this.uncacheEQItem(eventQueueItem);
            return eventQueueItem.event;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    AWTEvent getNextEvent(int n) throws InterruptedException {
        while (true) {
            SunToolkit.flushPendingEvents();
            this.pushPopLock.lock();
            try {
                for (int i = 0; i < 4; ++i) {
                    EventQueueItem eventQueueItem = this.queues[i].head;
                    EventQueueItem eventQueueItem2 = null;
                    while (eventQueueItem != null) {
                        if (eventQueueItem.event.getID() == n) {
                            if (eventQueueItem2 == null) {
                                this.queues[i].head = eventQueueItem.next;
                            } else {
                                eventQueueItem2.next = eventQueueItem.next;
                            }
                            if (this.queues[i].tail == eventQueueItem) {
                                this.queues[i].tail = eventQueueItem2;
                            }
                            this.uncacheEQItem(eventQueueItem);
                            AWTEvent aWTEvent = eventQueueItem.event;
                            return aWTEvent;
                        }
                        eventQueueItem2 = eventQueueItem;
                        eventQueueItem = eventQueueItem.next;
                    }
                }
                this.waitForID = n;
                this.pushPopCond.await();
                this.waitForID = 0;
                continue;
            }
            finally {
                this.pushPopLock.unlock();
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AWTEvent peekEvent() {
        this.pushPopLock.lock();
        try {
            for (int i = 3; i >= 0; --i) {
                if (this.queues[i].head == null) continue;
                AWTEvent aWTEvent = this.queues[i].head.event;
                return aWTEvent;
            }
        }
        finally {
            this.pushPopLock.unlock();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AWTEvent peekEvent(int n) {
        this.pushPopLock.lock();
        try {
            for (int i = 3; i >= 0; --i) {
                EventQueueItem eventQueueItem = this.queues[i].head;
                while (eventQueueItem != null) {
                    if (eventQueueItem.event.getID() == n) {
                        AWTEvent aWTEvent = eventQueueItem.event;
                        return aWTEvent;
                    }
                    eventQueueItem = eventQueueItem.next;
                }
            }
        }
        finally {
            this.pushPopLock.unlock();
        }
        return null;
    }

    protected void dispatchEvent(final AWTEvent aWTEvent) {
        final Object object = aWTEvent.getSource();
        final PrivilegedAction<Void> privilegedAction = new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                EventQueue.this.dispatchEventImpl(aWTEvent, object);
                return null;
            }
        };
        AccessControlContext accessControlContext = AccessController.getContext();
        AccessControlContext accessControlContext2 = EventQueue.getAccessControlContextFrom(object);
        final AccessControlContext accessControlContext3 = aWTEvent.getAccessControlContext();
        if (accessControlContext2 == null) {
            javaSecurityAccess.doIntersectionPrivilege(privilegedAction, accessControlContext, accessControlContext3);
        } else {
            javaSecurityAccess.doIntersectionPrivilege(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    javaSecurityAccess.doIntersectionPrivilege(privilegedAction, accessControlContext3);
                    return null;
                }
            }, accessControlContext, accessControlContext2);
        }
    }

    private static AccessControlContext getAccessControlContextFrom(Object object) {
        return object instanceof Component ? ((Component)object).getAccessControlContext() : (object instanceof MenuComponent ? ((MenuComponent)object).getAccessControlContext() : (object instanceof TrayIcon ? ((TrayIcon)object).getAccessControlContext() : null));
    }

    private void dispatchEventImpl(AWTEvent aWTEvent, Object object) {
        aWTEvent.isPosted = true;
        if (aWTEvent instanceof ActiveEvent) {
            this.setCurrentEventAndMostRecentTimeImpl(aWTEvent);
            ((ActiveEvent)((Object)aWTEvent)).dispatch();
        } else if (object instanceof Component) {
            ((Component)object).dispatchEvent(aWTEvent);
            aWTEvent.dispatched();
        } else if (object instanceof MenuComponent) {
            ((MenuComponent)object).dispatchEvent(aWTEvent);
        } else if (object instanceof TrayIcon) {
            ((TrayIcon)object).dispatchEvent(aWTEvent);
        } else if (object instanceof AWTAutoShutdown) {
            if (this.noEvents()) {
                this.dispatchThread.stopDispatching();
            }
        } else if (eventLog.isLoggable(500)) {
            eventLog.fine("Unable to dispatch event: " + aWTEvent);
        }
    }

    public static long getMostRecentEventTime() {
        return Toolkit.getEventQueue().getMostRecentEventTimeImpl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getMostRecentEventTimeImpl() {
        this.pushPopLock.lock();
        try {
            long l = Thread.currentThread() == this.dispatchThread ? this.mostRecentEventTime : System.currentTimeMillis();
            return l;
        }
        finally {
            this.pushPopLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long getMostRecentEventTimeEx() {
        this.pushPopLock.lock();
        try {
            long l = this.mostRecentEventTime;
            return l;
        }
        finally {
            this.pushPopLock.unlock();
        }
    }

    public static AWTEvent getCurrentEvent() {
        return Toolkit.getEventQueue().getCurrentEventImpl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AWTEvent getCurrentEventImpl() {
        this.pushPopLock.lock();
        try {
            AWTEvent aWTEvent = Thread.currentThread() == this.dispatchThread ? (AWTEvent)this.currentEvent.get() : null;
            return aWTEvent;
        }
        finally {
            this.pushPopLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void push(EventQueue eventQueue) {
        if (eventLog.isLoggable(500)) {
            eventLog.fine("EventQueue.push(" + eventQueue + ")");
        }
        this.pushPopLock.lock();
        try {
            EventQueue eventQueue2 = this;
            while (eventQueue2.nextQueue != null) {
                eventQueue2 = eventQueue2.nextQueue;
            }
            if (eventQueue2.dispatchThread != null && eventQueue2.dispatchThread.getEventQueue() == this) {
                eventQueue.dispatchThread = eventQueue2.dispatchThread;
                eventQueue2.dispatchThread.setEventQueue(eventQueue);
            }
            while (eventQueue2.peekEvent() != null) {
                try {
                    eventQueue.postEventPrivate(eventQueue2.getNextEventPrivate());
                }
                catch (InterruptedException interruptedException) {
                    if (!eventLog.isLoggable(500)) continue;
                    eventLog.fine("Interrupted push", interruptedException);
                }
            }
            eventQueue2.postEventPrivate(new InvocationEvent((Object)eventQueue2, dummyRunnable));
            eventQueue.previousQueue = eventQueue2;
            eventQueue2.nextQueue = eventQueue;
            AppContext appContext = AppContext.getAppContext();
            if (appContext.get(AppContext.EVENT_QUEUE_KEY) == eventQueue2) {
                appContext.put(AppContext.EVENT_QUEUE_KEY, eventQueue);
            }
            this.pushPopCond.signalAll();
        }
        finally {
            this.pushPopLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void pop() throws EmptyStackException {
        if (eventLog.isLoggable(500)) {
            eventLog.fine("EventQueue.pop(" + this + ")");
        }
        this.pushPopLock.lock();
        try {
            AppContext appContext;
            EventQueue eventQueue = this;
            while (eventQueue.nextQueue != null) {
                eventQueue = eventQueue.nextQueue;
            }
            EventQueue eventQueue2 = eventQueue.previousQueue;
            if (eventQueue2 == null) {
                throw new EmptyStackException();
            }
            eventQueue.previousQueue = null;
            eventQueue2.nextQueue = null;
            while (eventQueue.peekEvent() != null) {
                try {
                    eventQueue2.postEventPrivate(eventQueue.getNextEventPrivate());
                }
                catch (InterruptedException interruptedException) {
                    if (!eventLog.isLoggable(500)) continue;
                    eventLog.fine("Interrupted pop", interruptedException);
                }
            }
            if (eventQueue.dispatchThread != null && eventQueue.dispatchThread.getEventQueue() == this) {
                eventQueue2.dispatchThread = eventQueue.dispatchThread;
                eventQueue.dispatchThread.setEventQueue(eventQueue2);
            }
            if ((appContext = AppContext.getAppContext()).get(AppContext.EVENT_QUEUE_KEY) == this) {
                appContext.put(AppContext.EVENT_QUEUE_KEY, eventQueue2);
            }
            eventQueue.postEventPrivate(new InvocationEvent((Object)eventQueue, dummyRunnable));
            this.pushPopCond.signalAll();
        }
        finally {
            this.pushPopLock.unlock();
        }
    }

    public SecondaryLoop createSecondaryLoop() {
        return this.createSecondaryLoop(null, null, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SecondaryLoop createSecondaryLoop(Conditional conditional, EventFilter eventFilter, long l) {
        this.pushPopLock.lock();
        try {
            if (this.nextQueue != null) {
                SecondaryLoop secondaryLoop = this.nextQueue.createSecondaryLoop(conditional, eventFilter, l);
                return secondaryLoop;
            }
            if (this.dispatchThread == null) {
                this.initDispatchThread();
            }
            WaitDispatchSupport waitDispatchSupport = new WaitDispatchSupport(this.dispatchThread, conditional, eventFilter, l);
            return waitDispatchSupport;
        }
        finally {
            this.pushPopLock.unlock();
        }
    }

    public static boolean isDispatchThread() {
        EventQueue eventQueue = Toolkit.getEventQueue();
        return eventQueue.isDispatchThreadImpl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean isDispatchThreadImpl() {
        EventQueue eventQueue = this;
        this.pushPopLock.lock();
        try {
            EventQueue eventQueue2 = eventQueue.nextQueue;
            while (eventQueue2 != null) {
                eventQueue = eventQueue2;
                eventQueue2 = eventQueue.nextQueue;
            }
            boolean bl = Thread.currentThread() == eventQueue.dispatchThread;
            return bl;
        }
        finally {
            this.pushPopLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void initDispatchThread() {
        this.pushPopLock.lock();
        try {
            AppContext appContext = AppContext.getAppContext();
            if (this.dispatchThread == null && !this.threadGroup.isDestroyed() && !appContext.isDisposed()) {
                this.dispatchThread = AccessController.doPrivileged(new PrivilegedAction<EventDispatchThread>(){

                    @Override
                    public EventDispatchThread run() {
                        EventDispatchThread eventDispatchThread = new EventDispatchThread(EventQueue.this.threadGroup, EventQueue.this.name, EventQueue.this);
                        eventDispatchThread.setContextClassLoader(EventQueue.this.classLoader);
                        eventDispatchThread.setPriority(6);
                        eventDispatchThread.setDaemon(false);
                        return eventDispatchThread;
                    }
                });
                AWTAutoShutdown.getInstance().notifyThreadBusy(this.dispatchThread);
                this.dispatchThread.start();
            }
        }
        finally {
            this.pushPopLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean detachDispatchThread(EventDispatchThread eventDispatchThread, boolean bl) {
        this.pushPopLock.lock();
        try {
            if (eventDispatchThread == this.dispatchThread) {
                if (!bl && this.peekEvent() != null || !SunToolkit.isPostEventQueueEmpty()) {
                    boolean bl2 = false;
                    return bl2;
                }
                this.dispatchThread = null;
            }
            AWTAutoShutdown.getInstance().notifyThreadFree(eventDispatchThread);
            boolean bl3 = true;
            return bl3;
        }
        finally {
            this.pushPopLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final EventDispatchThread getDispatchThread() {
        this.pushPopLock.lock();
        try {
            EventDispatchThread eventDispatchThread = this.dispatchThread;
            return eventDispatchThread;
        }
        finally {
            this.pushPopLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void removeSourceEvents(Object object, boolean bl) {
        SunToolkit.flushPendingEvents();
        this.pushPopLock.lock();
        try {
            for (int i = 0; i < 4; ++i) {
                EventQueueItem eventQueueItem = this.queues[i].head;
                EventQueueItem eventQueueItem2 = null;
                while (eventQueueItem != null) {
                    if (!(eventQueueItem.event.getSource() != object || !bl && (eventQueueItem.event instanceof SequencedEvent || eventQueueItem.event instanceof SentEvent || eventQueueItem.event instanceof FocusEvent || eventQueueItem.event instanceof WindowEvent || eventQueueItem.event instanceof KeyEvent || eventQueueItem.event instanceof InputMethodEvent))) {
                        if (eventQueueItem.event instanceof SequencedEvent) {
                            ((SequencedEvent)eventQueueItem.event).dispose();
                        }
                        if (eventQueueItem.event instanceof SentEvent) {
                            ((SentEvent)eventQueueItem.event).dispose();
                        }
                        if (eventQueueItem2 == null) {
                            this.queues[i].head = eventQueueItem.next;
                        } else {
                            eventQueueItem2.next = eventQueueItem.next;
                        }
                        this.uncacheEQItem(eventQueueItem);
                    } else {
                        eventQueueItem2 = eventQueueItem;
                    }
                    eventQueueItem = eventQueueItem.next;
                }
                this.queues[i].tail = eventQueueItem2;
            }
        }
        finally {
            this.pushPopLock.unlock();
        }
    }

    static void setCurrentEventAndMostRecentTime(AWTEvent aWTEvent) {
        Toolkit.getEventQueue().setCurrentEventAndMostRecentTimeImpl(aWTEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setCurrentEventAndMostRecentTimeImpl(AWTEvent aWTEvent) {
        this.pushPopLock.lock();
        try {
            if (Thread.currentThread() != this.dispatchThread) {
                return;
            }
            this.currentEvent = new WeakReference<AWTEvent>(aWTEvent);
            long l = Long.MIN_VALUE;
            if (aWTEvent instanceof InputEvent) {
                InputEvent inputEvent = (InputEvent)aWTEvent;
                l = inputEvent.getWhen();
            } else if (aWTEvent instanceof InputMethodEvent) {
                InputMethodEvent inputMethodEvent = (InputMethodEvent)aWTEvent;
                l = inputMethodEvent.getWhen();
            } else if (aWTEvent instanceof ActionEvent) {
                ActionEvent actionEvent = (ActionEvent)aWTEvent;
                l = actionEvent.getWhen();
            } else if (aWTEvent instanceof InvocationEvent) {
                InvocationEvent invocationEvent = (InvocationEvent)aWTEvent;
                l = invocationEvent.getWhen();
            }
            this.mostRecentEventTime = Math.max(this.mostRecentEventTime, l);
        }
        finally {
            this.pushPopLock.unlock();
        }
    }

    public static void invokeLater(Runnable runnable) {
        Toolkit.getEventQueue().postEvent(new InvocationEvent((Object)Toolkit.getDefaultToolkit(), runnable));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void invokeAndWait(Runnable runnable) throws InterruptedException, InvocationTargetException {
        if (EventQueue.isDispatchThread()) {
            throw new Error("Cannot call invokeAndWait from the event dispatcher thread");
        }
        class AWTInvocationLock {
            AWTInvocationLock() {
            }
        }
        AWTInvocationLock aWTInvocationLock = new AWTInvocationLock();
        InvocationEvent invocationEvent = new InvocationEvent(Toolkit.getDefaultToolkit(), runnable, aWTInvocationLock, true);
        Object object = aWTInvocationLock;
        synchronized (object) {
            Toolkit.getEventQueue().postEvent(invocationEvent);
            while (!invocationEvent.isDispatched()) {
                aWTInvocationLock.wait();
            }
        }
        object = invocationEvent.getThrowable();
        if (object != null) {
            throw new InvocationTargetException((Throwable)object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void wakeup(boolean bl) {
        this.pushPopLock.lock();
        try {
            if (this.nextQueue != null) {
                this.nextQueue.wakeup(bl);
            } else if (this.dispatchThread != null) {
                this.pushPopCond.signalAll();
            } else if (!bl) {
                this.initDispatchThread();
            }
        }
        finally {
            this.pushPopLock.unlock();
        }
    }

    static {
        AWTAccessor.setEventQueueAccessor(new AWTAccessor.EventQueueAccessor(){

            @Override
            public Thread getDispatchThread(EventQueue eventQueue) {
                return eventQueue.getDispatchThread();
            }

            @Override
            public boolean isDispatchThreadImpl(EventQueue eventQueue) {
                return eventQueue.isDispatchThreadImpl();
            }

            @Override
            public void removeSourceEvents(EventQueue eventQueue, Object object, boolean bl) {
                eventQueue.removeSourceEvents(object, bl);
            }

            @Override
            public boolean noEvents(EventQueue eventQueue) {
                return eventQueue.noEvents();
            }

            @Override
            public void wakeup(EventQueue eventQueue, boolean bl) {
                eventQueue.wakeup(bl);
            }
        });
        javaSecurityAccess = SharedSecrets.getJavaSecurityAccess();
    }
}

