/*
 * Decompiled with CFR 0.152.
 */
package br.com.auttar.ctfclient.tools.devices.touchkeyboard;

import br.com.auttar.ctfclient.tools.devices.touchkeyboard.TecladoTouchLinx;
import com.csi.ctfclient.gui.TelaPrincipal;
import com.linx.touchkeyboard.TouchKeyboard;
import com.linx.touchkeyboard.exception.KeyboardConfigException;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import javax.swing.JFrame;

public class ConfiguraTecladoTouchLinx {
    private static ConfiguraTecladoTouchLinx configuraTecladoTouch = null;
    private TouchKeyboard touchKeyboard = null;
    private boolean configurado = false;
    private TelaPrincipal frameCTFClient = null;
    private Dimension dimensionCTFClient = null;
    private Dimension dimensionTecladoTouch = new Dimension(648, 410);
    private boolean estadoInicialTeclado = true;
    private boolean estadoTeclado = false;
    private String css = "teclado_touch_ctfclient.css";
    private String layout = "TECLADO_NUMERICO";

    private ConfiguraTecladoTouchLinx() {
    }

    public static ConfiguraTecladoTouchLinx getInstancia() {
        if (configuraTecladoTouch == null) {
            configuraTecladoTouch = new ConfiguraTecladoTouchLinx();
        }
        return configuraTecladoTouch;
    }

    public void configurar(TecladoTouchLinx tecladoTouchLinx) {
        this.touchKeyboard = new TouchKeyboard();
        if (!this.isConfigurado()) {
            try {
                System.out.println("css: " + this.css);
                this.touchKeyboard.configure(new File("mapatecladoTouchLinx.xml"), this.css, (JFrame)tecladoTouchLinx.getFrame(), this.layout);
                ConfiguraTecladoTouchLinx.getInstancia().setConfigurado(true);
                this.touchKeyboard.setLayout(this.layout);
                this.frameCTFClient = (TelaPrincipal)tecladoTouchLinx.getFrame();
                this.touchKeyboard.setComponentFocus((Component)this.frameCTFClient);
                this.dimensionCTFClient = this.frameCTFClient.getSize();
                this.alteraEstadoTeclado();
                this.setConfigurado(true);
                MouseClick mouseClick = new MouseClick();
                this.frameCTFClient.addMouseListener((MouseListener)mouseClick);
                this.frameCTFClient.removeRecuperaFocoListener();
            }
            catch (KeyboardConfigException e) {
                System.out.println("nao foi possivel configurar o teclado touch da linx no ctfclient. ");
                e.printStackTrace();
            }
        }
    }

    protected TouchKeyboard getTouchKeyboard() {
        return this.touchKeyboard;
    }

    protected boolean isConfigurado() {
        return this.configurado;
    }

    protected void setConfigurado(boolean configurado) {
        this.configurado = configurado;
    }

    protected void habilitaFrameTeclado() {
        if (this.estadoInicialTeclado) {
            this.frameCTFClient.setSize(this.dimensionTecladoTouch);
            this.estadoTeclado = true;
        } else {
            this.frameCTFClient.setSize(this.dimensionCTFClient);
            this.estadoTeclado = false;
        }
    }

    protected void desabilitaFrameTeclado() {
        this.frameCTFClient.setSize(this.dimensionCTFClient);
        this.estadoTeclado = false;
    }

    public void setTecladoVisivel(boolean tecladoVisivel) {
        this.estadoInicialTeclado = tecladoVisivel;
    }

    public void setCss(String nome) {
        this.css = nome;
    }

    public void setLayout(String layout) {
        this.layout = layout;
        if (this.touchKeyboard != null) {
            this.touchKeyboard.setLayout(layout);
        }
    }

    protected String getLayout() {
        return this.layout;
    }

    private void alteraEstadoTeclado() {
        if (this.estadoTeclado) {
            this.frameCTFClient.setSize(this.dimensionCTFClient);
            this.estadoTeclado = false;
        } else {
            this.frameCTFClient.setSize(this.dimensionTecladoTouch);
            this.estadoTeclado = true;
        }
    }

    class MouseClick
    implements MouseListener {
        MouseClick() {
        }

        public void mouseReleased(MouseEvent e) {
        }

        public void mousePressed(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() >= 2) {
                ConfiguraTecladoTouchLinx.this.alteraEstadoTeclado();
            }
        }
    }
}

