/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.uvm.abt.edit;

import com.ibm.uvm.abt.edit.ColorCellRenderer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Panel;
import java.awt.SystemColor;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ResourceBundle;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class BasicColorPropertyPage
extends Panel
implements ListSelectionListener {
    private static ResourceBundle resabtedit = ResourceBundle.getBundle("com/ibm/uvm/abt/edit/abtedit");
    static String[] colorNames = new String[]{resabtedit.getString("black"), resabtedit.getString("blue"), resabtedit.getString("cyan"), resabtedit.getString("darkGray"), resabtedit.getString("gray"), resabtedit.getString("green"), resabtedit.getString("lightGray"), resabtedit.getString("magenta"), resabtedit.getString("orange"), resabtedit.getString("pink"), resabtedit.getString("red"), resabtedit.getString("white"), resabtedit.getString("yellow")};
    static Color[] colorValues = new Color[]{Color.black, Color.blue, Color.cyan, Color.darkGray, Color.gray, Color.green, Color.lightGray, Color.magenta, Color.orange, Color.pink, Color.red, Color.white, Color.yellow};
    static String[] initStrings = new String[]{"black", "blue", "cyan", "darkGray", "gray", "green", "lightGray", "magenta", "orange", "pink", "red", "white", "yellow"};
    private JScrollPane scrollPane = null;
    private JList basicColorsList = null;
    protected transient PropertyChangeSupport propertyChange = new PropertyChangeSupport(this);

    public BasicColorPropertyPage() {
        this.initialize();
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChange.addPropertyChangeListener(listener);
    }

    private void basicColorsListValueChanged(ListSelectionEvent arg1) {
        this.firePropertyChange("colorValue", null, this.getColorValue());
    }

    private void fillColorList() {
        DefaultListModel model = (DefaultListModel)this.getBasicColorsList().getModel();
        int i = 0;
        while (i < colorNames.length) {
            model.addElement(new Integer(i));
            ++i;
        }
    }

    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        this.propertyChange.firePropertyChange(propertyName, oldValue, newValue);
    }

    private JList getBasicColorsList() {
        if (this.basicColorsList == null) {
            try {
                this.basicColorsList = new JList();
                this.basicColorsList.setName("BasicColorsList");
                this.basicColorsList.setModel(new DefaultListModel());
                this.basicColorsList.setSelectionMode(0);
                this.basicColorsList.setCellRenderer(new ColorCellRenderer(colorNames, colorValues));
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.basicColorsList;
    }

    public Color getColorValue() {
        return (Color)this.getValue();
    }

    String getJavaInitializationString() {
        int index = this.indexOfSelectedColor();
        return "java.awt.Color." + initStrings[index];
    }

    private JScrollPane getScrollPane() {
        if (this.scrollPane == null) {
            try {
                this.scrollPane = new JScrollPane();
                this.scrollPane.setName("ScrollPanel");
                this.scrollPane.setViewportView(this.getBasicColorsList());
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.scrollPane;
    }

    Object getValue() {
        int index = this.indexOfSelectedColor();
        if (index < 0) {
            return null;
        }
        return colorValues[index];
    }

    private void handleException(Throwable exception) {
    }

    private int indexOfSelectedColor() {
        return this.getBasicColorsList().getSelectedIndex();
    }

    private void initConnections() {
        this.getBasicColorsList().addListSelectionListener(this);
    }

    private void initialize() {
        this.setName("SystemColorPropertyPage");
        this.setLayout(new BorderLayout());
        this.setBackground(SystemColor.window);
        this.setSize(179, 181);
        this.add(this.getScrollPane());
        this.fillColorList();
        this.initConnections();
    }

    public static boolean isBasicColor(Color aColor) {
        int i = 0;
        while (i < colorValues.length) {
            if (aColor.equals(colorValues[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void preselectColor(Color aColor) {
        int i = 0;
        while (i < colorValues.length) {
            if (aColor.equals(colorValues[i])) {
                this.getBasicColorsList().setSelectedIndex(i);
                this.getBasicColorsList().ensureIndexIsVisible(i);
                return;
            }
            ++i;
        }
        this.getBasicColorsList().setSelectedIndex(0);
        this.getBasicColorsList().ensureIndexIsVisible(0);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChange.removePropertyChangeListener(listener);
    }

    public void setColorValue(Color colorValue) {
    }

    public void valueChanged(ListSelectionEvent e) {
        if (e.getSource() == this.getBasicColorsList()) {
            this.basicColorsListValueChanged(e);
        }
    }
}

