/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.uvm.abt.edit;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;

public class DataEncoder {
    protected byte decodeByte(StringReader inString) throws IOException {
        char[] c = new char[2];
        while ((c[0] = (char)inString.read()) == '\n' || c[0] == '\r' || c[0] == '\f') {
        }
        if (c[0] == '\uffff') {
            throw new IOException();
        }
        if (c[0] == 'g') {
            return 0;
        }
        c[1] = (char)inString.read();
        if (c[0] == '\uffff') {
            throw new IOException();
        }
        return (byte)Integer.parseInt(new String(c), 16);
    }

    public byte[] decodeData(String dataToDecode) {
        StringReader inString = new StringReader(dataToDecode);
        ByteArrayOutputStream outStream = new ByteArrayOutputStream(dataToDecode.length() / 2);
        boolean done = false;
        while (!done) {
            try {
                outStream.write(this.decodeByte(inString));
            }
            catch (IOException iOException) {
                done = true;
            }
        }
        return outStream.toByteArray();
    }

    protected void encodeByte(byte aByte, StringWriter outString) {
        if (aByte == 0) {
            outString.write(103);
        } else {
            String s = Integer.toHexString(aByte);
            if (s.length() < 2) {
                outString.write(48);
                outString.write(s);
            } else {
                char[] cbuf = new char[2];
                s.getChars(s.length() - 2, s.length(), cbuf, 0);
                outString.write(cbuf, 0, 2);
            }
        }
    }

    public String encodeData(byte[] bytesToEncode, int bytesPerLine) {
        StringWriter outString = new StringWriter();
        int i = 0;
        while (i < bytesToEncode.length) {
            this.encodeByte(bytesToEncode[i], outString);
            if ((i + 1) % bytesPerLine == 0) {
                outString.write("\n");
            }
            ++i;
        }
        return outString.toString();
    }
}

