/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.uvm.abt.edit;

import java.applet.Applet;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;

public class DialogHelper {
    public static void centerWindowOnComponent(Window w, Component c) {
        Container root = null;
        if (c != null && (c instanceof Window || c instanceof Applet)) {
            root = (Container)c;
        } else {
            Container parent = c.getParent();
            while (parent != null) {
                if (parent instanceof Window || parent instanceof Applet) {
                    root = parent;
                    break;
                }
                parent = parent.getParent();
            }
        }
        if (c != null && !c.isShowing() || root == null || !root.isShowing()) {
            Dimension paneSize = w.getSize();
            Dimension screenSize = w.getToolkit().getScreenSize();
            ((Component)w).setLocation((screenSize.width - paneSize.width) / 2, (screenSize.height - paneSize.height) / 2);
        } else {
            DialogHelper.centerWindowOnRectangle(w, new Rectangle(c.getLocationOnScreen(), c.getSize()));
        }
    }

    public static void centerWindowOnRectangle(Window w, Rectangle r) {
        Dimension rectSize = r.getSize();
        Point rectScreenLocation = r.getLocation();
        Rectangle windowBounds = w.getBounds();
        int dx = rectScreenLocation.x + (rectSize.width - windowBounds.width >> 1);
        int dy = rectScreenLocation.y + (rectSize.height - windowBounds.height >> 1);
        Dimension ss = w.getToolkit().getScreenSize();
        if (dy + windowBounds.height > ss.height) {
            dy = ss.height - windowBounds.height;
            int n = dx = rectScreenLocation.x < ss.width >> 1 ? rectScreenLocation.x + rectSize.width : rectScreenLocation.x - windowBounds.width;
        }
        if (dx + windowBounds.width > ss.width) {
            dx = ss.width - windowBounds.width;
        }
        if (dx < 0) {
            dx = 0;
        }
        if (dy < 0) {
            dy = 0;
        }
        ((Component)w).setLocation(dx, dy);
    }
}

