/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jpos.services;

import com.ibm.jpos.services.DeviceServiceState;
import com.ibm.jpos.services.InputDeviceServiceState;
import com.ibm.jpos.services.ibmprinter.MicrPrinterState;
import com.ibm.jpos.services.ibmprinter.PrintQueueManagerServiceState;
import jpos.JposException;

public class MICRServiceState
extends DeviceServiceState
implements InputDeviceServiceState,
PrintQueueManagerServiceState,
MicrPrinterState {
    private boolean autoDisable = false;
    private String accountNumber = "";
    private String amount = "";
    private String bankNumber = "";
    private int dataCount = 0;
    private boolean dataEventEnabled = false;
    private String epc = "";
    private String rawData = "";
    private String serialNumber = "";
    private String transitNumber = "";
    private int checkType = 99;
    private int countryCode = 99;
    private static final int MICR_SERVICE_VERSION = 1005134;
    private boolean recPresent = false;
    private boolean jrnPresent = false;
    private boolean slpPresent = true;
    private boolean coverOpen = false;
    private boolean flagidle = false;
    private boolean slpend = false;
    private boolean slpempty = false;

    MICRServiceState() {
    }

    public synchronized boolean getCapValidationDevice() {
        return false;
    }

    public synchronized boolean getAutoDisable() {
        return this.autoDisable;
    }

    public synchronized String getAccountNumber() {
        return this.accountNumber;
    }

    public synchronized String getAmount() {
        return this.amount;
    }

    public synchronized String getBankNumber() {
        return this.bankNumber;
    }

    public synchronized int getDataCount() {
        return this.dataCount;
    }

    public synchronized boolean getDataEventEnabled() {
        return this.dataEventEnabled;
    }

    public synchronized String getEPC() {
        return this.epc;
    }

    public synchronized String getRawData() {
        return this.rawData;
    }

    public synchronized String getSerialNumber() {
        return this.serialNumber;
    }

    public synchronized String getTransitNumber() {
        return this.transitNumber;
    }

    public synchronized int getCheckType() {
        return this.checkType;
    }

    public synchronized int getCountryCode() {
        return this.countryCode;
    }

    public synchronized void setAutoDisable(boolean bl) {
        this.autoDisable = bl;
    }

    public synchronized void setAccountNumber(String string) {
        this.accountNumber = string.trim();
    }

    public synchronized void setAmount(String string) {
        this.amount = string.trim();
    }

    public synchronized void setBankNumber(String string) {
        this.bankNumber = string.trim();
    }

    public synchronized void setDataCount(int n) throws JposException {
        this.checkNegativeValue(n);
        this.dataCount = n;
    }

    public synchronized void setDataEventEnabled(boolean bl) {
        this.dataEventEnabled = bl;
    }

    public synchronized void setEPC(String string) {
        this.epc = string.trim();
    }

    public synchronized void setRawData(String string) {
        this.rawData = string.toLowerCase();
    }

    public synchronized void setSerialNumber(String string) {
        this.serialNumber = string.trim();
    }

    public synchronized void setTransitNumber(String string) {
        this.transitNumber = string.trim();
        if (string.length() >= 8) {
            this.setBankNumber(this.transitNumber.substring(3, 8));
        }
    }

    public synchronized void setCheckType(int n) throws JposException {
        this.checkCheckTypeValue(n);
        this.checkType = n;
    }

    public synchronized void setCountryCode(int n) throws JposException {
        this.checkCountryCodeValue(n);
        this.countryCode = n;
    }

    public synchronized void setDeviceEnabled(boolean bl) {
        super.setDeviceEnabled(bl);
    }

    public void checkCheckTypeValue(int n) throws JposException {
        switch (n) {
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            case 99: {
                break;
            }
            default: {
                throw new JposException(106);
            }
        }
    }

    public void checkCountryCodeValue(int n) throws JposException {
        switch (n) {
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                break;
            }
            case 99: {
                break;
            }
            default: {
                throw new JposException(106);
            }
        }
    }

    synchronized void initProperties() throws JposException {
        super.initProperties();
        this.setDeviceServiceVersion(1005134);
        this.setAutoDisable(false);
        this.setDataCount(0);
        this.setDataEventEnabled(false);
        this.setAccountNumber("");
        this.setAmount("");
        this.setBankNumber("");
        this.setEPC("");
        this.setRawData("");
        this.setSerialNumber("");
        this.setTransitNumber("");
        this.setCheckType(99);
        this.setCountryCode(99);
    }

    public void setCapRecPresent(boolean bl) {
        this.recPresent = bl;
    }

    public void setCapJrnPresent(boolean bl) {
        this.jrnPresent = bl;
    }

    public void setCapSlpPresent(boolean bl) {
        this.slpPresent = bl;
    }

    public void setCoverOpen(boolean bl) {
        this.coverOpen = bl;
    }

    public void setFlagWhenIdle(boolean bl) {
        this.flagidle = bl;
    }

    public void setSlpNearEnd(boolean bl) {
        this.slpend = bl;
    }

    public void setSlpEmpty(boolean bl) {
        this.slpempty = bl;
    }

    public boolean getSlpNearEnd() {
        return this.slpend;
    }

    public boolean getSlpEmpty() {
        return this.slpempty;
    }

    public boolean getFlagWhenIdle() {
        return this.flagidle;
    }

    public boolean getAsyncMode() {
        return false;
    }

    public boolean getCapRecPresent() {
        return this.recPresent;
    }

    public boolean getCapJrnPresent() {
        return this.jrnPresent;
    }

    public boolean getCapSlpPresent() {
        return this.slpPresent;
    }

    public boolean getCoverOpen() {
        return this.coverOpen;
    }

    public void setErrorStation(int n) throws JposException {
    }

    public void setErrorString(String string) {
    }

    public void setErrorLevel(int n) throws JposException {
    }

    public void setOutputID(int n) throws JposException {
    }
}

