/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jpos.services.ibmprinter;

class TextAttributes {
    private int fontTypefaceSelection;
    private int underline;
    private int shading;
    private int horizontalScale;
    private int verticalScale;
    private byte flags;
    private static final byte BOLD = 1;
    private static final byte ITALIC = 2;
    private static final byte ALTERNATE_COLOR = 4;
    private static final byte REVERSE_VIDEO = 8;
    private static final byte DOUBLE_WIDE = 16;
    private static final byte DOUBLE_HIGH = 32;
    private static final byte DOUBLE_WIDE_DOUBLE_HIGH = 64;
    private static final int DEFAULT_UNDERLINE = -2147483525;
    private static final int DEFAULT_SHADING = -2147483525;

    TextAttributes() {
        this.reinit();
    }

    TextAttributes(TextAttributes textAttributes) {
        this.reinit(textAttributes);
    }

    void reinit() {
        this.setNormal();
        this.fontTypefaceSelection = 0;
    }

    void reinit(TextAttributes textAttributes) {
        this.flags = textAttributes.flags;
        this.fontTypefaceSelection = textAttributes.fontTypefaceSelection;
        this.underline = textAttributes.underline;
        this.shading = textAttributes.shading;
        this.horizontalScale = textAttributes.horizontalScale;
        this.verticalScale = textAttributes.verticalScale;
    }

    void setNormal() {
        this.flags = 0;
        this.underline = 0;
        this.shading = 0;
        this.horizontalScale = 1;
        this.verticalScale = 1;
    }

    void setFontTypefaceSelection(int n) {
        this.fontTypefaceSelection = n;
    }

    int getFontTypefaceSelection() {
        return this.fontTypefaceSelection;
    }

    void setBold() {
        this.flags = (byte)(this.flags | 1);
    }

    void setBold(boolean bl) {
        this.flags = bl ? (byte)(this.flags | 1) : (byte)(this.flags & 0xFFFFFFFE);
    }

    boolean isBold() {
        return (this.flags & 1) != 0;
    }

    void setUnderline() {
        this.underline = -2147483525;
    }

    void setUnderline(int n) {
        this.underline = n;
    }

    int getUnderline() {
        return this.underline;
    }

    void setItalic() {
        this.flags = (byte)(this.flags | 2);
    }

    void setItalic(boolean bl) {
        this.flags = bl ? (byte)(this.flags | 2) : (byte)(this.flags & 0xFFFFFFFD);
    }

    boolean isItalic() {
        return (this.flags & 2) != 0;
    }

    void setAlternateColor() {
        this.flags = (byte)(this.flags | 4);
    }

    void setAlternateColor(boolean bl) {
        this.flags = bl ? (byte)(this.flags | 4) : (byte)(this.flags & 0xFFFFFFFB);
    }

    boolean isAlternateColor() {
        return (this.flags & 4) != 0;
    }

    void setReverseVideo() {
        this.flags = (byte)(this.flags | 8);
    }

    void setReverseVideo(boolean bl) {
        this.flags = bl ? (byte)(this.flags | 8) : (byte)(this.flags & 0xFFFFFFF7);
    }

    boolean isReverseVideo() {
        return (this.flags & 8) != 0;
    }

    void setShading() {
        this.shading = -2147483525;
    }

    void setShading(int n) {
        this.shading = n;
    }

    int getShading() {
        return this.shading;
    }

    void setSingleWideSingleHigh() {
        this.flags = (byte)(this.flags & 0xFFFFFF8F);
    }

    void setDoubleWide() {
        this.flags = (byte)(this.flags | 0x10);
    }

    void setDoubleWide(boolean bl) {
        this.flags = bl ? (byte)(this.flags | 0x10) : (byte)(this.flags & 0xFFFFFFEF);
    }

    boolean isDoubleWide() {
        return (this.flags & 0x10) != 0;
    }

    void setDoubleHigh() {
        this.flags = (byte)(this.flags | 0x20);
    }

    void setDoubleHigh(boolean bl) {
        this.flags = bl ? (byte)(this.flags | 0x20) : (byte)(this.flags & 0xFFFFFFDF);
    }

    boolean isDoubleHigh() {
        return (this.flags & 0x20) != 0;
    }

    void setDoubleWideDoubleHigh() {
        this.flags = (byte)(this.flags | 0x40);
    }

    boolean isDoubleWideDoubleHigh() {
        return (this.flags & 0x40) != 0;
    }

    void setHorizontalScale(int n) {
        this.horizontalScale = n;
    }

    int getHorizontalScale() {
        return this.horizontalScale;
    }

    void setVerticalScale(int n) {
        this.verticalScale = n;
    }

    int getVerticalScale() {
        return this.verticalScale;
    }

    boolean isNormal() {
        return this.flags == 0 && this.underline == 0 && this.shading == 0 && this.horizontalScale == 1 && this.verticalScale == 1;
    }

    boolean attributesEqual(TextAttributes textAttributes) {
        return this.flags == textAttributes.flags && this.fontTypefaceSelection == textAttributes.fontTypefaceSelection && this.underline == textAttributes.underline && this.shading == textAttributes.shading && this.horizontalScale == textAttributes.horizontalScale && this.verticalScale == textAttributes.verticalScale;
    }
}

