/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jpos.services.jcomm;

import com.ibm.jpos.services.DeviceServiceAbstraction;
import com.ibm.jpos.services.POSPrinterServiceImp;
import com.ibm.jpos.services.ibmprinter.PrinterFont;
import com.ibm.jpos.services.jcomm.IBM4610EPOSPrinterImp;
import com.ibm.jpos.util.ByteEncoder;
import com.ibm.jpos.util.JposEntryInfo;
import com.ibm.jpos.util.Tracer;
import com.ibm.poss.PosDef;
import jpos.JposException;
import jpos.POSPrinterConst;

public class IBM4610SSTPOSPrinterImp
extends IBM4610EPOSPrinterImp
implements PosDef,
POSPrinterServiceImp,
POSPrinterConst {
    private static final String className = "IBM4610SSTPOSPrinterImp";
    private boolean narrowPaper = false;

    protected IBM4610SSTPOSPrinterImp(DeviceServiceAbstraction deviceServiceAbstraction) throws JposException {
        super(deviceServiceAbstraction);
        Tracer.trace(4, className, "Constructor()", "Entry");
        Tracer.trace(4, className, "Constructor()", "Exit");
    }

    public void processDynamicCapabilities() throws JposException {
        Tracer.trace(4, className, "processDynamicCapabilities()", "Entry");
        Object object = this.serial4610Device.getIOSemaphore();
        synchronized (object) {
            String string;
            boolean bl = false;
            JposEntryInfo jposEntryInfo = this.serviceState.getJposEntryInfo();
            if (jposEntryInfo != null && (string = (String)jposEntryInfo.getPropertyValue("colorMode")) != null) {
                int n = Integer.decode(string);
                bl = n == 2;
            }
            Tracer.trace(4, className, "processDynamicCapabilities()", "colorMode = " + bl);
            if (bl) {
                this.serviceState.setCapRecColor(3);
                this.serial4610Device.write(new byte[]{29, 59, 1});
            } else {
                this.serial4610Device.write(new byte[]{29, 59, 0});
            }
            this.serviceState.setCapRec2Color(bl);
            if ((this.serial4610Device.getPrinterID()[3] & 1) != 0) {
                this.narrowPaper = true;
                this.serviceState.setRecLineChars(30);
                this.serviceState.setRecLineWidth(400);
                this.serviceStateReset = false;
            }
            Tracer.trace(4, className, "processDynamicCapabilities()", "Exit");
        }
    }

    protected PrinterFont[] getPrinterFonts() throws JposException {
        Tracer.trace(4, className, "getPrinterFonts()", "Entry");
        PrinterFont[] printerFontArray = null;
        try {
            int n = ByteEncoder.getCodePage(this.serviceState.getCharacterSet());
            switch (n) {
                case 949: 
                case 951: 
                case 1088: {
                    if (this.narrowPaper) {
                        printerFontArray = new PrinterFont[]{new PrinterFont(2, 26, 400, 1, 0, 34)};
                        if (!this.serviceStateReset) {
                            this.serviceState.setRecLineChars(26);
                            this.serviceStateReset = true;
                        }
                    } else {
                        printerFontArray = new PrinterFont[]{new PrinterFont(2, 38, 576, 1, 0, 34)};
                        if (!this.serviceStateReset) {
                            this.serviceState.setRecLineChars(38);
                            this.serviceStateReset = true;
                        }
                    }
                    break;
                }
                case 932: 
                case 950: 
                case 1381: {
                    if (this.narrowPaper) {
                        printerFontArray = new PrinterFont[]{new PrinterFont(2, 26, 576, 10, 0, 34), new PrinterFont(2, 30, 576, 11, 0, 34), new PrinterFont(2, 33, 576, 12, 0, 34)};
                        if (!this.serviceStateReset) {
                            this.serviceState.setRecLineChars(26);
                            this.serviceStateReset = true;
                        }
                    } else {
                        printerFontArray = new PrinterFont[]{new PrinterFont(2, 38, 576, 10, 0, 34), new PrinterFont(2, 44, 576, 11, 0, 34), new PrinterFont(2, 48, 576, 12, 0, 34)};
                        if (!this.serviceStateReset) {
                            this.serviceState.setRecLineChars(38);
                            this.serviceStateReset = true;
                        }
                    }
                    break;
                }
                default: {
                    if (this.narrowPaper) {
                        printerFontArray = new PrinterFont[]{new PrinterFont(2, 30, 400, 1, 0, 34), new PrinterFont(2, 23, 400, 2, 0, 34), new PrinterFont(2, 33, 400, 3, 0, 34), new PrinterFont(2, 40, 400, 4, 0, 34)};
                        break;
                    }
                    printerFontArray = new PrinterFont[]{new PrinterFont(2, 44, 576, 1, 0, 34), new PrinterFont(2, 34, 576, 2, 0, 34), new PrinterFont(2, 48, 576, 3, 0, 34), new PrinterFont(2, 57, 576, 4, 0, 34)};
                    break;
                }
            }
        }
        catch (Exception exception) {
            this.checkPrinterErrorCause();
            throw this.createJposException(exception);
        }
        Tracer.trace(4, className, "getPrinterFonts()", "Exit");
        return printerFontArray;
    }

    public synchronized void setCharacterSet(int n) throws JposException {
        Tracer.trace(4, className, "setCharacterSet(" + n + ")", "Entry");
        super.setCharacterSet(n);
        try {
            this.serviceState.setCapSlpLeft90(false);
            this.serviceState.setSlpSidewaysMaxChars(0);
            this.serviceState.setSlpSidewaysMaxLines(0);
        }
        catch (Exception exception) {
            this.checkPrinterErrorCause();
            throw this.createJposException(exception);
        }
        Tracer.trace(4, className, "setCharacterSet()", "Exit");
    }
}

