/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jpos.services.jcomm;

import com.ibm.jpos.services.DeviceServiceAbstraction;
import com.ibm.jpos.services.MSRParsedData;
import com.ibm.jpos.services.MSRServiceImp;
import com.ibm.jpos.services.MSRServiceState;
import com.ibm.jpos.services.jcomm.CommApi4840MSRConnection;
import com.ibm.jpos.services.jcomm.CommApiDeviceConnection;
import com.ibm.jpos.services.jcomm.CommApiDeviceServiceImp;
import com.ibm.jpos.services.jcomm.IBM4840MSREvent;
import com.ibm.jpos.services.jcomm.IBM4840MSREventListener;
import com.ibm.jpos.services.jcomm.Rs232MsrDataHdr;
import com.ibm.jpos.services.poss.POSSMSRDataParser;
import com.ibm.jpos.util.JposEventContainer;
import com.ibm.jpos.util.Tracer;
import com.ibm.poss.Errno;
import com.ibm.poss.Msr;
import com.ibm.poss.PosDef;
import java.io.ByteArrayInputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import jpos.JposException;
import jpos.MSRConst;
import jpos.events.DataEvent;
import jpos.events.ErrorEvent;
import jpos.events.JposEvent;
import jpos.services.EventCallbacks;

public class IBM4840MSRImp
extends CommApiDeviceServiceImp
implements MSRServiceImp,
IBM4840MSREventListener,
Errno,
PosDef,
Msr {
    private static final String className = "IBM4840MSRImp";
    private MSRServiceState serviceState = null;
    private Object eventSource = null;
    private CommApi4840MSRConnection ibm4840MSRConnection = null;
    private byte[] msrData = new byte[0];
    private int rs232MsrType;
    private static final char TRACKTYPE_A = 'A';
    private static final char TRACKTYPE_B = 'B';
    private static final char TRACKTYPE_C = 'C';
    private static final int TRACKENCODING_4BIT = 4;
    private static final int TRACKENCODING_6BIT = 6;
    private static final int TRACKENCODING_7BIT = 7;
    public static final int RS232_ISO_MSR = 1;
    public static final int RS232_JUCC_MSR = 2;
    private static final String COM_PORT = "COM2";
    private static final String BAUD_RATE = "19200";
    private static final String CONTROL_FLOW = "HARDWARE";

    protected IBM4840MSRImp(DeviceServiceAbstraction deviceServiceAbstraction) throws JposException {
        super(deviceServiceAbstraction);
        Tracer.trace(4, className, "IBM4840MSRImp()", "Entry");
        Tracer.trace(4, className, "IBM4840MSRImp.IBM4840MSRImp", "Exit");
    }

    public void setAutoDisable(boolean bl) throws JposException {
    }

    public void setDataEventEnabled(boolean bl) throws JposException {
    }

    public void setDecodeData(boolean bl) throws JposException {
    }

    public void setErrorReportingType(int n) throws JposException {
    }

    public void setParseDecodeData(boolean bl) throws JposException {
    }

    public void setTracksToRead(int n) throws JposException {
    }

    public void setTransmitSentinels(boolean bl) throws JposException {
        if (!bl) {
            this.serviceState.setTransmitSentinels(bl);
        } else if (this.serviceState.getCapTransmitSentinels()) {
            this.serviceState.setTransmitSentinels(bl);
        } else {
            throw new JposException(106);
        }
    }

    public void IBM4840MSREventOccurred(IBM4840MSREvent iBM4840MSREvent) {
        Tracer.trace(4, className, "IBM4840MSREventOccurred", "entry: eventType = " + iBM4840MSREvent.getEventType());
        switch (iBM4840MSREvent.getEventType()) {
            case 1: {
                Tracer.trace(4, className, "IBM4840MSREventOccurred", "DATA_AVAIL");
                this.msrData = new byte[iBM4840MSREvent.getMsrDataLength()];
                System.arraycopy(iBM4840MSREvent.getMsrData(), 0, this.msrData, 0, iBM4840MSREvent.getMsrDataLength());
                break;
            }
        }
        if (this.serviceState.getDeviceEnabled()) {
            try {
                Tracer.trace(4, className, "IBM4840MSREventOccurred", "EventContainer");
                this.getEventQueueManager().postEvent(new POSSMSREventContainer());
            }
            catch (Exception exception) {
                Tracer.trace(4, className, "IBM4840MSREventOccurred", "Exception");
            }
        }
        Tracer.trace(4, className, "IBM4840MSREventOccurred", "exit");
    }

    public void open(String string, EventCallbacks eventCallbacks) throws JposException {
        Tracer.trace(4, className, "open()", "Entry");
        Hashtable hashtable = this.getPosResourceHashtable();
        try {
            if (this.getJposEntry() != null) {
                String string2 = "";
                Enumeration enumeration = null;
                String[] stringArray = new String[]{"comm"};
                int n = 0;
                while (n < stringArray.length) {
                    enumeration = this.getJposEntry().getPropertyNames();
                    while (enumeration.hasMoreElements()) {
                        string2 = (String)enumeration.nextElement();
                        if (!string2.startsWith(stringArray[n])) continue;
                        hashtable.put(string2.substring(stringArray[n].length(), string2.length()), this.getJposEntry().getPropertyValue(string2));
                    }
                    ++n;
                }
            }
        }
        catch (Exception exception) {
            Tracer.trace(1, className, "open()", "JposEntry Exception is " + exception);
            throw new JposException(111);
        }
        if (hashtable.containsKey("ComPort")) {
            this.comPort = hashtable.get("ComPort").toString();
        }
        if (hashtable.containsKey("BaudRate")) {
            this.baudRate = hashtable.get("BaudRate").toString();
        }
        if (hashtable.containsKey("FlowControl")) {
            this.flowControl = hashtable.get("FlowControl").toString();
        } else if (hashtable.containsKey("ControlFlow")) {
            this.flowControl = hashtable.get("ControlFlow").toString();
        }
        Tracer.trace(4, className, " ", " Finished scanning JposEntry -  comPort:" + this.comPort + ", " + " baudRate:" + this.baudRate + ", " + " flowControl:" + this.flowControl);
        this.serviceState = (MSRServiceState)this.getDeviceServiceState();
        this.eventSource = eventCallbacks.getEventSource();
        try {
            Tracer.trace(4, className, " ", " Calling open -  comPort:" + this.comPort + ", " + " baudRate:" + this.baudRate + ", " + " flowControl:" + this.flowControl);
            this.ibm4840MSRConnection = (CommApi4840MSRConnection)CommApi4840MSRConnection.open(this.comPort, new Integer(this.baudRate), this.flowControl, 8, 1, 0);
            Tracer.trace(4, className, " ", " Add to listener vector");
            CommApi4840MSRConnection.addEventListener(this);
        }
        catch (Exception exception) {
            Tracer.trace(1, className, "open", "exception is " + exception);
            throw new JposException(108);
        }
        Tracer.trace(4, className, "open()", "Exit");
    }

    public synchronized void close() throws JposException {
        Tracer.trace(4, className, "close()", "Entry");
        try {
            Tracer.trace(4, className, " ", " Remove from listener vector");
            CommApi4840MSRConnection.removeEventListener(this);
            this.ibm4840MSRConnection.close();
            this.ibm4840MSRConnection = null;
            super.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Tracer.trace(4, className, "close()", "Exit");
    }

    public void clearInput() throws JposException {
    }

    public synchronized void deleteImp() throws JposException {
        super.deleteImp();
    }

    protected int getMSRType() {
        return this.rs232MsrType;
    }

    protected void setMSRType(int n) {
        this.rs232MsrType = n;
    }

    protected CommApiDeviceConnection getDeviceConnection() {
        return this.ibm4840MSRConnection;
    }

    private class POSSMSREventContainer
    implements JposEventContainer,
    MSRConst,
    MSRParsedData {
        ErrorEvent errorEvent;
        private char track1Type = (char)67;
        private int track1Encoding = 6;
        private int track2Encoding = 4;
        private int track3Encoding = 4;
        private POSSMSRDataParser msrDataParser = null;
        private JposEvent jposEvent = null;
        private int errorReportingType = 0;
        private String accountNumber = "";
        private String expirationDate = "";
        private String firstName = "";
        private String middleInitial = "";
        private String serviceCode = "";
        private String suffix = "";
        private String surname = "";
        private String title = "";
        private byte[] track1Data = new byte[0];
        private byte[] track1DiscretionaryData = new byte[0];
        private byte[] track2Data = new byte[0];
        private byte[] track2DiscretionaryData = new byte[0];
        private byte[] track3Data = new byte[0];
        private byte[] trackJData = new byte[0];

        public void prepareToFire() {
            Tracer.trace(4, IBM4840MSRImp.className, "$POSSMSREventContainer.prepareToFire(): ", "Entry");
            if (!(this.jposEvent instanceof ErrorEvent) || this.errorReportingType != 0) {
                try {
                    IBM4840MSRImp.this.serviceState.setAccountNumber(this.accountNumber);
                    IBM4840MSRImp.this.serviceState.setExpirationDate(this.expirationDate);
                    IBM4840MSRImp.this.serviceState.setFirstName(this.firstName);
                    IBM4840MSRImp.this.serviceState.setMiddleInitial(this.middleInitial);
                    IBM4840MSRImp.this.serviceState.setServiceCode(this.serviceCode);
                    IBM4840MSRImp.this.serviceState.setSuffix(this.suffix);
                    IBM4840MSRImp.this.serviceState.setSurname(this.surname);
                    IBM4840MSRImp.this.serviceState.setTitle(this.title);
                    IBM4840MSRImp.this.serviceState.setTrack1Data(this.track1Data);
                    IBM4840MSRImp.this.serviceState.setTrack1DiscretionaryData(this.track1DiscretionaryData);
                    IBM4840MSRImp.this.serviceState.setTrack2Data(this.track2Data);
                    IBM4840MSRImp.this.serviceState.setTrack2DiscretionaryData(this.track2DiscretionaryData);
                    IBM4840MSRImp.this.serviceState.setTrack3Data(this.track3Data);
                    IBM4840MSRImp.this.serviceState.setTrack4Data(this.trackJData);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            Tracer.trace(4, IBM4840MSRImp.className, "IBM4840MSRImp$POSSMSREventContainer.prepareToFire:", " Exit ");
        }

        public void doneFiring() {
            Tracer.trace(4, IBM4840MSRImp.className, "$POSSMSREventContainer.DoneFiring()" + this.errorEvent.getErrorResponse(), "Entry");
            switch (this.errorEvent.getErrorResponse()) {
                case 11: {
                    break;
                }
                case 13: {
                    if (this.errorEvent.getErrorLocus() != 2) break;
                    try {
                        IBM4840MSRImp.this.clearInput();
                        IBM4840MSRImp.this.serviceState.setState(2);
                    }
                    catch (Exception exception) {}
                    break;
                }
                case 12: {
                    try {
                        IBM4840MSRImp.this.serviceState.setState(2);
                        IBM4840MSRImp.this.clearInput();
                        break;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            Tracer.trace(4, IBM4840MSRImp.className, "$POSSMSREventContainer.doneFiring()", "Exit");
        }

        public JposEvent getJposEvent() {
            Tracer.trace(4, IBM4840MSRImp.className, "IBM4840MSRImp$POSSMSREventContainer.getJposEvent:", " Entry");
            Tracer.trace(4, IBM4840MSRImp.className, "IBM4840MSRImp$POSSMSREventContainer.getJposEvent:", " Exit");
            return this.jposEvent;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public POSSMSREventContainer() {
            int n = 2;
            int n2 = 12;
            int n3 = 0;
            int n4 = 0;
            Tracer.trace(4, IBM4840MSRImp.className, "$POSSMSREventContainer.constructor: ", "Entry");
            try {
                block84: {
                    try {
                        this.errorReportingType = IBM4840MSRImp.this.serviceState.getErrorReportingType();
                        switch (IBM4840MSRImp.this.serviceState.getTracksToRead()) {
                            case 1: {
                                n4 = 1;
                                break;
                            }
                            case 2: {
                                n4 = 2;
                                break;
                            }
                            case 4: {
                                n4 = 4;
                                break;
                            }
                            case 8: {
                                n4 = 8;
                                break;
                            }
                            case 3: {
                                n4 = 3;
                                break;
                            }
                            case 5: {
                                n4 = 5;
                                break;
                            }
                            case 9: {
                                n4 = 9;
                                break;
                            }
                            case 6: {
                                n4 = 6;
                                break;
                            }
                            case 10: {
                                n4 = 10;
                                break;
                            }
                            case 12: {
                                n4 = 12;
                                break;
                            }
                            case 7: {
                                n4 = 7;
                                break;
                            }
                            case 11: {
                                n4 = 11;
                                break;
                            }
                            case 13: {
                                n4 = 13;
                                break;
                            }
                            case 14: {
                                n4 = 14;
                                break;
                            }
                            case 15: {
                                n4 = 11;
                                break;
                            }
                        }
                        Rs232MsrDataHdr rs232MsrDataHdr = null;
                        int n5 = 0;
                        short s = 0;
                        boolean bl = false;
                        int n6 = 0;
                        while (n6 < 3) {
                            rs232MsrDataHdr = new Rs232MsrDataHdr(IBM4840MSRImp.this.msrData, n5);
                            n3 = rs232MsrDataHdr.getTrack();
                            s = rs232MsrDataHdr.getLength();
                            bl = rs232MsrDataHdr.getTrackError();
                            switch (n3) {
                                case 1: {
                                    Tracer.trace(4, "IBM4840MSRImp$POSSMSREventContainer", "POSSMSREventContainer()", "Track type: PosTRACK_1");
                                    break;
                                }
                                case 2: {
                                    Tracer.trace(4, "IBM4840MSRImp$POSSMSREventContainer", "POSSMSREventContainer()", "Track type: PosTRACK_2");
                                    break;
                                }
                                case 4: {
                                    Tracer.trace(4, "IBM4840MSRImp$POSSMSREventContainer", "POSSMSREventContainer()", "Track type: PosTRACK_3");
                                    break;
                                }
                                case 8: {
                                    Tracer.trace(4, "IBM4840MSRImp$POSSMSREventContainer", "POSSMSREventContainer()", "Track type: PosTRACK_J");
                                    break;
                                }
                            }
                            if ((n3 & n4) != 0) {
                                if (!bl) {
                                    if (s > 0) {
                                        switch (n3) {
                                            case 1: {
                                                this.track1Data = new byte[s];
                                                System.arraycopy(IBM4840MSRImp.this.msrData, n5 + 1, this.track1Data, 0, s);
                                                String string = new String(this.track1Data);
                                                Tracer.trace(4, IBM4840MSRImp.className, " ", "track1Data: " + string);
                                                break;
                                            }
                                            case 2: {
                                                this.track2Data = new byte[s];
                                                System.arraycopy(IBM4840MSRImp.this.msrData, n5 + 1, this.track2Data, 0, s);
                                                String string = new String(this.track2Data);
                                                Tracer.trace(4, IBM4840MSRImp.className, " ", "track2Data: " + string);
                                                break;
                                            }
                                            case 4: {
                                                this.track3Data = new byte[s];
                                                System.arraycopy(IBM4840MSRImp.this.msrData, n5 + 1, this.track3Data, 0, s);
                                                String string = new String(this.track3Data);
                                                Tracer.trace(4, IBM4840MSRImp.className, " ", "track3Data: " + string);
                                                break;
                                            }
                                            case 8: {
                                                this.trackJData = new byte[s];
                                                System.arraycopy(IBM4840MSRImp.this.msrData, n5 + 1, this.trackJData, 0, s);
                                                String string = new String(this.trackJData);
                                                Tracer.trace(4, IBM4840MSRImp.className, " ", "trackJData: " + string);
                                                break;
                                            }
                                        }
                                    }
                                } else {
                                    Tracer.trace(4, IBM4840MSRImp.className, " ", "Read Error on requested track: " + n6);
                                    this.jposEvent = new ErrorEvent(IBM4840MSRImp.this.eventSource, 111, 0, 2, 12);
                                    if (this.errorReportingType == 0) {
                                        if (this.track1Data.length != 0) {
                                            this.track1Data = new byte[0];
                                        }
                                        if (this.track2Data.length != 0) {
                                            this.track2Data = new byte[0];
                                        }
                                        if (this.track3Data.length != 0) {
                                            this.track3Data = new byte[0];
                                        }
                                        if (this.trackJData.length == 0) break;
                                        this.trackJData = new byte[0];
                                        break;
                                    }
                                }
                            }
                            n5 = rs232MsrDataHdr.getTrackIndex();
                            ++n6;
                        }
                        if (this.jposEvent == null && this.track1Data.length == 0 && this.track2Data.length == 0 && this.track3Data.length == 0 && this.trackJData.length == 0) {
                            this.jposEvent = new ErrorEvent(IBM4840MSRImp.this.eventSource, 111, 0, 2, 12);
                        }
                        if (this.track1Data.length > 0) {
                            block35 : switch (this.track1Data[0]) {
                                case 33: {
                                    this.track1Type = (char)65;
                                    int n7 = this.track1Data.length - 1;
                                    while (n7 >= 0) {
                                        if ((this.track1Data[n7] & 0xC0) != 0) {
                                            this.track1Type = (char)67;
                                            break block35;
                                        }
                                        --n7;
                                    }
                                    break;
                                }
                                case 34: {
                                    this.track1Type = (char)66;
                                    int n8 = this.track1Data.length - 1;
                                    while (n8 >= 0) {
                                        if ((this.track1Data[n8] & 0xC0) != 0) {
                                            this.track1Type = (char)67;
                                            break block35;
                                        }
                                        --n8;
                                    }
                                    break;
                                }
                                default: {
                                    this.track1Type = (char)67;
                                }
                            }
                        }
                        if (IBM4840MSRImp.this.serviceState.getDecodeData()) {
                            Tracer.trace(4, IBM4840MSRImp.className, "POSSMSREventContainer", "POSSMSREventContainer");
                            Tracer.trace(4, IBM4840MSRImp.className, "POSSMSREventContainer", "track1Data.length: " + this.track1Data.length);
                            if (this.track1Data.length > 0) {
                                this.track1Encoding = 6;
                                int n9 = 0;
                                int n10 = this.track1Data.length;
                                while (n9 < n10) {
                                    if ((this.track1Data[n9] & 0xC0) != 0) {
                                        this.track1Encoding = 7;
                                        break;
                                    }
                                    ++n9;
                                }
                                if (this.track1Encoding == 6 && this.track1Data[0] != 33 && this.track1Data[0] != 34) {
                                    this.track1Encoding = 7;
                                }
                                if (this.track1Encoding == 6) {
                                    int n11 = 0;
                                    int n12 = this.track1Data.length;
                                    while (n11 < n12) {
                                        int n7 = n11++;
                                        this.track1Data[n7] = (byte)(this.track1Data[n7] + 32);
                                    }
                                }
                            }
                            this.track2Encoding = 4;
                            int n14 = 0;
                            int n15 = this.track2Data.length;
                            while (n14 < n15) {
                                if ((this.track2Data[n14] & 0xF0) != 0) {
                                    this.track2Encoding = 7;
                                    break;
                                }
                                ++n14;
                            }
                            if (this.track2Encoding == 4) {
                                int n16 = 0;
                                int n17 = this.track2Data.length;
                                while (n16 < n17) {
                                    int n8 = n16++;
                                    this.track2Data[n8] = (byte)(this.track2Data[n8] + 48);
                                }
                            }
                            if (this.track3Data.length > 0) {
                                this.track3Encoding = 4;
                                int n19 = 0;
                                int n20 = this.track3Data.length;
                                while (n19 < n20) {
                                    if ((this.track3Data[n19] & 0xF0) != 0) {
                                        this.track3Encoding = 7;
                                        break;
                                    }
                                    ++n19;
                                }
                                if (this.track3Encoding == 4) {
                                    int n21 = 0;
                                    int n22 = this.track3Data.length;
                                    while (n21 < n22) {
                                        int n9 = n21++;
                                        this.track3Data[n9] = (byte)(this.track3Data[n9] + 48);
                                    }
                                }
                            }
                        }
                        if (IBM4840MSRImp.this.serviceState.getParseDecodeData()) {
                            if (this.track1Data.length > 0) {
                                this.msrDataParser = new POSSMSRDataParser(new ByteArrayInputStream(this.track1Data));
                                this.msrDataParser.start(1, this);
                            }
                            if (this.track2Data.length > 0) {
                                if (this.msrDataParser == null) {
                                    this.msrDataParser = new POSSMSRDataParser(new ByteArrayInputStream(this.track2Data));
                                } else {
                                    this.msrDataParser.ReInit(new ByteArrayInputStream(this.track2Data));
                                }
                                this.msrDataParser.start(2, this);
                            }
                        }
                        if (this.jposEvent != null) break block84;
                        int n24 = 0;
                        n24 = this.trackJData.length > 0 ? (n24 |= this.trackJData.length & 0xFF) : (n24 |= this.track1Data.length & 0xFF);
                        n24 |= this.track2Data.length << 8 & 0xFF00;
                        Tracer.trace(4, IBM4840MSRImp.className, "IBM4840MSRImp$POSSMSREventContainer:", " new DataEvent");
                        this.jposEvent = new DataEvent(IBM4840MSRImp.this.eventSource, n24 |= this.track3Data.length << 16 & 0xFF0000);
                    }
                    catch (Exception exception) {
                        Tracer.trace(4, IBM4840MSRImp.className, "$POSSMSREventContainer.constructor: ", "Exception");
                        this.jposEvent = new ErrorEvent(IBM4840MSRImp.this.eventSource, 111, 0, 2, 12);
                        if (this.errorReportingType == 0) {
                            this.track1Data = new byte[0];
                            this.track2Data = new byte[0];
                            this.track3Data = new byte[0];
                            this.trackJData = new byte[0];
                            this.accountNumber = "";
                            this.expirationDate = "";
                            this.firstName = "";
                            this.middleInitial = "";
                            this.serviceCode = "";
                            this.suffix = "";
                            this.surname = "";
                            this.title = "";
                            this.track1Data = new byte[0];
                            this.track1DiscretionaryData = new byte[0];
                            this.track2Data = new byte[0];
                            this.track2DiscretionaryData = new byte[0];
                            this.track3Data = new byte[0];
                            this.trackJData = new byte[0];
                        }
                        Object var19_32 = null;
                        MSRServiceState mSRServiceState2 = IBM4840MSRImp.this.serviceState;
                        synchronized (mSRServiceState2) {
                            if (this.jposEvent == null || this.jposEvent instanceof ErrorEvent || !IBM4840MSRImp.this.serviceState.getAutoDisable()) {
                                IBM4840MSRImp.this.serviceState.setDeviceEnabled(true);
                            } else {
                                IBM4840MSRImp.this.serviceState.setDeviceEnabled(false);
                            }
                        }
                        Tracer.trace(4, IBM4840MSRImp.className, "$POSSMSREventContainer.constructor: ", "Exit");
                        this.errorEvent = new ErrorEvent(IBM4840MSRImp.this.eventSource, 111, 0, n, n2);
                        return;
                    }
                }
                Object var19_31 = null;
                MSRServiceState mSRServiceState = IBM4840MSRImp.this.serviceState;
                synchronized (mSRServiceState) {
                    if (this.jposEvent == null || this.jposEvent instanceof ErrorEvent || !IBM4840MSRImp.this.serviceState.getAutoDisable()) {
                        IBM4840MSRImp.this.serviceState.setDeviceEnabled(true);
                    } else {
                        IBM4840MSRImp.this.serviceState.setDeviceEnabled(false);
                    }
                }
                Tracer.trace(4, IBM4840MSRImp.className, "$POSSMSREventContainer.constructor: ", "Exit");
                this.errorEvent = new ErrorEvent(IBM4840MSRImp.this.eventSource, 111, 0, n, n2);
                return;
            }
            catch (Throwable throwable) {
                Object var19_33 = null;
                MSRServiceState mSRServiceState = IBM4840MSRImp.this.serviceState;
                synchronized (mSRServiceState) {
                    if (this.jposEvent == null || this.jposEvent instanceof ErrorEvent || !IBM4840MSRImp.this.serviceState.getAutoDisable()) {
                        IBM4840MSRImp.this.serviceState.setDeviceEnabled(true);
                    } else {
                        IBM4840MSRImp.this.serviceState.setDeviceEnabled(false);
                    }
                }
                Tracer.trace(4, IBM4840MSRImp.className, "$POSSMSREventContainer.constructor: ", "Exit");
                this.errorEvent = new ErrorEvent(IBM4840MSRImp.this.eventSource, 111, 0, n, n2);
                throw throwable;
            }
        }

        public String getAccountNumber() {
            return this.accountNumber;
        }

        public String getExpirationDate() {
            return this.expirationDate;
        }

        public String getFirstName() {
            return this.firstName;
        }

        public String getMiddleInitial() {
            return this.middleInitial;
        }

        public String getServiceCode() {
            return this.serviceCode;
        }

        public String getSuffix() {
            return this.suffix;
        }

        public String getSurname() {
            return this.surname;
        }

        public String getTitle() {
            return this.title;
        }

        public byte[] getTrack1DiscretionaryData() {
            return this.track1DiscretionaryData;
        }

        public byte[] getTrack2DiscretionaryData() {
            return this.track2DiscretionaryData;
        }

        public void setAccountNumber(String string) {
            this.accountNumber = string;
        }

        public void setExpirationDate(String string) {
            this.expirationDate = string;
        }

        public void setFirstName(String string) {
            this.firstName = string;
        }

        public void setMiddleInitial(String string) {
            this.middleInitial = string;
        }

        public void setServiceCode(String string) {
            this.serviceCode = string;
        }

        public void setSuffix(String string) {
            this.suffix = string;
        }

        public void setSurname(String string) {
            this.surname = string;
        }

        public void setTitle(String string) {
            this.title = string;
        }

        public void setTrack1DiscretionaryData(byte[] byArray) {
            this.track1DiscretionaryData = byArray;
        }

        public void setTrack2DiscretionaryData(byte[] byArray) {
            this.track2DiscretionaryData = byArray;
        }
    }
}

