/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jpos.services.poss;

import com.ibm.jpos.services.DeviceServiceAbstraction;
import com.ibm.jpos.services.POSPrinterServiceImp;
import com.ibm.jpos.services.POSPrinterServiceState;
import com.ibm.jpos.services.ibmprinter.PrinterFont;
import com.ibm.jpos.services.poss.POSPrinter4610EPOSSPrintDataCompiler;
import com.ibm.jpos.services.poss.POSPrinter4610Imp;
import com.ibm.jpos.util.ByteEncoder;
import com.ibm.jpos.util.JposEntryInfo;
import com.ibm.jpos.util.Tracer;
import com.ibm.poss.PosArg;
import com.ibm.poss.PosDef;
import com.ibm.poss.PosException;
import jpos.JposException;
import jpos.POSPrinterConst;
import jpos.services.EventCallbacks;

public class POSPrinter4610EImp
extends POSPrinter4610Imp
implements PosDef,
POSPrinterServiceImp,
POSPrinterConst {
    private static final String className = "POSPrinter4610EImp";
    private boolean colorMode = false;

    protected POSPrinter4610EImp(DeviceServiceAbstraction deviceServiceAbstraction) throws JposException {
        super(deviceServiceAbstraction);
        Tracer.trace(4, className, "Constructor()", "Entry");
        Tracer.trace(4, className, "Constructor()", "Exit");
    }

    public void open(String string, EventCallbacks eventCallbacks) throws JposException {
        Tracer.trace(4, className, "open(" + string + ")", "Entry");
        super.open(string, eventCallbacks);
        this.printDataCompiler = new POSPrinter4610EPOSSPrintDataCompiler((POSPrinterServiceState)this.getDeviceServiceState());
        Tracer.trace(4, className, "open()", "Exit");
    }

    public void processDynamicCapabilities() throws JposException {
        PosArg[] posArgArray;
        Tracer.trace(4, className, "processDynamicCapabilities()", "Entry");
        super.processDynamicCapabilities();
        JposEntryInfo jposEntryInfo = this.serviceState.getJposEntryInfo();
        if (jposEntryInfo != null && (posArgArray = (PosArg[])jposEntryInfo.getPropertyValue("colorMode")) != null) {
            int n = Integer.decode((String)posArgArray);
            this.colorMode = n == 2;
        }
        Tracer.trace(4, className, "processDynamicCapabilities()", "colorMode = " + this.colorMode);
        this.serviceState.setCapRec2Color(this.colorMode);
        if (this.colorMode) {
            this.serviceState.setCapRecColor(3);
            try {
                posArgArray = new PosArg[]{new PosArg("printColorMode", 1)};
                this.posDevice.ioctl(305, posArgArray);
            }
            catch (PosException posException) {
                throw new JposException(111, posException.getMessage(), (Exception)posException);
            }
        }
        Tracer.trace(4, className, "processDynamicCapabilities()", "Exit");
    }

    protected PrinterFont[] getPrinterFonts() throws JposException {
        Tracer.trace(4, className, "getPrinterFonts()", "Entry");
        PrinterFont[] printerFontArray = null;
        try {
            int n = ByteEncoder.getCodePage(this.serviceState.getCharacterSet());
            switch (n) {
                case 949: 
                case 951: 
                case 1088: {
                    printerFontArray = new PrinterFont[]{new PrinterFont(2, 38, 576, 1, 0, 34), new PrinterFont(4, 43, 474, 1, 0, 8)};
                    if (!this.serviceStateReset) {
                        this.serviceState.setRecLineChars(38);
                        this.serviceState.setSlpLineChars(43);
                        this.serviceStateReset = true;
                    }
                    break;
                }
                case 932: 
                case 950: 
                case 1381: {
                    printerFontArray = new PrinterFont[]{new PrinterFont(2, 38, 576, 5, 0, 34), new PrinterFont(2, 44, 576, 5, 0, 34), new PrinterFont(2, 48, 576, 5, 0, 34), new PrinterFont(4, 23, 474, 5, 0, 8), new PrinterFont(4, 24, 474, 5, 0, 8), new PrinterFont(4, 26, 474, 5, 0, 8), new PrinterFont(4, 27, 474, 5, 0, 8), new PrinterFont(4, 29, 474, 5, 0, 8)};
                    if (!this.serviceStateReset) {
                        this.serviceState.setRecLineChars(38);
                        this.serviceState.setSlpLineChars(24);
                        this.serviceStateReset = true;
                    }
                    break;
                }
                default: {
                    printerFontArray = new PrinterFont[]{new PrinterFont(2, 44, 576, 1, 0, 34), new PrinterFont(2, 34, 576, 2, 0, 34), new PrinterFont(2, 48, 576, 3, 0, 34), new PrinterFont(2, 57, 576, 4, 0, 34), new PrinterFont(4, 47, 474, 1, 0, 8), new PrinterFont(4, 37, 474, 2, 0, 8), new PrinterFont(4, 52, 474, 3, 0, 8), new PrinterFont(4, 38, 384, 1, 1, 8), new PrinterFont(4, 30, 384, 2, 1, 8), new PrinterFont(4, 42, 384, 3, 1, 8)};
                    break;
                }
            }
        }
        catch (Exception exception) {
            this.checkPrinterErrorCause();
            throw this.createJposException(exception);
        }
        Tracer.trace(4, className, "getPrinterFonts()", "Exit");
        return printerFontArray;
    }

    public synchronized void setRecLetterQuality(boolean bl) throws JposException {
        Tracer.trace(4, className, "setRecLetterQuality(" + bl + ")", "Entry");
        try {
            PosArg[] posArgArray = new PosArg[]{new PosArg("printQualityMode", bl ? 1 : 0)};
            this.posDevice.ioctl(305, posArgArray);
        }
        catch (PosException posException) {
            throw new JposException(111, posException.getMessage(), (Exception)posException);
        }
        this.serviceState.setRecLetterQuality(bl);
        Tracer.trace(4, className, "setRecLetterQuality()", "Exit");
    }

    public void setRecCurrentCartridge(int n) throws JposException {
        switch (n) {
            case 1: {
                break;
            }
            case 2: {
                if (this.colorMode) break;
            }
            default: {
                throw new JposException(106);
            }
        }
    }

    public int getWriteBufferSize() {
        Tracer.trace(4, className, "getWriteBufferSize()", "Entry");
        Tracer.trace(4, className, "getWriteBufferSize() = 8192", "Exit");
        return 8000;
    }
}

