/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jpos.services.poss;

import com.ibm.jpos.services.POSPrinterServiceState;
import com.ibm.jpos.services.ibmprinter.PrintDataParseException;
import com.ibm.jpos.services.ibmprinter.PrinterFont;
import com.ibm.jpos.services.poss.POSPrinter4610POSSPrintDataCompiler;
import com.ibm.jpos.util.ByteBuffer;
import com.ibm.jpos.util.Tracer;
import com.ibm.poss.Printer;
import jpos.JposException;
import jpos.POSPrinterConst;

public class POSPrinter4610EPOSSPrintDataCompiler
extends POSPrinter4610POSSPrintDataCompiler
implements POSPrinterConst,
Printer {
    private static final String className = "POSPrinter4610EPOSSPrintDataCompiler";
    private PrinterFont selectedPrinterFont = null;

    POSPrinter4610EPOSSPrintDataCompiler(POSPrinterServiceState pOSPrinterServiceState) throws JposException {
        super(pOSPrinterServiceState);
    }

    protected byte[] getPrologueBytes() throws PrintDataParseException, JposException {
        Tracer.trace(4, className, "getPrologueBytes()", "Entry");
        PrinterFont[] printerFontArray = this.getPrinterFonts();
        ByteBuffer byteBuffer = new ByteBuffer();
        String string = "";
        int n = 0;
        int n2 = -1;
        switch (this.getStation()) {
            case 1: {
                string = "JrnLineChars";
                n = this.getServiceState().getJrnLineChars();
                break;
            }
            case 2: {
                string = "RecLineChars";
                n = this.getServiceState().getRecLineChars();
                break;
            }
            case 4: {
                string = "SlpLineChars";
                n = this.getServiceState().getSlpLineChars();
                break;
            }
            default: {
                throw new JposException(111);
            }
        }
        Tracer.trace(4, className, "getPrologueBytes()", string + " == " + n);
        int n3 = 0;
        while (n3 < printerFontArray.length) {
            if (printerFontArray[n3].station == this.getStation()) {
                if (printerFontArray[n3].lineChars == n) {
                    n2 = n3;
                    break;
                }
                if (printerFontArray[n3].lineChars > n && (n2 == -1 || printerFontArray[n2].lineChars > printerFontArray[n3].lineChars)) {
                    n2 = n3;
                }
            }
            ++n3;
        }
        if (n2 == -1) {
            throw new JposException(111);
        }
        this.selectedPrinterFont = printerFontArray[n2];
        switch (printerFontArray[n2].fontType) {
            case 2: {
                byteBuffer.append(27).append(58);
                Tracer.trace(4, className, "getPrologueBytes()", "using spread font");
                break;
            }
            case 1: {
                byteBuffer.append(27).append(59);
                Tracer.trace(4, className, "getPrologueBytes()", "using normal font");
                break;
            }
            case 3: {
                byteBuffer.append(27).append(60);
                Tracer.trace(4, className, "getPrologueBytes()", "using small font");
                break;
            }
            case 4: {
                byteBuffer.append(27).append(62);
                Tracer.trace(4, className, "getPrologueBytes()", "using tiny font");
                break;
            }
            case 5: {
                byteBuffer.append(27).append(61).append((byte)n);
                Tracer.trace(4, className, "getPrologueBytes()", "using dbcs font");
            }
        }
        switch (this.getRotation()) {
            case 257: {
                this.reverseText();
                this.setInverted(true);
                byteBuffer.append(27).append(33).append(5);
                byteBuffer.append(27).append(33).append(6);
                break;
            }
            case 258: {
                this.reverseLines();
                this.setInverted(false);
                byteBuffer.append(27).append(33).append(133);
                byteBuffer.append(27).append(33).append(6);
                break;
            }
            case 259: {
                this.setInverted(false);
                byteBuffer.append(27).append(33).append(133);
                byteBuffer.append(27).append(33).append(134);
                break;
            }
            default: {
                this.setInverted(false);
                byteBuffer.append(27).append(33).append(133);
                byteBuffer.append(27).append(33).append(134);
            }
        }
        this.currentHorizontalScale = 1;
        this.currentVerticalScale = 1;
        Tracer.trace(4, className, "getPrologueBytes()", "Exit");
        return byteBuffer.getBytes();
    }

    protected byte[] getAlternateColorBytes(int n) throws PrintDataParseException, JposException {
        switch (n) {
            case 1: {
                return new byte[]{27, 34, 0};
            }
            case 2: {
                return new byte[]{27, 34, 1};
            }
        }
        return new byte[0];
    }

    protected byte[] getNormalBytes() {
        this.currentHorizontalScale = 1;
        this.currentVerticalScale = 1;
        byte[] byArray = new byte[]{27, 70, 27, 33, -127, 27, 33, -126, 27, 33, -125, 27, 33, -124, 27, 33, -123, 27, 35, 0, 27, 34, 0};
        if (this.getStation() == 2 && this.getServiceState().getRecCurrentCartridge() == 2) {
            byArray[22] = 1;
        }
        return byArray;
    }

    protected byte[] getScaleHorizontallyBytes(int n) throws PrintDataParseException, JposException {
        Tracer.trace(4, className, "getScaleHorizontallyBytes()", "Entry");
        if ((n > 8 || n < 1) && this.isValidating()) {
            throw new JposException(106);
        }
        n = this.getActualHorizontalScaleFactor(n);
        Tracer.trace(4, className, "getScaleHorizontallyBytes()", "Actual factor = " + n);
        return new byte[]{27, 35, this.scaleByte(n, this.currentVerticalScale)};
    }

    protected byte[] getScaleVerticallyBytes(int n) throws PrintDataParseException, JposException {
        Tracer.trace(4, className, "getScaleVerticallyBytes()", "Entry");
        if ((n > 8 || n < 1) && this.isValidating()) {
            throw new JposException(106);
        }
        n = this.getActualVerticalScaleFactor(n);
        Tracer.trace(4, className, "getScaleVerticallyBytes()", "Actual factor = " + n);
        return new byte[]{27, 35, this.scaleByte(this.currentHorizontalScale, n)};
    }

    protected int getActualHorizontalScaleFactor(int n) {
        return this.getActualScaleFactor(n);
    }

    protected int getActualVerticalScaleFactor(int n) {
        return this.getActualScaleFactor(n);
    }

    protected int getActualScaleFactor(int n) {
        if (n < 1) {
            n = 1;
        }
        if (n > 8) {
            n = 8;
        }
        return n;
    }

    private byte scaleByte(int n, int n2) {
        this.currentHorizontalScale = n--;
        this.currentVerticalScale = n2--;
        return (byte)((n << 4) + n2);
    }
}

