/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jpos.services.poss;

import com.ibm.jpos.services.DeviceServiceAbstraction;
import com.ibm.jpos.services.POSPrinterServiceImp;
import com.ibm.jpos.services.POSPrinterServiceState;
import com.ibm.jpos.services.ibmprinter.CacheVector;
import com.ibm.jpos.services.ibmprinter.CacheVectorEntry;
import com.ibm.jpos.services.ibmprinter.DirectIOBitmapInfo;
import com.ibm.jpos.services.ibmprinter.DirectIOFontInfo;
import com.ibm.jpos.services.ibmprinter.DirectIOPrintRawModeInfo;
import com.ibm.jpos.services.ibmprinter.DirectIOPrinterRead;
import com.ibm.jpos.services.ibmprinter.PrintBarCodeData;
import com.ibm.jpos.services.ibmprinter.PrintBitmapImageInfo;
import com.ibm.jpos.services.ibmprinter.PrintDataCompiler;
import com.ibm.jpos.services.ibmprinter.PrinterFont;
import com.ibm.jpos.services.poss.POSPrinter4POSSPrintDataCompiler;
import com.ibm.jpos.services.poss.POSSPOSPrinterServiceImp;
import com.ibm.jpos.util.Tracer;
import com.ibm.poss.PosDef;
import jpos.JposException;
import jpos.POSPrinterConst;
import jpos.services.EventCallbacks;

public class POSPrinter4Imp
extends POSSPOSPrinterServiceImp
implements PosDef,
POSPrinterServiceImp,
POSPrinterConst {
    private static final String className = "POSPrinter4Imp";
    private POSPrinter4POSSPrintDataCompiler printDataCompiler = null;

    protected POSPrinter4Imp(DeviceServiceAbstraction deviceServiceAbstraction) throws JposException {
        super(deviceServiceAbstraction);
        Tracer.trace(4, className, "Constructor()", "Entry");
        Tracer.trace(4, className, "Constructor()", "Exit");
    }

    public void open(String string, EventCallbacks eventCallbacks) throws JposException {
        Tracer.trace(4, className, "open(" + string + ")", "Entry");
        super.open(string, eventCallbacks);
        this.printDataCompiler = new POSPrinter4POSSPrintDataCompiler((POSPrinterServiceState)this.getDeviceServiceState());
        Tracer.trace(4, className, "open()", "Exit");
    }

    protected PrintDataCompiler getPrintDataCompiler() {
        return this.printDataCompiler;
    }

    void doDirectIOFlipCheck() throws JposException {
        throw new JposException(106);
    }

    void doDirectIOPrintDownloadedBitmap(int n, DirectIOBitmapInfo directIOBitmapInfo) throws JposException {
        if (n == 0) {
            this.clearBitmaps();
            if (this.printBitmapUtil != null) {
                this.printBitmapUtil.cacheVector.removeAllElements(CacheVector.BITMAP);
            }
        } else {
            if (n > 40) {
                throw new JposException(106);
            }
            if (this.printBitmapUtil == null) {
                throw new JposException(111);
            }
            CacheVectorEntry cacheVectorEntry = this.printBitmapUtil.cacheVector.get(CacheVector.BITMAP, directIOBitmapInfo.station, n);
            if (cacheVectorEntry == null) {
                throw new JposException(111);
            }
            POSSPOSPrinterServiceImp.debugPrintBitmap.println("printing " + n + " from " + cacheVectorEntry.index);
            this.doPrinting(directIOBitmapInfo.station, cacheVectorEntry.bitmap, cacheVectorEntry.alignment, 2);
        }
    }

    void doDirectIOPrintDownloadedMessage(int n) throws JposException {
        this.printDataCompiler.setLogo(1, "");
        this.printDataCompiler.setLogo(2, "");
    }

    public void setBitmap(int n, int n2, String string, int n3, int n4) throws JposException {
        Tracer.trace(4, className, "setBitmap(" + n + ", " + n2 + ", " + string + ", " + n3 + ", " + n4 + ")", "Entry");
        throw new JposException(106);
    }

    public void processPrintBarCode(PrintBarCodeData printBarCodeData) throws JposException {
        throw new JposException(111);
    }

    protected PrinterFont[] getPrinterFonts() throws JposException {
        Tracer.trace(4, className, "getPrinterFonts()", "Entry");
        PrinterFont[] printerFontArray = new PrinterFont[]{new PrinterFont(2, 42, 380, 3, 0, 12), new PrinterFont(2, 38, 380, 1, 0, 12), new PrinterFont(2, 30, 300, 2, 0, 12), new PrinterFont(1, 42, 380, 3, 0, 12), new PrinterFont(1, 38, 380, 1, 0, 12), new PrinterFont(1, 30, 300, 2, 0, 12), new PrinterFont(4, 94, 860, 3, 0, 12), new PrinterFont(4, 86, 860, 1, 0, 12), new PrinterFont(4, 68, 680, 2, 0, 12), new PrinterFont(4, 42, 380, 3, 1, 12), new PrinterFont(4, 38, 380, 1, 1, 12), new PrinterFont(4, 30, 300, 2, 1, 12)};
        Tracer.trace(4, className, "getPrinterFonts()", "Exit");
        return printerFontArray;
    }

    public int getMicronsPerStep(int n) {
        return 353;
    }

    public int getMultiplier() throws JposException {
        return 8;
    }

    public int getDotsPerInchHigh(int n) {
        return 72;
    }

    public int getDotsPerInchWide(int n) throws JposException {
        return 150;
    }

    public int getMaxBytesPerWrite(int n) throws JposException {
        switch (n) {
            case 4: {
                return 880;
            }
        }
        return 380;
    }

    public int getWriteBufferSize() {
        return 1000;
    }

    public int getMaxSetBitmapSize(int n) throws JposException {
        return 0;
    }

    public int getMaxPrintBitmapSize() throws JposException {
        return this.getWriteBufferSize();
    }

    public boolean requiresLinefeed(int n) {
        return false;
    }

    public void checkMode(int n, int n2) throws JposException {
        if (n2 == 2 || n2 == 16) {
            return;
        }
        throw new JposException(106);
    }

    public int getStationMaxBitmapHeight(int n) {
        return Integer.MAX_VALUE;
    }

    public short getNextByteForStation(int n, PrintBitmapImageInfo printBitmapImageInfo) {
        return printBitmapImageInfo.getNextByteForImpact(printBitmapImageInfo);
    }

    public byte[] getBitmapHeader(int n, int n2) {
        return null;
    }

    public void clearBitmaps() throws JposException {
        if (this.printBitmapUtil != null) {
            this.printBitmapUtil.bitmapIndex = 1;
        }
    }

    public void clearMessages() throws JposException {
        if (this.printBitmapUtil != null) {
            this.printBitmapUtil.messageIndex = 1;
        }
    }

    public void downloadData(int n, String string, int n2, int n3) throws JposException {
        throw new JposException(106);
    }

    public void downloadData(int n, byte[] byArray, int n2, int n3) throws JposException {
    }

    void doDirectIODownloadPropFont(DirectIOFontInfo directIOFontInfo) throws JposException {
        throw new JposException(106);
    }

    void doDirectIODownloadNonPropFont(DirectIOFontInfo directIOFontInfo) throws JposException {
        throw new JposException(106);
    }

    void doDirectIOHeadMovement(int n) throws JposException {
        throw new JposException(106);
    }

    void doSelectResidentCharacterSet() throws JposException {
        throw new JposException(106);
    }

    void doSelectUserDefinedCharacterSet() throws JposException {
        throw new JposException(106);
    }

    void doSelectCodePage(int n) throws JposException {
        throw new JposException(106);
    }

    void doEraseUserDefinedCharacterSet(int n) throws JposException {
        throw new JposException(106);
    }

    void doPrintInRawMode(DirectIOPrintRawModeInfo directIOPrintRawModeInfo) throws JposException {
        throw new JposException(106);
    }

    void doPrinterRead(DirectIOPrinterRead directIOPrinterRead) throws JposException {
        throw new JposException(106);
    }
}

