/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jpos.util;

import com.ibm.jpos.Version;
import com.ibm.jpos.util.Tracer;
import com.ibm.jpos.util.TracerListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.lang.reflect.Method;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;

public class LoadWithTrace {
    public static void main(String[] stringArray) {
        LoadWithTraceUI loadWithTraceUI = new LoadWithTraceUI();
    }

    static class LoadWithTraceUI
    extends JFrame
    implements TracerListener {
        String CONFIG_FILENAME = "LoadWithTrace.config";
        JTextField programNameJTF = new JTextField("", 40);
        JButton programNameJB = new JButton("Run Program");
        JTextField programArgsJTF = new JTextField("", 40);
        JLabel programArgsJL = new JLabel("Program Arguments", 0);
        JTextField levelJTF = new JTextField("0", 40);
        JButton levelJB = new JButton("Set Level");
        JTextField classnameJTF = new JTextField("", 40);
        JButton classnameJB = new JButton("Add Class");
        JTextField filenameJTF = new JTextField("", 40);
        JButton filenameJB = new JButton("Set Filename");
        JTextField bufferSizeJTF = new JTextField("0", 40);
        JButton bufferSizeJB = new JButton("Set Trace Buffer Size");
        JButton quitJB = new JButton("Quit");
        JButton saveBufferJB = new JButton("Save Trace Buffer");
        JTextArea resultsJTA = new JTextArea(10, 60);
        Runner runner = null;
        Properties defaults = new Properties();

        public LoadWithTraceUI() {
            Thread.currentThread().setName("LoadWithTrace UI");
            Tracer.addTracerListener(this);
            this.getDefaults();
            this.getContentPane().setLayout(new BorderLayout());
            JPanel jPanel = new JPanel();
            JPanel jPanel2 = new JPanel();
            jPanel.setLayout(new GridLayout(6, 1));
            jPanel2.setLayout(new GridLayout(6, 1));
            jPanel.add(this.programNameJB);
            jPanel2.add(this.programNameJTF);
            jPanel.add(this.programArgsJL);
            jPanel2.add(this.programArgsJTF);
            jPanel.add(this.levelJB);
            jPanel2.add(this.levelJTF);
            jPanel.add(this.classnameJB);
            jPanel2.add(this.classnameJTF);
            jPanel.add(this.filenameJB);
            jPanel2.add(this.filenameJTF);
            jPanel.add(this.bufferSizeJB);
            jPanel2.add(this.bufferSizeJTF);
            JPanel jPanel3 = new JPanel();
            jPanel3.setLayout(new BorderLayout());
            jPanel3.add((Component)jPanel, "West");
            jPanel3.add((Component)jPanel2, "Center");
            jPanel3.setBorder(new TitledBorder("Options"));
            this.getContentPane().add("North", jPanel3);
            JPanel jPanel4 = new JPanel();
            jPanel4.setLayout(new GridLayout(1, 1));
            JScrollPane jScrollPane = new JScrollPane(22, 30);
            jScrollPane.setViewportView(this.resultsJTA);
            jPanel4.add(jScrollPane);
            jPanel4.setBorder(new TitledBorder("Messages"));
            Font font = this.resultsJTA.getFont();
            Font font2 = new Font("Monospaced", 0, font.getSize());
            this.resultsJTA.setFont(font2);
            this.getContentPane().add("Center", jPanel4);
            JPanel jPanel5 = new JPanel();
            jPanel5.add(this.saveBufferJB);
            jPanel5.add(this.quitJB);
            this.getContentPane().add("South", jPanel5);
            Listener listener = new Listener();
            this.quitJB.addActionListener(listener);
            this.saveBufferJB.addActionListener(listener);
            this.programNameJB.addActionListener(listener);
            this.levelJB.addActionListener(listener);
            this.classnameJB.addActionListener(listener);
            this.filenameJB.addActionListener(listener);
            this.bufferSizeJB.addActionListener(listener);
            this.pack();
            String string = "IBM LoadWithTrace Utility V" + Version.getVersionString() + ", Copyright (c) IBM Corporation, 1999";
            this.setTitle(string);
            ((Component)this).setVisible(true);
            this.addWindowListener(new WindowAdapter(this){
                private final /* synthetic */ LoadWithTraceUI this$0;
                {
                    this.this$0 = loadWithTraceUI;
                }

                public void windowClosing(WindowEvent windowEvent) {
                    this.this$0.saveDefaults();
                    System.exit(0);
                }
            });
        }

        void getDefaults() {
            String string = System.getProperty("user.home");
            String string2 = string + this.CONFIG_FILENAME;
            try {
                FileInputStream fileInputStream = new FileInputStream(string2);
                this.defaults.load(fileInputStream);
                fileInputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.programNameJTF.setText(this.defaults.getProperty("ProgramName"));
            this.programArgsJTF.setText(this.defaults.getProperty("ProgramArgs"));
            this.levelJTF.setText(this.defaults.getProperty("TraceLevel"));
            this.classnameJTF.setText(this.defaults.getProperty("ClassNames"));
            this.filenameJTF.setText(this.defaults.getProperty("Filename"));
        }

        void saveDefaults() {
            String string = System.getProperty("user.home");
            String string2 = string + this.CONFIG_FILENAME;
            ((Hashtable)this.defaults).put("ProgramName", this.programNameJTF.getText());
            ((Hashtable)this.defaults).put("ProgramArgs", this.programArgsJTF.getText());
            ((Hashtable)this.defaults).put("TraceLevel", this.levelJTF.getText());
            ((Hashtable)this.defaults).put("ClassNames", this.classnameJTF.getText());
            ((Hashtable)this.defaults).put("Filename", this.filenameJTF.getText());
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(string2);
                this.defaults.save(fileOutputStream, "LoadWithTrace Defaults");
                fileOutputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        void addMessage(String string) {
            this.resultsJTA.append(string);
            this.resultsJTA.setCaretPosition(this.resultsJTA.getText().length());
        }

        public void traceInfo(String string, String string2, String string3, int n, String string4, String string5) {
            this.addMessage(string + "\n");
        }

        class Runner
        implements Runnable {
            Thread me = null;
            Method method = null;
            String programName = null;
            String programArgs = null;

            public Runner(String string, String string2) {
                this.programName = string;
                this.programArgs = string2;
            }

            public void run() {
                try {
                    boolean bl = false;
                    Object obj = Class.forName(this.programName).newInstance();
                    Class<?> clazz = obj.getClass();
                    Class[] classArray = new Class[1];
                    Method[] methodArray = clazz.getMethods();
                    int n = 0;
                    while (n < methodArray.length) {
                        if (methodArray[n].getName().equals("main")) {
                            bl = true;
                            StringTokenizer stringTokenizer = new StringTokenizer(this.programArgs, " ");
                            String[] stringArray = new String[stringTokenizer.countTokens()];
                            int n2 = 0;
                            while (stringTokenizer.hasMoreTokens()) {
                                stringArray[n2++] = stringTokenizer.nextToken();
                            }
                            Object[] objectArray = new Object[]{stringArray};
                            methodArray[n].invoke(obj, objectArray);
                        }
                        ++n;
                    }
                    if (!bl) {
                        LoadWithTraceUI.this.addMessage(this.programName + " does not have a main() method.\n");
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    LoadWithTraceUI.this.addMessage("Could not find class " + this.programName + "\n");
                }
                catch (Exception exception) {
                    LoadWithTraceUI.this.addMessage(exception.toString() + "\n");
                }
            }

            public void start() {
                if (this.me == null) {
                    this.me = new Thread(this);
                    this.me.start();
                    this.me.setName("LoadWithTrace Runner");
                }
            }
        }

        class Listener
        implements ActionListener {
            Listener() {
            }

            public void actionPerformed(ActionEvent actionEvent) {
                LoadWithTraceUI.this.saveDefaults();
                String string = actionEvent.getActionCommand();
                if (string.equals("Quit")) {
                    System.exit(0);
                } else if (string.equals("Run Program")) {
                    String string2 = LoadWithTraceUI.this.programNameJTF.getText();
                    if (string2.length() > 0) {
                        LoadWithTraceUI.this.runner = new Runner(LoadWithTraceUI.this.programNameJTF.getText(), LoadWithTraceUI.this.programArgsJTF.getText());
                        LoadWithTraceUI.this.runner.start();
                    }
                } else if (string.equals("Set Level")) {
                    String string3 = LoadWithTraceUI.this.levelJTF.getText();
                    int n = 0;
                    if (string3.length() > 0) {
                        try {
                            n = new Integer(string3);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        Tracer.setTracerLevel(n);
                    }
                } else if (string.equals("Add Class")) {
                    String string4 = LoadWithTraceUI.this.classnameJTF.getText();
                    Tracer.addTracerClassname(string4);
                } else if (string.equals("Set Filename")) {
                    String string5 = LoadWithTraceUI.this.filenameJTF.getText();
                    Tracer.setTracerFilename(string5);
                } else if (string.equals("Set Trace Buffer Size")) {
                    String string6 = LoadWithTraceUI.this.bufferSizeJTF.getText();
                    int n = 0;
                    if (string6.length() > 0) {
                        try {
                            n = new Integer(string6);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        Tracer.setTracerBuffer(n);
                    }
                } else if (string.equals("Save Trace Buffer")) {
                    JFileChooser jFileChooser = new JFileChooser();
                    jFileChooser.setDialogTitle("Select Bitmap Filename");
                    int n = jFileChooser.showSaveDialog(new JTextField());
                    if (n == 0) {
                        String string7 = jFileChooser.getSelectedFile().getPath();
                        try {
                            FileWriter fileWriter = new FileWriter(string7, false);
                            String[] stringArray = Tracer.dumpTracerBuffer();
                            int n2 = 0;
                            while (n2 < stringArray.length) {
                                if (stringArray[n2] != null) {
                                    fileWriter.write(stringArray[n2] + "\n");
                                }
                                ++n2;
                            }
                            fileWriter.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            }
        }
    }
}

