/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jpos.util;

import com.ibm.jpos.util.DefaultLogEntry;
import com.ibm.jpos.util.LogEntryMsg;
import com.ibm.jpos.util.LogEntryMsgHelper;
import java.io.Serializable;
import java.text.SimpleDateFormat;

public class LogEntry
extends DefaultLogEntry
implements Serializable {
    private char[] storeControllerId = null;
    private short terminalNumber = 0;
    private short severity = 1;
    private char messageGroup = (char)74;
    private short messageNumber = 0;
    private short logSection = 0;
    private short source = 0;
    private short eventCode = 0;
    private char[] uniqueData = null;
    private static final int MESSAGEGROUP_SIZE = 2;
    private static final int UNIQUEDATA_SIZE = 18;
    private static final int STORE_CONTROLLER_ID_SIZE = 2;
    private static final short MIN_TERMINALNUMBER = 0;
    private static final short MAX_TERMINALNUMBER = 999;
    public static final short MIN_SEVERITY = 1;
    public static final short MAX_SEVERITY = 5;
    public static final short MIN_LOGSECTION = 0;
    public static final short MAX_LOGSECTION = 9;
    public static final short MIN_SOURCE = 0;
    public static final short MAX_SOURCE = 999;
    public static final short MIN_EVENTCODE = 0;
    public static final short MAX_EVENTCODE = 999;

    public static LogEntry copy(LogEntry logEntry) {
        LogEntry logEntry2 = new LogEntry();
        logEntry2.setMessage(logEntry.getMessage());
        logEntry2.setData(logEntry.getData());
        logEntry2.setStoreControllerId(logEntry.getStoreControllerId());
        logEntry2.setTerminalNumber(logEntry.getTerminalNumber());
        logEntry2.setSeverity(logEntry.getSeverity());
        logEntry2.setMessageGroup(logEntry.getMessageGroup());
        logEntry2.setMessageNumber(logEntry.getMessageNumber());
        logEntry2.setSource(logEntry.getSource());
        logEntry2.setEventCode(logEntry.getEventCode());
        logEntry2.setUniqueData(logEntry.getUniqueData());
        return logEntry2;
    }

    public char[] getStoreControllerId() {
        return this.storeControllerId;
    }

    public short getTerminalNumber() {
        return this.terminalNumber;
    }

    public short getSeverity() {
        return this.severity;
    }

    public char getMessageGroup() {
        return this.messageGroup;
    }

    public short getMessageNumber() {
        return this.messageNumber;
    }

    public String getMessageText() {
        return LogEntryMsgHelper.getMessageText(this.getMessageNumber());
    }

    public short getLogSection() {
        return this.logSection;
    }

    public short getSource() {
        return this.source;
    }

    public short getEventCode() {
        return this.eventCode;
    }

    public char[] getUniqueData() {
        return this.uniqueData;
    }

    public void setStoreControllerId(char[] cArray) throws IllegalArgumentException {
        if (cArray == null || cArray.length < 2) {
            throw new IllegalArgumentException(LogEntryMsg.INVALID_LOGENTRY_STORECONTROLLERID_PROPERTY_MSG);
        }
        this.storeControllerId = new char[2];
        int n = 0;
        while (n < 2) {
            if (cArray[n] < 'C' || cArray[n] > 'Z') {
                throw new IllegalArgumentException(LogEntryMsg.INVALID_LOGENTRY_STORECONTROLLERID_PROPERTY_MSG);
            }
            this.storeControllerId[n] = cArray[n];
            ++n;
        }
    }

    public void setTerminalNumber(short s) throws IllegalArgumentException {
        if (s < 0 || s > 999) {
            throw new IllegalArgumentException(LogEntryMsg.INVALID_LOGENTRY_TERMINALNUMBER_PROPERTY_MSG);
        }
        this.terminalNumber = s;
    }

    public void setSeverity(short s) {
        if (s < 1 || s > 5) {
            throw new IllegalArgumentException(LogEntryMsg.INVALID_LOGENTRY_SEVERITY_PROPERTY_MSG);
        }
        this.severity = s;
    }

    public void setMessageGroup(char c) throws IllegalArgumentException {
        if (c < 'A' || c > 'Z') {
            throw new IllegalArgumentException(LogEntryMsg.INVALID_LOGENTRY_MESSAGEGROUP_PROPERTY_MSG);
        }
        this.messageGroup = c;
    }

    public void setMessageNumber(short s) {
        if (s < 0 || s > 10000) {
            throw new IllegalArgumentException(LogEntryMsg.INVALID_LOGENTRY_MESSAGENUMBER_PROPERTY_MSG);
        }
        this.messageNumber = s;
    }

    public void setLogSection(short s) {
        if (s < 0 || s > 9) {
            throw new IllegalArgumentException(LogEntryMsg.INVALID_LOGENTRY_LOGSECTION_PROPERTY_MSG);
        }
        this.logSection = s;
    }

    public void setSource(short s) {
        if (s < 0 || s > 999) {
            throw new IllegalArgumentException(LogEntryMsg.INVALID_LOGENTRY_SOURCE_PROPERTY_MSG);
        }
        this.source = s;
    }

    public void setEventCode(short s) {
        if (s < 0 || s > 999) {
            throw new IllegalArgumentException(LogEntryMsg.INVALID_LOGENTRY_EVENTCODE_PROPERTY_MSG);
        }
        this.eventCode = s;
    }

    public void setUniqueData(char[] cArray) throws IllegalArgumentException {
        if (cArray == null) {
            throw new IllegalArgumentException(LogEntryMsg.INVALID_LOGENTRY_UNIQUEDATA_PROPERTY_MSG);
        }
        int n = cArray.length > 18 ? 18 : cArray.length;
        this.uniqueData = new char[18];
        int n2 = 0;
        while (n2 < n) {
            this.uniqueData[n2] = cArray[n2];
            ++n2;
        }
    }

    public String toString() {
        String string = "\n-------------------------------------------------\n";
        string = string + "ID: " + String.valueOf(this.getID()) + ", ";
        string = string + "message: " + this.getMessage() + "\n\n";
        string = string + new SimpleDateFormat().format(this.getDateStamp()) + " ";
        string = string + (this.getStoreControllerId() == null ? "" : String.copyValueOf(this.getStoreControllerId())) + " ";
        string = string + String.valueOf(this.getTerminalNumber()) + " ";
        string = string + String.valueOf(this.getSeverity()) + " ";
        string = string + String.valueOf(this.getMessageGroup()) + String.valueOf(this.getMessageNumber()) + " ";
        string = string + this.getMessageText() + " ";
        string = string + "B" + String.valueOf(this.getLogSection()) + "/";
        string = string + "S" + String.valueOf(this.getSource()) + "/";
        string = string + "E" + String.valueOf(this.getEventCode()) + " ";
        string = string + (this.getUniqueData() == null ? "" : String.copyValueOf(this.getUniqueData()));
        string = string + "\n-------------------------------------------------";
        return string;
    }
}

