/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jpos.util;

import com.ibm.jpos.util.TracerListener;
import java.io.FileWriter;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class Tracer {
    private static final boolean optimizedBuild = false;
    private static int maxThreadNameLength = 8;
    private static int maxClassNameLength = 25;
    private static int traceLevel = 0;
    private static String traceFilename = new String("");
    private static Hashtable classNames = new Hashtable();
    private static String format = new String(":TIMESTAMPMILLI: (:THREADNAME:) <:CLASSNAME:> : :PADDING: :METHODNAME: - :COMMENT:");
    private static Date lastDate = new Date(System.currentTimeMillis());
    private static Vector listeners = new Vector();
    private static String[] traceBuffer = new String[1];
    private static int traceBufferLoc = 0;

    private Tracer() {
    }

    public static void addTracerListener(TracerListener tracerListener) {
        listeners.addElement(tracerListener);
    }

    public static void setTracerLevel(int n) {
        traceLevel = n;
    }

    public static void setTracerBuffer(int n) {
        if (n == 0) {
            n = 1;
        }
        traceBuffer = new String[n];
        traceBufferLoc = 0;
    }

    public static String[] dumpTracerBuffer() {
        String[] stringArray = new String[traceBuffer.length];
        int n = traceBufferLoc;
        int n2 = traceBufferLoc - 1;
        if (n2 < 0) {
            n2 = traceBuffer.length - 1;
        }
        int n3 = 0;
        while (n != n2) {
            stringArray[n3++] = new String(traceBuffer[n++]);
            if (n < traceBuffer.length) continue;
            n = 0;
        }
        stringArray[n3++] = new String(traceBuffer[n++]);
        return stringArray;
    }

    public static int getTracerLevel() {
        return traceLevel;
    }

    public static int getTraceLevel() {
        return Tracer.getTracerLevel();
    }

    public static void setTracerFilename(String string) {
        if (string == null) {
            Tracer.clearTracerFilename();
        } else if (string.length() == 0) {
            Tracer.clearTracerFilename();
        } else {
            traceFilename = new String(string);
        }
    }

    public static String getTracerFilename() {
        return traceFilename;
    }

    public static void clearTracerFilename() {
        traceFilename = new String("");
    }

    public static void addTracerClassname(String string) {
        if (string == null) {
            Tracer.clearTracerClassnames();
        } else if (string.length() == 0) {
            Tracer.clearTracerClassnames();
        } else {
            StringTokenizer stringTokenizer = new StringTokenizer(string, " ,");
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                classNames.put(string2, string2);
            }
        }
    }

    public static void removeTracerClassname(String string) {
        classNames.remove(string);
    }

    public static void clearTracerClassnames() {
        classNames.clear();
    }

    public static void setTracerFormat(String string) {
        format = new String(string);
    }

    public static synchronized void trace(int n, String string, String string2, String string3) {
        Object object;
        if (n > traceLevel) {
            return;
        }
        if (classNames.size() > 0 && !classNames.contains(string)) {
            return;
        }
        Date date = new Date(System.currentTimeMillis());
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("HH:mm:ss.SSS");
        String string4 = new String("");
        String string5 = new String("");
        String string6 = new String("");
        simpleDateFormat = new SimpleDateFormat("HH:mm:ss");
        string5 = simpleDateFormat.format(date);
        simpleDateFormat = new SimpleDateFormat("HH:mm:ss.SSS");
        string4 = simpleDateFormat.format(date);
        long l = date.getTime() - lastDate.getTime();
        string6 = Long.toString(l);
        while (string6.length() < 3) {
            string6 = "0" + string6;
        }
        lastDate = date;
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        StringBuffer stringBuffer2 = new StringBuffer(Thread.currentThread().getName().trim());
        Tracer.fixLength(stringBuffer2, maxThreadNameLength);
        maxThreadNameLength = stringBuffer2.length();
        n2 = Thread.currentThread().countStackFrames();
        String string7 = new String(stringBuffer2);
        if (string7.startsWith("AWT") && n2 > 21) {
            n2 -= 20;
        }
        stringBuffer = new StringBuffer("");
        int n3 = 2;
        while (n3 < n2) {
            stringBuffer.append(" ");
            ++n3;
        }
        StringBuffer stringBuffer3 = new StringBuffer(string.trim());
        Tracer.fixLength(stringBuffer3, maxClassNameLength);
        maxClassNameLength = stringBuffer3.length();
        String string8 = new String(Tracer.fixUnprintables(string2));
        String string9 = new String(format);
        string9 = Tracer.replaceKey(string9, ":TIMESTAMP:", string5);
        string9 = Tracer.replaceKey(string9, ":TIMESTAMPMILLI:", string4);
        string9 = Tracer.replaceKey(string9, ":TIMESTAMPDELTA:", string6);
        string9 = Tracer.replaceKey(string9, ":THREADNAME:", stringBuffer2.toString());
        string9 = Tracer.replaceKey(string9, ":CLASSNAME:", stringBuffer3.toString());
        string9 = Tracer.replaceKey(string9, ":LEVEL:", Integer.toString(n));
        string9 = Tracer.replaceKey(string9, ":METHODNAME:", string8);
        string9 = Tracer.replaceKey(string9, ":COMMENT:", string3);
        string9 = Tracer.replaceKey(string9, ":PADDING:", stringBuffer.toString());
        if (traceBuffer.length > 1) {
            Tracer.traceBuffer[Tracer.traceBufferLoc] = new String(string9);
            if (++traceBufferLoc >= traceBuffer.length) {
                traceBufferLoc = 0;
            }
        }
        if (listeners.isEmpty()) {
            if (traceFilename.length() > 0) {
                try {
                    object = new FileWriter(traceFilename, true);
                    ((Writer)object).write(string9 + "\n");
                    ((OutputStreamWriter)object).close();
                }
                catch (Exception exception) {}
            } else {
                System.out.println(string9);
            }
        }
        object = listeners;
        synchronized (object) {
            Enumeration enumeration = listeners.elements();
            while (enumeration.hasMoreElements()) {
                TracerListener tracerListener = (TracerListener)enumeration.nextElement();
                tracerListener.traceInfo(string9, stringBuffer2.toString(), stringBuffer3.toString(), n, string2, string3);
            }
        }
    }

    private static String replaceKey(String string, String string2, String string3) {
        int n = string.indexOf(string2);
        String string4 = new String(string);
        if (n != -1) {
            string4 = string.substring(0, n);
            string4 = string4 + string3;
            string4 = string4 + string.substring(n + string2.length());
        }
        return string4;
    }

    private static String fixUnprintables(String string) {
        int n = 0;
        while (n < string.length()) {
            if ((byte)string.charAt(n) < 32) {
                int n2 = string.charAt(n);
                String string2 = Integer.toHexString(n2 &= 0xFF);
                if (string2.length() < 2) {
                    string2 = "0" + string2;
                }
                string2 = "<" + string2 + ">";
                String string3 = string.substring(0, n);
                String string4 = string.substring(n + 1);
                string = string3 + string2 + string4;
            }
            ++n;
        }
        return string;
    }

    /*
     * Unable to fully structure code
     */
    private static void fixLength(StringBuffer var0, int var1_1) {
        if (var0.length() <= var1_1) ** GOTO lbl5
        return;
lbl-1000:
        // 1 sources

        {
            var0.append(" ");
lbl5:
            // 2 sources

            ** while (var0.length() < var1_1)
        }
lbl6:
        // 1 sources

    }
}

