/*
 * Decompiled with CFR 0.152.
 */
package de.ailis.usb4java;

import de.ailis.usb4java.AbstractDevice;
import de.ailis.usb4java.Port;
import de.ailis.usb4java.UsbPorts;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.usb.UsbHub;

final class Ports
implements UsbPorts<Port, AbstractDevice> {
    private final List<Port> ports = new ArrayList<Port>();
    private final UsbHub hub;

    Ports(UsbHub hub) {
        this.hub = hub;
        this.addPort();
    }

    private Port addPort() {
        byte portNo = (byte)(this.ports.size() + 1);
        Port port = new Port(this.hub, portNo);
        this.ports.add(port);
        return port;
    }

    private Port getFreePort() {
        for (Port port : this.ports) {
            if (port.isUsbDeviceAttached()) continue;
            return port;
        }
        return this.addPort();
    }

    @Override
    public byte getNumberOfPorts() {
        return (byte)this.ports.size();
    }

    @Override
    public List<Port> getUsbPorts() {
        return Collections.unmodifiableList(this.ports);
    }

    @Override
    public Port getUsbPort(byte number) {
        int index = (number & 0xFF) - 1;
        if (index < 0 || index >= this.ports.size()) {
            return null;
        }
        return this.ports.get(index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<AbstractDevice> getAttachedUsbDevices() {
        ArrayList<AbstractDevice> devices = new ArrayList<AbstractDevice>();
        List<Port> list = this.ports;
        synchronized (list) {
            for (Port port : this.ports) {
                if (!port.isUsbDeviceAttached()) continue;
                devices.add(port.getUsbDevice());
            }
        }
        return Collections.unmodifiableList(devices);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isUsbDeviceAttached(AbstractDevice device) {
        List<Port> list = this.ports;
        synchronized (list) {
            for (Port port : this.ports) {
                if (!device.equals(port.getUsbDevice())) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connectUsbDevice(AbstractDevice device) {
        List<Port> list = this.ports;
        synchronized (list) {
            Port port = this.getFreePort();
            port.connectUsbDevice(device);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disconnectUsbDevice(AbstractDevice device) {
        List<Port> list = this.ports;
        synchronized (list) {
            for (Port port : this.ports) {
                if (!device.equals(port.getUsbDevice())) continue;
                port.disconnectUsbDevice();
            }
        }
    }
}

