/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin.security;

import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.security.CeilingPolicy;
import com.sun.deploy.security.SecureCookiePermission;
import com.sun.deploy.security.TrustDecider;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.uitoolkit.ToolkitStore;
import com.sun.deploy.util.URLUtil;
import java.awt.AWTPermission;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Policy;
import java.security.PrivilegedAction;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.PropertyPermission;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipFile;
import sun.applet.AppletClassLoader;
import sun.awt.AppContext;
import sun.net.ProgressSource;
import sun.net.www.ParseUtil;
import sun.plugin.security.ActivatorSecurityManager;
import sun.plugin.util.ProgressMonitor;

public final class PluginClassLoader
extends AppletClassLoader {
    private static RuntimePermission usePolicyPermission;
    private URL base;
    private HashMap JARJARtoJAR = new HashMap();

    public PluginClassLoader(URL uRL) {
        super(uRL);
        this.base = uRL;
    }

    public URL getBaseURL() {
        return this.base;
    }

    protected PermissionCollection getPermissions(CodeSource codeSource) {
        Object object;
        Object object2;
        PermissionCollection permissionCollection = super.getPermissions(codeSource);
        URL uRL = codeSource.getLocation();
        if (uRL != null && uRL.getProtocol().equals("file") && (object2 = ParseUtil.decode(uRL.getFile())) != null) {
            object2 = ((String)object2).replace('/', File.separatorChar);
            object = File.separator + System.getProperty("java.home") + File.separator + "axbridge" + File.separator + "lib";
            try {
                object2 = new File((String)object2).getCanonicalPath();
                object = new File((String)object).getCanonicalPath();
                if (object2 != null && object != null && ((String)object2).startsWith((String)object)) {
                    permissionCollection.add(new AllPermission());
                    return permissionCollection;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        object2 = null;
        object = (Policy)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return Policy.getPolicy();
            }
        });
        object2 = ((Policy)object).getPermissions(codeSource);
        permissionCollection.add(new RuntimePermission("accessClassInPackage.sun.audio"));
        permissionCollection.add(new PropertyPermission("browser", "read"));
        permissionCollection.add(new PropertyPermission("browser.version", "read"));
        permissionCollection.add(new PropertyPermission("browser.vendor", "read"));
        permissionCollection.add(new PropertyPermission("http.agent", "read"));
        permissionCollection.add(new PropertyPermission("javapi.*", "read,write"));
        permissionCollection.add(new PropertyPermission("javaws.*", "read,write"));
        permissionCollection.add(new PropertyPermission("jnlp.*", "read,write"));
        permissionCollection.add(new PropertyPermission("javaplugin.version", "read"));
        if (usePolicyPermission == null) {
            usePolicyPermission = new RuntimePermission("usePolicy");
        }
        if (!((PermissionCollection)object2).implies(usePolicyPermission) && codeSource.getCertificates() != null) {
            try {
                if (TrustDecider.isAllPermissionGranted((CodeSource)codeSource, null) != 0L) {
                    CeilingPolicy.addTrustedPermissions((PermissionCollection)permissionCollection);
                }
            }
            catch (CertificateExpiredException certificateExpiredException) {
                Trace.securityPrintException((Throwable)certificateExpiredException, (String)ResourceManager.getMessage((String)"rsa.cert_expired"), (String)ResourceManager.getMessage((String)"security.dialog.caption"));
            }
            catch (CertificateNotYetValidException certificateNotYetValidException) {
                Trace.securityPrintException((Throwable)certificateNotYetValidException, (String)ResourceManager.getMessage((String)"rsa.cert_notyieldvalid"), (String)ResourceManager.getMessage((String)"security.dialog.caption"));
            }
            catch (Exception exception) {
                Trace.securityPrintException((Throwable)exception, (String)ResourceManager.getMessage((String)"rsa.general_error"), (String)ResourceManager.getMessage((String)"security.dialog.caption"));
            }
        }
        if (!permissionCollection.implies(new AWTPermission("accessClipboard")) && !((PermissionCollection)object2).implies(new AWTPermission("accessClipboard"))) {
            ToolkitStore.get().getAppContext().put((Object)"UNTRUSTED_CLIPBOARD_ACCESS_KEY", (Object)Boolean.TRUE);
        }
        permissionCollection.add((Permission)new SecureCookiePermission(SecureCookiePermission.getURLOriginString((URL)codeSource.getLocation())));
        return permissionCollection;
    }

    public void addLocalJar(URL uRL) {
        this.addURL(uRL);
    }

    private void addInnerJarURL(File file) throws MalformedURLException {
        URL uRL = file.toURI().toURL();
        this.addURL(uRL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void addJar(String string) throws IOException {
        block21: {
            String string2;
            File file;
            block22: {
                if (!string.toUpperCase().endsWith(".JARJAR") || !this.base.getProtocol().equalsIgnoreCase("file")) break block21;
                file = null;
                string2 = this.base.toString() + string;
                if (this.JARJARtoJAR.containsKey(string2)) break block22;
                ZipFile zipFile = null;
                boolean bl = false;
                try {
                    block23: {
                        boolean bl2;
                        FileOutputStream fileOutputStream;
                        FilterOutputStream filterOutputStream;
                        BufferedInputStream bufferedInputStream;
                        block20: {
                            zipFile = new JarFile(this.base.getPath() + string, true);
                            Enumeration<JarEntry> enumeration = ((JarFile)zipFile).entries();
                            int n = 0;
                            if (!enumeration.hasMoreElements()) {
                                throw new IOException("Invalid jarjar file");
                            }
                            JarEntry jarEntry = null;
                            while (enumeration.hasMoreElements()) {
                                jarEntry = enumeration.nextElement();
                                if (jarEntry.toString().toUpperCase().startsWith("META-INF/")) continue;
                                if (!jarEntry.toString().toUpperCase().endsWith(".JAR")) {
                                    throw new IOException("Invalid entry in jarjar file.");
                                }
                                if (++n <= 1) continue;
                            }
                            if (n > 1) {
                                jarEntry = null;
                                throw new IOException("Multiple JAR files inside JARJAR file");
                            }
                            byte[] byArray = new byte[8192];
                            bufferedInputStream = null;
                            filterOutputStream = null;
                            fileOutputStream = null;
                            InputStream inputStream = ((JarFile)zipFile).getInputStream(jarEntry);
                            bl2 = false;
                            try {
                                int n2;
                                file = File.createTempFile(jarEntry.toString().substring(0, jarEntry.toString().lastIndexOf(46)), ".jar");
                                Trace.msgPrintln((String)"pluginclassloader.created_file", (Object[])new Object[]{file.getPath()}, (TraceLevel)TraceLevel.BASIC);
                                this.updateJarProgress(string);
                                bufferedInputStream = new BufferedInputStream(inputStream);
                                fileOutputStream = new FileOutputStream(file);
                                filterOutputStream = new BufferedOutputStream(fileOutputStream);
                                while ((n2 = bufferedInputStream.read(byArray, 0, byArray.length)) != -1) {
                                    ((BufferedOutputStream)filterOutputStream).write(byArray, 0, n2);
                                }
                                ((BufferedOutputStream)filterOutputStream).flush();
                                bl2 = true;
                                this.JARJARtoJAR.put(string2, file);
                                try {
                                    this.addInnerJarURL(file);
                                }
                                catch (MalformedURLException malformedURLException) {
                                    throw new IllegalArgumentException(string);
                                }
                                Object var18_18 = null;
                                if (bufferedInputStream == null) break block20;
                            }
                            catch (Throwable throwable) {
                                Object var18_19 = null;
                                if (bufferedInputStream != null) {
                                    bufferedInputStream.close();
                                }
                                if (filterOutputStream != null) {
                                    filterOutputStream.close();
                                }
                                if (fileOutputStream != null) {
                                    fileOutputStream.close();
                                }
                                bufferedInputStream = null;
                                filterOutputStream = null;
                                fileOutputStream = null;
                                if (bl2) throw throwable;
                                Trace.msgPrintln((String)"pluginclassloader.empty_file", (Object[])new Object[]{file.getName()}, (TraceLevel)TraceLevel.BASIC);
                                if (file == null) throw throwable;
                                file.delete();
                                throw throwable;
                            }
                            bufferedInputStream.close();
                        }
                        if (filterOutputStream != null) {
                            filterOutputStream.close();
                        }
                        if (fileOutputStream != null) {
                            fileOutputStream.close();
                        }
                        bufferedInputStream = null;
                        filterOutputStream = null;
                        fileOutputStream = null;
                        if (bl2) break block23;
                        Trace.msgPrintln((String)"pluginclassloader.empty_file", (Object[])new Object[]{file.getName()}, (TraceLevel)TraceLevel.BASIC);
                        if (file != null) {
                            file.delete();
                        }
                    }
                    Object var20_21 = null;
                    if (zipFile == null) return;
                }
                catch (Throwable throwable) {
                    Object var20_22 = null;
                    if (zipFile == null) throw throwable;
                    zipFile.close();
                    throw throwable;
                }
                zipFile.close();
                return;
            }
            file = (File)this.JARJARtoJAR.get(string2);
            if (file != null) {
                try {
                    this.addInnerJarURL(file);
                }
                catch (MalformedURLException malformedURLException) {
                    throw new IllegalArgumentException(string);
                }
            }
            this.updateJarProgress(string);
            return;
        }
        super.addJar(string);
        this.updateJarProgress(string);
    }

    private void updateJarProgress(String string) {
        if (this.base.getProtocol().equalsIgnoreCase("file")) {
            try {
                URL uRL = new URL(this.base, string);
                if (!URLUtil.checkTargetURL((URL)this.base, (URL)uRL)) {
                    throw new SecurityException("Permission denied: " + uRL);
                }
                boolean bl = ProgressMonitor.get().shouldMeterInput(uRL, "GET");
                if (bl) {
                    ProgressSource progressSource = new ProgressSource(uRL, "GET", 10000L);
                    progressSource.beginTracking();
                    progressSource.updateProgress(10000L, 10000L);
                    progressSource.finishTracking();
                    progressSource.close();
                }
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(AppContext appContext) {
        block8: {
            Object object;
            Object object2;
            if (!this.JARJARtoJAR.isEmpty()) {
                Trace.msgPrintln((String)"pluginclassloader.deleting_files");
                object2 = this.JARJARtoJAR.keySet();
                object = object2.iterator();
                while (object.hasNext()) {
                    Object e = object.next();
                    File file = (File)this.JARJARtoJAR.get(e);
                    if (file == null) continue;
                    Trace.msgPrintln((String)"pluginclassloader.file", (Object[])new Object[]{file.getPath()}, (TraceLevel)TraceLevel.BASIC);
                    file.delete();
                }
                this.JARJARtoJAR.clear();
            }
            if (appContext == null) {
                return;
            }
            object2 = (ActivatorSecurityManager)((Object)System.getSecurityManager());
            object = appContext.getThreadGroup();
            ((ActivatorSecurityManager)((Object)object2)).lockThreadGroup((ThreadGroup)object);
            try {
                try {
                    appContext.dispose();
                }
                catch (IllegalThreadStateException illegalThreadStateException) {
                    Object var7_9 = null;
                    ((ActivatorSecurityManager)((Object)object2)).unlockThreadGroup((ThreadGroup)object);
                    break block8;
                }
                catch (Throwable throwable) {
                    Trace.printException((Throwable)throwable);
                    Object var7_10 = null;
                    ((ActivatorSecurityManager)((Object)object2)).unlockThreadGroup((ThreadGroup)object);
                }
                Object var7_8 = null;
                ((ActivatorSecurityManager)((Object)object2)).unlockThreadGroup((ThreadGroup)object);
            }
            catch (Throwable throwable) {
                Object var7_11 = null;
                ((ActivatorSecurityManager)((Object)object2)).unlockThreadGroup((ThreadGroup)object);
                throw throwable;
            }
        }
    }

    public AppContext resetAppContext() {
        return super.resetAppContext();
    }
}

