/*
 * Decompiled with CFR 0.152.
 */
package com.linx.touchkeyboard;

import com.linx.touchkeyboard.configuration.KeyboardConfiguration;
import com.linx.touchkeyboard.event.TouchKeyEvent;
import com.linx.touchkeyboard.event.TouchKeyboardListener;
import com.linx.touchkeyboard.exception.KeyboardConfigException;
import com.linx.touchkeyboard.exception.TouchKeyboardExceptionMessages;
import com.linx.touchkeyboard.renderer.TouchKeyboardKey;
import com.linx.touchkeyboard.renderer.TouchKeyboardRenderer;
import com.linx.touchkeyboard.util.TouchKeyboardXstreamUtil;
import java.awt.Component;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javafx.application.Platform;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.control.Button;
import javafx.scene.layout.Pane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TouchKeyboard
implements EventHandler<ActionEvent>,
TouchKeyboardExceptionMessages {
    private static final int INITIAL_MODE = -1;
    public static final int GRAPHICAL_MODE = 0;
    public static final int COMPONENT_MODE = 1;
    private int operationMode = -1;
    private TouchKeyboardRenderer renderer;
    private List<TouchKeyboardListener> listeners = new ArrayList<TouchKeyboardListener>();
    private Component componentFocus;
    private Logger logger = LoggerFactory.getLogger(TouchKeyboard.class);

    public void setComponentFocus(Component componentFocus) {
        this.componentFocus = componentFocus;
    }

    public void configure(File layouts, String styleRelativePath, String layoutId, int operationMode) throws KeyboardConfigException {
        if (this.renderer != null) {
            throw new KeyboardConfigException("N\u00e3o \u00e9 permitido alterar configura\u00e7\u00e3o para a atual inst\u00e2ncia do Touchkeyboard.");
        }
        if (layouts == null || !layouts.exists()) {
            throw new KeyboardConfigException("Arquivo com layouts do Teclado Touch n\u00e3o encontrado!");
        }
        if (operationMode != 0 && operationMode != 1) {
            throw new KeyboardConfigException("Modo de configura\u00e7\u00e3o do framewrok inv\u00e1lido. Valores v\u00e1lidos: 0 - Modo Gr\u00e1fico, 1 - Modo Componente");
        }
        this.logger.debug("Carregando configura\u00e7\u00f5es do arquivo (" + layouts.getAbsolutePath() + ") ...");
        KeyboardConfiguration configuration = TouchKeyboardXstreamUtil.loadKeyboardConfigurationWithValidation(layouts);
        this.logger.debug("Configura\u00e7\u00f5es carregadas.");
        if (styleRelativePath != null && new File(styleRelativePath).exists()) {
            this.logger.debug("Definindo estilo do teclado...");
            configuration.setStyleFilePath(styleRelativePath);
            this.logger.debug("Estilo do teclado definido.");
        }
        this.logger.debug("Instanciando renderizador do teclado...");
        this.renderer = new TouchKeyboardRenderer(configuration, this);
        this.logger.debug("Renderizador do teclado inicado.");
        if (operationMode == 0) {
            this.operationMode = 0;
            this.logger.debug("TouchKeyboard configurado para modo gr\u00e1fico.");
            Platform.runLater((Runnable)this.renderer);
        } else {
            this.logger.debug("TouchKeyboard configurado para modo componente.");
            this.operationMode = 1;
        }
        this.logger.debug("Definindo layout " + layoutId + " como padr\u00e3o...");
        this.renderer.setLayout(layoutId);
        this.logger.debug("Layout definido.");
    }

    public boolean isGraphicsMode() {
        return this.operationMode == 0;
    }

    public void show() {
        if (this.isGraphicsMode()) {
            if (this.renderer.getPrimaryStage() != null && this.renderer.getLayout() != null) {
                this.renderer.getPrimaryStage().show();
            } else {
                this.logger.debug("Stage ou Layout n\u00e3o definidos para renderiza\u00e7\u00e3o. Layout atual: " + this.renderer.getLayout() + " Stage Atual: " + this.renderer.getPrimaryStage());
            }
        } else {
            this.logger.debug("Touchkeyboard configurado como modo de opera\u00e7\u00e3o. Opera\u00e7\u00e3o n\u00e3o permitida.");
        }
    }

    public void hide() {
        if (this.isGraphicsMode()) {
            if (this.renderer.getPrimaryStage() != null) {
                this.renderer.getPrimaryStage().hide();
            } else {
                this.logger.debug("Stage n\u00e3o definido para renderiza\u00e7\u00e3o. Layout atual: " + this.renderer.getLayout());
            }
        } else {
            this.logger.debug("Touchkeyboard configurado como modo de opera\u00e7\u00e3o. Opera\u00e7\u00e3o n\u00e3o permitida.");
        }
    }

    public boolean isVisible() {
        if (this.isGraphicsMode()) {
            if (this.renderer.getPrimaryStage() != null) {
                return this.renderer.getPrimaryStage().isShowing();
            }
            return false;
        }
        return false;
    }

    public Pane getKeyboardAsComponent(String layoutId) {
        return this.renderer.getLayoutAsGridPane(layoutId);
    }

    public Pane getKeyboardAsComponent() {
        return this.renderer.getLayoutAsGridPane();
    }

    public Button getKeyAsButton(String layoutId, String keyId) {
        return this.renderer.getKeyAsButton(layoutId, keyId);
    }

    public void setLayout(String layoutId) {
        this.renderer.setLayout(layoutId);
        if (this.isGraphicsMode()) {
            this.renderer.drawLayout();
        }
    }

    public void addListener(TouchKeyboardListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(TouchKeyboardListener listener) {
        this.listeners.remove(listener);
    }

    public void setFocusTarget() {
        if (this.componentFocus != null) {
            this.componentFocus.requestFocus();
        }
    }

    public void handle(ActionEvent event) {
        TouchKeyboardKey keyboardKey = (TouchKeyboardKey)((Object)event.getSource());
        System.out.println("Evento recebido da tecla " + keyboardKey.getText());
        this.logger.debug("Evento recebido da tecla " + keyboardKey.getText());
        TouchKeyEvent evt = new TouchKeyEvent();
        evt.setKeyCode(keyboardKey.getKey().getKeyCode());
        evt.setCharCode(keyboardKey.getKey().getKeyChar());
        evt.setModifiers(0);
        this.logger.debug("Key code: " + keyboardKey.getKey().getKeyCode());
        this.logger.debug("Key char: " + keyboardKey.getKey().getKeyChar());
        this.logger.debug("Key type: " + (Object)((Object)keyboardKey.getKey().getType()));
        for (TouchKeyboardListener listener : this.listeners) {
            this.logger.debug("Notificando ouvindo do evento: " + listener.getClass().getName());
            listener.keyTouched(evt);
        }
        this.logger.debug("Definindo foco no componente.");
        this.setFocusTarget();
    }
}

