/*
 * Decompiled with CFR 0.152.
 */
package com.linx.touchkeyboard.renderer;

import com.linx.touchkeyboard.TouchKeyboard;
import com.linx.touchkeyboard.configuration.Key;
import com.linx.touchkeyboard.configuration.KeyType;
import com.linx.touchkeyboard.configuration.KeyboardConfiguration;
import com.linx.touchkeyboard.configuration.Layout;
import com.linx.touchkeyboard.renderer.TouchKeyboardKey;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.net.URL;
import java.util.Iterator;
import javafx.embed.swing.JFXPanel;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.OverrunStyle;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.RowConstraints;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.TextAlignment;
import javafx.stage.Stage;
import javafx.stage.StageBuilder;
import javafx.stage.StageStyle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TouchKeyboardRenderer
implements Runnable {
    Stage primaryStage;
    private KeyboardConfiguration configuration;
    private JFXPanel fxPanel = new JFXPanel();
    private String currentLayoutId;
    private Logger logger = LoggerFactory.getLogger(TouchKeyboard.class);
    private final TouchKeyboard keyboard;
    private int currentPageIndex = 0;

    public TouchKeyboardRenderer(KeyboardConfiguration configuration, TouchKeyboard keyboard) {
        this.configuration = configuration;
        this.keyboard = keyboard;
    }

    @Override
    public void run() {
        this.primaryStage = StageBuilder.create().build();
        this.drawLayout();
    }

    public Stage getPrimaryStage() {
        return this.primaryStage;
    }

    public void setPrimaryStage(Stage primaryStage) {
        this.primaryStage = primaryStage;
    }

    public KeyboardConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(KeyboardConfiguration configuration) {
        this.configuration = configuration;
    }

    public void setLayout(String layoutId) {
        if (layoutId != null) {
            this.currentLayoutId = layoutId;
        }
    }

    public String getLayout() {
        return this.currentLayoutId;
    }

    public void drawLayout() {
        Layout layout = this.configuration.getLayout(this.currentLayoutId);
        if (layout != null) {
            this.fxPanel.setSize(layout.getWidth(), layout.getHeight());
            this.fxPanel.setLocation(0, 0);
            Pane keyboardPages = this.getLayoutAsGridPane();
            if (keyboardPages != null && keyboardPages.getChildren() != null && keyboardPages.getChildren().size() > 0) {
                GridPane[] layoutPages = new GridPane[keyboardPages.getChildren().size()];
                Iterator it = keyboardPages.getChildren().iterator();
                int posicao = 0;
                while (it.hasNext()) {
                    Node node = (Node)it.next();
                    layoutPages[posicao] = (GridPane)node;
                    ++posicao;
                }
                layoutPages[this.currentPageIndex].toFront();
                Scene scene = new Scene((Parent)keyboardPages, (double)layout.getWidth(), (double)layout.getHeight(), (Paint)Color.TRANSPARENT);
                boolean cssParamOK = false;
                try {
                    if (this.configuration.getStyleFilePath() != null && !this.configuration.getStyleFilePath().trim().equalsIgnoreCase("")) {
                        this.logger.debug("Utilizando CSS parametrizado...");
                        scene.getStylesheets().add((Object)ClassLoader.getSystemResource(this.configuration.getStyleFilePath()).toExternalForm());
                        cssParamOK = true;
                    }
                }
                catch (Exception e) {
                    this.logger.error("Erro carregando arquivo de estilo!");
                }
                if (!cssParamOK) {
                    this.logger.debug("Nenhum estilo foi definido, utilizando CSS padr\u00e3o.");
                    URL url = this.getClass().getClassLoader().getResource("resource/stylesheet.css");
                    if (url != null) {
                        scene.getStylesheets().add((Object)url.toString());
                    }
                }
                if (this.primaryStage != null) {
                    this.primaryStage.setScene(scene);
                    this.primaryStage.initStyle(StageStyle.TRANSPARENT);
                    this.primaryStage.show();
                }
            }
        } else {
            this.logger.debug("Nenhum elemento ser\u00e1 renderizado. Layout atual: " + layout);
        }
    }

    public Pane getLayoutAsGridPane(String layoutId) {
        Pane keyboardPages = null;
        Layout layout = this.configuration.getLayout(layoutId);
        if (layout != null) {
            keyboardPages = new Pane();
            RowConstraints rowConstraint = new RowConstraints();
            rowConstraint.setVgrow(Priority.SOMETIMES);
            ColumnConstraints columnConstraint = new ColumnConstraints();
            columnConstraint.setHgrow(Priority.SOMETIMES);
            int pages = 1;
            if (this.keyboard.isGraphicsMode()) {
                pages = new BigDecimal(layout.getColumns() / layout.getVisibleColumns(), new MathContext(2, RoundingMode.UP)).intValue();
            }
            final GridPane[] layoutPages = new GridPane[pages];
            TouchKeyboardKey[][] keyboardKeys = new TouchKeyboardKey[layout.getRows()][layout.getColumns()];
            for (int column = 0; column < layout.getColumns(); ++column) {
                GridPane keyboardPage = null;
                int pageIndex = 0;
                if (this.keyboard.isGraphicsMode()) {
                    pageIndex = new BigDecimal(column / layout.getVisibleColumns(), new MathContext(2, RoundingMode.UP)).intValue();
                }
                if (pageIndex < keyboardPages.getChildren().size()) {
                    keyboardPage = (GridPane)keyboardPages.getChildren().get(pageIndex);
                } else {
                    keyboardPage = new GridPane();
                    keyboardPage.setGridLinesVisible(false);
                    keyboardPage.setPadding(new Insets(3.0, 3.0, 3.0, 3.0));
                    keyboardPage.setPrefSize((double)layout.getWidth(), (double)layout.getHeight());
                    keyboardPage.getRowConstraints().add((Object)rowConstraint);
                    keyboardPage.getColumnConstraints().add((Object)columnConstraint);
                    keyboardPages.getChildren().add((Object)keyboardPage);
                    layoutPages[pageIndex] = keyboardPage;
                }
                for (int row = 0; row < layout.getRows(); ++row) {
                    TouchKeyboardKey keyboardKey = new TouchKeyboardKey();
                    GridPane.setMargin((Node)keyboardKey, (Insets)new Insets(3.0, 3.0, 3.0, 3.0));
                    keyboardKey.setTextAlignment(TextAlignment.CENTER);
                    keyboardKey.setWrapText(true);
                    keyboardKey.setTextOverrun(OverrunStyle.CLIP);
                    keyboardKey.setFocusTraversable(false);
                    keyboardKey.setPrefSize(layout.getWidth() / layout.getVisibleColumns(), layout.getHeight() / layout.getVisibleRows());
                    keyboardPage.add((Node)keyboardKey, column, row);
                    keyboardKeys[row][column] = keyboardKey;
                }
            }
            block6: for (Key key : layout.getKeys()) {
                final TouchKeyboardKey keyboardKey = keyboardKeys[key.getRow()][key.getColumn()];
                keyboardKey.setKey(key);
                keyboardKey.setId(key.getId());
                keyboardKey.setStyle(key.getStyleId());
                keyboardKey.setText(key.getLabel());
                keyboardKey.setVisible(key.isVisible());
                keyboardKey.setDisable(key.isDisable());
                if (key.isDisable()) continue;
                switch (key.getType()) {
                    case FORWARD: {
                        keyboardKey.addEventHandler(ActionEvent.ACTION, (EventHandler)new EventHandler<ActionEvent>(){

                            public void handle(ActionEvent event) {
                                TouchKeyboardRenderer.this.navigateToPage(keyboardKey.getKey().getType(), layoutPages);
                            }
                        });
                        continue block6;
                    }
                    case BACKWARD: {
                        keyboardKey.addEventHandler(ActionEvent.ACTION, (EventHandler)new EventHandler<ActionEvent>(){

                            public void handle(ActionEvent event) {
                                TouchKeyboardRenderer.this.navigateToPage(keyboardKey.getKey().getType(), layoutPages);
                            }
                        });
                        continue block6;
                    }
                }
                keyboardKey.addEventHandler(ActionEvent.ACTION, this.keyboard);
            }
        } else {
            this.logger.debug("Nenhum elemento ser\u00e1 recuperado. Layout atual: " + layout);
        }
        return keyboardPages;
    }

    public Pane getLayoutAsGridPane() {
        return this.getLayoutAsGridPane(this.currentLayoutId);
    }

    public Button getKeyAsButton(String layoutId, String keyId) {
        TouchKeyboardKey button = null;
        Layout layout = this.configuration.getLayout(layoutId);
        if (layout != null) {
            for (Key key : layout.getKeys()) {
                if (key != null && key.getId() != null && key.getId().equalsIgnoreCase(keyId)) {
                    TouchKeyboardKey keyboardKey = new TouchKeyboardKey();
                    keyboardKey.setWrapText(true);
                    keyboardKey.setTextAlignment(TextAlignment.CENTER);
                    keyboardKey.setTextOverrun(OverrunStyle.CLIP);
                    keyboardKey.setFocusTraversable(false);
                    keyboardKey.setPrefSize(layout.getWidth() / layout.getVisibleColumns(), layout.getHeight() / layout.getVisibleRows());
                    keyboardKey.setKey(key);
                    keyboardKey.setId(key.getId());
                    keyboardKey.setStyle(key.getStyleId());
                    keyboardKey.setText(key.getLabel());
                    keyboardKey.setDisable(key.isDisable());
                    keyboardKey.setVisible(key.isVisible());
                    keyboardKey.addEventHandler(ActionEvent.ACTION, this.keyboard);
                    button = keyboardKey;
                    continue;
                }
                this.logger.debug("Button n\u00e3o ser\u00e1 retornado. KeyId " + keyId);
            }
        } else {
            this.logger.debug("Button n\u00e3o ser\u00e1 retornado. Layout atual: " + layout);
        }
        return button;
    }

    private void navigateToPage(KeyType keyType, GridPane[] layoutPages) {
        switch (keyType) {
            case FORWARD: {
                if (this.currentPageIndex >= layoutPages.length - 1) break;
                layoutPages[++this.currentPageIndex].toFront();
                break;
            }
            case BACKWARD: {
                if (this.currentPageIndex <= 0) break;
                layoutPages[--this.currentPageIndex].toFront();
                break;
            }
        }
    }
}

