/*
 * Decompiled with CFR 0.152.
 */
package com.linx.touchkeyboard.util;

import com.linx.touchkeyboard.TouchKeyboard;
import com.linx.touchkeyboard.configuration.Key;
import com.linx.touchkeyboard.configuration.KeyboardConfiguration;
import com.linx.touchkeyboard.configuration.Layout;
import com.linx.touchkeyboard.exception.KeyboardConfigException;
import com.linx.touchkeyboard.exception.TouchKeyboardExceptionMessages;
import com.linx.touchkeyboard.util.TouchKeyboardXstreamConverter;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.DomDriver;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TouchKeyboardXstreamUtil
implements TouchKeyboardExceptionMessages {
    private static Logger logger = LoggerFactory.getLogger(TouchKeyboard.class);

    public static void initizalizeConfiguration(XStream instance) {
        instance.alias("keyboardconfiguration", KeyboardConfiguration.class);
        instance.omitField(KeyboardConfiguration.class, "styleId");
        instance.alias("layout", Layout.class);
        instance.alias("key", Key.class);
        instance.omitField(Key.class, "valid");
        instance.omitField(Layout.class, "valid");
        instance.registerConverter((Converter)new TouchKeyboardXstreamConverter());
    }

    public static KeyboardConfiguration loadKeyboardConfiguration(File layoutFile) throws KeyboardConfigException {
        try {
            XStream parseXML = new XStream((HierarchicalStreamDriver)new DomDriver("UTF-8"));
            TouchKeyboardXstreamUtil.initizalizeConfiguration(parseXML);
            FileInputStream input = new FileInputStream(layoutFile);
            InputStreamReader reader = new InputStreamReader((InputStream)input, Charset.forName("UTF-8"));
            KeyboardConfiguration configuration = (KeyboardConfiguration)parseXML.fromXML((Reader)reader);
            return configuration;
        }
        catch (IOException ioe) {
            logger.error("Arquivo com layouts do Teclado Touch n\u00e3o encontrado!", (Throwable)ioe);
            throw new KeyboardConfigException("Arquivo com layouts do Teclado Touch n\u00e3o encontrado!", ioe);
        }
        catch (Exception e) {
            logger.error("Erro durante parse do arquivo de layout do Teclado Touch!", (Throwable)e);
            throw new KeyboardConfigException("Erro durante parse do arquivo de layout do Teclado Touch!", e);
        }
    }

    public static KeyboardConfiguration loadKeyboardConfigurationWithValidation(File layoutFile) throws KeyboardConfigException {
        try {
            KeyboardConfiguration configuration = TouchKeyboardXstreamUtil.loadKeyboardConfiguration(layoutFile);
            TouchKeyboardXstreamUtil.validateKeyboardConfiguration(configuration);
            return configuration;
        }
        catch (KeyboardConfigException kce) {
            throw kce;
        }
        catch (Exception e) {
            logger.error("Erro durante parse do arquivo de layout do Teclado Touch!", (Throwable)e);
            throw new KeyboardConfigException("Erro durante parse do arquivo de layout do Teclado Touch!", e);
        }
    }

    public static void saveKeyboardConfiguration(KeyboardConfiguration configuration, File layoutFile) throws KeyboardConfigException {
        try {
            XStream xstream = new XStream((HierarchicalStreamDriver)new DomDriver("UTF-8"));
            TouchKeyboardXstreamUtil.initizalizeConfiguration(xstream);
            FileOutputStream outputStream = new FileOutputStream(layoutFile);
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)outputStream, Charset.forName("UTF-8"));
            xstream.toXML((Object)configuration, (Writer)writer);
        }
        catch (FileNotFoundException e) {
            logger.error("Arquivo n\u00e3o encontrado para grava\u00e7\u00e3o das configura\u00e7\u00f5es!", (Throwable)e);
            throw new KeyboardConfigException("Arquivo n\u00e3o encontrado para grava\u00e7\u00e3o das configura\u00e7\u00f5es!", e);
        }
    }

    private static void validateKeyboardConfiguration(KeyboardConfiguration configuration) throws KeyboardConfigException {
        if (configuration != null) {
            Hashtable hashControle = new Hashtable();
            Map<String, Layout> mapLayouts = configuration.getLayouts();
            Collection<Layout> layouts = mapLayouts.values();
            if (layouts != null) {
                for (Layout layout : layouts) {
                    ArrayList<Key> keys;
                    if (layout == null || (keys = layout.getKeys()) == null) continue;
                    for (Key key : keys) {
                        if (key.isDisable()) continue;
                        if (key.getId() == null || key.getId().trim().equalsIgnoreCase("")) {
                            logger.error("Arquivo de layouts inv\u00e1lido.Tecla " + key.getLabel() + " com ID nulo ou em branco.");
                            throw new KeyboardConfigException("Arquivo de layouts inv\u00e1lido.Tecla " + key.getLabel() + " com ID nulo ou em branco.");
                        }
                        if (!hashControle.contains(key.getId())) continue;
                        logger.error("Arquivo de layouts inv\u00e1lido.Tecla " + key.getLabel() + " possui ID associado a outra tecla. ID: " + key.getId());
                        throw new KeyboardConfigException("Arquivo de layouts inv\u00e1lido.Tecla " + key.getLabel() + " possui ID associado a outra tecla. ID: " + key.getId());
                    }
                }
            }
            logger.debug("Configura\u00e7\u00e3o de Layouts validada com sucesso!");
        }
    }
}

