/*
 * Decompiled with CFR 0.152.
 */
package com.linx.touchkeyboard.util.configuration;

import com.linx.touchkeyboard.configuration.Layout;
import com.linx.touchkeyboard.renderer.TouchKeyboardKey;
import com.linx.touchkeyboard.util.TouchKeyboardKeyControlUtil;
import com.linx.touchkeyboard.util.configuration.AlertDialog;
import com.linx.touchkeyboard.util.configuration.KeyConfigurationDialog;
import com.linx.touchkeyboard.util.configuration.KeyConfigurationDialogController;
import java.net.URL;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXMLLoader;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.input.MouseEvent;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.WindowEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TouchKeyboardKeyEventHandler
implements EventHandler<ActionEvent> {
    Logger logger = LoggerFactory.getLogger(TouchKeyboardKeyEventHandler.class);
    private static final String KEY_CONFIG_FXML = "KeyConfigurationDialog.fxml";
    private TouchKeyboardKey keyboardKey;
    private Layout layout;

    public TouchKeyboardKeyEventHandler(Layout layout, TouchKeyboardKey key) {
        this.layout = layout;
        this.keyboardKey = key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(ActionEvent event) {
        try {
            this.logger.debug("Iniciando tratamento pata tecla selecionada");
            URL location = this.getClass().getResource(KEY_CONFIG_FXML);
            FXMLLoader fxmlLoader = new FXMLLoader(location);
            Parent root = (Parent)fxmlLoader.load();
            this.logger.debug("Instanciando controller");
            KeyConfigurationDialogController controller = (KeyConfigurationDialogController)fxmlLoader.getController();
            if (this.keyboardKey != null && this.keyboardKey.getKey() != null) {
                this.logger.debug("Incluindo informa\u00e7\u00f5es da teclas nos componentes do controller");
                controller.getTfId().setText(this.keyboardKey.getKey().getId());
                controller.getChkDisable().setSelected(this.keyboardKey.getKey().isDisable());
                controller.getChkVisible().setSelected(this.keyboardKey.getKey().isVisible());
                controller.getTfAscCode().setText(this.keyboardKey.getKey().getKeyCode() + "");
                controller.getTfCharCode().setText(this.keyboardKey.getKey().getKeyChar() + "");
                controller.getTfLabel().setText(this.keyboardKey.getKey().getLabel());
                controller.getTfStyleId().setText(this.keyboardKey.getKey().getStyleId());
                if (this.keyboardKey.getKey().getType() != null) {
                    controller.getSelectType().getSelectionModel().select((Object)this.keyboardKey.getKey().getType().getLabel());
                }
                this.logger.debug("Informa\u00e7\u00f5es inclupidas no controller com sucesso.");
                this.logger.debug("Exclui ID da tecla seleiconada da Hash de controle para permitir edi\u00e7\u00e3o");
                if (this.keyboardKey != null && this.keyboardKey.getKey() != null) {
                    TouchKeyboardKeyControlUtil.removeKeyHashControl(this.keyboardKey.getKey().getId());
                }
            }
            this.logger.debug("Inicializando Tela de Edi\u00e7\u00e3o de Teclas");
            Scene scene = new Scene(root);
            final KeyConfigurationDialog dialog = new KeyConfigurationDialog(StageStyle.TRANSPARENT);
            dialog.initModality(Modality.WINDOW_MODAL);
            dialog.initOwner(this.keyboardKey.getScene().getWindow());
            dialog.setScene(scene);
            dialog.setTouchKeyboardKey((TouchKeyboardKey)((Object)event.getSource()));
            dialog.setLayout(this.layout);
            dialog.centerOnScreen();
            controller.setStageParent(dialog);
            dialog.setOnCloseRequest((EventHandler)new EventHandler<WindowEvent>(){

                public void handle(WindowEvent event) {
                    if (event.getEventType().equals(WindowEvent.WINDOW_CLOSE_REQUEST)) {
                        event.consume();
                    }
                }
            });
            final PositionControl dragDelta = new PositionControl();
            root.setOnMousePressed((EventHandler)new EventHandler<MouseEvent>(){

                public void handle(MouseEvent mouseEvent) {
                    dragDelta.x = dialog.getX() - mouseEvent.getScreenX();
                    dragDelta.y = dialog.getY() - mouseEvent.getScreenY();
                }
            });
            root.setOnMouseDragged((EventHandler)new EventHandler<MouseEvent>(){

                public void handle(MouseEvent mouseEvent) {
                    dialog.setX(mouseEvent.getScreenX() + dragDelta.x);
                    dialog.setY(mouseEvent.getScreenY() + dragDelta.y);
                }
            });
            dialog.show();
            this.logger.debug("Tela de Edi\u00e7\u00e3o de Teclas configurada e liberada para exibi\u00e7\u00e3o");
        }
        catch (Exception e) {
            new AlertDialog((Stage)this.keyboardKey.getScene().getWindow(), "N\u00e3o foi poss\u00edvel exibir informa\u00e7\u00f5es da Tecla Selecionada").showAndWait();
            this.logger.error("N\u00e3o foi poss\u00edvel exibir informa\u00e7\u00f5es da Tecla Selecionada", (Throwable)e);
        }
        finally {
            this.logger.debug("Finalizandio tratamento pata tecla selecionada");
        }
    }

    class PositionControl {
        double x;
        double y;

        PositionControl() {
        }
    }
}

