/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui.mac;

import com.sun.glass.ui.Application;
import com.sun.glass.ui.CommonDialogs;
import com.sun.glass.ui.Cursor;
import com.sun.glass.ui.InvokeLaterDispatcher;
import com.sun.glass.ui.Launchable;
import com.sun.glass.ui.Menu;
import com.sun.glass.ui.MenuBar;
import com.sun.glass.ui.MenuItem;
import com.sun.glass.ui.Pen;
import com.sun.glass.ui.Pixels;
import com.sun.glass.ui.Robot;
import com.sun.glass.ui.Screen;
import com.sun.glass.ui.Size;
import com.sun.glass.ui.Timer;
import com.sun.glass.ui.View;
import com.sun.glass.ui.Window;
import com.sun.glass.ui.mac.MacCommonDialogs;
import com.sun.glass.ui.mac.MacCursor;
import com.sun.glass.ui.mac.MacPixels;
import com.sun.glass.ui.mac.MacRobot;
import com.sun.glass.ui.mac.MacScreen;
import com.sun.glass.ui.mac.MacTimer;
import com.sun.glass.ui.mac.MacView;
import com.sun.glass.ui.mac.MacWindow;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MacApplication
extends Application
implements InvokeLaterDispatcher.InvokeLaterSubmitter {
    private boolean isEmbedded = false;
    private boolean isTaskbarApplication = false;
    private final InvokeLaterDispatcher invokeLaterDispatcher = new InvokeLaterDispatcher(this);
    Menu appleMenu;
    static final long BROWSER_PARENT_ID = -1L;

    public MacApplication() {
        this.invokeLaterDispatcher.start();
    }

    private static native void _initIDs();

    native void _runLoop(String[] var1, ClassLoader var2, Launchable var3, boolean var4, boolean var5);

    @Override
    protected void runLoop(String[] args, Launchable launchable) {
        this.isEmbedded = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return Boolean.getBoolean("javafx.macosx.embedded");
            }
        });
        this.isTaskbarApplication = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                String taskbarAppProp = System.getProperty("com.sun.glass.taskbarApplication");
                return !"false".equalsIgnoreCase(taskbarAppProp);
            }
        });
        ClassLoader classLoader = MacApplication.class.getClassLoader();
        this._runLoop(args, classLoader, launchable, this.isEmbedded, this.isTaskbarApplication);
    }

    private native void _finishTerminating();

    @Override
    protected void finishTerminating() {
        this.setEventThread(null);
        if (!this.isEmbedded) {
            this._finishTerminating();
        }
        super.finishTerminating();
    }

    private void setEventThread() {
        this.setEventThread(Thread.currentThread());
    }

    private native Object _enterNestedEventLoopImpl();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Object _enterNestedEventLoop() {
        this.invokeLaterDispatcher.notifyEnteringNestedEventLoop();
        try {
            Object object = this._enterNestedEventLoopImpl();
            return object;
        }
        finally {
            this.invokeLaterDispatcher.notifyLeftNestedEventLoop();
        }
    }

    private native void _leaveNestedEventLoopImpl(Object var1);

    @Override
    protected void _leaveNestedEventLoop(Object retValue) {
        this.invokeLaterDispatcher.notifyLeavingNestedEventLoop();
        this._leaveNestedEventLoopImpl(retValue);
    }

    public void installAppleMenu(MenuBar menubar) {
        this.appleMenu = this.createMenu("Apple");
        MenuItem quitMenu = this.createMenuItem("Quit " + this.getName(), new MenuItem.Callback(){

            public void action() {
                Application.EventHandler eh = MacApplication.this.getEventHandler();
                if (eh != null) {
                    eh.handleQuitAction(Application.GetApplication(), System.nanoTime());
                }
            }

            public void validate() {
            }
        }, 113, 16);
        this.appleMenu.add(quitMenu);
        menubar.add(this.appleMenu);
    }

    public Menu getAppleMenu() {
        return this.appleMenu;
    }

    @Override
    public void installDefaultMenus(MenuBar menubar) {
        this.installAppleMenu(menubar);
    }

    @Override
    public Window createWindow(Window owner, Screen screen, int styleMask) {
        return new MacWindow(owner, screen, styleMask);
    }

    @Override
    public Window createWindow(long parent) {
        MacWindow window = new MacWindow(parent);
        if (parent == -1L) {
            window.setView(this.createView(new TempPen()));
        }
        return window;
    }

    @Override
    public View createView(Pen pen) {
        return new MacView(pen);
    }

    @Override
    public Cursor createCursor(int type) {
        return new MacCursor(type);
    }

    @Override
    public Cursor createCursor(int x, int y, Pixels pixels) {
        return new MacCursor(x, y, pixels);
    }

    @Override
    protected void staticCursor_setVisible(boolean visible) {
        MacCursor.setVisible_impl(visible);
    }

    @Override
    protected Size staticCursor_getBestSize(int width, int height) {
        return MacCursor.getBestSize_impl(width, height);
    }

    @Override
    public Pixels createPixels(int width, int height, ByteBuffer data) {
        return new MacPixels(width, height, data);
    }

    @Override
    public Pixels createPixels(int width, int height, IntBuffer data) {
        return new MacPixels(width, height, data);
    }

    @Override
    protected int staticPixels_getNativeFormat() {
        return MacPixels.getNativeFormat_impl();
    }

    @Override
    public Robot createRobot() {
        return new MacRobot();
    }

    @Override
    protected Screen staticScreen_getDeepestScreen() {
        return MacScreen.getDeepestScreen_impl();
    }

    @Override
    protected Screen staticScreen_getMainScreen() {
        return MacScreen.getMainScreen_impl();
    }

    @Override
    protected Screen staticScreen_getScreenForLocation(int x, int y) {
        return MacScreen.getScreenForLocation_impl(x, y);
    }

    @Override
    protected Screen staticScreen_getScreenForPtr(long screenPtr) {
        return MacScreen.getScreenForPtr_impl(screenPtr);
    }

    @Override
    protected List<Screen> staticScreen_getScreens() {
        return MacScreen.getScreens_impl();
    }

    @Override
    public Timer createTimer(Runnable runnable) {
        return new MacTimer(runnable);
    }

    @Override
    protected int staticTimer_getMinPeriod() {
        return MacTimer.getMinPeriod_impl();
    }

    @Override
    protected int staticTimer_getMaxPeriod() {
        return MacTimer.getMaxPeriod_impl();
    }

    @Override
    protected String[] staticCommonDialogs_showFileChooser(Window owner, String folder, String title, int type, boolean multipleMode, CommonDialogs.ExtensionFilter[] extensionFilters) {
        return MacCommonDialogs.showFileChooser_impl(owner, folder, title, type, multipleMode, extensionFilters);
    }

    @Override
    protected String staticCommonDialogs_showFolderChooser(Window owner, String folder, String title) {
        return MacCommonDialogs.showFolderChooser_impl();
    }

    @Override
    protected long staticView_getMultiClickTime() {
        return MacView.getMultiClickTime_impl();
    }

    @Override
    protected int staticView_getMultiClickMaxX() {
        return MacView.getMultiClickMaxX_impl();
    }

    @Override
    protected int staticView_getMultiClickMaxY() {
        return MacView.getMultiClickMaxY_impl();
    }

    @Override
    protected native void _invokeAndWait(Runnable var1);

    @Override
    public native void submitForLaterInvocation(Runnable var1);

    @Override
    protected void _invokeLater(Runnable runnable) {
        this.invokeLaterDispatcher.invokeLater(runnable);
    }

    @Override
    protected void _postOnEventQueue(Runnable runnable) {
        this._invokeLater(runnable);
    }

    @Override
    public boolean supportsTransparentWindows() {
        return true;
    }

    protected native String _getRemoteLayerServerName();

    public String getRemoteLayerServerName() {
        return this._getRemoteLayerServerName();
    }

    static {
        Application.loadNativeLibrary();
        MacApplication._initIDs();
    }

    static class TempPen
    extends Pen {
        private static final Map capabilities = new HashMap();

        TempPen() {
        }

        public Map getCapabilities() {
            return capabilities;
        }

        public void paint(long time, int width, int height) {
        }

        static {
            capabilities.put(View.Capability.k3dKey, new Boolean(true));
            capabilities.put(View.Capability.kSyncKey, new Boolean(true));
        }
    }
}

