/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.css;

import com.sun.javafx.css.StyleManager;
import com.sun.javafx.css.Styleable;
import com.sun.javafx.css.StyleableProperty;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.net.URL;
import javafx.scene.Node;
import javafx.scene.Scene;

public class CssError {
    private static Reference<Scene> SCENE_REF;
    private final Reference<Scene> sceneRef;
    protected final String message;

    public static void setCurrentScene(Scene scene) {
        if (StyleManager.getInstance().getErrors() == null) {
            return;
        }
        if (scene != null) {
            Scene scene2;
            Scene scene3 = scene2 = SCENE_REF != null ? SCENE_REF.get() : null;
            if (scene2 != scene) {
                SCENE_REF = new WeakReference<Scene>(scene);
            }
        } else {
            SCENE_REF = null;
        }
    }

    public final String getMessage() {
        return this.message;
    }

    public CssError(String string) {
        this.message = string;
        this.sceneRef = SCENE_REF;
    }

    public Scene getScene() {
        return this.sceneRef != null ? this.sceneRef.get() : null;
    }

    public String toString() {
        return "CSS Error: " + this.message;
    }

    public static final class PropertySetError
    extends CssError {
        private final StyleableProperty styleableProperty;
        private final Node node;

        public PropertySetError(StyleableProperty styleableProperty, Node node, String string) {
            super(string);
            this.styleableProperty = styleableProperty;
            this.node = node;
        }

        public Node getNode() {
            return this.node;
        }

        public StyleableProperty getProperty() {
            return this.styleableProperty;
        }
    }

    public static final class StringParsingError
    extends CssError {
        private final String style;

        public StringParsingError(String string, String string2) {
            super(string2);
            this.style = string;
        }

        public String getStyle() {
            return this.style;
        }

        @Override
        public String toString() {
            return "CSS Error parsing '" + this.style + ": " + this.message;
        }
    }

    public static final class InlineStyleParsingError
    extends CssError {
        private final Styleable styleable;

        public InlineStyleParsingError(Styleable styleable, String string) {
            super(string);
            this.styleable = styleable;
        }

        public Styleable getStyleable() {
            return this.styleable;
        }

        @Override
        public String toString() {
            String string = this.styleable.getStyle();
            String string2 = this.styleable.toString();
            return "CSS Error parsing in-line style '" + string + "' from " + string2 + ": " + this.message;
        }
    }

    public static final class StylesheetParsingError
    extends CssError {
        private final URL url;

        public StylesheetParsingError(URL uRL, String string) {
            super(string);
            this.url = uRL;
        }

        public URL getURL() {
            return this.url;
        }

        @Override
        public String toString() {
            String string = this.url != null ? this.url.toExternalForm() : "?";
            return "CSS Error parsing " + string + ": " + this.message;
        }
    }
}

