/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webpane.platform;

import com.sun.webpane.platform.SharedBufferInputStream;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SharedBufferManager {
    private volatile long sharedBufferPtr = 0L;
    private volatile long sharedBufferSize = 0L;
    private volatile boolean allDataReceived;
    private int inputStreamCounter;
    private boolean isReleased;
    private static final Logger log = Logger.getLogger(SharedBufferManager.class.getName());
    private String idStr;

    private String getID() {
        if (this.idStr == null) {
            this.idStr = String.format("ID %X: ", this.hashCode());
        }
        return this.idStr;
    }

    public static SharedBufferManager createInstance() {
        return new SharedBufferManager();
    }

    private SharedBufferManager() {
    }

    public synchronized SharedBufferInputStream getInputStream() {
        ++this.inputStreamCounter;
        return new SharedBufferInputStream(this, true);
    }

    public synchronized SharedBufferInputStream getInputStream(boolean bl) {
        ++this.inputStreamCounter;
        return new SharedBufferInputStream(this, bl);
    }

    public synchronized void release() {
        if (this.isReleased()) {
            return;
        }
        this.isReleased = true;
        if (this.inputStreamCounter == 0 && this.sharedBufferPtr != 0L) {
            SharedBufferManager.releaseSharedBufferPtr(this.sharedBufferPtr);
            this.sharedBufferPtr = 0L;
        }
    }

    public boolean isReleased() {
        return this.isReleased;
    }

    public boolean isAllDataReceived() {
        return this.allDataReceived;
    }

    public synchronized void update(long l, int n, boolean bl) {
        if (log.isLoggable(Level.FINE)) {
            log.fine(this.getID() + "More data available...");
        }
        boolean bl2 = this.allDataReceived = this.allDataReceived || bl;
        if (l == 0L) {
            log.fine("uninitialized native shared buffer");
            return;
        }
        if (this.sharedBufferSize > (long)n && log.isLoggable(Level.FINE)) {
            log.fine(String.format(this.getID() + "Invalid new buffer size: %d (old %d)", n, this.sharedBufferSize));
        }
        if (this.getSharedBufferPtr() != 0L) {
            if (this.getSharedBufferPtr() != l) {
                log.fine(String.format("Error: invalid shared buffer in use: %X (shuld be %X)", l, this.getSharedBufferPtr()));
                assert (false);
            }
        } else {
            this.setSharedBufferPtr(l);
        }
        this.sharedBufferSize = n;
        this.notifyAll();
    }

    public long getSharedBufferPtr() {
        return this.sharedBufferPtr;
    }

    public long getSharedBufferSize() {
        return this.sharedBufferSize;
    }

    long getNativeBufferSize() {
        if (this.sharedBufferPtr != 0L) {
            return SharedBufferManager.getNativeBufferSize(this.sharedBufferPtr);
        }
        return 0L;
    }

    public synchronized void notifyInputStreamClosed() {
        if (--this.inputStreamCounter == 0 && this.isReleased() && this.sharedBufferPtr != 0L) {
            SharedBufferManager.releaseSharedBufferPtr(this.sharedBufferPtr);
        }
    }

    public int fillBuffer(long l, byte[] byArray) throws IOException {
        if (this.sharedBufferPtr != 0L) {
            return SharedBufferManager.fillBuffer(this.sharedBufferPtr, l, byArray);
        }
        throw new IOException("All the connected SharedBufferInputStreams are closed and the native SharedBuffer has been destroyed");
    }

    private void setSharedBufferPtr(long l) {
        assert (l != 0L);
        this.sharedBufferPtr = l;
        SharedBufferManager.protectSharedBufferPtr(l);
    }

    private static synchronized native void protectSharedBufferPtr(long var0);

    private static synchronized native void releaseSharedBufferPtr(long var0);

    private static native int fillBuffer(long var0, long var2, byte[] var4);

    private static native long getNativeBufferSize(long var0);
}

