/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webpane.platform;

import com.sun.javafx.runtime.NativeLibLoader;
import com.sun.webpane.platform.BackForwardList;
import com.sun.webpane.platform.ConfigManager;
import com.sun.webpane.platform.InputMethodClient;
import com.sun.webpane.platform.InspectorClient;
import com.sun.webpane.platform.Invoker;
import com.sun.webpane.platform.LoadListenerClient;
import com.sun.webpane.platform.PolicyClient;
import com.sun.webpane.platform.ThemeClient;
import com.sun.webpane.platform.UIClient;
import com.sun.webpane.platform.Utilities;
import com.sun.webpane.platform.WebPageClient;
import com.sun.webpane.platform.event.WCFocusEvent;
import com.sun.webpane.platform.event.WCInputMethodEvent;
import com.sun.webpane.platform.event.WCKeyEvent;
import com.sun.webpane.platform.event.WCMouseEvent;
import com.sun.webpane.platform.event.WCMouseWheelEvent;
import com.sun.webpane.platform.event.WCTouchEvent;
import com.sun.webpane.platform.graphics.RenderTheme;
import com.sun.webpane.platform.graphics.ScrollBarTheme;
import com.sun.webpane.platform.graphics.WCGraphicsContext;
import com.sun.webpane.platform.graphics.WCImage;
import com.sun.webpane.platform.graphics.WCPageBackBuffer;
import com.sun.webpane.platform.graphics.WCPoint;
import com.sun.webpane.platform.graphics.WCRectangle;
import com.sun.webpane.platform.graphics.WCRenderQueue;
import com.sun.webpane.platform.graphics.WCSize;
import com.sun.webpane.webkit.WCFrameView;
import com.sun.webpane.webkit.WCWidget;
import com.sun.webpane.webkit.network.CookieManager;
import com.sun.webpane.webkit.network.URLs;
import java.net.CookieHandler;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import netscape.javascript.JSException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class WebPage {
    private static final Logger log = Logger.getLogger(WebPage.class.getName());
    private static final Logger paintLog = Logger.getLogger(WebPage.class.getName() + ".paint");
    private static final Logger paintDirtyLog = Logger.getLogger(WebPage.class.getName() + ".paint.dirty");
    private long pPage = 0L;
    private boolean isDisposed = false;
    private int width;
    private int height;
    private int fontSmoothingType;
    private WCFrameView hostWindow;
    private Set<Long> frames = new HashSet<Long>();
    private final AccessControlContext accessControlContext;
    private Map<Integer, String> requestURLs = new HashMap<Integer, String>();
    private Set<Integer> requestStarted = new HashSet<Integer>();
    public static final ReentrantLock PAGE_LOCK = new ReentrantLock();
    private List<WCRenderQueue> rqList = new LinkedList<WCRenderQueue>();
    private int rqSize = 0;
    private WCPageBackBuffer backbuffer;
    private List<WCRectangle> dirtyRects = new LinkedList<WCRectangle>();
    private List<ScrollRequest> scrollRequests = new LinkedList<ScrollRequest>();
    private WebPageClient pageClient;
    private UIClient uiClient;
    private PolicyClient policyClient;
    private InputMethodClient imClient;
    private List<LoadListenerClient> loadListenerClients = new LinkedList<LoadListenerClient>();
    private InspectorClient inspectorClient;
    private ThemeClient themeClient;
    private RenderTheme renderTheme;
    private ScrollBarTheme scrollbarTheme;
    public static final int DND_DST_ENTER = 0;
    public static final int DND_DST_OVER = 1;
    public static final int DND_DST_CHANGE = 2;
    public static final int DND_DST_EXIT = 3;
    public static final int DND_DST_DROP = 4;
    public static final int DND_SRC_ENTER = 100;
    public static final int DND_SRC_OVER = 101;
    public static final int DND_SRC_CHANGE = 102;
    public static final int DND_SRC_EXIT = 103;
    public static final int DND_SRC_DROP = 104;

    public WebPage(WebPageClient webPageClient, UIClient uIClient, PolicyClient policyClient, ThemeClient themeClient, boolean bl) {
        Invoker.getInvoker().checkEventThread();
        this.setPageClient(webPageClient);
        this.setUIClient(uIClient);
        this.setPolicyClient(policyClient);
        this.setThemeClient(themeClient);
        this.accessControlContext = AccessController.getContext();
        this.hostWindow = new WCFrameView(this);
        this.pPage = this.twkCreatePage(bl);
        this.twkInit(this.pPage, AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return Boolean.getBoolean("com.sun.swing.webpane.usePlugins");
            }
        }));
        if (webPageClient != null && webPageClient.isBackBufferSupported()) {
            this.backbuffer = webPageClient.createBackBuffer();
            this.backbuffer.ref();
        }
    }

    public long getPage() {
        return this.pPage;
    }

    public WCWidget getHostWindow() {
        return this.hostWindow;
    }

    public AccessControlContext getAccessControlContext() {
        return this.accessControlContext;
    }

    public static boolean lockPage() {
        return Invoker.getInvoker().lock(PAGE_LOCK);
    }

    public static boolean unlockPage() {
        return Invoker.getInvoker().unlock(PAGE_LOCK);
    }

    private boolean addLastRenderQueue(WCRenderQueue wCRenderQueue) {
        this.rqSize += wCRenderQueue.getSize();
        this.rqList.add(wCRenderQueue);
        if (this.rqSize > 524288) {
            log.log(Level.FINE, "RQ overflow {0}: Drop incremental update.", this.rqSize);
            this.clearRenderQueues();
            this.markDirty();
            return false;
        }
        return true;
    }

    private WCRenderQueue removeFirstRenderQueue() {
        if (this.rqList.isEmpty()) {
            return null;
        }
        WCRenderQueue wCRenderQueue = this.rqList.remove(0);
        this.rqSize -= wCRenderQueue.getSize();
        return wCRenderQueue;
    }

    private void markDirty() {
        this.dirtyRects.clear();
        this.addDirtyRect(new WCRectangle(0.0f, 0.0f, this.width, this.height));
    }

    private void addDirtyRect(WCRectangle wCRectangle) {
        Iterator<WCRectangle> iterator = this.dirtyRects.iterator();
        while (iterator.hasNext()) {
            WCRectangle wCRectangle2 = iterator.next();
            if (wCRectangle2.contains(wCRectangle)) {
                return;
            }
            if (wCRectangle.contains(wCRectangle2)) {
                iterator.remove();
                continue;
            }
            WCRectangle wCRectangle3 = wCRectangle2.createUnion(wCRectangle);
            if (wCRectangle3.getIntWidth() * wCRectangle3.getIntHeight() >= wCRectangle2.getIntWidth() * wCRectangle2.getIntHeight() + wCRectangle.getIntWidth() * wCRectangle.getIntHeight()) continue;
            iterator.remove();
            wCRectangle = wCRectangle3;
        }
        this.dirtyRects.add(wCRectangle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDirty() {
        WebPage.lockPage();
        try {
            boolean bl = !this.dirtyRects.isEmpty() || !this.scrollRequests.isEmpty();
            return bl;
        }
        finally {
            WebPage.unlockPage();
        }
    }

    private void updateDirty(WCRectangle wCRectangle) {
        Object object;
        if (this.isDisposed || this.width <= 0 || this.height <= 0) {
            this.dirtyRects.clear();
            return;
        }
        if (wCRectangle == null) {
            wCRectangle = new WCRectangle(0.0f, 0.0f, this.width, this.height);
        }
        List<WCRectangle> list = this.dirtyRects;
        this.dirtyRects = new LinkedList<WCRectangle>();
        while (!list.isEmpty()) {
            object = list.remove(0).intersection(wCRectangle);
            if (((WCRectangle)object).getWidth() <= 0.0f || ((WCRectangle)object).getHeight() <= 0.0f) continue;
            if (log.isLoggable(Level.FINEST)) {
                paintLog.finest("updating: " + object);
            }
            WCRenderQueue wCRenderQueue = new WCRenderQueue((WCRectangle)object);
            this.twkUpdateContent(this.getPage(), wCRenderQueue, ((WCRectangle)object).getIntX() - 1, ((WCRectangle)object).getIntY() - 1, ((WCRectangle)object).getIntWidth() + 2, ((WCRectangle)object).getIntHeight() + 2);
            if (this.addLastRenderQueue(wCRenderQueue)) continue;
            return;
        }
        object = new WCRenderQueue(wCRectangle);
        this.twkDrawHighlight(this.getPage(), (WCRenderQueue)object);
        this.addLastRenderQueue((WCRenderQueue)object);
    }

    private void updateScroll(int n, int n2, int n3, int n4, int n5, int n6) {
        if (paintLog.isLoggable(Level.FINEST)) {
            paintLog.finest("rect=[" + n + ", " + n2 + " " + n3 + "x" + n4 + "] delta=[" + n5 + ", " + n6 + "]");
        }
        if (Math.abs(n5) < n3 && Math.abs(n6) < n4) {
            int n7 = n5 >= 0 ? n : n - n5;
            int n8 = n6 >= 0 ? n2 : n2 - n6;
            int n9 = n5 == 0 ? n3 : n3 - Math.abs(n5);
            int n10 = n6 == 0 ? n4 : n4 - Math.abs(n6);
            WCRenderQueue wCRenderQueue = new WCRenderQueue((WCRectangle)null);
            wCRenderQueue.addBuffer(ByteBuffer.allocate(32).putInt(40).putInt(this.backbuffer.getID()).putInt(n7).putInt(n8).putInt(n9).putInt(n10).putInt(n5).putInt(n6));
            if (!this.addLastRenderQueue(wCRenderQueue)) {
                return;
            }
            if (!this.dirtyRects.isEmpty()) {
                WCRectangle wCRectangle = new WCRectangle(n, n2, n3, n4);
                for (WCRectangle wCRectangle2 : this.dirtyRects) {
                    if (!wCRectangle.contains(wCRectangle2)) continue;
                    if (paintLog.isLoggable(Level.FINEST)) {
                        paintLog.log(Level.FINEST, "translating old dirty rect by the delta: " + wCRectangle2);
                    }
                    wCRectangle2.translate(n5, n6);
                }
            }
        }
        this.addDirtyRect(new WCRectangle(n5 >= 0 ? (float)n : (float)(n + n3 + n5 - 1), n6 >= 0 ? (float)n2 : (float)(n2 + n4 + n6 - 1), (n5 == 0 ? n3 : Math.abs(n5)) + 1, (n6 == 0 ? n4 : Math.abs(n6)) + 1));
    }

    public void setPageClient(WebPageClient webPageClient) {
        this.pageClient = webPageClient;
    }

    public WebPageClient getPageClient() {
        return this.pageClient;
    }

    public void setUIClient(UIClient uIClient) {
        this.uiClient = uIClient;
    }

    public void setPolicyClient(PolicyClient policyClient) {
        this.policyClient = policyClient;
    }

    public void setInputMethodClient(InputMethodClient inputMethodClient) {
        this.imClient = inputMethodClient;
    }

    public InputMethodClient getInputMethodClient() {
        return this.imClient;
    }

    public void setInputMethodState(boolean bl) {
        InputMethodClient inputMethodClient = this.getInputMethodClient();
        if (inputMethodClient != null) {
            inputMethodClient.activateInputMethods(bl);
        }
    }

    public void addLoadListenerClient(LoadListenerClient loadListenerClient) {
        if (!this.loadListenerClients.contains(loadListenerClient)) {
            this.loadListenerClients.add(loadListenerClient);
        }
    }

    public void removeLoadListenerClient(LoadListenerClient loadListenerClient) {
        this.loadListenerClients.remove(loadListenerClient);
    }

    public void setThemeClient(ThemeClient themeClient) {
        this.themeClient = themeClient;
        if (this.themeClient != null) {
            this.renderTheme = this.themeClient.createRenderTheme();
            this.scrollbarTheme = this.themeClient.createScrollBarTheme();
        }
    }

    public RenderTheme getRenderTheme() {
        return this.renderTheme;
    }

    private static RenderTheme getDefaultRenderTheme() {
        return ThemeClient.getDefaultRenderTheme();
    }

    public ScrollBarTheme getScrollBarTheme() {
        return this.scrollbarTheme;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBounds(int n, int n2, int n3, int n4) {
        WebPage.lockPage();
        try {
            log.log(Level.FINE, "setBounds: " + n + " " + n2 + " " + n3 + " " + n4);
            if (this.isDisposed) {
                log.log(Level.FINE, "setBounds() request for a disposed web page.");
                return;
            }
            this.width = n3;
            this.height = n4;
            this.twkSetBounds(this.getPage(), 0, 0, n3, n4);
            this.repaintAll();
        }
        finally {
            WebPage.unlockPage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOpaque(long l, boolean bl) {
        WebPage.lockPage();
        try {
            log.log(Level.FINE, "setOpaque: " + bl);
            if (this.isDisposed) {
                log.log(Level.FINE, "setOpaque() request for a disposed web page.");
                return;
            }
            if (!this.frames.contains(l)) {
                return;
            }
            this.twkSetTransparent(l, !bl);
        }
        finally {
            WebPage.unlockPage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBackgroundColor(long l, int n) {
        WebPage.lockPage();
        try {
            log.log(Level.FINE, "setBackgroundColor: " + n);
            if (this.isDisposed) {
                log.log(Level.FINE, "setBackgroundColor() request for a disposed web page.");
                return;
            }
            if (!this.frames.contains(l)) {
                return;
            }
            this.twkSetBackgroundColor(l, n);
        }
        finally {
            WebPage.unlockPage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBackgroundColor(int n) {
        WebPage.lockPage();
        try {
            log.log(Level.FINE, "setBackgroundColor: " + n + " for all frames");
            if (this.isDisposed) {
                log.log(Level.FINE, "setBackgroundColor() request for a disposed web page.");
                return;
            }
            for (long l : this.frames) {
                this.twkSetBackgroundColor(l, n);
            }
        }
        finally {
            WebPage.unlockPage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateContent(WCRectangle wCRectangle) {
        WebPage.lockPage();
        try {
            if (log.isLoggable(Level.FINEST)) {
                paintLog.finest("updateContent: " + wCRectangle.getIntX() + " " + wCRectangle.getIntY() + " " + wCRectangle.getIntWidth() + " " + wCRectangle.getIntHeight());
            }
            if (this.isDisposed) {
                paintLog.fine("updateContent() request for a disposed web page.");
                return;
            }
            while (!this.scrollRequests.isEmpty()) {
                ScrollRequest scrollRequest = this.scrollRequests.remove(0);
                this.updateScroll(scrollRequest.x, scrollRequest.y, scrollRequest.w, scrollRequest.h, scrollRequest.dx, scrollRequest.dy);
            }
            this.updateDirty(wCRectangle);
        }
        finally {
            WebPage.unlockPage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRepaintPending() {
        WebPage.lockPage();
        try {
            boolean bl = this.rqList.size() > 0;
            return bl;
        }
        finally {
            WebPage.unlockPage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(WCGraphicsContext wCGraphicsContext, WCRectangle wCRectangle) {
        block10: {
            WebPage.lockPage();
            try {
                if (this.pageClient != null && this.pageClient.isBackBufferSupported()) {
                    if (!this.backbuffer.validate(this.width, this.height)) {
                        Invoker.getInvoker().invokeOnEventThread(new Runnable(){

                            @Override
                            public void run() {
                                WebPage.this.repaintAll();
                            }
                        });
                        return;
                    }
                    WCGraphicsContext wCGraphicsContext2 = this.backbuffer.createGraphics();
                    try {
                        this.paint2GC(wCGraphicsContext2);
                    }
                    finally {
                        this.backbuffer.disposeGraphics(wCGraphicsContext2);
                    }
                    this.backbuffer.flush(wCGraphicsContext, wCRectangle.getIntX(), wCRectangle.getIntY(), wCRectangle.getIntWidth(), wCRectangle.getIntHeight());
                    break block10;
                }
                this.paint2GC(wCGraphicsContext);
            }
            finally {
                WebPage.unlockPage();
            }
        }
    }

    private void paint2GC(WCGraphicsContext wCGraphicsContext) {
        wCGraphicsContext.setFontSmoothingType(this.fontSmoothingType);
        WCRenderQueue wCRenderQueue = this.removeFirstRenderQueue();
        while (wCRenderQueue != null) {
            wCGraphicsContext.saveState();
            if (wCRenderQueue.getClip() != null) {
                wCGraphicsContext.setClip(wCRenderQueue.getClip());
            }
            wCRenderQueue.decode(wCGraphicsContext);
            wCGraphicsContext.restoreState();
            wCRenderQueue = this.removeFirstRenderQueue();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearRenderQueues() {
        WebPage.lockPage();
        try {
            WCRenderQueue wCRenderQueue = this.removeFirstRenderQueue();
            while (wCRenderQueue != null) {
                wCRenderQueue.dispose();
                wCRenderQueue = this.removeFirstRenderQueue();
            }
        }
        finally {
            WebPage.unlockPage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void print(long l, WCGraphicsContext wCGraphicsContext, WCRectangle wCRectangle) {
        WebPage.lockPage();
        try {
            log.log(Level.FINEST, "print: " + wCRectangle.getIntX() + " " + wCRectangle.getIntY() + " " + wCRectangle.getIntWidth() + " " + wCRectangle.getIntHeight());
            if (this.isDisposed) {
                log.log(Level.FINE, "print() request for a disposed web page.");
                return;
            }
            if (!this.frames.contains(l)) {
                return;
            }
            this.twkPrint(l, wCGraphicsContext, wCRectangle.getIntX(), wCRectangle.getIntY(), wCRectangle.getIntWidth(), wCRectangle.getIntHeight());
        }
        finally {
            WebPage.unlockPage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispatchFocusEvent(WCFocusEvent wCFocusEvent) {
        WebPage.lockPage();
        try {
            log.log(Level.FINEST, "dispatchFocusEvent: " + wCFocusEvent);
            if (this.isDisposed) {
                log.log(Level.FINE, "Focus event for a disposed web page.");
                return;
            }
            this.twkProcessFocusEvent(this.getPage(), wCFocusEvent.getID(), wCFocusEvent.getDirection());
        }
        finally {
            WebPage.unlockPage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean dispatchKeyEvent(WCKeyEvent wCKeyEvent) {
        WebPage.lockPage();
        try {
            log.log(Level.FINEST, "dispatchKeyEvent: " + wCKeyEvent);
            if (this.isDisposed) {
                log.log(Level.FINE, "Key event for a disposed web page.");
                boolean bl = false;
                return bl;
            }
            if (WCKeyEvent.filterEvent(wCKeyEvent)) {
                log.log(Level.FINEST, "filtered");
                boolean bl = false;
                return bl;
            }
            boolean bl = this.twkProcessKeyEvent(this.getPage(), wCKeyEvent.getType(), wCKeyEvent.getText(), wCKeyEvent.getKeyIdentifier(), wCKeyEvent.getWindowsVirtualKeyCode(), wCKeyEvent.isShiftDown(), wCKeyEvent.isCtrlDown(), wCKeyEvent.isAltDown(), wCKeyEvent.isMetaDown());
            return bl;
        }
        finally {
            WebPage.unlockPage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean dispatchMouseEvent(WCMouseEvent wCMouseEvent) {
        WebPage.lockPage();
        try {
            log.log(Level.FINEST, "dispatchMouseEvent: " + wCMouseEvent.getX() + "," + wCMouseEvent.getY());
            if (this.isDisposed) {
                log.log(Level.FINE, "Mouse event for a disposed web page.");
                boolean bl = false;
                return bl;
            }
            boolean bl = this.twkProcessMouseEvent(this.getPage(), wCMouseEvent.getID(), wCMouseEvent.getButton(), wCMouseEvent.getClickCount(), wCMouseEvent.getX(), wCMouseEvent.getY(), wCMouseEvent.getScreenX(), wCMouseEvent.getScreenY(), wCMouseEvent.isShiftDown(), wCMouseEvent.isControlDown(), wCMouseEvent.isAltDown(), wCMouseEvent.isMetaDown(), wCMouseEvent.isPopupTrigger(), (float)wCMouseEvent.getWhen() / 1000.0f);
            return bl;
        }
        finally {
            WebPage.unlockPage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean dispatchMouseWheelEvent(WCMouseWheelEvent wCMouseWheelEvent) {
        WebPage.lockPage();
        try {
            log.log(Level.FINEST, "dispatchMouseWheelEvent: " + wCMouseWheelEvent);
            if (this.isDisposed) {
                log.log(Level.FINE, "MouseWheel event for a disposed web page.");
                boolean bl = false;
                return bl;
            }
            boolean bl = this.twkProcessMouseWheelEvent(this.getPage(), wCMouseWheelEvent.getX(), wCMouseWheelEvent.getY(), wCMouseWheelEvent.getScreenX(), wCMouseWheelEvent.getScreenY(), wCMouseWheelEvent.getDeltaX(), wCMouseWheelEvent.getDeltaY(), wCMouseWheelEvent.isShiftDown(), wCMouseWheelEvent.isControlDown(), wCMouseWheelEvent.isAltDown(), wCMouseWheelEvent.isMetaDown(), (float)wCMouseWheelEvent.getWhen() / 1000.0f);
            return bl;
        }
        finally {
            WebPage.unlockPage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean dispatchTouchEvent(WCTouchEvent wCTouchEvent) {
        WebPage.lockPage();
        try {
            log.log(Level.FINEST, "dispatchTouchEvent");
            if (this.isDisposed) {
                log.log(Level.FINE, "Touch event for a disposed web page.");
                boolean bl = false;
                return bl;
            }
            boolean bl = this.twkProcessTouchEvent(this.getPage(), wCTouchEvent.getID(), wCTouchEvent.getTouchData(), wCTouchEvent.isShiftDown(), wCTouchEvent.isControlDown(), wCTouchEvent.isAltDown(), wCTouchEvent.isMetaDown(), (float)wCTouchEvent.getWhen() / 1000.0f);
            return bl;
        }
        finally {
            WebPage.unlockPage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean dispatchInputMethodEvent(WCInputMethodEvent wCInputMethodEvent) {
        WebPage.lockPage();
        try {
            log.log(Level.FINEST, "dispatchInputMethodEvent: " + wCInputMethodEvent);
            if (this.isDisposed) {
                log.log(Level.FINE, "InputMethod event for a disposed web page.");
                boolean bl = false;
                return bl;
            }
            switch (wCInputMethodEvent.getID()) {
                case 0: {
                    boolean bl = this.twkProcessInputTextChange(this.getPage(), wCInputMethodEvent.getComposed(), wCInputMethodEvent.getCommitted(), wCInputMethodEvent.getAttributes(), wCInputMethodEvent.getCaretPosition());
                    return bl;
                }
                case 1: {
                    boolean bl = this.twkProcessCaretPositionChange(this.getPage(), wCInputMethodEvent.getCaretPosition());
                    return bl;
                }
            }
            boolean bl = false;
            return bl;
        }
        finally {
            WebPage.unlockPage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int dispatchDragOperation(int n, String[] stringArray, String[] stringArray2, int n2, int n3, int n4, int n5, int n6) {
        WebPage.lockPage();
        try {
            log.log(Level.FINEST, "dispatchDragOperation: " + n2 + "," + n3 + " dndCommand:" + n + " dndAction" + n6);
            if (this.isDisposed) {
                log.log(Level.FINE, "DnD event for a disposed web page.");
                int n7 = 0;
                return n7;
            }
            int n8 = this.twkProcessDrag(this.getPage(), n, stringArray, stringArray2, n2, n3, n4, n5, n6);
            return n8;
        }
        finally {
            WebPage.unlockPage();
        }
    }

    public void confirmStartDrag() {
        if (this.uiClient != null) {
            this.uiClient.confirmStartDrag();
        }
    }

    public boolean isDragConfirmed() {
        return this.uiClient != null ? this.uiClient.isDragConfirmed() : false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] getClientTextLocation(int n) {
        WebPage.lockPage();
        try {
            if (this.isDisposed) {
                log.log(Level.FINE, "getClientTextLocation() request for a disposed web page.");
                int[] nArray = new int[]{0, 0, 0, 0};
                return nArray;
            }
            int[] nArray = this.twkGetTextLocation(this.getPage(), n);
            return nArray;
        }
        finally {
            WebPage.unlockPage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getClientLocationOffset(int n, int n2) {
        WebPage.lockPage();
        try {
            if (this.isDisposed) {
                log.log(Level.FINE, "getClientLocationOffset() request for a disposed web page.");
                int n3 = 0;
                return n3;
            }
            int n4 = this.twkGetInsertPositionOffset(this.getPage());
            return n4;
        }
        finally {
            WebPage.unlockPage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getClientInsertPositionOffset() {
        WebPage.lockPage();
        try {
            if (this.isDisposed) {
                log.log(Level.FINE, "getClientInsertPositionOffset() request for a disposed web page.");
                int n = 0;
                return n;
            }
            int n = this.twkGetInsertPositionOffset(this.getPage());
            return n;
        }
        finally {
            WebPage.unlockPage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getClientCommittedTextLength() {
        WebPage.lockPage();
        try {
            if (this.isDisposed) {
                log.log(Level.FINE, "getClientCommittedTextOffset() request for a disposed web page.");
                int n = 0;
                return n;
            }
            int n = this.twkGetCommittedTextLength(this.getPage());
            return n;
        }
        finally {
            WebPage.unlockPage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getClientCommittedText() {
        WebPage.lockPage();
        try {
            if (this.isDisposed) {
                log.log(Level.FINE, "getClientCommittedText() request for a disposed web page.");
                String string = "";
                return string;
            }
            String string = this.twkGetCommittedText(this.getPage());
            return string;
        }
        finally {
            WebPage.unlockPage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getClientSelectedText() {
        WebPage.lockPage();
        try {
            if (this.isDisposed) {
                log.log(Level.FINE, "getClientSelectedText() request for a disposed web page.");
                String string = "";
                return string;
            }
            String string = this.twkGetSelectedText(this.getPage());
            return string;
        }
        finally {
            WebPage.unlockPage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        WebPage.lockPage();
        try {
            log.log(Level.FINER, "dispose");
            this.stop();
            this.clearRenderQueues();
            this.isDisposed = true;
            this.twkDestroyPage(this.pPage);
            this.pPage = 0L;
            for (long l : this.frames) {
                log.log(Level.FINE, "Undestroyed frame view: " + l);
            }
            this.frames.clear();
            if (this.backbuffer != null) {
                this.backbuffer.deref();
                this.backbuffer = null;
            }
        }
        finally {
            WebPage.unlockPage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getName(long l) {
        WebPage.lockPage();
        try {
            log.log(Level.FINE, "Get Name: frame = " + l);
            if (this.isDisposed) {
                log.log(Level.FINE, "getName() request for a disposed web page.");
                String string = null;
                return string;
            }
            if (!this.frames.contains(l)) {
                String string = null;
                return string;
            }
            String string = this.twkGetName(l);
            return string;
        }
        finally {
            WebPage.unlockPage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getURL(long l) {
        WebPage.lockPage();
        try {
            log.log(Level.FINE, "Get URL: frame = " + l);
            if (this.isDisposed) {
                log.log(Level.FINE, "getURL() request for a disposed web page.");
                String string = null;
                return string;
            }
            if (!this.frames.contains(l)) {
                String string = null;
                return string;
            }
            String string = this.twkGetURL(l);
            return string;
        }
        finally {
            WebPage.unlockPage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getEncoding() {
        WebPage.lockPage();
        try {
            log.log(Level.FINE, "Get encoding");
            if (this.isDisposed) {
                log.log(Level.FINE, "getEncoding() request for a disposed web page.");
                String string = null;
                return string;
            }
            String string = this.twkGetEncoding(this.getPage());
            return string;
        }
        finally {
            WebPage.unlockPage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEncoding(String string) {
        WebPage.lockPage();
        try {
            log.log(Level.FINE, "Set encoding: encoding = " + string);
            if (this.isDisposed) {
                log.log(Level.FINE, "setEncoding() request for a disposed web page.");
                return;
            }
            if (string != null && !string.isEmpty()) {
                this.twkSetEncoding(this.getPage(), string);
            }
        }
        finally {
            WebPage.unlockPage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getInnerText(long l) {
        WebPage.lockPage();
        try {
            log.log(Level.FINE, "Get inner text: frame = " + l);
            if (this.isDisposed) {
                log.log(Level.FINE, "getInnerText() request for a disposed web page.");
                String string = null;
                return string;
            }
            if (!this.frames.contains(l)) {
                String string = null;
                return string;
            }
            String string = this.twkGetInnerText(l);
            return string;
        }
        finally {
            WebPage.unlockPage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getRenderTree(long l) {
        WebPage.lockPage();
        try {
            log.log(Level.FINE, "Get render tree: frame = " + l);
            if (this.isDisposed) {
                log.log(Level.FINE, "getRenderTree() request for a disposed web page.");
                String string = null;
                return string;
            }
            if (!this.frames.contains(l)) {
                String string = null;
                return string;
            }
            String string = this.twkGetRenderTree(l);
            return string;
        }
        finally {
            WebPage.unlockPage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getUnloadEventListenersCount(long l) {
        WebPage.lockPage();
        try {
            log.log(Level.FINE, "frame: " + l);
            if (this.isDisposed) {
                log.log(Level.FINE, "request for a disposed web page.");
                int n = 0;
                return n;
            }
            if (!this.frames.contains(l)) {
                int n = 0;
                return n;
            }
            int n = this.twkGetUnloadEventListenersCount(l);
            return n;
        }
        finally {
            WebPage.unlockPage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getContentType(long l) {
        WebPage.lockPage();
        try {
            log.log(Level.FINE, "Get content type: frame = " + l);
            if (this.isDisposed) {
                log.log(Level.FINE, "getContentType() request for a disposed web page.");
                String string = null;
                return string;
            }
            if (!this.frames.contains(l)) {
                String string = null;
                return string;
            }
            String string = this.twkGetContentType(l);
            return string;
        }
        finally {
            WebPage.unlockPage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getTitle(long l) {
        WebPage.lockPage();
        try {
            log.log(Level.FINE, "Get title: frame = " + l);
            if (this.isDisposed) {
                log.log(Level.FINE, "getTitle() request for a disposed web page.");
                String string = null;
                return string;
            }
            if (!this.frames.contains(l)) {
                String string = null;
                return string;
            }
            String string = this.twkGetTitle(l);
            return string;
        }
        finally {
            WebPage.unlockPage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WCImage getIcon(long l) {
        WebPage.lockPage();
        try {
            Utilities utilities;
            log.log(Level.FINE, "Get icon: frame = " + l);
            if (this.isDisposed) {
                log.log(Level.FINE, "getIcon() request for a disposed web page.");
                WCImage wCImage = null;
                return wCImage;
            }
            if (!this.frames.contains(l)) {
                WCImage wCImage = null;
                return wCImage;
            }
            String string = this.twkGetIconURL(l);
            if (string != null && !string.isEmpty() && (utilities = Utilities.getUtilities()) != null) {
                WCImage wCImage = utilities.getIconImage(string);
                return wCImage;
            }
            utilities = null;
            return utilities;
        }
        finally {
            WebPage.unlockPage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open(long l, String string) {
        WebPage.lockPage();
        try {
            log.log(Level.FINE, "Open URL: " + string);
            if (this.isDisposed) {
                log.log(Level.FINE, "open() request for a disposed web page.");
                return;
            }
            if (!this.frames.contains(l)) {
                return;
            }
            this.twkOpen(l, string);
        }
        finally {
            WebPage.unlockPage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(long l, String string, String string2) {
        WebPage.lockPage();
        try {
            log.log(Level.FINE, "Load text: " + string);
            if (string == null) {
                return;
            }
            if (this.isDisposed) {
                log.log(Level.FINE, "load() request for a disposed web page.");
                return;
            }
            if (!this.frames.contains(l)) {
                return;
            }
            this.twkLoad(l, string, string2);
        }
        finally {
            WebPage.unlockPage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(long l) {
        WebPage.lockPage();
        try {
            log.log(Level.FINE, "Stop loading: frame = " + l);
            if (this.isDisposed) {
                log.log(Level.FINE, "cancel() request for a disposed web page.");
                return;
            }
            if (!this.frames.contains(l)) {
                return;
            }
            String string = this.twkGetURL(l);
            String string2 = this.twkGetContentType(l);
            this.twkStop(l);
            this.fireLoadEvent(l, 6, string, string2, 1.0, 0);
        }
        finally {
            WebPage.unlockPage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        WebPage.lockPage();
        try {
            log.log(Level.FINE, "Stop loading sync");
            if (this.isDisposed) {
                log.log(Level.FINE, "stopAll() request for a disposed web page.");
                return;
            }
            this.twkStopAll(this.getPage());
        }
        finally {
            WebPage.unlockPage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh(long l) {
        WebPage.lockPage();
        try {
            log.log(Level.FINE, "Refresh: frame = " + l);
            if (this.isDisposed) {
                log.log(Level.FINE, "refresh() request for a disposed web page.");
                return;
            }
            if (!this.frames.contains(l)) {
                return;
            }
            this.twkRefresh(l);
        }
        finally {
            WebPage.unlockPage();
        }
    }

    public BackForwardList createBackForwardList() {
        return new BackForwardList(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean goBack() {
        WebPage.lockPage();
        try {
            log.log(Level.FINE, "Go back");
            if (this.isDisposed) {
                log.log(Level.FINE, "goBack() request for a disposed web page.");
                boolean bl = false;
                return bl;
            }
            boolean bl = this.twkGoBackForward(this.getPage(), -1);
            return bl;
        }
        finally {
            WebPage.unlockPage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean goForward() {
        WebPage.lockPage();
        try {
            log.log(Level.FINE, "Go forward");
            if (this.isDisposed) {
                log.log(Level.FINE, "goForward() request for a disposed web page.");
                boolean bl = false;
                return bl;
            }
            boolean bl = this.twkGoBackForward(this.getPage(), 1);
            return bl;
        }
        finally {
            WebPage.unlockPage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean copy() {
        WebPage.lockPage();
        try {
            log.log(Level.FINE, "Copy");
            if (this.isDisposed) {
                log.log(Level.FINE, "copy() request for a disposed web page.");
                boolean bl = false;
                return bl;
            }
            long l = this.getMainFrame();
            if (!this.frames.contains(l)) {
                boolean bl = false;
                return bl;
            }
            boolean bl = this.twkCopy(l);
            return bl;
        }
        finally {
            WebPage.unlockPage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean find(String string, boolean bl, boolean bl2, boolean bl3) {
        WebPage.lockPage();
        try {
            log.log(Level.FINE, "Find in page: stringToFind = " + string + ", " + (bl ? "forward" : "backward") + (bl2 ? ", wrap" : "") + (bl3 ? ", matchCase" : ""));
            if (this.isDisposed) {
                log.log(Level.FINE, "find() request for a disposed web page.");
                boolean bl4 = false;
                return bl4;
            }
            boolean bl5 = this.twkFindInPage(this.getPage(), string, bl, bl2, bl3);
            return bl5;
        }
        finally {
            WebPage.unlockPage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean find(long l, String string, boolean bl, boolean bl2, boolean bl3) {
        WebPage.lockPage();
        try {
            log.log(Level.FINE, "Find in frame: stringToFind = " + string + ", " + (bl ? "forward" : "backward") + (bl2 ? ", wrap" : "") + (bl3 ? ", matchCase" : ""));
            if (this.isDisposed) {
                log.log(Level.FINE, "find() request for a disposed web page.");
                boolean bl4 = false;
                return bl4;
            }
            if (!this.frames.contains(l)) {
                boolean bl5 = false;
                return bl5;
            }
            boolean bl6 = this.twkFindInFrame(l, string, bl, bl2, bl3);
            return bl6;
        }
        finally {
            WebPage.unlockPage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float getZoomFactor(boolean bl) {
        WebPage.lockPage();
        try {
            log.log(Level.FINE, "Get zoom factor, textOnly=" + bl);
            if (this.isDisposed) {
                log.log(Level.FINE, "getZoomFactor() request for a disposed web page.");
                float f = 1.0f;
                return f;
            }
            long l = this.getMainFrame();
            if (!this.frames.contains(l)) {
                float f = 1.0f;
                return f;
            }
            float f = this.twkGetZoomFactor(l, bl);
            return f;
        }
        finally {
            WebPage.unlockPage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setZoomFactor(float f, boolean bl) {
        WebPage.lockPage();
        try {
            log.fine(String.format("Set zoom factor %.2f, textOnly=%b", Float.valueOf(f), bl));
            if (this.isDisposed) {
                log.log(Level.FINE, "setZoomFactor() request for a disposed web page.");
                return;
            }
            long l = this.getMainFrame();
            if (l == 0L || !this.frames.contains(l)) {
                return;
            }
            this.twkSetZoomFactor(l, f, bl);
        }
        finally {
            WebPage.unlockPage();
        }
    }

    public void setFontSmoothingType(int n) {
        this.fontSmoothingType = n;
        this.repaintAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset(long l) {
        WebPage.lockPage();
        try {
            log.log(Level.FINE, "Reset: frame = " + l);
            if (this.isDisposed) {
                log.log(Level.FINE, "reset() request for a disposed web page.");
                return;
            }
            if (l == 0L || !this.frames.contains(l)) {
                return;
            }
            this.twkReset(l);
        }
        finally {
            WebPage.unlockPage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object executeScript(long l, String string) throws JSException {
        WebPage.lockPage();
        try {
            log.log(Level.FINE, "execute script: \"" + string + "\" in frame = " + l);
            if (this.isDisposed) {
                log.log(Level.FINE, "executeScript() request for a disposed web page.");
                Object var4_3 = null;
                return var4_3;
            }
            if (l == 0L || !this.frames.contains(l)) {
                Object var4_4 = null;
                return var4_4;
            }
            Object object = this.twkExecuteScript(l, string);
            return object;
        }
        finally {
            WebPage.unlockPage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addJavaScriptBinding(long l, String string, Object object) {
        WebPage.lockPage();
        try {
            log.log(Level.FINE, "addJavaScriptBinding for " + string + ": frame = " + l);
            if (this.isDisposed) {
                log.log(Level.FINE, "addJavaScriptBinding() request for a disposed web page.");
                return;
            }
            if (l == 0L || !this.frames.contains(l)) {
                return;
            }
            this.twkAddJavaScriptBinding(l, string, object);
        }
        finally {
            WebPage.unlockPage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getMainFrame() {
        WebPage.lockPage();
        try {
            log.log(Level.FINER, "getMainFrame: page = " + this.pPage);
            if (this.isDisposed) {
                log.log(Level.FINE, "getMainFrame() request for a disposed web page.");
                long l = 0L;
                return l;
            }
            long l = this.twkGetMainFrame(this.getPage());
            log.log(Level.FINER, "Main frame = " + l);
            this.frames.add(l);
            long l2 = l;
            return l2;
        }
        finally {
            WebPage.unlockPage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getParentFrame(long l) {
        WebPage.lockPage();
        try {
            log.log(Level.FINE, "getParentFrame: child = " + l);
            if (this.isDisposed) {
                log.log(Level.FINE, "getParentFrame() request for a disposed web page.");
                long l2 = 0L;
                return l2;
            }
            if (!this.frames.contains(l)) {
                long l3 = 0L;
                return l3;
            }
            long l4 = this.twkGetParentFrame(l);
            return l4;
        }
        finally {
            WebPage.unlockPage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Long> getChildFrames(long l) {
        WebPage.lockPage();
        try {
            log.log(Level.FINE, "getChildFrames: parent = " + l);
            if (this.isDisposed) {
                log.log(Level.FINE, "getChildFrames() request for a disposed web page.");
                List<Long> list = null;
                return list;
            }
            if (!this.frames.contains(l)) {
                List<Long> list = null;
                return list;
            }
            long[] lArray = this.twkGetChildFrames(l);
            LinkedList<Long> linkedList = new LinkedList<Long>();
            for (long l2 : lArray) {
                linkedList.add(l2);
            }
            LinkedList<Long> linkedList2 = linkedList;
            return linkedList2;
        }
        finally {
            WebPage.unlockPage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WCRectangle getVisibleRect(long l) {
        WebPage.lockPage();
        try {
            if (!this.frames.contains(l)) {
                WCRectangle wCRectangle = null;
                return wCRectangle;
            }
            int[] nArray = this.twkGetVisibleRect(l);
            if (nArray != null) {
                WCRectangle wCRectangle = new WCRectangle(nArray[0], nArray[1], nArray[2], nArray[3]);
                return wCRectangle;
            }
            WCRectangle wCRectangle = null;
            return wCRectangle;
        }
        finally {
            WebPage.unlockPage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scrollToPosition(long l, WCPoint wCPoint) {
        WebPage.lockPage();
        try {
            if (!this.frames.contains(l)) {
                return;
            }
            this.twkScrollToPosition(l, wCPoint.getIntX(), wCPoint.getIntY());
        }
        finally {
            WebPage.unlockPage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WCSize getContentSize(long l) {
        WebPage.lockPage();
        try {
            if (!this.frames.contains(l)) {
                WCSize wCSize = null;
                return wCSize;
            }
            int[] nArray = this.twkGetContentSize(l);
            if (nArray != null) {
                WCSize wCSize = new WCSize(nArray[0], nArray[1]);
                return wCSize;
            }
            WCSize wCSize = null;
            return wCSize;
        }
        finally {
            WebPage.unlockPage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Document getDocument(long l) {
        WebPage.lockPage();
        try {
            log.log(Level.FINE, "getDocument");
            if (this.isDisposed) {
                log.log(Level.FINE, "getDocument() request for a disposed web page.");
                Document document = null;
                return document;
            }
            if (!this.frames.contains(l)) {
                Document document = null;
                return document;
            }
            Document document = WebPage.twkGetDocument(l);
            return document;
        }
        finally {
            WebPage.unlockPage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Element getOwnerElement(long l) {
        WebPage.lockPage();
        try {
            log.log(Level.FINE, "getOwnerElement");
            if (this.isDisposed) {
                log.log(Level.FINE, "getOwnerElement() request for a disposed web page.");
                Element element = null;
                return element;
            }
            if (!this.frames.contains(l)) {
                Element element = null;
                return element;
            }
            Element element = WebPage.twkGetOwnerElement(l);
            return element;
        }
        finally {
            WebPage.unlockPage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean executeCommand(String string, String string2) {
        WebPage.lockPage();
        try {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "command: [{0}], value: [{1}]", new Object[]{string, string2});
            }
            if (this.isDisposed) {
                log.log(Level.FINE, "Web page is already disposed");
                boolean bl = false;
                return bl;
            }
            boolean bl = this.twkExecuteCommand(this.getPage(), string, string2);
            log.log(Level.FINE, "result: [{0}]", bl);
            boolean bl2 = bl;
            return bl2;
        }
        finally {
            WebPage.unlockPage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean queryCommandEnabled(String string) {
        WebPage.lockPage();
        try {
            log.log(Level.FINE, "command: [{0}]", string);
            if (this.isDisposed) {
                log.log(Level.FINE, "Web page is already disposed");
                boolean bl = false;
                return bl;
            }
            boolean bl = this.twkQueryCommandEnabled(this.getPage(), string);
            log.log(Level.FINE, "result: [{0}]", bl);
            boolean bl2 = bl;
            return bl2;
        }
        finally {
            WebPage.unlockPage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean queryCommandState(String string) {
        WebPage.lockPage();
        try {
            log.log(Level.FINE, "command: [{0}]", string);
            if (this.isDisposed) {
                log.log(Level.FINE, "Web page is already disposed");
                boolean bl = false;
                return bl;
            }
            boolean bl = this.twkQueryCommandState(this.getPage(), string);
            log.log(Level.FINE, "result: [{0}]", bl);
            boolean bl2 = bl;
            return bl2;
        }
        finally {
            WebPage.unlockPage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String queryCommandValue(String string) {
        WebPage.lockPage();
        try {
            log.log(Level.FINE, "command: [{0}]", string);
            if (this.isDisposed) {
                log.log(Level.FINE, "Web page is already disposed");
                String string2 = null;
                return string2;
            }
            String string3 = this.twkQueryCommandValue(this.getPage(), string);
            log.log(Level.FINE, "result: [{0}]", string3);
            String string4 = string3;
            return string4;
        }
        finally {
            WebPage.unlockPage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEditable() {
        WebPage.lockPage();
        try {
            log.log(Level.FINE, "isEditable");
            if (this.isDisposed) {
                log.log(Level.FINE, "isEditable() request for a disposed web page.");
                boolean bl = false;
                return bl;
            }
            boolean bl = this.twkIsEditable(this.getPage());
            return bl;
        }
        finally {
            WebPage.unlockPage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEditable(boolean bl) {
        WebPage.lockPage();
        try {
            log.log(Level.FINE, "setEditable");
            if (this.isDisposed) {
                log.log(Level.FINE, "setEditable() request for a disposed web page.");
                return;
            }
            this.twkSetEditable(this.getPage(), bl);
        }
        finally {
            WebPage.unlockPage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getHtml(long l) {
        WebPage.lockPage();
        try {
            log.log(Level.FINE, "getHtml");
            if (this.isDisposed) {
                log.log(Level.FINE, "getHtml() request for a disposed web page.");
                String string = null;
                return string;
            }
            String string = this.twkGetHtml(l);
            return string;
        }
        finally {
            WebPage.unlockPage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int startPrinting(long l, float f, boolean bl) {
        WebPage.lockPage();
        try {
            log.log(Level.FINE, "Start printing: width=" + f + ", scale=" + bl);
            if (this.isDisposed) {
                log.log(Level.FINE, "startPrinting() request for a disposed web page.");
                int n = 0;
                return n;
            }
            if (!this.frames.contains(l)) {
                int n = 0;
                return n;
            }
            int n = this.twkStartPrinting(l, f, bl);
            log.log(Level.FINE, "Preferred width = " + n);
            int n2 = n;
            return n2;
        }
        finally {
            WebPage.unlockPage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endPrinting(long l) {
        WebPage.lockPage();
        try {
            log.log(Level.FINE, "End printing");
            if (this.isDisposed) {
                log.log(Level.FINE, "endPrinting() request for a disposed web page.");
                return;
            }
            if (!this.frames.contains(l)) {
                return;
            }
            this.twkEndPrinting(l);
        }
        finally {
            WebPage.unlockPage();
        }
    }

    public int getPageHeight() {
        return this.getFrameHeight(this.getMainFrame());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getFrameHeight(long l) {
        WebPage.lockPage();
        try {
            log.log(Level.FINE, "Get page height");
            if (this.isDisposed) {
                log.log(Level.FINE, "getFrameHeight() request for a disposed web page.");
                int n = 0;
                return n;
            }
            if (!this.frames.contains(l)) {
                int n = 0;
                return n;
            }
            int n = this.twkGetFrameHeight(l);
            log.log(Level.FINE, "Height = " + n);
            int n2 = n;
            return n2;
        }
        finally {
            WebPage.unlockPage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float adjustFrameHeight(long l, float f, float f2, float f3) {
        WebPage.lockPage();
        try {
            log.log(Level.FINE, "Adjust page height");
            if (this.isDisposed) {
                log.log(Level.FINE, "adjustFrameHeight() request for a disposed web page.");
                float f4 = 0.0f;
                return f4;
            }
            if (!this.frames.contains(l)) {
                float f5 = 0.0f;
                return f5;
            }
            float f6 = this.twkAdjustFrameHeight(l, f, f2, f3);
            return f6;
        }
        finally {
            WebPage.unlockPage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getUsePageCache() {
        WebPage.lockPage();
        try {
            boolean bl = this.twkGetUsePageCache(this.getPage());
            return bl;
        }
        finally {
            WebPage.unlockPage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUsePageCache(boolean bl) {
        WebPage.lockPage();
        try {
            this.twkSetUsePageCache(this.getPage(), bl);
        }
        finally {
            WebPage.unlockPage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getDeveloperExtrasEnabled() {
        WebPage.lockPage();
        try {
            boolean bl = this.twkGetDeveloperExtrasEnabled(this.getPage());
            log.log(Level.FINE, "Getting developerExtrasEnabled, result: [{0}]", bl);
            boolean bl2 = bl;
            return bl2;
        }
        finally {
            WebPage.unlockPage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDeveloperExtrasEnabled(boolean bl) {
        WebPage.lockPage();
        try {
            log.log(Level.FINE, "Setting developerExtrasEnabled, value: [{0}]", bl);
            this.twkSetDeveloperExtrasEnabled(this.getPage(), bl);
        }
        finally {
            WebPage.unlockPage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isJavaScriptEnabled() {
        WebPage.lockPage();
        try {
            boolean bl = this.twkIsJavaScriptEnabled(this.getPage());
            return bl;
        }
        finally {
            WebPage.unlockPage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setJavaScriptEnabled(boolean bl) {
        WebPage.lockPage();
        try {
            this.twkSetJavaScriptEnabled(this.getPage(), bl);
        }
        finally {
            WebPage.unlockPage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isContextMenuEnabled() {
        WebPage.lockPage();
        try {
            boolean bl = this.twkIsContextMenuEnabled(this.getPage());
            return bl;
        }
        finally {
            WebPage.unlockPage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setContextMenuEnabled(boolean bl) {
        WebPage.lockPage();
        try {
            this.twkSetContextMenuEnabled(this.getPage(), bl);
        }
        finally {
            WebPage.unlockPage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUserStyleSheetLocation(String string) {
        WebPage.lockPage();
        try {
            this.twkSetUserStyleSheetLocation(this.getPage(), string);
        }
        finally {
            WebPage.unlockPage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connectInspectorFrontend() {
        WebPage.lockPage();
        try {
            log.log(Level.FINE, "Connecting inspector frontend");
            this.twkConnectInspectorFrontend(this.getPage());
        }
        finally {
            WebPage.unlockPage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnectInspectorFrontend() {
        WebPage.lockPage();
        try {
            log.log(Level.FINE, "Disconnecting inspector frontend");
            this.twkDisconnectInspectorFrontend(this.getPage());
        }
        finally {
            WebPage.unlockPage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispatchInspectorMessageFromFrontend(String string) {
        WebPage.lockPage();
        try {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "Dispatching inspector message from frontend, message: [{0}]", string);
            }
            this.twkDispatchInspectorMessageFromFrontend(this.getPage(), string);
        }
        finally {
            WebPage.unlockPage();
        }
    }

    public InspectorClient getInspectorClient() {
        return this.inspectorClient;
    }

    public void setInspectorClient(InspectorClient inspectorClient) {
        this.inspectorClient = inspectorClient;
    }

    private void fwkFrameCreated(long l) {
        log.log(Level.FINE, "Frame created: frame = " + l);
        if (this.frames.contains(l)) {
            log.log(Level.FINE, "Error in fwkFrameCreated: frame is already in frames");
            return;
        }
        this.frames.add(l);
    }

    private void fwkFrameDestroyed(long l) {
        log.log(Level.FINE, "Frame destroyed: frame = " + l);
        if (!this.frames.contains(l)) {
            log.log(Level.FINE, "Error in fwkFrameDestroyed: frame is not found in frames");
            return;
        }
        this.frames.remove(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fwkRepaint(int n, int n2, int n3, int n4, boolean bl, boolean bl2) {
        WebPage.lockPage();
        try {
            if (log.isLoggable(Level.FINEST)) {
                paintLog.finest("fwkRepaint: " + n + " " + n2 + " " + n3 + " " + n4);
            }
            if (this.pageClient != null) {
                this.addDirtyRect(new WCRectangle(n, n2, n3, n4));
                this.pageClient.repaint(n, n2, n3, n4, bl, bl2);
            }
        }
        finally {
            WebPage.unlockPage();
        }
    }

    private void fwkScroll(int n, int n2, int n3, int n4, int n5, int n6) {
        if (log.isLoggable(Level.FINEST)) {
            paintLog.finest("Scroll: " + n + " " + n2 + " " + n3 + " " + n4 + "  " + n5 + " " + n6);
        }
        if (this.pageClient == null || !this.pageClient.isBackBufferSupported()) {
            paintLog.finest("blit scrolling is switched off");
            return;
        }
        this.scrollRequests.add(new ScrollRequest(n, n2, n3, n4, n5, n6));
        this.pageClient.repaint(n, n2, n3, n4, true, true);
    }

    private void fwkTransferFocus(boolean bl) {
        log.log(Level.FINER, "Transfer focus " + (bl ? "forward" : "backward"));
        if (this.pageClient != null) {
            this.pageClient.transferFocus(bl);
        }
    }

    private void fwkSetCursor(long l) {
        log.log(Level.FINER, "Set cursor: " + l);
        if (this.pageClient != null) {
            this.pageClient.setCursor(l);
        }
    }

    private void fwkSetFocus(boolean bl) {
        log.log(Level.FINER, "Set focus: " + (bl ? "true" : "false"));
        if (this.pageClient != null) {
            this.pageClient.setFocus(bl);
        }
    }

    private void fwkSetTooltip(String string) {
        log.log(Level.FINER, "Set tooltip: " + string);
        if (this.pageClient != null) {
            this.pageClient.setTooltip(string);
        }
    }

    private void fwkPrint() {
        log.log(Level.FINER, "Print");
        if (this.uiClient != null) {
            this.uiClient.print();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fwkSetRequestURL(long l, int n, String string) {
        log.log(Level.FINER, "Set request URL: id = " + n + ", url = " + string);
        Map<Integer, String> map = this.requestURLs;
        synchronized (map) {
            this.requestURLs.put(n, string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fwkRemoveRequestURL(long l, int n) {
        log.log(Level.FINER, "Set request URL: id = " + n);
        Map<Integer, String> map = this.requestURLs;
        synchronized (map) {
            this.requestURLs.remove(n);
            this.requestStarted.remove(n);
        }
    }

    private WebPage fwkCreateWindow(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        log.log(Level.FINER, "Create window");
        if (this.uiClient != null) {
            return this.uiClient.createPage(bl, bl2, bl3, bl4);
        }
        return null;
    }

    private void fwkShowWindow() {
        log.log(Level.FINER, "Show window");
        if (this.uiClient != null) {
            this.uiClient.showView();
        }
    }

    private void fwkCloseWindow() {
        log.log(Level.FINER, "Close window");
        if (this.permitCloseWindowAction() && this.uiClient != null) {
            this.uiClient.closePage();
        }
    }

    private WCRectangle fwkGetWindowBounds() {
        WCRectangle wCRectangle;
        log.log(Level.FINE, "Get window bounds");
        if (this.uiClient != null && (wCRectangle = this.uiClient.getViewBounds()) != null) {
            return wCRectangle;
        }
        return this.fwkGetPageBounds();
    }

    private void fwkSetWindowBounds(int n, int n2, int n3, int n4) {
        log.log(Level.FINER, "Set window bounds: " + n + " " + n2 + " " + n3 + " " + n4);
        if (this.uiClient != null) {
            this.uiClient.setViewBounds(new WCRectangle(n, n2, n3, n4));
        }
    }

    private WCRectangle fwkGetPageBounds() {
        log.log(Level.FINER, "Get page bounds");
        return new WCRectangle(0.0f, 0.0f, this.width, this.height);
    }

    private void fwkSetScrollbarsVisible(boolean bl) {
    }

    private void fwkSetStatusbarText(String string) {
        log.log(Level.FINER, "Set statusbar text: " + string);
        if (this.uiClient != null) {
            this.uiClient.setStatusbarText(string);
        }
    }

    private String fwkChooseFile(String string) {
        log.log(Level.FINER, "Choose file, initial=" + string);
        return this.uiClient != null ? this.uiClient.chooseFile(string) : null;
    }

    private void fwkStartDrag(WCImage wCImage, int n, int n2, int n3, int n4, String[] stringArray, Object[] objectArray) {
        log.log(Level.FINER, "Start drag: ");
        if (this.uiClient != null) {
            this.uiClient.startDrag(wCImage, n, n2, n3, n4, stringArray, objectArray);
        }
    }

    private WCPoint fwkScreenToWindow(WCPoint wCPoint) {
        log.log(Level.FINER, "fwkScreenToWindow");
        if (this.pageClient != null) {
            return this.pageClient.screenToWindow(wCPoint);
        }
        return wCPoint;
    }

    private WCPoint fwkWindowToScreen(WCPoint wCPoint) {
        log.log(Level.FINER, "fwkWindowToScreen");
        if (this.pageClient != null) {
            return this.pageClient.windowToScreen(wCPoint);
        }
        return wCPoint;
    }

    private void fwkAlert(String string) {
        log.log(Level.FINE, "JavaScript alert(): text = " + string);
        if (this.uiClient != null) {
            this.uiClient.alert(string);
        }
    }

    private boolean fwkConfirm(String string) {
        log.log(Level.FINE, "JavaScript confirm(): text = " + string);
        if (this.uiClient != null) {
            return this.uiClient.confirm(string);
        }
        return false;
    }

    private String fwkPrompt(String string, String string2) {
        log.log(Level.FINE, "JavaScript prompt(): text = " + string + ", default = " + string2);
        if (this.uiClient != null) {
            return this.uiClient.prompt(string, string2);
        }
        return null;
    }

    private void fwkAddMessageToConsole(String string, int n, String string2) {
        log.log(Level.FINE, "fwkAddMessageToConsole(): message = " + string + ", lineNumber = " + n + ", sourceId = " + string2);
        this.addMessageToConsole(string, n, string2);
    }

    protected void addMessageToConsole(String string, int n, String string2) {
    }

    private void fwkFireLoadEvent(long l, int n, String string, String string2, double d, int n2) {
        log.log(Level.FINER, "Load event: pFrame = " + l + ", state = " + n + ", url = " + string + ", contenttype=" + string2 + ", progress = " + d + ", error = " + n2);
        this.fireLoadEvent(l, n, string, string2, d, n2);
    }

    private void fwkFireResourceLoadEvent(long l, int n, int n2, String string, double d, int n3) {
        log.log(Level.FINER, "Resource load event: pFrame = " + l + ", state = " + n + ", id = " + n2 + ", contenttype=" + string + ", progress = " + d + ", error = " + n3);
        String string2 = this.requestURLs.get(n2);
        if (string2 == null) {
            log.log(Level.FINE, "Error in fwkFireResourceLoadEvent: unknown request id " + n2);
            return;
        }
        int n4 = n;
        if (n == 20) {
            if (this.requestStarted.contains(n2)) {
                n4 = 21;
            } else {
                this.requestStarted.add(n2);
            }
        }
        this.fireResourceLoadEvent(l, n4, string2, string, d, n3);
    }

    private boolean fwkPermitNavigateAction(long l, String string) {
        log.log(Level.FINE, "Policy: permit NAVIGATE: pFrame = " + l + ", url = " + string);
        if (this.policyClient != null) {
            return this.policyClient.permitNavigateAction(l, this.str2url(string));
        }
        return true;
    }

    private boolean fwkPermitRedirectAction(long l, String string) {
        log.log(Level.FINE, "Policy: permit REDIRECT: pFrame = " + l + ", url = " + string);
        if (this.policyClient != null) {
            return this.policyClient.permitRedirectAction(l, this.str2url(string));
        }
        return true;
    }

    private boolean fwkPermitAcceptResourceAction(long l, String string) {
        log.log(Level.FINE, "Policy: permit ACCEPT_RESOURCE: pFrame + " + l + ", url = " + string);
        if (this.policyClient != null) {
            return this.policyClient.permitAcceptResourceAction(l, this.str2url(string));
        }
        return true;
    }

    private boolean fwkPermitSubmitDataAction(long l, String string, String string2, boolean bl) {
        log.log(Level.FINE, "Policy: permit " + (bl ? "" : "RE") + "SUBMIT_DATA: pFrame = " + l + ", url = " + string + ", httpMethod = " + string2);
        if (this.policyClient != null) {
            if (bl) {
                return this.policyClient.permitSubmitDataAction(l, this.str2url(string), string2);
            }
            return this.policyClient.permitResubmitDataAction(l, this.str2url(string), string2);
        }
        return true;
    }

    private boolean fwkPermitEnableScriptsAction(long l, String string) {
        log.log(Level.FINE, "Policy: permit ENABLE_SCRIPTS: pFrame + " + l + ", url = " + string);
        if (this.policyClient != null) {
            return this.policyClient.permitEnableScriptsAction(l, this.str2url(string));
        }
        return true;
    }

    private boolean fwkPermitNewWindowAction(long l, String string) {
        log.log(Level.FINE, "Policy: permit NEW_PAGE: pFrame = " + l + ", url = " + string);
        if (this.policyClient != null) {
            return this.policyClient.permitNewPageAction(l, this.str2url(string));
        }
        return true;
    }

    private boolean permitCloseWindowAction() {
        log.log(Level.FINE, "Policy: permit CLOSE_PAGE");
        if (this.policyClient != null) {
            return this.policyClient.permitClosePageAction(this.getMainFrame());
        }
        return true;
    }

    private void fwkRepaintAll() {
        log.log(Level.FINE, "Repainting the entire page");
        this.repaintAll();
    }

    private boolean fwkSendInspectorMessageToFrontend(String string) {
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Sending inspector message to frontend, message: [{0}]", string);
        }
        boolean bl = false;
        if (this.inspectorClient != null) {
            log.log(Level.FINE, "Invoking inspector client");
            bl = this.inspectorClient.sendMessageToFrontend(string);
        }
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Result: [{0}]", bl);
        }
        return bl;
    }

    private void fwkDidClearWindowObject(long l, long l2) {
        this.didClearWindowObject(l, l2);
    }

    protected void didClearWindowObject(long l, long l2) {
    }

    private URL str2url(String string) {
        try {
            return URLs.newURL(string);
        }
        catch (MalformedURLException malformedURLException) {
            log.log(Level.FINE, "Exception while converting \"" + string + "\" to URL", malformedURLException);
            return null;
        }
    }

    private void fireLoadEvent(long l, int n, String string, String string2, double d, int n2) {
        for (LoadListenerClient loadListenerClient : this.loadListenerClients) {
            loadListenerClient.dispatchLoadEvent(l, n, string, string2, d, n2);
        }
    }

    private void fireResourceLoadEvent(long l, int n, String string, String string2, double d, int n2) {
        for (LoadListenerClient loadListenerClient : this.loadListenerClients) {
            loadListenerClient.dispatchResourceLoadEvent(l, n, string, string2, d, n2);
        }
    }

    private void repaintAll() {
        if (this.pageClient != null) {
            this.markDirty();
            this.pageClient.repaint(0, 0, this.width, this.height, true, false);
        }
    }

    private native long twkCreatePage(boolean var1);

    private native void twkInit(long var1, boolean var3);

    private native void twkDestroyPage(long var1);

    private native long twkGetMainFrame(long var1);

    private native long twkGetParentFrame(long var1);

    private native long[] twkGetChildFrames(long var1);

    private native String twkGetName(long var1);

    private native String twkGetURL(long var1);

    private native String twkGetInnerText(long var1);

    private native String twkGetRenderTree(long var1);

    private native String twkGetContentType(long var1);

    private native String twkGetTitle(long var1);

    private native String twkGetIconURL(long var1);

    private static native Document twkGetDocument(long var0);

    private static native Element twkGetOwnerElement(long var0);

    private native void twkOpen(long var1, String var3);

    private native void twkLoad(long var1, String var3, String var4);

    private native void twkStop(long var1);

    private native void twkStopAll(long var1);

    private native void twkRefresh(long var1);

    private native boolean twkGoBackForward(long var1, int var3);

    private native boolean twkCopy(long var1);

    private native boolean twkFindInPage(long var1, String var3, boolean var4, boolean var5, boolean var6);

    private native boolean twkFindInFrame(long var1, String var3, boolean var4, boolean var5, boolean var6);

    private native float twkGetZoomFactor(long var1, boolean var3);

    private native void twkSetZoomFactor(long var1, float var3, boolean var4);

    private native Object twkExecuteScript(long var1, String var3);

    private native void twkAddJavaScriptBinding(long var1, String var3, Object var4);

    private native void twkReset(long var1);

    private native int twkGetFrameHeight(long var1);

    private native int twkStartPrinting(long var1, float var3, boolean var4);

    private native void twkEndPrinting(long var1);

    private native float twkAdjustFrameHeight(long var1, float var3, float var4, float var5);

    private native int[] twkGetVisibleRect(long var1);

    private native void twkScrollToPosition(long var1, int var3, int var4);

    private native int[] twkGetContentSize(long var1);

    private native void twkSetTransparent(long var1, boolean var3);

    private native void twkSetBackgroundColor(long var1, int var3);

    private native void twkSetBounds(long var1, int var3, int var4, int var5, int var6);

    private native void twkPrint(long var1, WCGraphicsContext var3, int var4, int var5, int var6, int var7);

    private native void twkUpdateContent(long var1, WCRenderQueue var3, int var4, int var5, int var6, int var7);

    private native void twkDrawHighlight(long var1, WCRenderQueue var3);

    private native String twkGetEncoding(long var1);

    private native void twkSetEncoding(long var1, String var3);

    private native void twkProcessFocusEvent(long var1, int var3, int var4);

    private native boolean twkProcessKeyEvent(long var1, int var3, String var4, String var5, int var6, boolean var7, boolean var8, boolean var9, boolean var10);

    private native boolean twkProcessMouseEvent(long var1, int var3, int var4, int var5, int var6, int var7, int var8, int var9, boolean var10, boolean var11, boolean var12, boolean var13, boolean var14, float var15);

    private native boolean twkProcessMouseWheelEvent(long var1, int var3, int var4, int var5, int var6, float var7, float var8, boolean var9, boolean var10, boolean var11, boolean var12, float var13);

    private native boolean twkProcessTouchEvent(long var1, int var3, ByteBuffer var4, boolean var5, boolean var6, boolean var7, boolean var8, float var9);

    private native boolean twkProcessInputTextChange(long var1, String var3, String var4, int[] var5, int var6);

    private native boolean twkProcessCaretPositionChange(long var1, int var3);

    private native int[] twkGetTextLocation(long var1, int var3);

    private native int twkGetInsertPositionOffset(long var1);

    private native int twkGetCommittedTextLength(long var1);

    private native String twkGetCommittedText(long var1);

    private native String twkGetSelectedText(long var1);

    private native int twkProcessDrag(long var1, int var3, String[] var4, String[] var5, int var6, int var7, int var8, int var9, int var10);

    private native boolean twkExecuteCommand(long var1, String var3, String var4);

    private native boolean twkQueryCommandEnabled(long var1, String var3);

    private native boolean twkQueryCommandState(long var1, String var3);

    private native String twkQueryCommandValue(long var1, String var3);

    private native boolean twkIsEditable(long var1);

    private native void twkSetEditable(long var1, boolean var3);

    private native String twkGetHtml(long var1);

    private native boolean twkGetUsePageCache(long var1);

    private native void twkSetUsePageCache(long var1, boolean var3);

    private native boolean twkGetDeveloperExtrasEnabled(long var1);

    private native void twkSetDeveloperExtrasEnabled(long var1, boolean var3);

    private native boolean twkIsJavaScriptEnabled(long var1);

    private native void twkSetJavaScriptEnabled(long var1, boolean var3);

    private native boolean twkIsContextMenuEnabled(long var1);

    private native void twkSetContextMenuEnabled(long var1, boolean var3);

    private native void twkSetUserStyleSheetLocation(long var1, String var3);

    private native int twkGetUnloadEventListenersCount(long var1);

    private native void twkConnectInspectorFrontend(long var1);

    private native void twkDisconnectInspectorFrontend(long var1);

    private native void twkDispatchInspectorMessageFromFrontend(long var1, String var3);

    static {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                String string = System.getProperty("os.name");
                String string2 = System.getProperty("os.arch");
                String string3 = null;
                if (string.startsWith("Windows")) {
                    string3 = "windows";
                } else if (string.startsWith("Linux")) {
                    string3 = "linux";
                } else if (string.startsWith("SunOS")) {
                    string3 = "solaris";
                }
                if (string3 != null) {
                    String string4 = ConfigManager.getProperty(string3 + ".libs");
                    if (string4 != null) {
                        String[] stringArray = string4.split("\\s*,\\s*");
                        try {
                            log.finer("loading " + string + " native libraries ...");
                            for (String string5 : stringArray) {
                                NativeLibLoader.loadLibrary(string5);
                                log.finer(string5 + " loaded");
                            }
                        }
                        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                            log.finer("Cannot load libraries that webkit depends on. So, trying to load WebKitJava relying on system library path.");
                        }
                    } else {
                        log.finer("No extra libraries to load.");
                    }
                } else {
                    log.finer(string + " (" + string2 + ") is not supported. " + "Trying to load WebKitJava relying on " + "system library path.");
                }
                NativeLibLoader.loadLibrary("jfxwebkit");
                log.finer("jfxwebkit loaded");
                return null;
            }
        });
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                boolean bl;
                if (CookieHandler.getDefault() == null && (bl = Boolean.valueOf(System.getProperty("com.sun.webpane.setDefaultCookieHandler", "true")).booleanValue())) {
                    CookieHandler.setDefault(new CookieManager());
                }
                return null;
            }
        });
    }

    private static class ScrollRequest {
        int x;
        int y;
        int w;
        int h;
        int dx;
        int dy;

        ScrollRequest(int n, int n2, int n3, int n4, int n5, int n6) {
            this.x = n;
            this.y = n2;
            this.w = n3;
            this.h = n4;
            this.dx = n5;
            this.dy = n6;
        }
    }
}

