/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.input;

import javafx.event.EventTarget;
import javafx.event.EventType;
import javafx.scene.input.GestureEvent;

public class ZoomEvent
extends GestureEvent {
    public static final EventType<ZoomEvent> ANY = new EventType<GestureEvent>(GestureEvent.ANY, "ANY_ZOOM");
    public static final EventType<ZoomEvent> ZOOM = new EventType<ZoomEvent>(ANY, "ZOOM");
    public static final EventType<ZoomEvent> ZOOM_STARTED = new EventType<ZoomEvent>(ANY, "ZOOM_STARTED");
    public static final EventType<ZoomEvent> ZOOM_FINISHED = new EventType<ZoomEvent>(ANY, "ZOOM_FINISHED");
    private double zoomFactor;
    private double totalZoomFactor;

    private ZoomEvent(EventType<? extends ZoomEvent> eventType) {
        super((EventType<? extends GestureEvent>)eventType);
    }

    private ZoomEvent(Object object, EventTarget eventTarget, EventType<? extends ZoomEvent> eventType) {
        super(object, eventTarget, (EventType<? extends GestureEvent>)eventType);
    }

    private ZoomEvent(EventType<? extends ZoomEvent> eventType, double d, double d2, double d3, double d4, double d5, double d6, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6) {
        super(eventType, d3, d4, d5, d6, bl, bl2, bl3, bl4, bl5, bl6);
        this.zoomFactor = d;
        this.totalZoomFactor = d2;
    }

    public static ZoomEvent impl_zoomEvent(EventType<? extends ZoomEvent> eventType, double d, double d2, double d3, double d4, double d5, double d6, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6) {
        return new ZoomEvent(eventType, d, d2, d3, d4, d5, d6, bl, bl2, bl3, bl4, bl5, bl6);
    }

    public double getZoomFactor() {
        return this.zoomFactor;
    }

    public double getTotalZoomFactor() {
        return this.totalZoomFactor;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("ZoomEvent [");
        stringBuilder.append("source = ").append(this.getSource());
        stringBuilder.append(", target = ").append(this.getTarget());
        stringBuilder.append(", eventType = ").append(this.getEventType());
        stringBuilder.append(", consumed = ").append(this.isConsumed());
        stringBuilder.append(", zoomFactor = ").append(this.getZoomFactor());
        stringBuilder.append(", totalZoomFactor = ").append(this.getTotalZoomFactor());
        stringBuilder.append(", x = ").append(this.getX()).append(", y = ").append(this.getY());
        stringBuilder.append(this.isDirect() ? ", direct" : ", indirect");
        if (this.isShiftDown()) {
            stringBuilder.append(", shiftDown");
        }
        if (this.isControlDown()) {
            stringBuilder.append(", controlDown");
        }
        if (this.isAltDown()) {
            stringBuilder.append(", altDown");
        }
        if (this.isMetaDown()) {
            stringBuilder.append(", metaDown");
        }
        if (this.isShortcutDown()) {
            stringBuilder.append(", shortcutDown");
        }
        return stringBuilder.append("]").toString();
    }
}

