/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.apitef;

import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.apitef.IdentApiTefC;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.apitef.model.ContingenciaConexao;
import com.csi.ctfclient.autenticacao.AutenticacaoUtil;
import com.csi.ctfclient.config.ConfCTFClient;
import com.csi.ctfclient.config.ConfContingenciaConexao;
import com.csi.ctfclient.config.ConfTraceApiwebctf;
import com.csi.ctfclient.config.ControladorConfCTFClient;
import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.tools.communication.ServicoCTF;
import com.csi.ctfclient.tools.util.StringUtil;
import com.csi.ctfclient.tools.util.logger.CTFClientLogger;
import java.util.ArrayList;
import java.util.Date;
import org.apache.log4j.Logger;

public class Apitef {
    private static Logger logger = CTFClientLogger.getCTFClient();
    public static final String ARQ_DLL_TEF = "apiwebctf";
    private static final String OPER_CONFIRMACAO = "80";
    private static final String OPER_DESFAZIMENTO = "C1";

    public static Apitef newInstance() {
        return new Apitef();
    }

    public Apitef() {
        System.loadLibrary(ARQ_DLL_TEF);
    }

    private EntradaApiTefC prepararEntrada(IdentApiTefC identApiTefC, EntradaApiTefC entrada) {
        entrada.setTimestamp(new Date());
        entrada.setVersaoClient("C0212".substring(0, 5));
        entrada.setVersaoEspecificacaoRedecard("L0503");
        entrada.setVersaoClientRedecard("C0135");
        try {
            ConfCTFClient confCTFClient = ControladorConfCTFClient.getInstance().getConfig();
            entrada.setVersaoPathTerminal(confCTFClient.getVersaoPathTerminal());
            if (confCTFClient.isSuporteHttps()) {
                if (confCTFClient.getIps() != null && confCTFClient.getIps().size() > 0) {
                    ArrayList<String> listaIPs = new ArrayList<String>();
                    for (ServicoCTF servicoCTF : confCTFClient.getIps()) {
                        String comunicacao = "6022" + StringUtil.completaString(servicoCTF.getHost().getEndereco().length() + "", 4, '0', true) + servicoCTF.getHost().getEndereco();
                        comunicacao = comunicacao + "6023" + StringUtil.completaString(servicoCTF.getIdentificadorServico().length() + "", 4, '0', true) + servicoCTF.getIdentificadorServico();
                        comunicacao = comunicacao + "60240001" + servicoCTF.getCodigoProtocolo();
                        listaIPs.add(comunicacao);
                    }
                    entrada.setComunicacaoCTF((String)listaIPs.get(0));
                    if (listaIPs.size() > 1) {
                        entrada.setComunicacaoCTF2((String)listaIPs.get(1));
                    }
                    identApiTefC.setListaIP(null);
                }
                AutenticacaoUtil autenticacaoUtil = AutenticacaoUtil.getInstance();
                try {
                    entrada.setTokenTerminal(autenticacaoUtil.getTokenAutorizacao());
                    String path = "ca-bundle.crt";
                    if (ControladorConfCTFClient.getDiretorioTrabalho() != null) {
                        path = ControladorConfCTFClient.getDiretorioTrabalho() + path;
                    }
                    entrada.setCertificadoHttps(path);
                }
                catch (Exception e) {
                    logger.error((Object)"nao foi possivel recuperar o token de autorizacao do terminal.", (Throwable)e);
                }
            }
            entrada.setFlagPingUDP(confCTFClient.isPingUDP());
            if (entrada.getTimeoutCtf() == 0) {
                int timeout = confCTFClient.getTimeOutDefault();
                entrada.setTimeoutCtf(timeout);
                logger.warn((Object)("CTFClient - utilizando timeout default = " + timeout));
            }
            if (confCTFClient.getConfTraceApiwebctf() != null) {
                ConfTraceApiwebctf confTraceApiwebctf = confCTFClient.getConfTraceApiwebctf();
                entrada.setFlagTrace(confTraceApiwebctf.isHabilitado());
                entrada.setQtdDiasTrace(confTraceApiwebctf.getQtdDias());
            }
            if (confCTFClient.getConfContingenciaConexao() != null) {
                ConfContingenciaConexao contingenciaConexao = confCTFClient.getConfContingenciaConexao();
                ContingenciaConexao contingencia = new ContingenciaConexao();
                if (contingenciaConexao.isMaximoConexao()) {
                    contingencia.setMaximoConexao(contingenciaConexao.getMaximoConexao());
                }
                if (contingenciaConexao.isTempoMaximoConexao()) {
                    contingencia.setTempoMaximoConexao(contingenciaConexao.getTempoMaximoConexao());
                }
                if (contingenciaConexao.isResetConexao()) {
                    contingencia.setResetConexao(contingenciaConexao.getResetConexao());
                }
                identApiTefC.setContingenciaConexao(contingencia);
            }
        }
        catch (ExcecaoApiAc e) {
            logger.error((Object)"nao foi possivel recuperar o controlador de configuracao", (Throwable)e);
            logger.warn((Object)"CTFClient - utilizando timeout for\u00e7ado = 30");
            entrada.setTimeoutCtf(30);
        }
        return entrada;
    }

    public SaidaApiTefC solicitacao(IdentApiTefC ident, EntradaApiTefC entrada) {
        if ((entrada = this.prepararEntrada(ident, entrada)).getIndiceMasterKey() == '*') {
            entrada.setTamanhoSenha("08");
        } else if (entrada.getIndiceMasterKey() == '0') {
            entrada.setTamanhoSenha("00");
        } else {
            entrada.setTamanhoSenha("#8");
        }
        String messageLog = entrada.getOperacao() + " terminal=" + ident.getNumeroEstabelecimento() + ident.getNumeroLoja() + "." + ident.getNumeroPdv() + " valor=" + entrada.getValorTransacao();
        if (!entrada.getOperacao().equals("2M")) {
            logger.info((Object)("solicita opera\u00e7\u00e3o " + messageLog));
        }
        SaidaApiTefC saidaApiTefC = null;
        try {
            saidaApiTefC = this.solicitacaoTEF(ident, entrada);
            StringBuffer sbDisplay = new StringBuffer();
            for (int i = 0; i < saidaApiTefC.getDisplayCTF().length; ++i) {
                sbDisplay.append(" " + saidaApiTefC.getDisplayCTF()[i]);
            }
            if (!entrada.getOperacao().equals("2M")) {
                logger.info((Object)("resposta opera\u00e7\u00e3o " + messageLog + " retorno=" + saidaApiTefC.getRetorno() + " cod_erro=" + saidaApiTefC.getCodigoErro() + " nsu_ctf=" + saidaApiTefC.getNsuCTF() + " cod_van=" + saidaApiTefC.getCodigoVan() + " cod_aut=" + saidaApiTefC.getCodigoAutorizadora() + " display_ctf=" + sbDisplay.toString()));
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return saidaApiTefC;
    }

    public SaidaApiTefC confirmacao(IdentApiTefC ident, EntradaApiTefC entrada) {
        if ((entrada = this.prepararEntrada(ident, entrada)).getOperacao() == null || entrada.getOperacao().trim().length() == 0) {
            entrada.setOperacao(OPER_CONFIRMACAO);
        }
        String messageLog = entrada.getOperacao() + " terminal=" + ident.getNumeroEstabelecimento() + ident.getNumeroLoja() + "." + ident.getNumeroPdv() + " valor=" + entrada.getValorTransacao();
        logger.info((Object)("solicita opera\u00e7\u00e3o " + messageLog));
        SaidaApiTefC saidaApiTefC = this.confirmacaoTEF(ident, entrada);
        logger.info((Object)("resposta opera\u00e7\u00e3o " + messageLog + " retorno=" + saidaApiTefC.getRetorno() + " cod_erro=" + saidaApiTefC.getCodigoErro()));
        return saidaApiTefC;
    }

    public SaidaApiTefC desfazimento(IdentApiTefC ident, EntradaApiTefC entrada) {
        entrada = this.prepararEntrada(ident, entrada);
        entrada.setOperacao(OPER_DESFAZIMENTO);
        String messageLog = entrada.getOperacao() + " terminal=" + ident.getNumeroEstabelecimento() + ident.getNumeroLoja() + "." + ident.getNumeroPdv() + " valor=" + entrada.getValorTransacao();
        logger.info((Object)("solicita opera\u00e7\u00e3o " + messageLog));
        SaidaApiTefC saidaApiTefC = this.desfazimentoTEF(ident, entrada);
        logger.info((Object)("resposta opera\u00e7\u00e3o " + messageLog + " retorno=" + saidaApiTefC.getRetorno() + " cod_erro=" + saidaApiTefC.getCodigoErro()));
        return saidaApiTefC;
    }

    public int getCupom(IdentApiTefC identApiTefC, EntradaApiTefC entradaApiTefC, SaidaApiTefC saidaApiTefC) {
        return this.getCupomTEF(identApiTefC, entradaApiTefC, saidaApiTefC);
    }

    private native int getCupomTEF(IdentApiTefC var1, EntradaApiTefC var2, SaidaApiTefC var3);

    private native SaidaApiTefC solicitacaoTEF(IdentApiTefC var1, EntradaApiTefC var2);

    private native SaidaApiTefC confirmacaoTEF(IdentApiTefC var1, EntradaApiTefC var2);

    private native SaidaApiTefC desfazimentoTEF(IdentApiTefC var1, EntradaApiTefC var2);
}

