/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.autenticacao;

import com.csi.ctfclient.tools.util.ByteUtil;
import com.csi.ctfclient.tools.util.KeyStoreUtil;
import com.csi.ctfclient.tools.util.logger.CTFClientLogger;
import com.csi.ctfclient.util.AutenticacaoUtilJava1_4Compatible;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.util.Properties;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import org.apache.log4j.Logger;

public class AutenticacaoUtil
extends AutenticacaoUtilJava1_4Compatible {
    private static Logger logger = CTFClientLogger.getCTFClient();
    private static AutenticacaoUtil autenticacaoUtil = null;
    private Properties properties;
    private KeyStore keyStore;
    private final String alias = "key-aut-token";
    private String FILE_PROPERTIES = "config.properties";

    private AutenticacaoUtil() {
        this.init();
    }

    public static AutenticacaoUtil getInstance() {
        if (autenticacaoUtil == null) {
            autenticacaoUtil = new AutenticacaoUtil();
        }
        return autenticacaoUtil;
    }

    private void init() {
        this.keyStore = KeyStoreUtil.getDefaultKeyStory();
        this.properties = new Properties();
        if (new File(this.FILE_PROPERTIES).exists()) {
            try {
                this.properties.load(new FileInputStream(this.FILE_PROPERTIES));
            }
            catch (FileNotFoundException e) {
                logger.error((Object)("nao foi possivel abrir o arquivo '" + this.FILE_PROPERTIES + "'"), (Throwable)e);
            }
            catch (IOException e) {
                logger.error((Object)("nao foi possivel ler o arquivo '" + this.FILE_PROPERTIES + "'"), (Throwable)e);
            }
        }
    }

    protected KeyStore getKeyStory() {
        return this.keyStore;
    }

    protected String getAlias() {
        return "key-aut-token";
    }

    public boolean isTokenAutorizacao() throws Exception {
        return this.keyStore.containsAlias("key-aut-token") && this.properties != null && this.properties.containsKey("key-aut-token");
    }

    private void deleteAlias() throws Exception {
        try {
            this.keyStore.deleteEntry("key-aut-token");
            if (this.properties != null && this.properties.containsKey("key-aut-token")) {
                this.properties.remove("key-aut-token");
            }
        }
        catch (KeyStoreException e) {
            throw new Exception("nao foi possivel remover alias de autenteticacao.", e);
        }
    }

    public void clean() throws Exception {
        this.deleteAlias();
        File file = new File(this.FILE_PROPERTIES);
        if (file.exists()) {
            file.delete();
        }
    }

    public String getTokenAutorizacao() throws Exception {
        if (this.isTokenAutorizacao()) {
            SecretKey secretKey = this.getSecretKey();
            byte[] cipheredText = null;
            try {
                Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
                cipher.init(2, secretKey);
                cipheredText = cipher.doFinal(ByteUtil.hexToByteArray(this.properties.getProperty("key-aut-token")));
            }
            catch (Exception e) {
                logger.error((Object)"erro ao recuperar token", (Throwable)e);
                throw e;
            }
            return new String(cipheredText);
        }
        logger.error((Object)"nao existe token de seguranca valido para o terminal, verifique configuracao.");
        return null;
    }

    public void configTokenAutorizacao(String token) throws Exception {
        SecretKey secretKey = null;
        if (!this.isTokenAutorizacao()) {
            secretKey = this.createSecretKey();
        }
        byte[] cipheredText = null;
        try {
            Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
            cipher.init(1, secretKey);
            cipheredText = cipher.doFinal(token.getBytes());
        }
        catch (Exception e) {
            logger.error((Object)"erro no processamento do token", (Throwable)e);
            throw e;
        }
        Properties properties = new Properties();
        properties.setProperty("key-aut-token", ByteUtil.byteArrayToHex(cipheredText));
        FileOutputStream os = new FileOutputStream(this.FILE_PROPERTIES);
        properties.store(os, "autorizacao do terminal");
        os.close();
        this.init();
    }
}

