/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.config;

import com.csi.ctfclient.tools.util.StringUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Properties;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.UIManager;

public class CTFClientConfigurator
extends JFrame
implements ActionListener,
KeyListener {
    private final String PATH_FILE_PERIFERICOS = "./configPerifericos.properties";
    private final String PATH_FILE_PARAMETROS_CTF = "./confClientCTF.xml";
    private static final long serialVersionUID = 1L;
    private JPanel jContentPane = null;
    private JLabel labelEstabelecimento = null;
    private JLabel labelLoja = null;
    private JLabel labelTerminal = null;
    private JTextField fieldEstabelecimento = null;
    private JTextField fieldLoja = null;
    private JTextField fieldTerminal = null;
    private JLabel labelHost = null;
    private JLabel labelPorta = null;
    private JTextField fieldHost = null;
    private JSeparator separatorHost = null;
    private JSeparator separatorButton = null;
    private JButton buttonCancelar = null;
    private JButton buttonConfirmar = null;
    private JComboBox comboPortaSerial = null;
    private JLabel labelPostaScanner = null;
    private JComboBox comboScanner = null;

    public CTFClientConfigurator() {
        this.initialize();
    }

    private void initialize() {
        this.setSize(262, 271);
        this.setResizable(false);
        this.setContentPane(this.getJContentPane());
        this.setTitle("Configura\u00e7\u00e3o CTFClient");
        this.setDefaultCloseOperation(3);
        try {
            String parametrosScanner;
            String[] arrayScanner;
            Properties properties = new Properties();
            FileInputStream inputStream = new FileInputStream("./configPerifericos.properties");
            properties.load(inputStream);
            String parametros = properties.getProperty("DRIVE_PIN");
            String[] array = parametros.split(",");
            if (array.length == 5) {
                this.getComboPortaSerial().setSelectedItem(array[1]);
            }
            if ((arrayScanner = (parametrosScanner = properties.getProperty("DRIVE_SCANNER")).split(",")).length == 5) {
                this.getComboScanner().setSelectedItem(arrayScanner[1]);
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.labelPostaScanner = new JLabel();
            this.labelPostaScanner.setBounds(new Rectangle(141, 152, 83, 15));
            this.labelPostaScanner.setText("Porta Scanner:");
            this.labelPorta = new JLabel();
            this.labelPorta.setBounds(new Rectangle(10, 152, 93, 16));
            this.labelPorta.setText("Porta Serial (Pin):");
            this.labelHost = new JLabel();
            this.labelHost.setBounds(new Rectangle(10, 111, 38, 16));
            this.labelHost.setText("Host:");
            this.labelTerminal = new JLabel();
            this.labelTerminal.setBounds(new Rectangle(10, 54, 87, 16));
            this.labelTerminal.setText("Terminal (PDV):");
            this.labelLoja = new JLabel();
            this.labelLoja.setBounds(new Rectangle(142, 9, 38, 16));
            this.labelLoja.setText("Loja:");
            this.labelEstabelecimento = new JLabel();
            this.labelEstabelecimento.setBounds(new Rectangle(10, 9, 87, 16));
            this.labelEstabelecimento.setText("Estabelecimento:");
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(null);
            this.jContentPane.add((Component)this.labelEstabelecimento, null);
            this.jContentPane.add((Component)this.labelLoja, null);
            this.jContentPane.add((Component)this.labelTerminal, null);
            this.jContentPane.add((Component)this.getFieldEstabelecimento(), null);
            this.jContentPane.add((Component)this.getFieldLoja(), null);
            this.jContentPane.add((Component)this.getFieldTerminal(), null);
            this.jContentPane.add((Component)this.labelHost, null);
            this.jContentPane.add((Component)this.labelPorta, null);
            this.jContentPane.add((Component)this.getFieldHost(), null);
            this.jContentPane.add((Component)this.getSeparatorHost(), null);
            this.jContentPane.add((Component)this.getSeparatorButton(), null);
            this.jContentPane.add((Component)this.getButtonCancelar(), null);
            this.jContentPane.add((Component)this.getButtonConfirmar(), null);
            this.jContentPane.add((Component)this.getComboPortaSerial(), null);
            this.jContentPane.add((Component)this.labelPostaScanner, null);
            this.jContentPane.add((Component)this.getComboScanner(), null);
        }
        return this.jContentPane;
    }

    private JTextField getFieldEstabelecimento() {
        if (this.fieldEstabelecimento == null) {
            this.fieldEstabelecimento = new JTextField();
            this.fieldEstabelecimento.setBounds(new Rectangle(10, 29, 103, 20));
            this.fieldEstabelecimento.addKeyListener(this);
        }
        return this.fieldEstabelecimento;
    }

    private JTextField getFieldLoja() {
        if (this.fieldLoja == null) {
            this.fieldLoja = new JTextField();
            this.fieldLoja.setLocation(new Point(141, 29));
            this.fieldLoja.setSize(new Dimension(103, 20));
            this.fieldLoja.addKeyListener(this);
        }
        return this.fieldLoja;
    }

    private JTextField getFieldTerminal() {
        if (this.fieldTerminal == null) {
            this.fieldTerminal = new JTextField();
            this.fieldTerminal.setLocation(new Point(10, 74));
            this.fieldTerminal.setSize(new Dimension(103, 20));
            this.fieldTerminal.addKeyListener(this);
        }
        return this.fieldTerminal;
    }

    private JTextField getFieldHost() {
        if (this.fieldHost == null) {
            this.fieldHost = new JTextField();
            this.fieldHost.setLocation(new Point(10, 128));
            this.fieldHost.setSize(new Dimension(235, 19));
            this.fieldHost.addKeyListener(this);
        }
        return this.fieldHost;
    }

    private JSeparator getSeparatorHost() {
        if (this.separatorHost == null) {
            this.separatorHost = new JSeparator();
            this.separatorHost.setBounds(new Rectangle(9, 100, 240, 10));
        }
        return this.separatorHost;
    }

    private JSeparator getSeparatorButton() {
        if (this.separatorButton == null) {
            this.separatorButton = new JSeparator();
            this.separatorButton.setLocation(new Point(11, 198));
            this.separatorButton.setSize(new Dimension(240, 10));
        }
        return this.separatorButton;
    }

    private JButton getButtonCancelar() {
        if (this.buttonCancelar == null) {
            this.buttonCancelar = new JButton();
            this.buttonCancelar.setSize(new Dimension(86, 22));
            this.buttonCancelar.setBounds(new Rectangle(163, 209, 86, 22));
            this.buttonCancelar.setText("Cancelar");
            this.buttonCancelar.setActionCommand("cancelAction");
            this.buttonCancelar.addActionListener(this);
        }
        return this.buttonCancelar;
    }

    private JButton getButtonConfirmar() {
        if (this.buttonConfirmar == null) {
            this.buttonConfirmar = new JButton();
            this.buttonConfirmar.setText("Ok");
            this.buttonConfirmar.setActionCommand("okAction");
            this.buttonConfirmar.setSize(new Dimension(86, 22));
            this.buttonConfirmar.setLocation(new Point(69, 209));
            this.buttonConfirmar.addActionListener(this);
        }
        return this.buttonConfirmar;
    }

    private void createConfigPerifericos(String portaSerial, String portaScanner) {
        File file = new File("./configPerifericos.properties");
        try {
            FileWriter fileWrite = new FileWriter(file);
            fileWrite.write("# Classe que extend Teclado \n");
            fileWrite.write("DRIVE_TECLADO com.csi.apitef.devices.generic.TecladoPC\n");
            fileWrite.write("# Classe que extend Scanner \n");
            fileWrite.write("DRIVE_SCANNER com.csi.apitef.devices.generic.ScannerSerial," + portaScanner + ",9600,8,N,1\n");
            fileWrite.write("# Classe que implementa Display \n");
            fileWrite.write("DRIVE_DISPLAY_OPERADOR com.csi.apitef.devices.generic.JPanelDisplay,30,35\n");
            fileWrite.write("#Classe que implementa Display \n");
            fileWrite.write("DRIVE_DISPLAY_CLIENTE com.csi.apitef.devices.generic.JPanelDisplay,40,35\n");
            fileWrite.write("# Classe que extend LeitorCartao \n");
            fileWrite.write("DRIVE_LEITOR_CARTAO\tcom.csi.apitef.devices.emvfull.LeitorCartaoBibliotecaCompartilhada," + portaSerial + ",PASSE O CARTAO,SEJA BEM VINDO\n");
            fileWrite.write("# Classe que extend PIN \n");
            fileWrite.write("DRIVE_PIN\tcom.csi.apitef.devices.emvfull.PinBibliotecaCompartilhada," + portaSerial + ",SEJA BEM VINDO,DIGITE A SENHA,PROCESSANDO...\n");
            fileWrite.flush();
            fileWrite.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void createConfigClienteCTF(String estab, String loja, String terminal, String host) {
        File file = new File("./confClientCTF.xml");
        estab = StringUtil.completaString(estab, 5, '0', true);
        loja = StringUtil.completaString(loja, 4, '0', true);
        terminal = StringUtil.completaString(terminal, 3, '0', true);
        try {
            FileWriter fileWrite = new FileWriter(file);
            fileWrite.write("<?xml version='1.0' encoding='UTF-8'?> \n");
            fileWrite.write("<clientCTF> \n");
            fileWrite.write(" <property name='estabelecimento' value='" + estab + "' /> \n");
            fileWrite.write(" <property name='loja' value='" + loja + "' /> \n");
            fileWrite.write(" <property name='pdv' value='" + terminal + "' /> \n");
            fileWrite.write(" <property name='numeroSite' value='01' /> \n");
            fileWrite.write(" <property name='numeroPin' value='54987' /> \n");
            fileWrite.write(" <property name='quantidadeVias' value='2'/> \n");
            fileWrite.write("   <properties name='ips' beanType='com.csi.apitef.config.InetAddress'> \n");
            fileWrite.write("     <bean> \n");
            fileWrite.write("      <property name='host' value='" + host + "' /> \n");
            fileWrite.write("      <property name='port' value='1996' /> \n");
            fileWrite.write("     </bean> \n");
            fileWrite.write("   </properties> \n");
            fileWrite.write("</clientCTF>");
            fileWrite.flush();
            fileWrite.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private JComboBox getComboPortaSerial() {
        if (this.comboPortaSerial == null) {
            Vector<String> opcoes = new Vector<String>();
            opcoes.add("COM1");
            opcoes.add("COM2");
            opcoes.add("COM3");
            opcoes.add("COM4");
            opcoes.add("COM5");
            opcoes.add("COM6");
            opcoes.add("COM7");
            opcoes.add("COM8");
            opcoes.add("COM9");
            this.comboPortaSerial = new JComboBox(opcoes);
            this.comboPortaSerial.setBounds(new Rectangle(10, 170, 94, 22));
        }
        return this.comboPortaSerial;
    }

    private JComboBox getComboScanner() {
        if (this.comboScanner == null) {
            Vector<String> opcoes = new Vector<String>();
            opcoes.add("COM1");
            opcoes.add("COM2");
            opcoes.add("COM3");
            opcoes.add("COM4");
            opcoes.add("COM5");
            opcoes.add("COM6");
            opcoes.add("COM7");
            opcoes.add("COM8");
            opcoes.add("COM9");
            this.comboScanner = new JComboBox(opcoes);
            this.comboScanner.setSize(new Dimension(94, 22));
            this.comboScanner.setLocation(new Point(141, 170));
        }
        return this.comboScanner;
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            CTFClientConfigurator manager = new CTFClientConfigurator();
            manager.setVisible(true);
        }
        catch (Exception e) {
            System.exit(0);
        }
    }

    public void actionPerformed(ActionEvent event) {
        if (event.getSource() == this.buttonConfirmar) {
            if (this.getFieldEstabelecimento().getText().trim().length() != 0 && this.getFieldLoja().getText().trim().length() != 0 && this.getFieldTerminal().getText().trim().length() != 0 && this.getFieldHost().getText().trim().length() != 0) {
                this.createConfigPerifericos((String)this.getComboPortaSerial().getSelectedItem(), (String)this.getComboScanner().getSelectedItem());
                this.createConfigClienteCTF(this.getFieldEstabelecimento().getText(), this.getFieldLoja().getText(), this.getFieldTerminal().getText(), this.getFieldHost().getText());
                System.exit(0);
            } else {
                JOptionPane.showMessageDialog(this, "Todos os parametros s\u00e3o de preenchimento obrigat\u00f3rio.");
            }
        } else if (event.getSource() == this.buttonCancelar) {
            System.exit(0);
        }
    }

    public void keyTyped(KeyEvent event) {
        JTextField field;
        if (event.getSource() != this.fieldHost && !Character.isDigit(event.getKeyChar()) && event.getKeyChar() != '\b' && event.getKeyChar() != '.') {
            event.consume();
        }
        if (event.getSource() == this.fieldEstabelecimento) {
            JTextField field2 = (JTextField)event.getSource();
            if (field2.getText().length() == 5 && event.getKeyChar() != '\b') {
                event.consume();
            }
        } else if (event.getSource() == this.fieldLoja) {
            JTextField field3 = (JTextField)event.getSource();
            if (field3.getText().length() == 4 && event.getKeyChar() != '\b') {
                event.consume();
            }
        } else if (event.getSource() == this.fieldTerminal && (field = (JTextField)event.getSource()).getText().length() == 3 && event.getKeyChar() != '\b') {
            event.consume();
        }
    }

    public void keyPressed(KeyEvent event) {
    }

    public void keyReleased(KeyEvent event) {
    }
}

