/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.config;

import com.csi.ctfclient.config.ConfCreditoDigital;
import com.csi.ctfclient.config.ControladorConfCTFClient;
import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.operacoes.model.OperadoraTelefonia;
import com.csi.ctfclient.tools.util.xml.Config;
import com.csi.ctfclient.tools.util.xml.MultipleNamesFoundException;
import com.csi.ctfclient.tools.util.xml.NoSuchParameterException;
import com.csi.ctfclient.tools.util.xml.ParameterSet;
import com.csi.ctfclient.tools.util.xml.ParseConfigException;
import com.csi.ctfclient.tools.util.xml.StructureConfigException;
import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.log4j.Logger;

public class ControladorConfCreditoDigital {
    private static Logger logger = Logger.getLogger((String)"ControladorConfCreditoDigital");
    private final String FILE_CONFIG = "configCreditoDigital.xml";
    private final String INVALID_PARAMETER = "valor de parametro invalido";
    private static ConfCreditoDigital confCreditoDigital;
    private static ControladorConfCreditoDigital readerConfCreditoDigital;

    private ControladorConfCreditoDigital() {
    }

    public static synchronized ControladorConfCreditoDigital getInstance() throws ExcecaoApiAc {
        if (readerConfCreditoDigital == null) {
            logger.info((Object)"Inicializando controlador de configura\u00e7\u00f5es de cr\u00e9dito digital...");
            readerConfCreditoDigital = new ControladorConfCreditoDigital();
            confCreditoDigital = readerConfCreditoDigital.read();
        }
        return readerConfCreditoDigital;
    }

    public ConfCreditoDigital getConfig() {
        return confCreditoDigital;
    }

    private ConfCreditoDigital read() throws ExcecaoApiAc {
        logger.info((Object)"Inicializando carga dos parametros de configura\u00e7\u00e3o...");
        ConfCreditoDigital confCreditoDigital = new ConfCreditoDigital();
        try {
            LinkedHashSet<OperadoraTelefonia> operadorasTelefonia;
            logger.info((Object)"Inicializando leitura do arquivo de configura\u00e7\u00f5es");
            Config config = ControladorConfCTFClient.getDiretorioTrabalho() != null ? Config.getConfig(ControladorConfCTFClient.getDiretorioTrabalho() + "configCreditoDigital.xml") : Config.getConfig("configCreditoDigital.xml");
            logger.info((Object)"Arquivo de configura\u00e7\u00e3o carregado...");
            ParameterSet root = config.getParameterSet("configCreditoDigital");
            ParameterSet ipsParameter = root.getParameterSet("operadoras");
            if (ipsParameter != null && ipsParameter.getParameterSets("operadora") != null && ipsParameter.getParameterSets("operadora").size() > 0) {
                operadorasTelefonia = new LinkedHashSet<OperadoraTelefonia>();
                List listaOperadora = ipsParameter.getParameterSets("operadora");
                for (ParameterSet paramOperadora : listaOperadora) {
                    int digitoInt;
                    String codigo = paramOperadora.getParameter("codigo").getContent();
                    if (codigo == null || codigo.equals("")) {
                        logger.info((Object)"valor de parametro invalido ==> operadora = codigo");
                        throw new ExcecaoApiAc("valor de parametro invalido");
                    }
                    String nome = paramOperadora.getParameter("nome").getContent();
                    if (nome == null || nome.equals("")) {
                        logger.info((Object)"valor de parametro invalido ==> operadora = nome");
                        throw new ExcecaoApiAc("valor de parametro invalido");
                    }
                    String digito = paramOperadora.getParameter("digito").getContent();
                    if (digito == null || digito.equals("")) {
                        logger.info((Object)"valor de parametro invalido ==> operadora = digito");
                        throw new ExcecaoApiAc("valor de parametro invalido");
                    }
                    try {
                        digitoInt = Integer.parseInt(digito);
                    }
                    catch (NumberFormatException e) {
                        logger.info((Object)"valor de parametro invalido ==> operadora = digito");
                        throw new ExcecaoApiAc("valor de parametro invalido");
                    }
                    OperadoraTelefonia operadora = new OperadoraTelefonia();
                    operadora.setAutorizadora(codigo);
                    operadora.setNome(nome);
                    operadora.setDigito(digitoInt == 1);
                    operadorasTelefonia.add(operadora);
                }
            } else {
                logger.info((Object)"lista de operadoras n\u00e3o configurada ==> operadoras");
                throw new ExcecaoApiAc("valor de parametro invalido");
            }
            confCreditoDigital.setOperadorasTelefonia(operadorasTelefonia);
        }
        catch (SecurityException e) {
            logger.error((Object)e.getMessage());
            throw new ExcecaoApiAc(e.getMessage());
        }
        catch (ParseConfigException e) {
            logger.error((Object)e.getMessage());
            throw new ExcecaoApiAc(e.getMessage());
        }
        catch (StructureConfigException e) {
            logger.error((Object)e.getMessage());
            throw new ExcecaoApiAc(e.getMessage());
        }
        catch (MultipleNamesFoundException e) {
            logger.error((Object)e.getMessage());
            throw new ExcecaoApiAc(e.getMessage());
        }
        catch (NoSuchParameterException e) {
            logger.error((Object)e.getMessage());
            throw new ExcecaoApiAc(e.getMessage());
        }
        catch (IOException e) {
            logger.error((Object)e.getMessage());
            throw new ExcecaoApiAc("Erro ao ler o arquivo configCreditoDigital.xml");
        }
        return confCreditoDigital;
    }

    public void save(ConfCreditoDigital confCreditoDigital) throws ExcecaoApiAc {
        logger.info((Object)"Inicializando leitura do arquivo de configura\u00e7\u00f5es de cr\u00e9dito digital");
        try {
            logger.info((Object)"Arquivo de configura\u00e7\u00e3o carregado...");
            logger.info((Object)"Inicializando atualiza\u00e7\u00e3o do arquivo de configura\u00e7\u00f5es...");
        }
        catch (SecurityException e1) {
            e1.printStackTrace();
        }
    }

    public static void main(String[] args) {
        try {
            ControladorConfCreditoDigital controlador = ControladorConfCreditoDigital.getInstance();
            ConfCreditoDigital conf = controlador.getConfig();
            conf.getOperadorasTelefonia();
        }
        catch (ExcecaoApiAc e) {
            e.printStackTrace();
        }
    }
}

