/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.excecoes;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.util.ArrayList;

public class ErroApiTef
extends Error {
    private static final long serialVersionUID = 1L;
    private String detalhe;

    public ErroApiTef(String texto) {
        super(texto);
        this.detalhe = "";
    }

    public ErroApiTef(String codErro, String detalheErro) {
        super(codErro);
        this.detalhe = detalheErro;
    }

    public String getDetalheErro() {
        return this.detalhe;
    }

    public String[] getInformacoesDetalhe() {
        if (this.detalhe != null || !this.detalhe.equals("")) {
            String[] stack = this.getStackTraceComoString(this);
            String[] retorno = new String[stack.length + 1];
            retorno[0] = this.detalhe;
            System.arraycopy(stack, 0, retorno, 1, stack.length);
            return retorno;
        }
        return this.getStackTraceComoString(this);
    }

    public String getMessage() {
        return super.getMessage() + " -  " + this.detalhe;
    }

    final String[] getStackTraceComoString(Throwable e) {
        ByteArrayOutputStream byteArrayOut = new ByteArrayOutputStream();
        PrintWriter printWriter = new PrintWriter(byteArrayOut);
        e.printStackTrace(printWriter);
        printWriter.close();
        ByteArrayInputStream byteArrayInput = new ByteArrayInputStream(byteArrayOut.toByteArray());
        InputStreamReader inputReader = new InputStreamReader(byteArrayInput);
        LineNumberReader lineReader = new LineNumberReader(inputReader);
        ArrayList<String> linhas = new ArrayList<String>();
        try {
            String linha = lineReader.readLine();
            while (linha != null) {
                linhas.add(linha);
                linha = lineReader.readLine();
            }
        }
        catch (IOException e1) {
            // empty catch block
        }
        String[] retorno = new String[linhas.size()];
        retorno = linhas.toArray(retorno);
        return retorno;
    }

    public static void main(String[] args) {
        ErroApiTef erro = new ErroApiTef("texto do erro");
        String[] detalhe = erro.getInformacoesDetalhe();
        for (int i = 0; i < detalhe.length; ++i) {
            System.out.println(detalhe[i]);
        }
    }
}

