/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.info.tiposgerais;

import com.csi.ctfclient.excecoes.ExcecaoCodigoInvalido;
import com.csi.ctfclient.excecoes.ExcecaoDigitoInvalido;
import com.csi.ctfclient.excecoes.ExcecaoStringInvalido;
import com.csi.ctfclient.info.tiposgerais.CodigoBarras;
import com.csi.ctfclient.info.tiposgerais.EmpresaCGC;
import com.csi.ctfclient.info.tiposgerais.EmpresaCodNormal;
import com.csi.ctfclient.info.tiposgerais.EmpresaCredora;
import com.csi.ctfclient.tools.util.codigobarras.CalculadorDigito;
import com.csi.ctfclient.tools.util.codigobarras.CodigoBarrasUtil;

public class CodigoFebraban
extends CodigoBarras {
    private char produto;
    private char indicadorValRef;
    private char digitoVerificador;
    private String valorReferencia;
    private EmpresaCredora empresaCredora;
    protected static final int POSICAO_DVG = 4;
    protected static final int TAMANHO_CODIGO = 44;
    protected static final int TAMANHO_EMPRESA_CGC = 8;
    protected static final int TAMANHO_EMPRESA_FEBRABAN = 4;
    protected static final int TAMANHO_GRUPO = 11;
    protected static final int TAMANHO_VALOR = 11;
    protected static final String SEGMENTO_BANCO = "9";
    protected static final String SEGMENTO_CGC = "6";
    protected static final String SEGMENTO_FEBRABAN = "1,2,3,4,5";
    private static final long serialVersionUID = -1001406866058852773L;

    public char getDigitoVerificador() {
        return this.digitoVerificador;
    }

    public EmpresaCredora getEmpresaCredora() {
        return this.empresaCredora;
    }

    public char getIndicadorValRef() {
        return this.indicadorValRef;
    }

    public char getProduto() {
        return this.produto;
    }

    public String getValorReferencia() {
        return this.valorReferencia;
    }

    public void setDigitoVerificador(char novoValor) {
        this.digitoVerificador = novoValor;
    }

    public void setEmpresaCredora(EmpresaCredora novoValor) {
        this.empresaCredora = novoValor;
    }

    public void setIndicadorValRef(char novoValor) {
        this.indicadorValRef = novoValor;
    }

    public void setProduto(char novoValor) {
        this.produto = novoValor;
    }

    public void setValorReferencia(String novoValor) {
        this.valorReferencia = novoValor;
    }

    public CodigoFebraban(String codigo) throws ExcecaoCodigoInvalido {
        this.geraCodigoBarras(codigo);
    }

    public int getTipoCodigo() {
        return 1;
    }

    public static void validaDigitoGrupo(String grupo) throws ExcecaoDigitoInvalido {
        int multiplicador = 2;
        int dac = 0;
        if (grupo.length() != 12) {
            throw new ExcecaoDigitoInvalido();
        }
        String campo = grupo.substring(0, 11);
        String validaDAC = grupo.substring(11);
        for (int contador = campo.length(); contador > 0; --contador) {
            int produtoDigito = new Integer(campo.substring(contador - 1, contador));
            dac += (produtoDigito *= multiplicador) % 10 + produtoDigito / 10;
            multiplicador = multiplicador % 2 + 1;
        }
        dac = (10 - dac % 10) % 10;
        if (!validaDAC.equals("" + dac)) {
            throw new ExcecaoDigitoInvalido();
        }
    }

    public static void validaDigitoGeral(String codigo) throws ExcecaoDigitoInvalido {
        String digitoCalculado;
        if (codigo.length() != 44) {
            throw new ExcecaoDigitoInvalido();
        }
        String codigoSemDV = codigo.substring(0, 3) + codigo.substring(4, codigo.length());
        String validaDVG = codigo.substring(3, 4);
        int indicadorModulo = CodigoBarrasUtil.capturaIndicativoValidacao(codigo);
        try {
            digitoCalculado = indicadorModulo == 8 || indicadorModulo == 9 ? CalculadorDigito.calculaDigitoModulo11Geral(codigoSemDV) : CalculadorDigito.calculaDigitoModulo10(codigoSemDV);
        }
        catch (ExcecaoCodigoInvalido e) {
            e.printStackTrace();
            throw new ExcecaoDigitoInvalido("ExcecaoCodigoInvalido levantado, indicador valida\u00e7\u00e3o: " + indicadorModulo + ", original message: " + e.getMessage());
        }
        if (!validaDVG.equals("" + digitoCalculado)) {
            throw new ExcecaoDigitoInvalido();
        }
    }

    public void geraCodigoBarras(String codigo) throws ExcecaoCodigoInvalido {
        String codigoFebraban = "";
        if (codigo == null || codigo.length() != 48) {
            throw new ExcecaoCodigoInvalido();
        }
        try {
            for (int contador = 0; contador < 48; contador += 12) {
                String grupo = codigo.substring(contador, contador + 11 + 1);
                CodigoFebraban.validaDigitoGrupo(grupo);
                codigoFebraban = codigoFebraban + codigo.substring(contador, contador + 11);
            }
            CodigoFebraban.validaDigitoGeral(codigoFebraban);
            this.setProduto(codigoFebraban.charAt(0));
            this.setSegmento(codigoFebraban.substring(1, 2));
            this.setIndicadorValRef(codigoFebraban.charAt(2));
            this.setDigitoVerificador(codigoFebraban.charAt(3));
            this.setValorReferencia(codigoFebraban.substring(4, 15));
            EmpresaCredora empresa = this.getSegmento().equals(SEGMENTO_CGC) ? new EmpresaCGC(codigoFebraban.substring(15, 23), codigoFebraban.substring(23)) : new EmpresaCodNormal(codigoFebraban.substring(15, 19), codigoFebraban.substring(19));
            this.setEmpresaCredora(empresa);
        }
        catch (Exception e) {
            throw new ExcecaoCodigoInvalido();
        }
    }

    public CodigoFebraban(char produto, char indValRef, char digitoVer, String valRef, String segmento, String usoEmpresa, String cgcEmpresa, String codigoEmpresa) throws ExcecaoStringInvalido {
        this.setProduto(produto);
        this.setIndicadorValRef(indValRef);
        this.setDigitoVerificador(digitoVer);
        this.setValorReferencia(valRef);
        super.setSegmento(segmento);
        if (this.getSegmento().equals(SEGMENTO_CGC)) {
            this.setEmpresaCredora(new EmpresaCGC(cgcEmpresa, usoEmpresa));
        } else {
            this.setEmpresaCredora(new EmpresaCodNormal(codigoEmpresa, usoEmpresa));
        }
    }
}

