/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.integracao;

import com.csi.ctfclient.integracao.ConfiguracaoException;
import com.csi.ctfclient.integracao.ConfiguracaoIntegrador;
import com.csi.ctfclient.integracao.Handler;
import com.csi.ctfclient.integracao.ParserInput;
import com.csi.ctfclient.integracao.ParserInputCSI;
import com.csi.ctfclient.integracao.ParserOutput;
import com.csi.ctfclient.integracao.ParserOutputCSI;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ConfiguracaoIntegradorXML
extends ConfiguracaoIntegrador {
    private String path = "./confIntegrador.xml";
    private Handler handler;
    private ParserInput parserInput;
    private ParserOutput parserOutput;

    public ConfiguracaoIntegradorXML() throws ConfiguracaoException {
        this(null);
    }

    public ConfiguracaoIntegradorXML(String path) throws ConfiguracaoException {
        if (path != null) {
            this.path = path;
        }
        this.buildData();
    }

    private void buildData() throws ConfiguracaoException {
        try {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document document = builder.parse(new File(this.path));
            Element root = document.getDocumentElement();
            if (!"configuracaoIntegrador".equals(root.getTagName())) {
                throw new IOException();
            }
            NodeList handlerlist = root.getElementsByTagName("handler");
            Element handlerElemnt = (Element)handlerlist.item(0);
            this.handler = (Handler)this.getbuildObject(handlerElemnt);
            this.parserInput = new ParserInputCSI(null);
            this.parserOutput = new ParserOutputCSI((Map)null);
        }
        catch (Exception e) {
            throw new ConfiguracaoException();
        }
    }

    private Object getbuildObject(Element element) throws ConfiguracaoException {
        try {
            String handlerClass = element.getAttribute("class");
            NodeList properties = element.getElementsByTagName("property");
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("class", handlerClass);
            for (int i = 0; i < properties.getLength(); ++i) {
                Element property = (Element)properties.item(i);
                map.put(property.getAttribute("name"), property.getAttribute("value"));
            }
            return this.newInstanceObject(map);
        }
        catch (Exception e) {
            throw new ConfiguracaoException();
        }
    }

    private Object newInstanceObject(Map map) throws ConfiguracaoException {
        try {
            Class<?> objectClass = Class.forName((String)map.get("class"));
            Constructor<?> constructor = objectClass.getConstructor(Map.class);
            return constructor.newInstance(map);
        }
        catch (Exception e) {
            throw new ConfiguracaoException();
        }
    }

    public ParserInput createParserInput() {
        return this.parserInput;
    }

    public ParserOutput createParserOut() {
        return this.parserOutput;
    }

    public Handler getHandlerStream() {
        return this.handler;
    }
}

