/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.integracao;

import com.csi.ctfclient.config.ConfCTFClient;
import com.csi.ctfclient.config.ControladorConfCTFClient;
import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.excecoes.ExcecaoParametroInvalido;
import com.csi.ctfclient.integracao.ConstantesIntegracaoCSI;
import com.csi.ctfclient.integracao.ParserInput;
import com.csi.ctfclient.integracao.SyntaxError;
import com.csi.ctfclient.integracao.TimeoutException;
import com.csi.ctfclient.operacoes.model.ProdutoPromocional;
import com.csi.ctfclient.servicos.EntradaCTFClient;
import com.csi.ctfclient.servicos.IdentTerminal;
import com.csi.ctfclient.tools.communication.Host;
import com.csi.ctfclient.tools.communication.ServicoCTF;
import com.csi.ctfclient.tools.devices.config.ConfPeriferico;
import com.csi.ctfclient.tools.util.NumberUtil;
import com.csi.ctfclient.tools.util.StringUtil;
import com.csi.ctfclient.tools.util.logger.CTFClientLogger;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.Map;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class ParserInputCSI
extends ParserInput
implements ConstantesIntegracaoCSI {
    private Logger logger = CTFClientLogger.getIntegrador();
    private int posLinha3 = 0;
    private IdentTerminal identTerminal;
    private EntradaCTFClient entrada;
    private ConfCTFClient config;
    private int[] tamDado = new int[]{3, -2, 3, 12, -2, -2, 14, 16, 2, 4, 8, 12, 12, 6, -3, 12, 4, 4, 1, 17, 10, -3, -3, -3, 5, 12, 12, 1, 1, 2, 34, 3, 2, 12, 12, 10, 20, 40, 6, 5, 2, 20, 9, 2, 2, 11, 80, 1, -2, 0, 40, -3, 40, -3, 40, -3, 40, -3, 40, -3, 40, -3, 40, -3, 1, 2, 2, 1, 8, 3, 8, 1, 1, 1, 12, 2, 1, 1, 0, 20, 1, -2, 10, 10, 10, 11, 20, 1, 1, 1, 1, 12, -2, -2, 1, 19, 2, -2, 2, 8, 2};
    private boolean dadosCriptografados;

    private int parse1stLine(EntradaCTFClient entrada, IdentTerminal identTerminal, String linha1) throws SyntaxError {
        int operacao;
        if (linha1.length() != 35) {
            throw new SyntaxError(1, 4);
        }
        try {
            Date date;
            String dado = linha1.substring(0, 3);
            operacao = new Integer(dado);
            entrada.setOperacao(operacao);
            dado = linha1.substring(3, 8);
            identTerminal.setEstabelecimento(dado);
            dado = linha1.substring(8, 12);
            identTerminal.setLoja(dado);
            dado = linha1.substring(12, 15);
            identTerminal.setTerminal(dado);
            dado = linha1.substring(15, 16);
            dado = linha1.substring(16, 20);
            dado = linha1.substring(20, 28);
            try {
                date = new SimpleDateFormat("yyyyMMdd").parse(dado);
            }
            catch (ParseException e) {
                date = null;
            }
            entrada.setDataAbertura(date);
            dado = linha1.substring(28, 32);
            dado = linha1.substring(32, 34);
            dado = linha1.substring(34, 35);
        }
        catch (NumberFormatException e) {
            this.logger.error((Object)"Erro no conte\u00fado da primeira linha");
            throw new SyntaxError(1, 3);
        }
        return operacao;
    }

    private void parse2nd3rdLine(EntradaCTFClient entrada, IdentTerminal identTerminal, int operacao, String linha2, String linha3) throws SyntaxError {
        if (linha2.length() != 128) {
            throw new SyntaxError(2, 4);
        }
        if (!NumberUtil.isNumeric(linha2)) {
            throw new SyntaxError(2, 3);
        }
        this.posLinha3 = 0;
        int col = 0;
        String versaoAc = null;
        try {
            long dadoLong;
            int dadoInt;
            BigDecimal dadoBigDecimal;
            String dadoString;
            if (linha2.charAt(col) == '1') {
                dadoString = this.capturaDadoLinha(linha3, col).trim();
                entrada.setCodigoTransancao(dadoString);
            }
            if (linha2.charAt(++col) == '1') {
                dadoString = this.capturaDadoLinha(linha3, col);
                entrada.setNumeroCupom(dadoString);
            }
            if (linha2.charAt(++col) == '1') {
                this.capturaDadoLinha(linha3, col);
            }
            if (linha2.charAt(++col) == '1') {
                dadoBigDecimal = new BigDecimal(this.capturaDadoLinha(linha3, col));
                dadoBigDecimal = dadoBigDecimal.movePointLeft(2);
                entrada.setValorTransacao(dadoBigDecimal);
            }
            if (linha2.charAt(++col) == '1') {
                dadoString = this.capturaDadoLinha(linha3, col);
                entrada.setNumeroCartao(dadoString);
                if (operacao != 262 && operacao != 300 && !this.dadosCriptografados) {
                    this.logger.error((Object)"O N\u00famero do Cart\u00e3o s\u00f3 pode ser informado em integra\u00e7\u00f5es criptografadas");
                    throw new SyntaxError(3, 5, "O CARTAO DEVE SER CRIPTOGRAFADO", 1);
                }
            }
            if (linha2.charAt(++col) == '1') {
                dadoString = this.capturaDadoLinha(linha3, col);
                entrada.setInfo(dadoString);
            }
            Calendar calendar = Calendar.getInstance();
            if (linha2.charAt(++col) == '1') {
                dadoString = this.capturaDadoLinha(linha3, col);
                SimpleDateFormat dateFormat = new SimpleDateFormat("ddMMyyyyHHmmss");
                try {
                    Date dataTransacao = dateFormat.parse(dadoString);
                    calendar.setTime(dataTransacao);
                    entrada.setTimestamp(calendar.getTimeInMillis());
                }
                catch (ParseException e) {
                    throw new SyntaxError(3, 3, "TIMESTAMP DE FORMATO INVALIDO.");
                }
            }
            if (linha2.charAt(++col) == '1') {
                dadoString = this.capturaDadoLinha(linha3, col);
            }
            if (linha2.charAt(++col) == '1') {
                dadoInt = new Integer(this.capturaDadoLinha(linha3, col));
                entrada.setNumeroParcelas(dadoInt);
            }
            if (linha2.charAt(++col) == '1') {
                dadoString = this.capturaDadoLinha(linha3, col);
                String dadoFormato = dadoString.substring(2, 4) + dadoString.substring(0, 2);
                entrada.setDataVencimentoCartao(dadoFormato);
                if (!this.dadosCriptografados) {
                    this.logger.error((Object)"O vencimento do cart\u00e3o s\u00f3 pode ser informado em integra\u00e7\u00f5es criptografadas");
                    throw new SyntaxError(3, 5, "O VENCIMENTO DO CARTAO DEVE SER CRIPTOGRAFADO", 2);
                }
            }
            if (linha2.charAt(++col) == '1') {
                dadoString = this.capturaDadoLinha(linha3, col);
                Date date = new SimpleDateFormat("ddMMyyyy").parse(dadoString);
                entrada.setDataReferencia(date);
            }
            if (linha2.charAt(++col) == '1') {
                dadoBigDecimal = new BigDecimal(this.capturaDadoLinha(linha3, col));
                dadoBigDecimal = dadoBigDecimal.movePointLeft(2);
                entrada.setValorTaxaServico(dadoBigDecimal);
            }
            if (linha2.charAt(++col) == '1') {
                dadoBigDecimal = new BigDecimal(this.capturaDadoLinha(linha3, col));
                dadoBigDecimal = dadoBigDecimal.movePointLeft(2);
                entrada.setValorEntrada(dadoBigDecimal);
            }
            if (linha2.charAt(++col) == '1') {
                dadoInt = new Integer(this.capturaDadoLinha(linha3, col));
                entrada.setNsuCTF(dadoInt);
            }
            if (linha2.charAt(++col) == '1') {
                dadoString = this.capturaDadoLinha(linha3, col);
            }
            if (linha2.charAt(++col) == '1') {
                dadoString = this.capturaDadoLinha(linha3, col);
                entrada.setCheque(new Long(dadoString));
            }
            if (linha2.charAt(++col) == '1') {
                dadoInt = new Integer(this.capturaDadoLinha(linha3, col));
                entrada.setBanco(dadoInt);
            }
            if (linha2.charAt(++col) == '1') {
                dadoInt = new Integer(this.capturaDadoLinha(linha3, col));
                entrada.setAgencia(dadoInt);
            }
            int tipoDocumento = 0;
            if (linha2.charAt(++col) == '1') {
                tipoDocumento = dadoInt = new Integer(this.capturaDadoLinha(linha3, col)).intValue();
                entrada.setTipoDocumento(dadoInt);
            }
            if (linha2.charAt(++col) == '1') {
                String documento = null;
                dadoString = this.capturaDadoLinha(linha3, col);
                documento = tipoDocumento == 1 ? dadoString.substring(dadoString.length() - 14) : (tipoDocumento == 2 ? dadoString.substring(dadoString.length() - 11) : dadoString);
                entrada.setDocumento(documento);
            }
            if (linha2.charAt(++col) == '1') {
                dadoLong = new Long(this.capturaDadoLinha(linha3, col));
                entrada.setContaCorrente(dadoLong);
            }
            if (linha2.charAt(++col) == '1') {
                dadoString = this.capturaDadoLinha(linha3, col);
                if (operacao == 173 || operacao == 174) {
                    String tipoCreditoCompra;
                    String codUsuarioPdv;
                    int versaoLayoutCD = 1;
                    ConfCTFClient confCTFClient = null;
                    try {
                        confCTFClient = ControladorConfCTFClient.getInstance().getConfig();
                        versaoLayoutCD = confCTFClient.getVersaoLayoutCD();
                        if (versaoLayoutCD != 1 && versaoLayoutCD != 2 && versaoLayoutCD != 3) {
                            versaoLayoutCD = 1;
                        }
                    }
                    catch (ExcecaoApiAc e) {
                        this.logger.log((Priority)Level.ERROR, (Object)("Erro ao utlizar o arquivo de configura\u00e7\u00e3o. " + e.getMessage()));
                    }
                    int i = 0;
                    int tamCampo = 2;
                    String operadoraTelefonia = dadoString.substring(i, i + tamCampo);
                    if (!operadoraTelefonia.trim().equals("")) {
                        entrada.setCodigoOperadoraTelefonia(operadoraTelefonia);
                    }
                    i += tamCampo;
                    boolean dddSetado = false;
                    boolean telefoneSetado = false;
                    if (versaoLayoutCD == 1 || versaoLayoutCD == 2) {
                        String telefone;
                        tamCampo = 3;
                        String ddd = dadoString.substring(i, i + tamCampo);
                        if (!ddd.trim().equals("") && !ddd.equals("000")) {
                            entrada.setDdd(ddd.trim());
                            dddSetado = true;
                        }
                        if (!(telefone = dadoString.substring(i += tamCampo, i + (tamCampo = 8))).trim().equals("") && !telefone.equals("00000000")) {
                            entrada.setTelefone(telefone.trim());
                            telefoneSetado = true;
                        }
                        i += tamCampo;
                    } else if (versaoLayoutCD == 3) {
                        String telefone;
                        int tamTelefone;
                        String ddd;
                        tamCampo = 2;
                        int tamDdd = Integer.parseInt(dadoString.substring(i, i + tamCampo));
                        if (tamDdd > 0 && !(ddd = dadoString.substring(i += tamCampo, i + tamDdd)).trim().equals("") && !ddd.equals(StringUtil.completaString("", tamDdd, '0', 3))) {
                            entrada.setDdd(ddd.trim());
                            dddSetado = true;
                        }
                        if ((tamTelefone = Integer.parseInt(dadoString.substring(i += tamDdd, i + (tamCampo = 2)))) > 0 && !(telefone = dadoString.substring(i += tamCampo, i + tamTelefone)).trim().equals("") && !telefone.equals(StringUtil.completaString("", tamTelefone, '0', 3))) {
                            entrada.setTelefone(telefone.trim());
                            telefoneSetado = true;
                        }
                        i += tamTelefone;
                    }
                    if (!(dddSetado && telefoneSetado || !dddSetado && !telefoneSetado)) {
                        this.logger.error((Object)"O ddd e o telefone devem ser informados juntos, ou nenhum deles deve ser informado");
                        throw new SyntaxError(3, 3);
                    }
                    tamCampo = 2;
                    String digVerificador = dadoString.substring(i, i + tamCampo);
                    if (!digVerificador.trim().equals("") && Integer.parseInt(digVerificador.trim()) != 0) {
                        entrada.setDigitoVerificadorTelefone(Integer.parseInt(digVerificador.trim()));
                    }
                    if (!(codUsuarioPdv = dadoString.substring(i += tamCampo, i + (tamCampo = 10))).trim().equals("")) {
                        entrada.setCodigoUsuarioPdv(codUsuarioPdv.trim());
                    }
                    if (!(tipoCreditoCompra = dadoString.substring(i += tamCampo, i + (tamCampo = 2))).trim().equals("")) {
                        entrada.setTipoCreditoCompra(Integer.parseInt(tipoCreditoCompra.trim()));
                    }
                    i += tamCampo;
                } else if (operacao == 152 || operacao == 153 || operacao == 154 || operacao == 155 || operacao == 180 || operacao == 181) {
                    String cmc7;
                    int modalidadePagamento;
                    BigDecimal codigoBarras;
                    boolean modoEntradaSetado = false;
                    int modoEntrada = Integer.parseInt(dadoString.substring(0, 1));
                    if (modoEntrada > 0) {
                        entrada.setModoEntradaCodigoBarras(modoEntrada);
                        modoEntradaSetado = true;
                    }
                    if ((codigoBarras = new BigDecimal(dadoString.substring(1, 49))).compareTo(new BigDecimal(0)) > 0) {
                        if (modoEntradaSetado) {
                            entrada.setCodigoBarras(String.valueOf(codigoBarras));
                        } else {
                            this.logger.warn((Object)"C\u00f3digo de barras informado, mas modo de entrada nulo");
                            throw new SyntaxError(3, 1, "CODIGO DE BARRAS INFORMADO, MAS MODO DE ENTRADA NULO");
                        }
                    }
                    if ((modalidadePagamento = Integer.parseInt(dadoString.substring(49, 51))) > 0) {
                        entrada.setFormaPagamentoContas(modalidadePagamento);
                    }
                    if ((cmc7 = dadoString.substring(51, 85).trim()).length() > 0) {
                        entrada.setCmc7(cmc7);
                    }
                } else if (operacao == 129) {
                    boolean dddSetado = false;
                    String ddd = dadoString.substring(8, 11);
                    if (!ddd.trim().equals("") && !ddd.equals("000")) {
                        entrada.setDdd(ddd.trim());
                        dddSetado = true;
                    }
                    boolean telefoneSetado = false;
                    String telefone = dadoString.substring(11, 21);
                    if (!telefone.trim().equals("") && !telefone.equals("0000000000")) {
                        entrada.setTelefone(telefone.trim());
                        telefoneSetado = true;
                    }
                    if (!(dddSetado && telefoneSetado || !dddSetado && !telefoneSetado)) {
                        this.logger.warn((Object)"O DDD e o Telefone devem ser informados ou nenhum deles");
                        throw new SyntaxError(3, 3);
                    }
                } else if (operacao == 172) {
                    String dataNascimento;
                    String nomeCliente;
                    String codigoUsuario;
                    String tipoConsulta;
                    String codigoCliente = dadoString.substring(0, 15);
                    if (codigoCliente.trim().length() > 0) {
                        if (this.validaDadoNumerico(codigoCliente.trim())) {
                            entrada.setCodigoCliente(Integer.parseInt(codigoCliente));
                        } else {
                            this.logger.log((Priority)Level.ERROR, (Object)"Bit 62: C\u00f3digo do cliente n\u00e3o num\u00e9rico");
                            throw new NumberFormatException();
                        }
                    }
                    if ((tipoConsulta = dadoString.substring(15, 16)).trim().length() > 0) {
                        if (this.validaDadoNumerico(tipoConsulta)) {
                            entrada.setTipoConsultaSpc(Integer.parseInt(tipoConsulta));
                        } else {
                            this.logger.log((Priority)Level.ERROR, (Object)"Bit 62: Tipo da consulta n\u00e3o num\u00e9rico");
                            throw new NumberFormatException();
                        }
                    }
                    if (!(codigoUsuario = dadoString.substring(16, 26)).trim().equals("")) {
                        if (this.validaDadoNumerico(codigoUsuario)) {
                            entrada.setCodigoUsuarioPdv(codigoUsuario);
                        } else {
                            this.logger.log((Priority)Level.ERROR, (Object)"Bit 62: C\u00f3digo do usu\u00e1rio n\u00e3o num\u00e9rico");
                            throw new NumberFormatException();
                        }
                    }
                    if (!(nomeCliente = dadoString.substring(26, 66)).trim().equals("")) {
                        entrada.setNomeCliente(nomeCliente);
                    }
                    if ((dataNascimento = dadoString.substring(66, 74)).trim().length() > 0) {
                        try {
                            Date date = new SimpleDateFormat("ddMMyyyy").parse(dataNascimento);
                            entrada.setDataNascimentoCliente(date);
                        }
                        catch (ParseException e) {
                            this.logger.log((Priority)Level.ERROR, (Object)"Bit 62: Data inv\u00e1lida");
                        }
                    }
                } else if (operacao == 277) {
                    String timestamp = dadoString.substring(0, 14);
                    try {
                        Long.parseLong(timestamp);
                    }
                    catch (NumberFormatException e) {
                        this.logger.log((Priority)Level.ERROR, (Object)"Bit 62: Timestamp dos produtos promocionais n\u00e3o num\u00e9rico");
                        throw new NumberFormatException();
                    }
                    entrada.setTimestampProdutosPromocionais(timestamp);
                } else if (operacao == 278) {
                    int tamanhoRegistro = 30;
                    ArrayList<ProdutoPromocional> listProdutos = new ArrayList<ProdutoPromocional>();
                    for (int i = 0; i < dadoString.length() / tamanhoRegistro; ++i) {
                        int offset = i * tamanhoRegistro;
                        String bufferProduto = dadoString.substring(offset, offset + 30);
                        ProdutoPromocional produto = new ProdutoPromocional();
                        produto.setCodigoEAN(bufferProduto.substring(0, 20));
                        produto.setQuantidade(Integer.parseInt(bufferProduto.substring(20, 23)));
                        produto.setValorProduto(new BigDecimal(bufferProduto.substring(23, 30)).movePointLeft(2));
                        listProdutos.add(produto);
                    }
                    entrada.setListProdutosPromocionais(listProdutos);
                } else {
                    entrada.setInfoAdicionais(dadoString);
                }
            }
            if (linha2.charAt(++col) == '1') {
                dadoString = this.capturaDadoLinha(linha3, col);
                entrada.setCodigoAutorizacao(dadoString);
            }
            if (linha2.charAt(++col) == '1') {
                dadoString = this.capturaDadoLinha(linha3, col);
                entrada.setMedicamento(dadoString);
            }
            if (linha2.charAt(++col) == '1') {
                dadoString = this.capturaDadoLinha(linha3, col);
                entrada.setCodigoSeguraca(dadoString);
                if (!this.dadosCriptografados) {
                    this.logger.error((Object)"O c\u00f3digo de seguran\u00e7a s\u00f3 pode ser informado em integra\u00e7\u00f5es criptografadas");
                    throw new SyntaxError(3, 5, "O CODIGO DE SEGURANCA DEVE SER CRIPTOGRAFADO", 3);
                }
            }
            if (linha2.charAt(++col) == '1') {
                dadoBigDecimal = new BigDecimal(this.capturaDadoLinha(linha3, col));
                dadoBigDecimal = dadoBigDecimal.movePointLeft(2);
                entrada.setValorSaque(dadoBigDecimal);
            }
            if (linha2.charAt(++col) == '1') {
                dadoBigDecimal = new BigDecimal(this.capturaDadoLinha(linha3, col));
                dadoBigDecimal = dadoBigDecimal.movePointLeft(2);
                entrada.setValorTaxaEmbarque(dadoBigDecimal);
            }
            if (linha2.charAt(++col) == '1') {
                dadoInt = new Integer(this.capturaDadoLinha(linha3, col));
                entrada.setTipoGarantia(dadoInt);
            }
            if (linha2.charAt(++col) == '1') {
                dadoString = this.capturaDadoLinha(linha3, col);
            }
            if (linha2.charAt(++col) == '1') {
                dadoString = this.capturaDadoLinha(linha3, col);
                entrada.setCodigoAutorizadora(dadoString);
            }
            if (linha2.charAt(++col) == '1') {
                dadoString = this.capturaDadoLinha(linha3, col);
                entrada.setCmc7(dadoString);
            }
            if (linha2.charAt(++col) == '1') {
                dadoInt = new Integer(this.capturaDadoLinha(linha3, col));
                entrada.setPracaCompensacao(dadoInt);
            }
            if (linha2.charAt(++col) == '1') {
                dadoString = this.capturaDadoLinha(linha3, col);
                dadoInt = new Integer(dadoString);
                entrada.setNumeroTransacao(dadoInt);
            }
            if (linha2.charAt(++col) == '1') {
                dadoBigDecimal = new BigDecimal(this.capturaDadoLinha(linha3, col));
                dadoBigDecimal = dadoBigDecimal.movePointLeft(2);
                entrada.setValorDesconto(dadoBigDecimal);
            }
            if (linha2.charAt(++col) == '1') {
                dadoBigDecimal = new BigDecimal(this.capturaDadoLinha(linha3, col));
                dadoBigDecimal = dadoBigDecimal.movePointLeft(2);
                entrada.setValorAcrescimo(dadoBigDecimal);
            }
            if (linha2.charAt(++col) == '1') {
                versaoAc = dadoString = this.capturaDadoLinha(linha3, col).trim();
                entrada.setVersaoAc(dadoString);
            }
            if (linha2.charAt(++col) == '1') {
                dadoString = this.capturaDadoLinha(linha3, col);
                entrada.setNomeAc(dadoString);
            }
            if (linha2.charAt(++col) == '1') {
                dadoString = this.capturaDadoLinha(linha3, col).trim();
                entrada.setEndereco(dadoString);
            }
            if (linha2.charAt(++col) == '1') {
                dadoString = new Integer(this.capturaDadoLinha(linha3, col)).toString();
                entrada.setNumero(dadoString);
            }
            if (linha2.charAt(++col) == '1') {
                dadoString = this.capturaDadoLinha(linha3, col).trim();
                entrada.setComplemento(dadoString);
            }
            if (linha2.charAt(++col) == '1') {
                dadoString = this.capturaDadoLinha(linha3, col).trim();
                entrada.setBloco(dadoString);
            }
            if (linha2.charAt(++col) == '1') {
                dadoString = this.capturaDadoLinha(linha3, col).trim();
                entrada.setBairro(dadoString);
            }
            if (linha2.charAt(++col) == '1') {
                dadoString = this.capturaDadoLinha(linha3, col).trim();
                entrada.setCep(dadoString);
            }
            if (linha2.charAt(++col) == '1') {
                dadoString = new Integer(this.capturaDadoLinha(linha3, col)).toString();
                entrada.setCiclosPular(Integer.parseInt(dadoString));
            }
            if (linha2.charAt(++col) == '1') {
                dadoString = new Integer(this.capturaDadoLinha(linha3, col)).toString();
                entrada.setNumeroPlano(dadoString);
            }
            if (linha2.charAt(++col) == '1') {
                dadoString = new Integer(this.capturaDadoLinha(linha3, col)).toString();
                entrada.setNumeroItem(dadoString);
            }
            if (linha2.charAt(++col) == '1') {
                dadoString = this.capturaDadoLinha(linha3, col).trim();
                entrada.setCodigoBarras(dadoString);
            }
            if (linha2.charAt(++col) == '1') {
                dadoInt = new Integer(this.capturaDadoLinha(linha3, col));
                entrada.setModoEntradaCodigoBarras(dadoInt);
            }
            ++col;
            if (operacao == 5) {
                String[] listaParametrosTemp;
                this.config.setEstabelecimento(identTerminal.getEstabelecimento());
                this.config.setLoja(identTerminal.getLoja());
                this.config.setTerminal(identTerminal.getTerminal());
                if (linha2.charAt(col) == '1') {
                    dadoString = this.capturaDadoLinha(linha3, col);
                    this.config.setHostClient(dadoString);
                    dadoString = Integer.valueOf(linha3.substring(this.posLinha3, this.posLinha3 + 5)).toString();
                    this.config.setPortClient(dadoString);
                    this.posLinha3 += 5;
                }
                this.config.setVersaoAC(versaoAc);
                if (linha2.charAt(++col) == '1') {
                    if (Integer.parseInt(linha3.substring(this.posLinha3, this.posLinha3 + 3)) != 0) {
                        this.posLinha3 += 3;
                    }
                    try {
                        LinkedHashSet<ServicoCTF> ips = new LinkedHashSet<ServicoCTF>();
                        int colCollection = this.posLinha3;
                        int offset = 0;
                        while (!linha3.substring(colCollection, colCollection + 2).equals("00")) {
                            offset = Integer.valueOf(linha3.substring(colCollection, colCollection + 2));
                            String ip = linha3.substring(colCollection += 2, offset + colCollection);
                            String porta = Integer.valueOf(linha3.substring(colCollection += offset, colCollection + 5)).toString();
                            String protocolo = linha3.substring(colCollection += 5, colCollection + 4).trim();
                            colCollection += 4;
                            Host host = new Host(ip);
                            ServicoCTF servico = new ServicoCTF(host, porta, protocolo);
                            ips.add(servico);
                        }
                        this.config.setIps(ips);
                        this.posLinha3 = colCollection += 2;
                    }
                    catch (ExcecaoParametroInvalido e) {
                        this.logger.error((Object)"Campo ips da terceira linha cont\u00e9m host's ou ip's inv\u00e1lidos");
                        throw new SyntaxError(3, 3);
                    }
                }
                if (linha2.charAt(++col) == '1') {
                    ConfPeriferico teclado;
                    dadoString = this.capturaDadoLinha(linha3, col).trim();
                    if (dadoString.equalsIgnoreCase("TECLADO_PC")) {
                        teclado = new ConfPeriferico("TECLADO_PC");
                    } else if (dadoString.equalsIgnoreCase("TECLADO_JAVAPOS")) {
                        teclado = new ConfPeriferico("TECLADO_JAVAPOS");
                    } else {
                        this.logger.error((Object)"Constante para sele\u00e7\u00e3o do driver de teclado n\u00e3o encontrada");
                        throw new SyntaxError(3, 3);
                    }
                    if (linha2.charAt(++col) == '1') {
                        dadoString = this.capturaDadoLinha(linha3, col).trim();
                        teclado.setParametros(dadoString.split(","));
                    }
                    this.config.setTeclado(teclado);
                } else if (linha2.charAt(++col) == '1') {
                    this.pulaColunaLVar(linha3, col);
                }
                if (linha2.charAt(++col) == '1') {
                    dadoString = this.capturaDadoLinha(linha3, col).trim();
                    if (!(dadoString.equalsIgnoreCase("DISPLAY_CTFCLIENT") || dadoString.equalsIgnoreCase("DISPLAY_JAVAPOS") || dadoString.equalsIgnoreCase("DISPLAY_AUTTAR") || dadoString.equalsIgnoreCase("DISPLAY_CSI"))) {
                        this.logger.error((Object)"Constante para sele\u00e7\u00e3o do driver de display do operador n\u00e3o encontrada");
                        throw new SyntaxError(3, 3);
                    }
                    ConfPeriferico displayOperador = new ConfPeriferico(dadoString);
                    if (linha2.charAt(++col) == '1') {
                        dadoString = this.capturaDadoLinha(linha3, col).trim();
                        displayOperador.setParametros(dadoString.split(","));
                    }
                } else if (linha2.charAt(++col) == '1') {
                    this.pulaColunaLVar(linha3, col);
                }
                if (linha2.charAt(++col) == '1') {
                    dadoString = this.capturaDadoLinha(linha3, col).trim();
                    if (!(dadoString.equalsIgnoreCase("DISPLAY_CTFCLIENT") || dadoString.equalsIgnoreCase("DISPLAY_JAVAPOS") || dadoString.equalsIgnoreCase("DISPLAY_AUTTAR"))) {
                        this.logger.error((Object)"Constante para sele\u00e7\u00e3o do driver de display do cliente n\u00e3o encontrada");
                        throw new SyntaxError(3, 3);
                    }
                    ConfPeriferico displayCliente = new ConfPeriferico(dadoString);
                    if (linha2.charAt(++col) == '1') {
                        dadoString = this.capturaDadoLinha(linha3, col).trim();
                        displayCliente.setParametros(dadoString.split(","));
                    }
                    this.config.setDisplayCliente(displayCliente);
                } else if (linha2.charAt(++col) == '1') {
                    this.pulaColunaLVar(linha3, col);
                }
                if (linha2.charAt(++col) == '1') {
                    dadoString = this.capturaDadoLinha(linha3, col).trim();
                    if (!dadoString.equalsIgnoreCase("LEITOR_CARTAO_BIB_COMPARTILHADA")) {
                        this.logger.error((Object)"Constante para sele\u00e7\u00e3o do driver de leitor do cart\u00e3o n\u00e3o encontrada");
                        throw new SyntaxError(3, 3);
                    }
                    ++col;
                } else {
                    ++col;
                }
                if (linha2.charAt(col) == '1') {
                    dadoString = this.capturaDadoLinha(linha3, col).trim();
                    ConfPeriferico configLeitorCartao = new ConfPeriferico("PARAMS_LEITOR_CARTAO");
                    listaParametrosTemp = dadoString.split(",");
                    String[] listaParametros = this.removeSpacesArray(listaParametrosTemp);
                    configLeitorCartao.setNomeClasse("com.csi.ctfclient.tools.devices.LeitorCartaoHandler");
                    configLeitorCartao.setParametros(listaParametros);
                    this.config.setLeitorCartao(configLeitorCartao);
                }
                if (linha2.charAt(++col) == '1') {
                    dadoString = this.capturaDadoLinha(linha3, col).trim();
                    if (!dadoString.equalsIgnoreCase("PINPAD_BIB_COMPARTILHADA")) {
                        this.logger.error((Object)"Constante para sele\u00e7\u00e3o do driver de pinpad n\u00e3o encontrada");
                        throw new SyntaxError(3, 3);
                    }
                    ++col;
                } else {
                    ++col;
                }
                if (linha2.charAt(col) == '1') {
                    dadoString = this.capturaDadoLinha(linha3, col).trim();
                    ConfPeriferico configPinPad = new ConfPeriferico("PARAMS_PINPAD");
                    configPinPad.setNomeClasse("com.csi.ctfclient.tools.devices.emvfull.BibliotecaPinpad");
                    listaParametrosTemp = dadoString.split(",");
                    String[] listaParametros = this.removeSpacesArray(listaParametrosTemp);
                    configPinPad.setParametros(listaParametros);
                    this.config.setPin(configPinPad);
                }
                if (linha2.charAt(++col) == '1') {
                    dadoString = this.capturaDadoLinha(linha3, col).trim();
                    if (!dadoString.equalsIgnoreCase("SCANNER_SERIAL") && !dadoString.equalsIgnoreCase("SCANNER_JAVAPOS")) {
                        this.logger.error((Object)"Constante para sele\u00e7\u00e3o do driver de scanner n\u00e3o encontrada");
                        throw new SyntaxError(3, 3);
                    }
                    ConfPeriferico scanner = new ConfPeriferico(dadoString);
                    if (linha2.charAt(++col) == '1') {
                        dadoString = this.capturaDadoLinha(linha3, col).trim();
                        scanner.setParametros(dadoString.split(","));
                    }
                    this.config.setScanner(scanner);
                } else if (linha2.charAt(++col) == '1') {
                    this.pulaColunaLVar(linha3, col);
                }
                if (linha2.charAt(++col) == '1') {
                    dadoString = this.capturaDadoLinha(linha3, col).trim();
                    if (!(dadoString.equalsIgnoreCase("LEITOR_DOCUMENTO_CHRONOS") || dadoString.equalsIgnoreCase("LEITOR_DOCUMENTO_LOGGER2") || dadoString.equalsIgnoreCase("LEITOR_DOCUMENTO_TECPOINTTL840"))) {
                        this.logger.error((Object)"Constante para sele\u00e7\u00e3o do driver de leitor de documento n\u00e3o encontrada");
                        throw new SyntaxError(3, 3);
                    }
                    ConfPeriferico leitorDocumento = new ConfPeriferico(dadoString);
                    if (linha2.charAt(++col) == '1') {
                        dadoString = this.capturaDadoLinha(linha3, col).trim();
                        leitorDocumento.setParametros(dadoString.split(","));
                    } else {
                        ++col;
                    }
                    this.config.setLeitorDocumento(leitorDocumento);
                } else if (linha2.charAt(++col) == '1') {
                    this.pulaColunaLVar(linha3, col);
                }
                if (linha2.charAt(++col) == '1') {
                    dadoInt = new Integer(this.capturaDadoLinha(linha3, col));
                    this.config.setIntegracaoCriptografada(dadoInt == 1);
                }
                ++col;
            } else {
                col += 17;
            }
            if (linha2.charAt(col) == '1') {
                dadoInt = new Integer(this.capturaDadoLinha(linha3, col));
                entrada.setFormaPagamentoContas(dadoInt);
            }
            if (linha2.charAt(++col) == '1') {
                dadoInt = Integer.parseInt(this.capturaDadoLinha(linha3, col).trim());
                entrada.setModoEntradaCartao(dadoInt);
            }
            if (linha2.charAt(++col) == '1') {
                dadoInt = new Integer(this.capturaDadoLinha(linha3, col));
                if (operacao == 5) {
                    this.config.setCapturaCmc7(dadoInt == 1);
                }
            }
            if (linha2.charAt(++col) == '1') {
                dadoString = this.capturaDadoLinha(linha3, col);
                entrada.setDataEmissao(dadoString);
            }
            boolean dddSetado = false;
            if (linha2.charAt(++col) == '1') {
                dadoString = this.capturaDadoLinha(linha3, col).trim();
                entrada.setDdd(dadoString);
                dddSetado = true;
                if (!this.dadosCriptografados) {
                    throw new SyntaxError(3, 5, "O DDD DEVE SER CRIPTOGRAFADO", 4);
                }
            }
            boolean telefoneSetado = false;
            if (linha2.charAt(++col) == '1') {
                dadoString = this.capturaDadoLinha(linha3, col).trim();
                entrada.setTelefone(dadoString);
                telefoneSetado = true;
                if (!this.dadosCriptografados) {
                    throw new SyntaxError(3, 5, "O TELEFONE DEVE SER CRIPTOGRAFADO", 5);
                }
            }
            ++col;
            if (!(dddSetado && telefoneSetado || !dddSetado && !telefoneSetado)) {
                this.logger.warn((Object)"O DDD e o Telefone devem ser informados ou nenhum deles");
                throw new SyntaxError(3, 3, "O DDD E O TELEFONE DEVEM SER INFORMADOS OU NENHUM DELES");
            }
            if (linha2.charAt(col) == '1') {
                dadoString = this.capturaDadoLinha(linha3, col);
            }
            if (linha2.charAt(++col) == '1') {
                dadoString = this.capturaDadoLinha(linha3, col);
            }
            if (linha2.charAt(++col) == '1') {
                dadoInt = new Integer(this.capturaDadoLinha(linha3, col));
                entrada.setMultitransacaoWeb(dadoInt == 1);
            }
            if (linha2.charAt(++col) == '1') {
                dadoString = this.capturaDadoLinha(linha3, col).trim();
                entrada.setCodigoMultitransacao(dadoString);
            }
            if (linha2.charAt(++col) == '1') {
                dadoInt = new Integer(this.capturaDadoLinha(linha3, col));
                entrada.setCodigoTabela(dadoInt);
            }
            if (linha2.charAt(++col) == '1') {
                dadoInt = new Integer(this.capturaDadoLinha(linha3, col));
                entrada.setUtilizaSaldoVoucher(dadoInt == 1);
            }
            if (linha2.charAt(++col) == '1') {
                dadoInt = new Integer(this.capturaDadoLinha(linha3, col));
                if (operacao == 5) {
                    this.config.setCreditoCelularHabilitado(dadoInt == 1);
                }
            }
            ++col;
            if (linha2.charAt(++col) == '1') {
                dadoString = this.capturaDadoLinha(linha3, col).trim();
                entrada.setMatriculaOperador(dadoString);
            }
            if (linha2.charAt(++col) == '1') {
                dadoInt = new Integer(this.capturaDadoLinha(linha3, col));
                entrada.setCodigoOrigemTransacao(dadoInt);
            }
            ++col;
            if (linha2.charAt(++col) == '1') {
                dadoInt = new Integer(this.capturaDadoLinha(linha3, col));
                entrada.setRg(dadoInt);
            }
            if (linha2.charAt(++col) == '1') {
                dadoString = this.capturaDadoLinha(linha3, col).trim();
                entrada.setTelefoneFixo(dadoString);
            }
            if (linha2.charAt(++col) == '1') {
                dadoString = this.capturaDadoLinha(linha3, col).trim();
                entrada.setTelefoneMovel(dadoString);
            }
            if (linha2.charAt(++col) == '1') {
                dadoString = this.capturaDadoLinha(linha3, col).trim();
                entrada.setCodigoVoucher(dadoString);
            }
            if (linha2.charAt(++col) == '1') {
                dadoString = this.capturaDadoLinha(linha3, col).trim();
                entrada.setPedido(dadoString);
            }
            if (linha2.charAt(++col) == '1') {
                dadoInt = new Integer(this.capturaDadoLinha(linha3, col));
                entrada.setTipoAutorizadora(dadoInt);
            }
            if (linha2.charAt(++col) == '1') {
                dadoInt = new Integer(this.capturaDadoLinha(linha3, col));
                this.config.setAcSuportaPlataformaPromocional(dadoInt == 1);
            }
            if (linha2.charAt(++col) == '1') {
                dadoInt = new Integer(this.capturaDadoLinha(linha3, col));
                entrada.setTipoCapturaPreAutorizacao(dadoInt);
            }
            if (linha2.charAt(++col) == '1') {
                dadoString = this.capturaDadoLinha(linha3, col).trim();
                entrada.setTipoProduto(dadoString);
            }
            if (linha2.charAt(++col) == '1') {
                dadoString = this.capturaDadoLinha(linha3, col).trim();
                entrada.setCodigoTerminalOriginal(dadoString);
            }
            if (linha2.charAt(++col) == '1') {
                dadoString = this.capturaDadoLinha(linha3, col).trim();
                entrada.setMad(dadoString);
            }
            if (linha2.charAt(++col) == '1') {
                int offset = 0;
                offset = Integer.valueOf(linha3.substring(this.posLinha3, this.posLinha3 + 2));
                this.posLinha3 += 2;
                String ipFusion = linha3.substring(this.posLinha3, this.posLinha3 + offset);
                this.posLinha3 += offset;
                int portaFusion = Integer.parseInt(linha3.substring(this.posLinha3, this.posLinha3 + 5));
                this.posLinha3 += 5;
                this.config.setIpFusion(ipFusion);
                this.config.setPortaFusion(portaFusion);
            }
            if (linha2.charAt(++col) == '1') {
                dadoInt = new Integer(this.capturaDadoLinha(linha3, col));
                entrada.setConsulta(dadoInt == 1);
            }
            if (linha2.charAt(++col) == '1') {
                dadoLong = Long.parseLong(this.capturaDadoLinha(linha3, col));
                entrada.setIdentConsulta(dadoLong);
            }
            ++col;
            ++col;
            if (linha2.charAt(++col) == '1') {
                dadoInt = new Integer(this.capturaDadoLinha(linha3, col));
                entrada.setFormaIdentificacaoPagamentoFatura(dadoInt);
            }
            ++col;
            if (linha2.charAt(++col) == '1') {
                dadoInt = new Integer(this.capturaDadoLinha(linha3, col));
                entrada.setTipoCapturaDadosPinpad(dadoInt);
            }
        }
        catch (NumberFormatException e) {
            this.logger.error((Object)("Erro na convers\u00e3o num\u00e9rica na terceira linha. erro no bit= " + (col + 1)));
            throw new SyntaxError(3, 3);
        }
        catch (ParseException e) {
            this.logger.error((Object)("ParseException na terceira linha. erro no bit= " + (col + 1)));
            throw new SyntaxError(3, 1);
        }
        catch (StringIndexOutOfBoundsException e) {
            this.logger.error((Object)("A terceira linha n\u00e3o possui o tamanho esperado. erro no bit= " + (col + 1) + ", tamanho= " + this.tamDado[col]));
            throw new SyntaxError(3, 4);
        }
    }

    private String capturaDadoLinha(String linha, int col) {
        int tam = this.tamDado[col];
        if (tam < 0) {
            int tamVar = Math.abs(tam);
            String tamStr = linha.substring(this.posLinha3, this.posLinha3 + tamVar);
            tam = Integer.parseInt(tamStr);
            this.posLinha3 += tamVar;
        }
        String dadoLinha = linha.substring(this.posLinha3, this.posLinha3 + tam);
        this.posLinha3 += tam;
        return dadoLinha;
    }

    private void pulaColunaLVar(String linha, int col) {
        int tam = this.tamDado[col];
        if (tam < 0) {
            int tamVar = Math.abs(tam);
            String tamStr = linha.substring(this.posLinha3, this.posLinha3 + tamVar);
            tam = Integer.parseInt(tamStr);
            this.posLinha3 += tamVar;
        } else {
            throw new IllegalArgumentException("O m\u00e9todo apenas poder\u00e1 ser usado para colunas de tamanho vari\u00e1vel");
        }
        this.posLinha3 += tam;
    }

    public ParserInputCSI(Map map) {
        super(map);
    }

    public void parseStream(InputStream stream, boolean dadosCriptografados) throws SyntaxError, TimeoutException {
        this.dadosCriptografados = dadosCriptografados;
        ConfCTFClient confCTFClient = null;
        try {
            confCTFClient = ControladorConfCTFClient.getInstance().getConfig();
        }
        catch (ExcecaoApiAc e) {
            this.logger.error((Object)e.getMessage());
        }
        String linha1 = "";
        String linha2 = "";
        String linha3 = "";
        InputStreamReader isr = new InputStreamReader(stream);
        LineNumberReader reader = new LineNumberReader(isr);
        try {
            linha1 = reader.readLine();
        }
        catch (Exception e) {
            this.logger.error((Object)"Problemas na conex\u00e3o ou timeout na leitura do posentra");
            throw new TimeoutException();
        }
        boolean configuracaoTerminal = false;
        if (confCTFClient.isIntegracaoDll() && linha1.length() > 3 && linha1.substring(0, 3).equals("800")) {
            configuracaoTerminal = true;
        }
        if (confCTFClient != null && confCTFClient.isIntegracaoDll() && !configuracaoTerminal) {
            try {
                linha1 = linha1.substring(4, linha1.length());
                linha2 = reader.readLine();
                linha3 = reader.readLine();
            }
            catch (Exception e) {
                this.logger.error((Object)"Problemas na conex\u00e3o ou timeout");
                throw new TimeoutException();
            }
        }
        try {
            linha2 = reader.readLine();
            linha3 = reader.readLine();
        }
        catch (Exception e) {
            this.logger.error((Object)"Problemas na conex\u00e3o ou timeout");
            throw new TimeoutException();
        }
        this.entrada = new EntradaCTFClient();
        if (confCTFClient.isIntegracaoDll()) {
            this.entrada.setConfigTerminalInterno(configuracaoTerminal);
        }
        this.identTerminal = new IdentTerminal();
        this.config = new ConfCTFClient();
        int operacao = this.parse1stLine(this.entrada, this.identTerminal, linha1);
        this.parse2nd3rdLine(this.entrada, this.identTerminal, operacao, linha2, linha3);
    }

    public EntradaCTFClient getEntrada() {
        return this.entrada;
    }

    public IdentTerminal getIdentTerminal() {
        return this.identTerminal;
    }

    public ConfCTFClient getConfig() {
        return this.config;
    }

    private String[] removeSpacesArray(String[] arrayOrigem) {
        String[] listaParametros = new String[arrayOrigem.length];
        for (int i = 0; i < arrayOrigem.length; ++i) {
            if (arrayOrigem[i] == null) continue;
            listaParametros[i] = arrayOrigem[i].trim();
        }
        return listaParametros;
    }

    private boolean validaDadoNumerico(String dado) {
        try {
            Integer.parseInt(dado);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }
}

