/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.integracao;

import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.config.ConfCTFClient;
import com.csi.ctfclient.config.ControladorConfCTFClient;
import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.integracao.ConstantesIntegracaoCSI;
import com.csi.ctfclient.integracao.ParserOutput;
import com.csi.ctfclient.integracao.SyntaxError;
import com.csi.ctfclient.operacoes.model.ProdutoPromocional;
import com.csi.ctfclient.servicos.RespostaAtivacaoCartaoPrepago;
import com.csi.ctfclient.servicos.RespostaBypass;
import com.csi.ctfclient.servicos.RespostaCompraCreditoDigital;
import com.csi.ctfclient.servicos.RespostaConsultaAnaliticaSPC;
import com.csi.ctfclient.servicos.RespostaConsultaAvs;
import com.csi.ctfclient.servicos.RespostaConsultaConfiguracao;
import com.csi.ctfclient.servicos.RespostaConsultaValoresCreditoDigital;
import com.csi.ctfclient.servicos.RespostaCorrespondenteBancario;
import com.csi.ctfclient.servicos.RespostaOperacaoCheque;
import com.csi.ctfclient.servicos.RespostaPagamentoFaturaCartao;
import com.csi.ctfclient.servicos.RespostaProdutosPromocionais;
import com.csi.ctfclient.servicos.RespostaSimulacaoCrediario;
import com.csi.ctfclient.servicos.RespostaTransacoesSAA;
import com.csi.ctfclient.servicos.RespostaValeGas;
import com.csi.ctfclient.servicos.SaidaCTFClient;
import com.csi.ctfclient.tools.communication.Host;
import com.csi.ctfclient.tools.communication.ServicoCTF;
import com.csi.ctfclient.tools.devices.ControladorTranslator;
import com.csi.ctfclient.tools.util.StringUtil;
import com.csi.ctfclient.tools.util.logger.CTFClientLogger;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class ParserOutputCSI
extends ParserOutput
implements ConstantesIntegracaoCSI {
    private Logger logger = CTFClientLogger.getIntegrador();
    private OutputStream outStr;
    private int[] tamCampo = new int[]{3, 5, 4, 3, 40, 2, 4, 3, 19, 4, 6, 6, 9, 20, 2, 12, 2, 12, 4, 12, 2, 38, 12, 8, 6, 2, 2, 16, 2, 6, 12, 1, 12, 8, 12, 8, 50, 12, 12, 12, 12, 5, 4, 12, 9, 15, 1, 30, 19, 30, 2, 8};
    private int[] tipoCampo = new int[]{1, 1, 1, 1, 2, 1, 1, 2, 2, 1, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 2, 2, 1, 1, 1, 1, 2, 2, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 2, 1, 1, 1, 2, 1, 2, 1, 1, 2, 1, 2, 2, 1};
    private int[] tamCampoConsultaAvs = new int[]{1, 16};
    private int[] tipoCampoConsultaAvs = new int[]{2, 1};
    private int[] tamCampoCorrespondenteBancario = new int[]{40, 6, 8, 17, 29, 16, 12, 12, 12, 8, 1, 48, 2, 34};
    private int[] tipoCampoCorrespondenteBancario = new int[]{2, 1, 1, 2, 2, 2, 1, 1, 1, 1, 1, 1, 1, 2};
    private int[] tamCampoPagamentoFatura = new int[]{40, 6, 8, 17, 12, 12, 5, 16, 12, 12, 12, 6, 16, 1, 48, 2, 34};
    private int[] tipoCampoPagamentoFatura = new int[]{2, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 2};
    private int[] tamCampoConsultaValorCreditoDigital = new int[]{2, 11, 10, 10, 2, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 2, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10};
    private int[] tipoCampoConsultaValorCreditoDigital = new int[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1};
    private int[] tamCampoCompraCreditoDigitalLayout3 = new int[]{2, -2, -2};
    private int[] tipoCampoCompraCreditoDigitalLayout3 = new int[]{1, 1, 1};
    private int[] tamCampoCompraCreditoDigitalLayout1 = new int[]{2, 3, 8};
    private int[] tipoCampoCompraCreditoDigitalLayout1 = new int[]{1, 1, 1};
    private int[] tamCampoConsultaValorCreditoDigital2 = new int[]{2, 11, 10, 10, 2, -4};
    private int[] tipoCampoConsultaValorCreditoDigital2 = new int[]{1, 1, 1, 1, 1, 2};
    private int[] tamCampoConsultaConfiguracao = new int[]{10, -2, -3, 40, -3, 40, -3, 40, -3, 40, -3, 40, -3, 40, -3, 40, -3, 1, 1, 1};
    private int[] tipoCampoConsultaConfiguracao = new int[]{2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2};
    private int[] tamCampoValeGas = new int[]{7, 15, 15};
    private int[] tipoCampoValeGas = new int[]{1, 2, 1};
    private int[] tamCampoTefDiscOperacaoCheque = new int[]{34, 1, 17, 8, 4, 4, 10};
    private int[] tipoCampoTefDiscOperacaoCheque = new int[]{2, 1, 1, 1, 1, 1, 1};
    private int[] tamCampoConsultaAnaliticaSpc = new int[]{83};
    private int[] tipoCampoConsultaAnaliticaSpc = new int[]{2};
    private int[] tamCampoAtivacaoCartaoPrepago = new int[]{60};
    private int[] tipoCampoAtivacaoCartaoPrepago = new int[]{2};

    public String formatLL(int tam, String campo) {
        int tamCampo;
        if (campo == null) {
            campo = "";
        }
        String strTam = (tamCampo = campo.length()) < 10 ? "0" + tamCampo : "" + tamCampo;
        return strTam + StringUtil.completaString(campo, tam, ' ', 4);
    }

    public String formatLLL(int tam, String campo) {
        int tamCampo = campo.length();
        String strTam = "";
        strTam = tamCampo < 10 ? "00" + tamCampo : (tamCampo < 100 ? "0" + tamCampo : "" + tamCampo);
        return strTam + StringUtil.completaString(campo, tam - 3, ' ', true);
    }

    public String formatLLLL(int tam, String campo) {
        int tamCampo = campo.length();
        String strTam = "";
        strTam = tamCampo < 100 ? "000" + tamCampo : (tamCampo < 10 ? "00" + tamCampo : (tamCampo < 100 ? "0" + tamCampo : "" + tamCampo));
        return strTam + StringUtil.completaString(campo, tam - 3, ' ', true);
    }

    public void montaStream(SaidaCTFClient saida) throws SyntaxError {
        int col = 0;
        int ultimaLinha = 1;
        DecimalFormat df = null;
        Calendar calendar = Calendar.getInstance();
        try {
            StringBuffer buffer = new StringBuffer();
            String codigoOperacao = String.valueOf(saida.getOperacao());
            buffer.append(this.format(this.tamCampo[col], saida.getOperacao(), this.tipoCampo[col]));
            buffer.append(this.format(this.tamCampo[++col], saida.getEstabelecimento(), this.tipoCampo[col]));
            buffer.append(this.format(this.tamCampo[++col], saida.getLoja(), this.tipoCampo[col]));
            buffer.append(this.format(this.tamCampo[++col], saida.getTerminal(), this.tipoCampo[col]));
            buffer.append(this.formatLL(this.tamCampo[++col], saida.getDocumento()));
            buffer.append(this.format(this.tamCampo[++col], saida.getCodigoRetorno(), this.tipoCampo[col]));
            buffer.append(this.format(this.tamCampo[++col], saida.getCodigoErro(), this.tipoCampo[col]));
            buffer.append(this.format(this.tamCampo[++col], saida.getCodigoRespAutorizadora(), this.tipoCampo[col]));
            String cartao = this.format(this.tamCampo[++col], saida.getNumeroCartao(), this.tipoCampo[col]);
            int tamCartao = cartao.trim().length();
            cartao = tamCartao > 10 ? tamCartao + cartao : "0" + tamCartao + cartao;
            buffer.append(cartao);
            buffer.append(this.format(this.tamCampo[++col], saida.getDataVencimentoCartao(), this.tipoCampo[col]));
            buffer.append(this.format(this.tamCampo[++col], saida.getNsuCTF(), this.tipoCampo[col]));
            buffer.append(this.format(this.tamCampo[++col], saida.getCodigoAprovacao(), this.tipoCampo[col]));
            buffer.append(this.format(this.tamCampo[++col], saida.getNsuAutorizadora(), this.tipoCampo[col]));
            buffer.append(this.format(this.tamCampo[++col], saida.getNomeOperacao(), this.tipoCampo[col]));
            buffer.append(this.format(this.tamCampo[++col], saida.getCodigoAutorizadora(), this.tipoCampo[col]));
            buffer.append(this.format(this.tamCampo[++col], saida.getNomeAutorizadora(), this.tipoCampo[col]));
            buffer.append(this.format(this.tamCampo[++col], saida.getCodigoVan(), this.tipoCampo[col]));
            buffer.append(this.format(this.tamCampo[++col], saida.getNomeVan(), this.tipoCampo[col]));
            buffer.append(this.format(this.tamCampo[++col], saida.getCodigoInstFinanceira(), this.tipoCampo[col]));
            buffer.append(this.format(this.tamCampo[++col], saida.getNomeInstFinanceira(), this.tipoCampo[col]));
            buffer.append(this.format(this.tamCampo[++col], saida.getCodigoTransacaoCanceladaCTF(), this.tipoCampo[col]));
            buffer.append(this.formatLL(this.tamCampo[++col], ""));
            buffer.append(this.format(this.tamCampo[++col], saida.getValorTransacao(), this.tipoCampo[col]));
            ++col;
            String dataTransacaoFormatada = "";
            String horaTransacaoFormatada = "";
            boolean dataHoraSetado = false;
            if (codigoOperacao.equals("226")) {
                calendar.setTimeInMillis(saida.getIdentConsulta());
                dataHoraSetado = true;
            } else if (saida.getHorarioTransacao() != null) {
                calendar.setTime(saida.getHorarioTransacao());
                dataHoraSetado = true;
            }
            if (dataHoraSetado) {
                df = new DecimalFormat("00");
                dataTransacaoFormatada = df.format(calendar.get(5)) + df.format(calendar.get(2) + 1) + String.valueOf(calendar.get(1));
                horaTransacaoFormatada = df.format(calendar.get(11)) + df.format(calendar.get(12)) + df.format(calendar.get(13));
            }
            buffer.append(this.format(this.tamCampo[col], dataTransacaoFormatada, this.tipoCampo[col]));
            buffer.append(this.format(this.tamCampo[++col], horaTransacaoFormatada, this.tipoCampo[col]));
            buffer.append(this.format(this.tamCampo[++col], saida.getNumeroTransacao(), this.tipoCampo[col]));
            buffer.append(this.format(this.tamCampo[++col], saida.getCodigoTransacaoCTF(), this.tipoCampo[col]));
            buffer.append(this.format(this.tamCampo[++col], saida.getInformacaoCriptografada(), this.tipoCampo[col]));
            buffer.append(this.format(this.tamCampo[++col], saida.getNumeroParcelas(), this.tipoCampo[col]));
            buffer.append(this.format(this.tamCampo[++col], saida.getNsuCTFOriginal(), this.tipoCampo[col]));
            buffer.append(this.format(this.tamCampo[++col], saida.getValorEntrada(), this.tipoCampo[col]));
            buffer.append(this.format(this.tamCampo[++col], saida.getTipoGarantia(), this.tipoCampo[col]));
            buffer.append(this.format(this.tamCampo[++col], saida.getValorSaque(), this.tipoCampo[col]));
            ++col;
            String data1aParcelaFormatada = null;
            if (saida.getData1aParcela() != null) {
                df = new DecimalFormat("00");
                calendar.setTime(saida.getData1aParcela());
                data1aParcelaFormatada = df.format(calendar.get(5)) + df.format(calendar.get(2) + 1) + String.valueOf(calendar.get(1));
            }
            buffer.append(this.format(this.tamCampo[col], data1aParcelaFormatada, this.tipoCampo[col]));
            buffer.append(this.format(this.tamCampo[++col], saida.getValorParcela(), this.tipoCampo[col]));
            ++col;
            String dataTransacaoOriginal = null;
            if (saida.getDataTransacaoOrig() != null) {
                df = new DecimalFormat("00");
                calendar.setTime(saida.getDataTransacaoOrig());
                dataTransacaoOriginal = df.format(calendar.get(5)) + df.format(calendar.get(2) + 1) + String.valueOf(calendar.get(1));
            }
            buffer.append(this.format(this.tamCampo[col], dataTransacaoOriginal, this.tipoCampo[col]));
            buffer.append(this.format(this.tamCampo[++col], saida.getLogomarca(), this.tipoCampo[col]));
            buffer.append(this.format(this.tamCampo[++col], saida.getSaldoCliente(), this.tipoCampo[col]));
            buffer.append(this.format(this.tamCampo[++col], saida.getCodigoMultitransacao(), this.tipoCampo[col]));
            buffer.append(this.format(this.tamCampo[++col], saida.getValorParcela(), this.tipoCampo[col]));
            buffer.append(this.format(this.tamCampo[++col], saida.getValorTotal(), this.tipoCampo[col]));
            buffer.append(this.format(this.tamCampo[++col], saida.getTaxaJuros(), this.tipoCampo[col]));
            buffer.append(this.format(this.tamCampo[++col], "", this.tipoCampo[col]));
            buffer.append(this.format(this.tamCampo[++col], saida.getValorDesconto(), this.tipoCampo[col]));
            buffer.append(this.format(this.tamCampo[++col], saida.getCodigoAprovacao(), this.tipoCampo[col]));
            buffer.append(this.format(this.tamCampo[++col], saida.getNsuAutorizadora(), this.tipoCampo[col]));
            buffer.append(this.format(this.tamCampo[++col], saida.getTipoCapturaPreAutorizacao(), this.tipoCampo[col]));
            buffer.append(this.formatLL(this.tamCampo[++col], saida.getNomeBandeiraProduto()));
            buffer.append(this.format(this.tamCampo[++col], saida.getIdentConsulta(), this.tipoCampo[col]));
            buffer.append(this.formatLL(this.tamCampo[++col], saida.getNomeRedeAdquirente()));
            buffer.append(this.format(this.tamCampo[++col], "", this.tipoCampo[col]));
            buffer.append(this.format(this.tamCampo[++col], saida.getNumeroValeTroca(), this.tipoCampo[col]));
            ++col;
            buffer.append("\n");
            ultimaLinha = 2;
            if (saida.getMensagemCTF() != null) {
                for (int i = 0; i < saida.getMensagemCTF().length; ++i) {
                    buffer.append(this.formatLLL(saida.getMensagemCTF()[i].length(), saida.getMensagemCTF()[i]));
                }
            }
            buffer.append("000\n");
            if (saida.getCodigoRetorno() == 0) {
                RespostaProdutosPromocionais respostaProdutosPromocionais;
                Object respCD;
                ultimaLinha = 3;
                int col3aLinha = 0;
                if (codigoOperacao.equals("227") || codigoOperacao.equals("118") || codigoOperacao.equals("301")) {
                    RespostaBypass respostaBypass = saida.getRespostaBypass();
                    if (respostaBypass != null) {
                        buffer.append(respostaBypass.getValue());
                        ++col3aLinha;
                    }
                } else if (codigoOperacao.equals("139")) {
                    RespostaConsultaAvs respostaConsultaAvs = saida.getRespostaConsultaAvs();
                    buffer.append(this.format(this.tamCampoConsultaAvs[col3aLinha], respostaConsultaAvs.getCodigoResposta(), this.tipoCampoConsultaAvs[col3aLinha]));
                    buffer.append(this.format(this.tamCampoConsultaAvs[++col3aLinha], respostaConsultaAvs.getResultadoConsulta(), this.tipoCampoConsultaAvs[col3aLinha]));
                    ++col3aLinha;
                } else if (codigoOperacao.equals("152") || codigoOperacao.equals("153") || codigoOperacao.equals("154") || codigoOperacao.equals("155") || codigoOperacao.equals("180") || codigoOperacao.equals("181")) {
                    RespostaCorrespondenteBancario respostaCorrespondenteBancario = saida.getRespostaCorrespondenteBancario();
                    buffer.append(this.format(this.tamCampoCorrespondenteBancario[col3aLinha], respostaCorrespondenteBancario.getCorrespondenteBancario().getCedente(), this.tipoCampoCorrespondenteBancario[col3aLinha]));
                    df = new DecimalFormat("00");
                    calendar.setTime(respostaCorrespondenteBancario.getCorrespondenteBancario().getDataContabil());
                    String dataContabilFormatada = df.format(calendar.get(5)) + df.format(calendar.get(2) + 1) + String.valueOf(calendar.get(1)).substring(2);
                    buffer.append(this.format(this.tamCampoCorrespondenteBancario[++col3aLinha], dataContabilFormatada, this.tipoCampoCorrespondenteBancario[col3aLinha]));
                    ++col3aLinha;
                    String bufferFormaPgto = "";
                    bufferFormaPgto = bufferFormaPgto + (respostaCorrespondenteBancario.getCorrespondenteBancario().isPagamentoDinheiro() ? "1" : "0");
                    bufferFormaPgto = bufferFormaPgto + (respostaCorrespondenteBancario.getCorrespondenteBancario().isPagamentoCheque() ? "1" : "0");
                    bufferFormaPgto = bufferFormaPgto + (respostaCorrespondenteBancario.getCorrespondenteBancario().isPagamentoChequeBanco() ? "1" : "0");
                    bufferFormaPgto = bufferFormaPgto + (respostaCorrespondenteBancario.getCorrespondenteBancario().isPagamentoDebito() ? "1" : "0");
                    bufferFormaPgto = bufferFormaPgto + (respostaCorrespondenteBancario.getCorrespondenteBancario().isPagamentoCredito() ? "1" : "0");
                    bufferFormaPgto = bufferFormaPgto + (respostaCorrespondenteBancario.getCorrespondenteBancario().isPagamentoCartaoProprio() ? "1" : "0");
                    bufferFormaPgto = bufferFormaPgto + "00";
                    buffer.append(this.format(this.tamCampoCorrespondenteBancario[col3aLinha], bufferFormaPgto, this.tipoCampoCorrespondenteBancario[col3aLinha]));
                    buffer.append(this.format(this.tamCampoCorrespondenteBancario[++col3aLinha], respostaCorrespondenteBancario.getCorrespondenteBancario().getNumeroConvenio(), this.tipoCampoCorrespondenteBancario[col3aLinha]));
                    buffer.append(this.format(this.tamCampoCorrespondenteBancario[++col3aLinha], respostaCorrespondenteBancario.getCorrespondenteBancario().getFiller(), this.tipoCampoCorrespondenteBancario[col3aLinha]));
                    buffer.append(this.format(this.tamCampoCorrespondenteBancario[++col3aLinha], respostaCorrespondenteBancario.getCorrespondenteBancario().getAutenticacao(), this.tipoCampoCorrespondenteBancario[col3aLinha]));
                    buffer.append(this.format(this.tamCampoCorrespondenteBancario[++col3aLinha], respostaCorrespondenteBancario.getValor(), this.tipoCampoCorrespondenteBancario[col3aLinha]));
                    buffer.append(this.format(this.tamCampoCorrespondenteBancario[++col3aLinha], respostaCorrespondenteBancario.getValorDesconto(), this.tipoCampoCorrespondenteBancario[col3aLinha]));
                    buffer.append(this.format(this.tamCampoCorrespondenteBancario[++col3aLinha], respostaCorrespondenteBancario.getValorAcrescimo(), this.tipoCampoCorrespondenteBancario[col3aLinha]));
                    df = new DecimalFormat("00");
                    calendar.setTime(respostaCorrespondenteBancario.getDataVencimento());
                    String dataVencimentoFormatada = df.format(calendar.get(5)) + df.format(calendar.get(2) + 1) + String.valueOf(calendar.get(1));
                    buffer.append(this.format(this.tamCampoCorrespondenteBancario[++col3aLinha], dataVencimentoFormatada, this.tipoCampoCorrespondenteBancario[col3aLinha]));
                    buffer.append(this.format(this.tamCampoCorrespondenteBancario[++col3aLinha], respostaCorrespondenteBancario.getModoEntrada(), this.tipoCampoCorrespondenteBancario[col3aLinha]));
                    buffer.append(this.format(this.tamCampoCorrespondenteBancario[++col3aLinha], respostaCorrespondenteBancario.getCodigoBarras(), this.tipoCampoCorrespondenteBancario[col3aLinha]));
                    buffer.append(this.format(this.tamCampoCorrespondenteBancario[++col3aLinha], respostaCorrespondenteBancario.getModalidadePagamento(), this.tipoCampoCorrespondenteBancario[col3aLinha]));
                    buffer.append(this.format(this.tamCampoCorrespondenteBancario[++col3aLinha], respostaCorrespondenteBancario.getCmc7(), this.tipoCampoCorrespondenteBancario[col3aLinha]));
                    ++col3aLinha;
                } else if (codigoOperacao.equals("183")) {
                    RespostaPagamentoFaturaCartao respostaPagamentoFaturaCartao = saida.getRespostaPagamentoFaturaCartao();
                    if (respostaPagamentoFaturaCartao != null) {
                        buffer.append(this.format(this.tamCampoPagamentoFatura[col3aLinha], respostaPagamentoFaturaCartao.getCorrespondenteBancario().getCedente(), this.tipoCampoPagamentoFatura[col3aLinha]));
                        df = new DecimalFormat("00");
                        calendar.setTime(respostaPagamentoFaturaCartao.getCorrespondenteBancario().getDataContabil());
                        String dataContabilFormatada = String.valueOf(calendar.get(1)).substring(2) + df.format(calendar.get(2) + 1) + df.format(calendar.get(5));
                        buffer.append(this.format(this.tamCampoPagamentoFatura[++col3aLinha], dataContabilFormatada, this.tipoCampoPagamentoFatura[col3aLinha]));
                        ++col3aLinha;
                        String bufferFormaPgto = "";
                        bufferFormaPgto = bufferFormaPgto + (respostaPagamentoFaturaCartao.getCorrespondenteBancario().isPagamentoDinheiro() ? "1" : "0");
                        bufferFormaPgto = bufferFormaPgto + (respostaPagamentoFaturaCartao.getCorrespondenteBancario().isPagamentoCheque() ? "1" : "0");
                        bufferFormaPgto = bufferFormaPgto + (respostaPagamentoFaturaCartao.getCorrespondenteBancario().isPagamentoChequeBanco() ? "1" : "0");
                        bufferFormaPgto = bufferFormaPgto + (respostaPagamentoFaturaCartao.getCorrespondenteBancario().isPagamentoDebito() ? "1" : "0");
                        bufferFormaPgto = bufferFormaPgto + (respostaPagamentoFaturaCartao.getCorrespondenteBancario().isPagamentoCredito() ? "1" : "0");
                        bufferFormaPgto = bufferFormaPgto + (respostaPagamentoFaturaCartao.getCorrespondenteBancario().isPagamentoCartaoProprio() ? "1" : "0");
                        bufferFormaPgto = bufferFormaPgto + "00";
                        buffer.append(this.format(this.tamCampoPagamentoFatura[col3aLinha], bufferFormaPgto, this.tipoCampoPagamentoFatura[col3aLinha]));
                        buffer.append(this.format(this.tamCampoPagamentoFatura[++col3aLinha], respostaPagamentoFaturaCartao.getCorrespondenteBancario().getNumeroConvenio(), this.tipoCampoPagamentoFatura[col3aLinha]));
                        buffer.append(this.format(this.tamCampoPagamentoFatura[++col3aLinha], respostaPagamentoFaturaCartao.getValorDevido(), this.tipoCampoPagamentoFatura[col3aLinha]));
                        buffer.append(this.format(this.tamCampoPagamentoFatura[++col3aLinha], respostaPagamentoFaturaCartao.getValorOriginal(), this.tipoCampoPagamentoFatura[col3aLinha]));
                        buffer.append(this.format(this.tamCampoPagamentoFatura[++col3aLinha], respostaPagamentoFaturaCartao.getCorrespondenteBancario().getFiller(), this.tipoCampoPagamentoFatura[col3aLinha]));
                        buffer.append(this.format(this.tamCampoPagamentoFatura[++col3aLinha], respostaPagamentoFaturaCartao.getCorrespondenteBancario().getAutenticacao(), this.tipoCampoPagamentoFatura[col3aLinha]));
                        buffer.append(this.format(this.tamCampoPagamentoFatura[++col3aLinha], respostaPagamentoFaturaCartao.getValorAcrescimo(), this.tipoCampoPagamentoFatura[col3aLinha]));
                        buffer.append(this.format(this.tamCampoPagamentoFatura[++col3aLinha], respostaPagamentoFaturaCartao.getValorDesconto(), this.tipoCampoPagamentoFatura[col3aLinha]));
                        buffer.append(this.format(this.tamCampoPagamentoFatura[++col3aLinha], respostaPagamentoFaturaCartao.getPagamentoMinimo(), this.tipoCampoPagamentoFatura[col3aLinha]));
                        ++col3aLinha;
                        df = new DecimalFormat("00");
                        String dataVencimentoFormatada = "000000";
                        if (respostaPagamentoFaturaCartao.getDataVencimento() != null) {
                            calendar.setTime(respostaPagamentoFaturaCartao.getDataVencimento());
                            dataVencimentoFormatada = df.format(calendar.get(5)) + df.format(calendar.get(2) + 1) + String.valueOf(calendar.get(1)).substring(2);
                        }
                        buffer.append(this.format(this.tamCampoPagamentoFatura[col3aLinha], dataVencimentoFormatada, this.tipoCampoPagamentoFatura[col3aLinha]));
                        buffer.append(this.format(this.tamCampoPagamentoFatura[++col3aLinha], respostaPagamentoFaturaCartao.getNumeroDocumento(), this.tipoCampoPagamentoFatura[col3aLinha]));
                        buffer.append(this.format(this.tamCampoPagamentoFatura[++col3aLinha], respostaPagamentoFaturaCartao.getModoEntrada(), this.tipoCampoPagamentoFatura[col3aLinha]));
                        buffer.append(this.format(this.tamCampoPagamentoFatura[++col3aLinha], respostaPagamentoFaturaCartao.getCodigoBarras(), this.tipoCampoPagamentoFatura[col3aLinha]));
                        buffer.append(this.format(this.tamCampoPagamentoFatura[++col3aLinha], respostaPagamentoFaturaCartao.getModalidadePagamento(), this.tipoCampoPagamentoFatura[col3aLinha]));
                        buffer.append(this.format(this.tamCampoPagamentoFatura[++col3aLinha], respostaPagamentoFaturaCartao.getCmc7(), this.tipoCampoPagamentoFatura[col3aLinha]));
                        ++col3aLinha;
                    }
                } else if (codigoOperacao.equals("173")) {
                    respCD = saida.getRespostaConsultaValoresCreditoDigital();
                    if (((RespostaConsultaValoresCreditoDigital)respCD).getVersaoLayout() == 1) {
                        buffer.append(this.format(this.tamCampoConsultaValorCreditoDigital[col3aLinha], ((RespostaConsultaValoresCreditoDigital)respCD).getCodigoOperadora(), this.tipoCampoConsultaValorCreditoDigital[col3aLinha]));
                        String ddd = this.format(3, ((RespostaConsultaValoresCreditoDigital)respCD).getDDD(), 1);
                        String telefone = this.format(8, ((RespostaConsultaValoresCreditoDigital)respCD).getTelefone(), 1);
                        buffer.append(this.format(this.tamCampoConsultaValorCreditoDigital[++col3aLinha], ddd + telefone, this.tipoCampoConsultaValorCreditoDigital[col3aLinha]));
                        buffer.append(this.format(this.tamCampoConsultaValorCreditoDigital[++col3aLinha], ((RespostaConsultaValoresCreditoDigital)respCD).getValorVariavelMinimo(), this.tipoCampoConsultaValorCreditoDigital[col3aLinha]));
                        buffer.append(this.format(this.tamCampoConsultaValorCreditoDigital[++col3aLinha], ((RespostaConsultaValoresCreditoDigital)respCD).getValorVariavelMaximo(), this.tipoCampoConsultaValorCreditoDigital[col3aLinha]));
                        buffer.append(this.format(this.tamCampoConsultaValorCreditoDigital[++col3aLinha], ((RespostaConsultaValoresCreditoDigital)respCD).getQtdeValores(), this.tipoCampoConsultaValorCreditoDigital[col3aLinha]));
                        ++col3aLinha;
                        Iterator iteratorValor = ((RespostaConsultaValoresCreditoDigital)respCD).getValoresCreditoDigital().iterator();
                        for (int seqValor = 1; iteratorValor.hasNext() && seqValor <= 10; ++seqValor) {
                            BigDecimal valorAtual = (BigDecimal)iteratorValor.next();
                            buffer.append(this.format(this.tamCampoConsultaValorCreditoDigital[col3aLinha], valorAtual, this.tipoCampoConsultaValorCreditoDigital[col3aLinha]));
                            ++col3aLinha;
                        }
                        for (int iValor = 0; iValor < 10 - ((RespostaConsultaValoresCreditoDigital)respCD).getValoresCreditoDigital().size(); ++iValor) {
                            buffer.append(this.format(this.tamCampoConsultaValorCreditoDigital[col3aLinha], 0, this.tipoCampoConsultaValorCreditoDigital[col3aLinha]));
                            ++col3aLinha;
                        }
                        buffer.append(this.format(this.tamCampoConsultaValorCreditoDigital[col3aLinha], ((RespostaConsultaValoresCreditoDigital)respCD).getQtdeBonus(), this.tipoCampoConsultaValorCreditoDigital[col3aLinha]));
                        ++col3aLinha;
                        Iterator iteratorBonus = ((RespostaConsultaValoresCreditoDigital)respCD).getValoresBonus().iterator();
                        for (int seqBonus = 1; iteratorBonus.hasNext() && seqBonus <= 10; ++seqBonus) {
                            BigDecimal valorBonus = (BigDecimal)iteratorBonus.next();
                            buffer.append(this.format(this.tamCampoConsultaValorCreditoDigital[col3aLinha], valorBonus, this.tipoCampoConsultaValorCreditoDigital[col3aLinha]));
                            ++col3aLinha;
                        }
                        for (int iBonus = 0; iBonus < 10 - ((RespostaConsultaValoresCreditoDigital)respCD).getValoresBonus().size(); ++iBonus) {
                            buffer.append(this.format(this.tamCampoConsultaValorCreditoDigital[col3aLinha], 0, this.tipoCampoConsultaValorCreditoDigital[col3aLinha]));
                            ++col3aLinha;
                        }
                    } else if (((RespostaConsultaValoresCreditoDigital)respCD).getVersaoLayout() == 2 || ((RespostaConsultaValoresCreditoDigital)respCD).getVersaoLayout() == 3) {
                        buffer.append(this.format(this.tamCampoConsultaValorCreditoDigital2[col3aLinha], ((RespostaConsultaValoresCreditoDigital)respCD).getCodigoOperadora(), this.tipoCampoConsultaValorCreditoDigital2[col3aLinha]));
                        ++col3aLinha;
                        if (((RespostaConsultaValoresCreditoDigital)respCD).getVersaoLayout() >= 3) {
                            buffer.append(this.formatLL(-2, ((RespostaConsultaValoresCreditoDigital)respCD).getDDD()));
                            buffer.append(this.formatLL(-2, ((RespostaConsultaValoresCreditoDigital)respCD).getTelefone()));
                            ++col3aLinha;
                        } else {
                            String ddd = this.format(3, ((RespostaConsultaValoresCreditoDigital)respCD).getDDD(), 1);
                            String telefone = this.format(8, ((RespostaConsultaValoresCreditoDigital)respCD).getTelefone(), 1);
                            buffer.append(this.format(this.tamCampoConsultaValorCreditoDigital2[col3aLinha], ddd + telefone, this.tipoCampoConsultaValorCreditoDigital2[col3aLinha]));
                            ++col3aLinha;
                        }
                        buffer.append(this.format(this.tamCampoConsultaValorCreditoDigital2[col3aLinha], ((RespostaConsultaValoresCreditoDigital)respCD).getValorVariavelMinimo(), this.tipoCampoConsultaValorCreditoDigital2[col3aLinha]));
                        buffer.append(this.format(this.tamCampoConsultaValorCreditoDigital2[++col3aLinha], ((RespostaConsultaValoresCreditoDigital)respCD).getValorVariavelMaximo(), this.tipoCampoConsultaValorCreditoDigital2[col3aLinha]));
                        buffer.append(this.format(this.tamCampoConsultaValorCreditoDigital2[++col3aLinha], ((RespostaConsultaValoresCreditoDigital)respCD).getQtdeValores(), this.tipoCampoConsultaValorCreditoDigital2[col3aLinha]));
                        ++col3aLinha;
                        Iterator iteratorValor = ((RespostaConsultaValoresCreditoDigital)respCD).getValoresCreditoDigital().iterator();
                        Iterator iteratorBonus = ((RespostaConsultaValoresCreditoDigital)respCD).getValoresBonus().iterator();
                        while (iteratorValor.hasNext()) {
                            BigDecimal valorAtual = (BigDecimal)iteratorValor.next();
                            BigDecimal valorBonus = (BigDecimal)iteratorBonus.next();
                            buffer.append(this.format(10, valorAtual, 1));
                            buffer.append(this.format(10, valorBonus, 1));
                        }
                        ++col3aLinha;
                    }
                } else if (codigoOperacao.equals("174")) {
                    respCD = saida.getRespostaCompraCreditoDigital();
                    if (((RespostaCompraCreditoDigital)respCD).getVersaoLayout() < 3) {
                        buffer.append(this.format(this.tamCampoCompraCreditoDigitalLayout1[col3aLinha], ((RespostaCompraCreditoDigital)respCD).getCodigoOperadora(), this.tipoCampoCompraCreditoDigitalLayout1[col3aLinha]));
                        buffer.append(this.format(this.tamCampoCompraCreditoDigitalLayout1[++col3aLinha], ((RespostaCompraCreditoDigital)respCD).getDdd(), this.tipoCampoCompraCreditoDigitalLayout1[col3aLinha]));
                        buffer.append(this.format(this.tamCampoCompraCreditoDigitalLayout1[++col3aLinha], ((RespostaCompraCreditoDigital)respCD).getTelefone(), this.tipoCampoCompraCreditoDigitalLayout1[col3aLinha]));
                        ++col3aLinha;
                    } else if (((RespostaCompraCreditoDigital)respCD).getVersaoLayout() == 3) {
                        buffer.append(this.format(this.tamCampoCompraCreditoDigitalLayout3[col3aLinha], ((RespostaCompraCreditoDigital)respCD).getCodigoOperadora(), this.tipoCampoCompraCreditoDigitalLayout3[col3aLinha]));
                        buffer.append(this.formatLL(this.tamCampoCompraCreditoDigitalLayout3[++col3aLinha], ((RespostaCompraCreditoDigital)respCD).getDdd()));
                        buffer.append(this.formatLL(this.tamCampoCompraCreditoDigitalLayout3[++col3aLinha], ((RespostaCompraCreditoDigital)respCD).getTelefone()));
                        ++col3aLinha;
                    }
                } else if (codigoOperacao.equals("901")) {
                    RespostaOperacaoCheque respostaCheque = saida.getRespostaCheque();
                    buffer.append(this.format(this.tamCampoTefDiscOperacaoCheque[col3aLinha], respostaCheque.getCmc7(), this.tipoCampoTefDiscOperacaoCheque[col3aLinha]));
                    buffer.append(this.format(this.tamCampoTefDiscOperacaoCheque[++col3aLinha], respostaCheque.getTipoDocumento(), this.tipoCampoTefDiscOperacaoCheque[col3aLinha]));
                    buffer.append(this.format(this.tamCampoTefDiscOperacaoCheque[++col3aLinha], respostaCheque.getDocumento(), this.tipoCampoTefDiscOperacaoCheque[col3aLinha]));
                    SimpleDateFormat dateFormat = new SimpleDateFormat("ddMMyyyy");
                    String dataCheque = dateFormat.format(respostaCheque.getDataCheque());
                    buffer.append(this.format(this.tamCampoTefDiscOperacaoCheque[++col3aLinha], dataCheque, this.tipoCampoTefDiscOperacaoCheque[col3aLinha]));
                    buffer.append(this.format(this.tamCampoTefDiscOperacaoCheque[++col3aLinha], respostaCheque.getBanco(), this.tipoCampoTefDiscOperacaoCheque[col3aLinha]));
                    buffer.append(this.format(this.tamCampoTefDiscOperacaoCheque[++col3aLinha], respostaCheque.getAgencia(), this.tipoCampoTefDiscOperacaoCheque[col3aLinha]));
                    buffer.append(this.format(this.tamCampoTefDiscOperacaoCheque[++col3aLinha], respostaCheque.getContaCorrente(), this.tipoCampoTefDiscOperacaoCheque[col3aLinha]));
                    ++col3aLinha;
                } else if (codigoOperacao.equals("235")) {
                    RespostaValeGas respValeGas = saida.getRespostaValeGas();
                    buffer.append(this.format(this.tamCampoValeGas[col3aLinha], respValeGas.getCodigoProduto(), this.tipoCampoValeGas[col3aLinha]));
                    buffer.append(this.format(this.tamCampoValeGas[++col3aLinha], respValeGas.getDescricaoProduto(), this.tipoCampoValeGas[col3aLinha]));
                    buffer.append(this.format(this.tamCampoValeGas[++col3aLinha], respValeGas.getNumeroEVale(), this.tipoCampoValeGas[col3aLinha]));
                    ++col3aLinha;
                } else if (codigoOperacao.equals("228")) {
                    RespostaConsultaConfiguracao consConf = saida.getRespostaConsultaConfiguracao();
                    buffer.append(this.format(this.tamCampoConsultaConfiguracao[col3aLinha], consConf.getVersaoAc(), this.tipoCampoConsultaConfiguracao[col3aLinha]));
                    df = new DecimalFormat("00000");
                    String portaFormatada = df.format(Integer.parseInt(consConf.getPortClient()));
                    buffer.append(this.formatLL(this.tamCampoConsultaConfiguracao[++col3aLinha], consConf.getHostClient()) + portaFormatada);
                    ++col3aLinha;
                    HashSet ipsCTF = (HashSet)consConf.getIpsCTF();
                    Iterator iteIps = ipsCTF.iterator();
                    String bufferIps = "";
                    df = new DecimalFormat("00000");
                    while (iteIps.hasNext()) {
                        ServicoCTF servico = (ServicoCTF)iteIps.next();
                        String porta = servico.getIdentificadorServico();
                        Host host = servico.getHost();
                        String protocolo = servico.getProtocolo();
                        bufferIps = bufferIps + this.formatLL(-2, host.getEndereco());
                        bufferIps = bufferIps + df.format(Integer.parseInt(porta));
                        bufferIps = bufferIps + StringUtil.completaString(protocolo, 4, ' ', 4);
                    }
                    bufferIps = bufferIps + "00";
                    buffer.append(this.formatLLL(this.tamCampoConsultaConfiguracao[col3aLinha], bufferIps));
                    String classeTeclado = consConf.getTeclado() != null ? consConf.getTeclado().getNomeLogico() : "";
                    String tipoTeclado = classeTeclado.equals("TECLADO_PC") ? "TECLADO_PC" : "";
                    buffer.append(this.format(this.tamCampoConsultaConfiguracao[++col3aLinha], tipoTeclado, this.tipoCampoConsultaConfiguracao[col3aLinha]));
                    String param = consConf.getTeclado() != null ? this.generateParam(consConf.getTeclado().getParametros()) : "";
                    buffer.append(this.formatLLL(this.tamCampoConsultaConfiguracao[++col3aLinha], param));
                    String classeDisplayOperador = consConf.getDisplayOperador() != null ? consConf.getDisplayOperador().getNomeLogico() : "";
                    String tipoDisplayOperador = classeDisplayOperador.equals("DISPLAY_CTFCLIENT") ? "DISPLAY_CTFCLIENT" : (classeDisplayOperador.length() == 0 ? "DISPLAY_CTFCLIENT" : "");
                    buffer.append(this.format(this.tamCampoConsultaConfiguracao[++col3aLinha], tipoDisplayOperador, this.tipoCampoConsultaConfiguracao[col3aLinha]));
                    param = consConf.getDisplayOperador() != null ? this.generateParam(consConf.getDisplayOperador().getParametros()) : "";
                    buffer.append(this.formatLLL(this.tamCampoConsultaConfiguracao[++col3aLinha], param));
                    String classeDisplayCliente = consConf.getDisplayCliente() != null ? consConf.getDisplayCliente().getNomeLogico() : "";
                    String tipoDisplayCliente = classeDisplayCliente.equals("DISPLAY_CTFCLIENT") ? "DISPLAY_CTFCLIENT" : "DISPLAY_CTFCLIENT";
                    buffer.append(this.format(this.tamCampoConsultaConfiguracao[++col3aLinha], tipoDisplayCliente, this.tipoCampoConsultaConfiguracao[col3aLinha]));
                    param = consConf.getDisplayCliente() != null ? this.generateParam(consConf.getDisplayCliente().getParametros()) : "";
                    buffer.append(this.formatLLL(this.tamCampoConsultaConfiguracao[++col3aLinha], param));
                    String tipoLeitorCartoes = StringUtil.completaString("LEITOR_CARTAO_BIB_COMPARTILHADA", 40, ' ', true);
                    buffer.append(this.format(this.tamCampoConsultaConfiguracao[++col3aLinha], tipoLeitorCartoes, this.tipoCampoConsultaConfiguracao[col3aLinha]));
                    param = consConf.getLeitorCartao() != null ? this.generateParam(consConf.getLeitorCartao().getParametros()) : "";
                    buffer.append(this.formatLLL(this.tamCampoConsultaConfiguracao[++col3aLinha], param));
                    String tipoPinpad = StringUtil.completaString("PINPAD_BIB_COMPARTILHADA", 40, ' ', true);
                    buffer.append(this.format(this.tamCampoConsultaConfiguracao[++col3aLinha], tipoPinpad, this.tipoCampoConsultaConfiguracao[col3aLinha]));
                    param = consConf.getPin() != null ? this.generateParam(consConf.getPin().getParametros()) : "";
                    buffer.append(this.formatLLL(this.tamCampoConsultaConfiguracao[++col3aLinha], param));
                    String classeScanner = consConf.getScanner() != null ? consConf.getScanner().getNomeLogico() : "";
                    String tipoScanner = classeScanner.equals("SCANNER_SERIAL") ? "SCANNER_SERIAL" : "";
                    buffer.append(this.format(this.tamCampoConsultaConfiguracao[++col3aLinha], tipoScanner, this.tipoCampoConsultaConfiguracao[col3aLinha]));
                    param = consConf.getScanner() != null ? this.generateParam(consConf.getScanner().getParametros()) : "";
                    buffer.append(this.formatLLL(this.tamCampoConsultaConfiguracao[++col3aLinha], param));
                    String classeLeitorDocumentos = consConf.getLeitorDocumento() != null ? consConf.getLeitorDocumento().getNomeLogico() : "";
                    String tipoLeitorDocumentos = classeLeitorDocumentos.equals("LEITOR_DOCUMENTO_TECPOINTTL840") ? "LEITOR_DOCUMENTO_TECPOINTTL840" : "";
                    buffer.append(this.format(this.tamCampoConsultaConfiguracao[++col3aLinha], tipoLeitorDocumentos, this.tipoCampoConsultaConfiguracao[col3aLinha]));
                    param = consConf.getLeitorDocumento() != null ? this.generateParam(consConf.getLeitorDocumento().getParametros()) : "";
                    buffer.append(this.formatLLL(this.tamCampoConsultaConfiguracao[++col3aLinha], param));
                    buffer.append(this.format(this.tamCampoConsultaConfiguracao[++col3aLinha], consConf.isIntegracaoCriptografada() ? "1" : "0", this.tipoCampoConsultaConfiguracao[col3aLinha]));
                    buffer.append(this.format(this.tamCampoConsultaConfiguracao[++col3aLinha], consConf.isCapturaCmc7() ? "1" : "0", this.tipoCampoConsultaConfiguracao[col3aLinha]));
                    buffer.append(this.format(this.tamCampoConsultaConfiguracao[++col3aLinha], consConf.isCreditoCelularHabilitado() ? "1" : "0", this.tipoCampoConsultaConfiguracao[col3aLinha]));
                    ++col3aLinha;
                } else if (codigoOperacao.equals("172")) {
                    RespostaConsultaAnaliticaSPC respostaConsultaAnaliticaSPC = saida.getRespostaConsultaAnaliticaSPC();
                    buffer.append(this.format(this.tamCampoConsultaAnaliticaSpc[col3aLinha], respostaConsultaAnaliticaSPC.getBit62(), this.tipoCampoConsultaAnaliticaSpc[col3aLinha]));
                    ++col3aLinha;
                } else if (codigoOperacao.equals("260")) {
                    RespostaAtivacaoCartaoPrepago respostaAtivacaoCartaoPrepago = saida.getRespostaAtivacaoCartaoPrepago();
                    buffer.append(this.format(this.tamCampoAtivacaoCartaoPrepago[col3aLinha], respostaAtivacaoCartaoPrepago.toString(), this.tipoCampoAtivacaoCartaoPrepago[col3aLinha]));
                    ++col3aLinha;
                } else if (codigoOperacao.equals("277")) {
                    respostaProdutosPromocionais = saida.getRespostaProdutosPromocionais();
                    buffer.append(this.format(14, respostaProdutosPromocionais.getTimestamp(), 2));
                    ++col3aLinha;
                    List listProdutos = respostaProdutosPromocionais.getListProdutosPromocionais();
                    if (listProdutos != null) {
                        for (ProdutoPromocional produtoPromocional : listProdutos) {
                            buffer.append(this.format(20, produtoPromocional.getCodigoEAN(), 2));
                        }
                    }
                    ++col3aLinha;
                } else if (codigoOperacao.equals("278")) {
                    respostaProdutosPromocionais = saida.getRespostaProdutosPromocionais();
                    List listProdutos = respostaProdutosPromocionais.getListProdutosPromocionais();
                    if (listProdutos != null) {
                        for (ProdutoPromocional produtoPromocional : listProdutos) {
                            buffer.append(this.format(20, produtoPromocional.getCodigoEAN(), 2));
                            buffer.append(this.format(3, produtoPromocional.getQuantidade(), 1));
                            buffer.append(this.format(7, produtoPromocional.getValorDesconto(), 1));
                        }
                    }
                    ++col3aLinha;
                } else if (codigoOperacao.equals("270")) {
                    RespostaSimulacaoCrediario respostaSimulacaoCrediario = saida.getRespostaSimulacaoCrediario();
                    buffer.append(this.format(this.tamCampoAtivacaoCartaoPrepago[col3aLinha], respostaSimulacaoCrediario.toString(), this.tipoCampoAtivacaoCartaoPrepago[col3aLinha]));
                    ++col3aLinha;
                } else if (codigoOperacao.equals("307") || codigoOperacao.equals("308") || codigoOperacao.equals("309") || codigoOperacao.equals("310") || codigoOperacao.equals("311") || codigoOperacao.equals("312") || codigoOperacao.equals("313") || codigoOperacao.equals("314") || codigoOperacao.equals("315") || codigoOperacao.equals("316") || codigoOperacao.equals("317") || codigoOperacao.equals("318") || codigoOperacao.equals("319") || codigoOperacao.equals("320") || codigoOperacao.equals("321") || codigoOperacao.equals("323") || codigoOperacao.equals("324") || codigoOperacao.equals("325")) {
                    RespostaTransacoesSAA respostaTransacoesSAA = saida.getRespostaTransacoesSAA();
                    if (respostaTransacoesSAA != null) {
                        buffer.append(respostaTransacoesSAA.getBit62());
                        ++col3aLinha;
                    }
                } else if (codigoOperacao.equals("908") && saida.getCapturaDadoPinpad() != null) {
                    buffer.append(saida.getCapturaDadoPinpad());
                    ++col3aLinha;
                }
            }
            buffer.append("\n");
            ConfCTFClient confCTFClient = null;
            try {
                confCTFClient = ControladorConfCTFClient.getInstance().getConfig();
            }
            catch (ExcecaoApiAc e) {
                this.logger.error((Object)e.getMessage());
            }
            if (confCTFClient != null && confCTFClient.isIntegracaoDll()) {
                ControladorTranslator.montaPossaida(this.outStr, buffer);
            } else {
                this.outStr.write(buffer.toString().getBytes());
            }
            this.logger.info((Object)buffer.toString());
            this.outStr.flush();
        }
        catch (IOException e) {
            this.logger.error((Object)"Problemas de IO no stream de sa\u00edda");
            throw new SyntaxError(ultimaLinha, 2);
        }
    }

    private String format(int tam, String value, int tipo) {
        if (value == null) {
            value = "";
        } else {
            String string = value = value.trim().length() != 0 ? value : value.trim();
        }
        if (value.length() > tam) {
            if (tipo == 1) {
                return value.substring(value.length() - tam);
            }
            return value.substring(0, tam);
        }
        if (tipo == 1) {
            return StringUtil.completaString(value, tam, '0', 3);
        }
        return StringUtil.completaString(value, tam, ' ', 4);
    }

    private String format(int tam, int value, int tipo) {
        return this.format(tam, String.valueOf(value), tipo);
    }

    private String format(int tam, long value, int tipo) {
        return this.format(tam, String.valueOf(value), tipo);
    }

    private String format(int tam, BigDecimal value, int tipo) {
        value = value != null ? value.multiply(new BigDecimal(100)) : new BigDecimal(0);
        DecimalFormat df = new DecimalFormat("0");
        return this.format(tam, df.format(value), tipo);
    }

    private String generateParam(String[] itens) {
        String result = "";
        for (int i = 0; i < itens.length; ++i) {
            if (i > 0) {
                result = result + ",";
            }
            result = result + itens[i];
        }
        return result;
    }

    public ParserOutputCSI(SaidaApiTefC saida) throws SyntaxError {
        super(null);
    }

    public ParserOutputCSI(Map map) {
        super(map);
    }

    public OutputStream getOutputStream() {
        return this.outStr;
    }

    public OutputStream parse(SaidaCTFClient saida, OutputStream outStr) throws SyntaxError {
        this.outStr = outStr;
        this.montaStream(saida);
        return outStr;
    }
}

