/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.integracao;

import com.csi.ctfclient.integracao.TerminalManager;
import com.csi.ctfclient.servicos.IdentTransacoes;
import com.csi.ctfclient.servicos.TerminalTransacoes;
import com.csi.ctfclient.tools.util.logger.CTFClientLogger;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class RunnableTimeOut
implements Runnable {
    private static Logger logger = CTFClientLogger.getCTFClient();
    TerminalManager terminalManager = null;
    long timeout = 0L;

    public RunnableTimeOut(int timeout) {
        this.timeout = timeout * 1000;
        this.terminalManager = TerminalManager.getInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        logger.info((Object)("controlador de timeout inicializado com valor = " + this.timeout / 1000L));
        while (true) {
            Map aguardandoConfirmacao = this.terminalManager.getAguardandoConfirmacao();
            Set terminais = aguardandoConfirmacao.keySet();
            ArrayList<IdentTransacoes> keys = new ArrayList<IdentTransacoes>();
            if (terminais != null && !terminais.isEmpty()) {
                Map map = aguardandoConfirmacao;
                synchronized (map) {
                    Date nowDate = new Date();
                    for (IdentTransacoes identTransacoes : terminais) {
                        TerminalTransacoes terminalTransacoes = (TerminalTransacoes)aguardandoConfirmacao.get(identTransacoes);
                        if (nowDate.getTime() - terminalTransacoes.getTerminal().getTimeStamp().getTime() <= this.timeout) continue;
                        this.terminalManager.liberaTerminal(terminalTransacoes.getTerminal());
                        keys.add(identTransacoes);
                        logger.info((Object)("terminal " + terminalTransacoes.getTerminal().getTerminal() + " liberado por timeout."));
                    }
                    Map map2 = aguardandoConfirmacao;
                    synchronized (map2) {
                        for (IdentTransacoes identTransacoes : keys) {
                            aguardandoConfirmacao.remove(identTransacoes);
                        }
                    }
                }
            }
            try {
                Thread.sleep(this.timeout);
                continue;
            }
            catch (InterruptedException e) {
                logger.error((Object)e.getMessage());
                continue;
            }
            break;
        }
    }
}

