/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.integracao;

import com.csi.ctfclient.excecoes.ExcecaoParametroInvalido;
import com.csi.ctfclient.integracao.Handler;
import com.csi.ctfclient.integracao.SocketGetData;
import com.csi.ctfclient.integracao.event.HandlerEvent;
import com.csi.ctfclient.tools.communication.Host;
import com.csi.ctfclient.tools.communication.Servico;
import com.csi.ctfclient.tools.communication.access.Conector;
import com.csi.ctfclient.tools.communication.access.ExcecaoErroInstanciacaoServidor;
import com.csi.ctfclient.tools.communication.access.ExcecaoNenhumaThreadDisponivel;
import com.csi.ctfclient.tools.communication.access.GerenciadorDeAcesso;
import com.csi.ctfclient.tools.communication.access.Servidor;
import com.csi.ctfclient.tools.communication.access.TratadorDeConexoesDeEntrada;
import com.csi.ctfclient.tools.util.logger.CTFClientLogger;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import org.apache.log4j.Logger;

public class SocketHandler
extends Handler
implements TratadorDeConexoesDeEntrada {
    private static String tipoAcesso = "TCP/IP";
    private Servidor servidor = null;
    private Servico servicoLocal;
    private Logger logger = CTFClientLogger.getIntegrador();
    private String port;
    private String strHost;
    private boolean enable;
    private SocketGetData socketGetData;
    private SocketHandler objHandler = this;

    public SocketHandler(Map map) {
        this((String)map.get("host"), (String)map.get("port"));
    }

    public SocketHandler(String strHost, String port) {
        this.strHost = strHost;
        this.port = port;
    }

    public void start() {
        if (this.enable) {
            return;
        }
        try {
            Host host = new Host(this.strHost);
            this.servicoLocal = new Servico(host, this.port);
        }
        catch (ExcecaoParametroInvalido e) {
            this.logger.error((Object)"Erro criando servi\u00e7o por erros nos par\u00e2metros");
            return;
        }
        try {
            this.servidor = GerenciadorDeAcesso.getInstanciaServidor(tipoAcesso, this.servicoLocal, this, 60);
            this.logger.info((Object)"Servidor CTFClient aberto.");
        }
        catch (ExcecaoErroInstanciacaoServidor e1) {
            this.logger.error((Object)"Erro instanciando servi\u00e7o local");
            e1.printStackTrace();
        }
        catch (ExcecaoParametroInvalido e1) {
            this.logger.error((Object)"Erro instanciando servico local por erros nos par\u00e2metros");
            e1.printStackTrace();
        }
        this.enable = true;
    }

    public void stop() {
        this.servidor.finalizarServidor();
        this.enable = false;
    }

    public SocketGetData getThreadConexaoEntrada(Conector conexao) throws ExcecaoNenhumaThreadDisponivel {
        try {
            SocketGetData socketGetData = SocketGetData.getInstance(this.objHandler, conexao);
            this.logger.info((Object)"Conex\u00e3o aceita");
            return socketGetData;
        }
        catch (IllegalStateException e) {
            this.logger.error((Object)"Conex\u00e3o recusada, j\u00e1 existe um cliente conectado");
            throw new ExcecaoNenhumaThreadDisponivel(e.getMessage());
        }
    }

    public SocketGetData getSocketGetData() {
        return this.socketGetData;
    }

    public void fireReadInputStream(String dados, OutputStream outputStream) {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(dados.getBytes());
        HandlerEvent event = new HandlerEvent(this, inputStream, outputStream);
        this.fireReadStream(event);
    }

    public void fireReadInputStream(InputStream inputStream, OutputStream outputStream) {
        HandlerEvent event = new HandlerEvent(this, inputStream, outputStream);
        this.fireReadStream(event);
    }
}

