/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes;

import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.excecoes.ExcecaoMascaraInvalida;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.excecoes.ExcecaoValorInvalido;
import com.csi.ctfclient.gui.TelaPrincipal;
import com.csi.ctfclient.info.constantes.ConstantesApiAc;
import com.csi.ctfclient.info.constantes.ConstantesControladorPeriferico;
import com.csi.ctfclient.operacoes.VerificaTemporizacao;
import com.csi.ctfclient.operacoes.model.PerifericoEventHandler;
import com.csi.ctfclient.tools.devices.ConfiguracaoPerifericos;
import com.csi.ctfclient.tools.devices.ControladorTranslator;
import com.csi.ctfclient.tools.devices.Display;
import com.csi.ctfclient.tools.devices.EntradaDeDados;
import com.csi.ctfclient.tools.devices.EventoDispositivoEntrada;
import com.csi.ctfclient.tools.devices.EventoTeclado;
import com.csi.ctfclient.tools.devices.ExcecaoPerifericos;
import com.csi.ctfclient.tools.devices.ILeitorCartaoHandler;
import com.csi.ctfclient.tools.devices.LeitorDocumento;
import com.csi.ctfclient.tools.devices.ParametrosEdicaoTeclado;
import com.csi.ctfclient.tools.devices.Scanner;
import com.csi.ctfclient.tools.devices.Teclado;
import com.csi.ctfclient.tools.devices.display.ItemMenu;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.devices.display.LayoutMenu;
import com.csi.ctfclient.tools.devices.display.Linha;
import com.csi.ctfclient.tools.devices.emv.PinEMV;
import com.csi.ctfclient.tools.devices.emvfull.BibliotecaPinpad;
import com.csi.ctfclient.tools.devices.fusion.ControladorFusion;
import com.csi.ctfclient.tools.devices.generic.JPanelDisplay;
import com.csi.ctfclient.tools.util.ParametrosInternacionalizacao;
import com.csi.ctfclient.tools.util.logger.CTFClientLogger;
import java.util.List;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class ControladorPerifericos
implements ConstantesControladorPeriferico {
    private static Logger logger = CTFClientLogger.getPeriferico();
    private ConfiguracaoPerifericos configuracaoPerifericos;
    private boolean displayLocked;
    private EntradaDeDados entradaDeDados;
    private ParametrosInternacionalizacao internacionalizacao;
    private TelaPrincipal telaPrincipal;
    private boolean integracaoTranslator = false;
    private LayoutDisplay ultimoDisplay = null;
    public static final int WRITE_LEFT_TO_RIGHT = 0;
    public static final int WRITE_RIGTH_TO_LEFT = 1;
    private static final String MSG_DISPLAY = "OPERACAO CANCELADA?";

    public ControladorPerifericos(ConfiguracaoPerifericos per, boolean integracaoTranslator) throws ExcecaoNaoLocal {
        logger.log((Priority)Level.INFO, (Object)"Instanciando controlador de perifericos...");
        this.integracaoTranslator = integracaoTranslator;
        if (!integracaoTranslator) {
            this.telaPrincipal = new TelaPrincipal();
        }
        this.entradaDeDados = new EntradaDeDados();
        this.internacionalizacao = new ParametrosInternacionalizacao();
        this.configuracaoPerifericos = per;
    }

    public void configTerminalInterno(boolean configTerminalInterno) {
        if (configTerminalInterno) {
            if (this.telaPrincipal == null) {
                this.telaPrincipal = new TelaPrincipal();
            }
            if (this.integracaoTranslator) {
                this.integracaoTranslator = false;
            }
        } else {
            if (this.telaPrincipal != null) {
                this.telaPrincipal.setVisible(false);
            }
            this.integracaoTranslator = true;
        }
    }

    public void desabilitaIntegracaoTranslator() {
    }

    public EntradaDeDados getEntradaDeDados() {
        return this.entradaDeDados;
    }

    public ILeitorCartaoHandler getLeitorCartao() throws ExcecaoPerifericos {
        ILeitorCartaoHandler cartaoHandler;
        if (this.entradaDeDados.getLeitorCartao() == null && (cartaoHandler = this.configuracaoPerifericos.getPerifericoLeitorCartao()) != null) {
            cartaoHandler.addListener(new PerifericoEventHandler(this), false);
            this.entradaDeDados.setLeitorCartao(cartaoHandler);
            this.entradaDeDados.habilitaLeitorCartao();
        }
        return this.configuracaoPerifericos.getPerifericoLeitorCartao();
    }

    public LeitorDocumento getLeitorDocumento() throws ExcecaoPerifericos {
        LeitorDocumento leitorDocumento;
        if (this.entradaDeDados.getLeitorDocumento() == null && (leitorDocumento = this.configuracaoPerifericos.getPerifericoLeitorDocumento()) != null) {
            leitorDocumento.setFrame(this.telaPrincipal);
            this.entradaDeDados.setLeitorDocumento(leitorDocumento);
            this.entradaDeDados.habilitaLeitorDocumento();
        }
        return this.configuracaoPerifericos.getPerifericoLeitorDocumento();
    }

    public Scanner getScanner() throws ExcecaoPerifericos {
        Scanner scanner;
        if (this.entradaDeDados.getScanner() == null && (scanner = this.configuracaoPerifericos.getPerifericoScanner()) != null) {
            this.entradaDeDados.setScanner(scanner);
            this.entradaDeDados.habilitaScanner();
        }
        return this.configuracaoPerifericos.getPerifericoScanner();
    }

    public PinEMV getPin() throws ExcecaoPerifericos {
        PinEMV pinEMV;
        if (this.entradaDeDados.getPin() == null && (pinEMV = this.configuracaoPerifericos.getPerifericoPin()) != null) {
            pinEMV.addListener(new PerifericoEventHandler(this), false);
            this.entradaDeDados.setPin(pinEMV);
            this.entradaDeDados.habilitaPin();
        }
        return this.configuracaoPerifericos.getPerifericoPin();
    }

    protected Teclado getTeclado() throws ExcecaoPerifericos {
        Teclado teclado = this.configuracaoPerifericos.getPerifericoTeclado();
        if (this.entradaDeDados.getTeclado() == null && teclado != null) {
            try {
                ParametrosEdicaoTeclado par = new ParametrosEdicaoTeclado(false, false, true, "ZZZZZZZZZZZZZZ", 1, 0, ",", ".", true, "", 0, 0, null, ConstantesApiAc.TODAS_TECLAS, false);
                par.ativeSenha('*');
                teclado.defineParametros(par);
            }
            catch (ExcecaoMascaraInvalida e) {
                throw new ExcecaoPerifericos(null, e.getMessage());
            }
            teclado.setFrame(this.telaPrincipal);
            teclado.adicionaDisplayEco(this.getDisplay());
            if (this.isDisplayExterno()) {
                teclado.adicionaDisplayEco(this.getDisplayOperador());
            }
            this.entradaDeDados.setTeclado(teclado);
            this.entradaDeDados.habilitaTeclado();
            teclado.habilita();
        }
        return teclado;
    }

    private Display getDisplay() throws ExcecaoPerifericos {
        this.getTelaPrincipal().setVisible(true);
        Display display = this.configuracaoPerifericos.getPerifericoDisplayCliente();
        this.telaPrincipal.setDisplay((JPanelDisplay)display);
        return display;
    }

    public Display getDisplayOperador() throws ExcecaoPerifericos {
        Display display = this.configuracaoPerifericos.getPerifericoDisplayOperador();
        if (display != null) {
            display.habilita();
        }
        return display;
    }

    public boolean isDisplayExterno() {
        return this.configuracaoPerifericos.isDisplayExterno();
    }

    private TelaPrincipal getTelaPrincipal() {
        return this.telaPrincipal;
    }

    public LayoutDisplay getUltimoDisplay() {
        return this.ultimoDisplay;
    }

    public int imprimeDisplay(LayoutDisplay layoutDisplay) throws ExcecaoNaoLocal {
        this.ultimoDisplay = layoutDisplay;
        if (this.integracaoTranslator) {
            return ControladorTranslator.getInstancia().exibeDisplay(layoutDisplay);
        }
        try {
            this.limpaDisplay();
            List linhas = layoutDisplay.getLinhas();
            int x = layoutDisplay.getPrimeiraLinha();
            Display display = this.getDisplay();
            Display displayOperador = this.getDisplayOperador();
            for (Linha linha : linhas) {
                display.imprimeEm(x += linha.getPularLinha(), linha.getColuna(), linha.getTexto());
                if (this.isDisplayExterno() && linha.getTexto() != null && x < 2) {
                    displayOperador.imprimeEm(x, linha.getColuna(), linha.getTexto());
                }
                ++x;
            }
            if (layoutDisplay.getDelay() > 0L) {
                if (layoutDisplay.isCancelarDelay()) {
                    VerificaTemporizacao verificaTemporizacao = new VerificaTemporizacao(this.entradaDeDados, layoutDisplay.getDelay());
                    verificaTemporizacao.start();
                    this.leDados(new long[]{1L});
                    verificaTemporizacao.cancelaTemporizacao();
                } else {
                    try {
                        Thread.sleep(layoutDisplay.getDelay());
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                }
            }
            return x;
        }
        catch (ExcecaoPerifericos e) {
            throw new ExcecaoNaoLocal(e);
        }
    }

    public void imprimeComDelayNaoBlocante(LayoutDisplay layoutDisplay) throws ExcecaoNaoLocal {
        long delayDisplay = layoutDisplay.getDelay();
        if (delayDisplay > 0L) {
            layoutDisplay.setDelay(0L);
        }
        VerificaTemporizacao verificaTemporizacao = new VerificaTemporizacao(this.entradaDeDados, delayDisplay);
        verificaTemporizacao.start();
        this.leDados(new long[]{1L});
        verificaTemporizacao.cancelaTemporizacao();
    }

    public synchronized EventoDispositivoEntrada confirmaDado(LayoutDisplay layoutDisplay) throws ExcecaoNaoLocal {
        if (this.integracaoTranslator) {
            return ControladorTranslator.getInstancia().confirmaDado(layoutDisplay);
        }
        String[] teclasFinalizadoras = new String[]{"ENTRA", "VOLTA"};
        if (this.isDisplayExterno()) {
            try {
                boolean novaLinha = true;
                int linhaVisivel = 1;
                LayoutDisplay aux = layoutDisplay;
                EventoTeclado evt = null;
                while (novaLinha) {
                    String navegacao = "";
                    if (aux.getLinhas().size() > 2) {
                        if (linhaVisivel == 1) {
                            navegacao = " [->]";
                            teclasFinalizadoras = new String[]{"ENTRA", "VOLTA", "TECLA_DIREITA"};
                        } else if (linhaVisivel == aux.getLinhas().size() - 1) {
                            navegacao = " [<-]";
                            teclasFinalizadoras = new String[]{"ENTRA", "VOLTA", "TECLA_ESQUERDA"};
                        } else {
                            navegacao = " [<- / ->]";
                            teclasFinalizadoras = new String[]{"ENTRA", "VOLTA", "TECLA_ESQUERDA", "TECLA_DIREITA"};
                        }
                    }
                    layoutDisplay = new LayoutDisplay();
                    Linha linha = (Linha)aux.getLinhas().get(0);
                    layoutDisplay.addLinha(new Linha(linha.getTexto() + navegacao));
                    if (aux.getLinhas().size() > 1) {
                        linha = (Linha)aux.getLinhas().get(linhaVisivel);
                        layoutDisplay.addLinha(new Linha(linha.getTexto()));
                    }
                    if ((evt = (EventoTeclado)this.capturaDadoDisplayExterno(layoutDisplay, null, teclasFinalizadoras)).getTeclaFinalizadora().equals("TECLA_ESQUERDA")) {
                        if (linhaVisivel <= 1) continue;
                        --linhaVisivel;
                        continue;
                    }
                    if (evt.getTeclaFinalizadora().equals("TECLA_DIREITA")) {
                        if (linhaVisivel >= aux.getLinhas().size() - 1) continue;
                        ++linhaVisivel;
                        continue;
                    }
                    novaLinha = false;
                    return evt;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        }
        return this.capturaDado(layoutDisplay, null, -1, 1, teclasFinalizadoras, 0, true, false, "", false, new long[]{1L}, false);
    }

    public synchronized EventoDispositivoEntrada capturaDadoDisplayExterno(LayoutDisplay layoutDisplay, ConstantesApiAc.TipoCampo tipoCampo, String[] teclasFinalizadoras) throws ExcecaoNaoLocal {
        int i = layoutDisplay.getLinhas().size();
        if (i > 0) {
            --i;
        }
        Linha linha = (Linha)layoutDisplay.getLinhas().get(i);
        return this.capturaDado(layoutDisplay, tipoCampo, -1, 1, teclasFinalizadoras, linha.getTexto().length(), false, true, "", false, new long[]{1L}, false);
    }

    public synchronized EventoDispositivoEntrada capturaDado(LayoutDisplay layoutDisplay, ConstantesApiAc.TipoCampo tipoCampo) throws ExcecaoNaoLocal {
        String[] teclasFinalizadoras = new String[]{"ENTRA", "VOLTA"};
        return this.capturaDado(layoutDisplay, tipoCampo, -1, 1, teclasFinalizadoras, 0, true, true, "", false, new long[]{1L}, false);
    }

    public synchronized EventoDispositivoEntrada capturaDado(LayoutDisplay layoutDisplay, ConstantesApiAc.TipoCampo tipoCampo, String[] teclasFinalizadoras) throws ExcecaoNaoLocal {
        return this.capturaDado(layoutDisplay, tipoCampo, -1, 1, teclasFinalizadoras, 0, true, true, "", true, new long[]{1L}, false);
    }

    public synchronized EventoDispositivoEntrada capturaO(LayoutDisplay layoutDisplay, ConstantesApiAc.TipoCampo tipoCampo, String[] teclasFinalizadoras) throws ExcecaoNaoLocal {
        return this.capturaDado(layoutDisplay, tipoCampo, -1, 1, teclasFinalizadoras, 0, true, true, "", true, new long[]{1L}, false);
    }

    public synchronized EventoDispositivoEntrada capturaDado(LayoutDisplay layoutDisplay, ConstantesApiAc.TipoCampo tipoCampo, String valorDefault) throws ExcecaoNaoLocal {
        String[] teclasFinalizadoras = new String[]{"ENTRA", "VOLTA"};
        return this.capturaDado(layoutDisplay, tipoCampo, -1, 1, teclasFinalizadoras, 0, true, true, valorDefault, false, new long[]{1L}, false);
    }

    public synchronized EventoDispositivoEntrada capturaDado(LayoutDisplay layoutDisplay, boolean autoSkip, ConstantesApiAc.TipoCampo tipoCampo) throws ExcecaoNaoLocal {
        String[] teclasFinalizadoras = new String[]{"ENTRA", "VOLTA"};
        return this.capturaDado(layoutDisplay, tipoCampo, -1, 1, teclasFinalizadoras, 0, true, true, "", autoSkip, new long[]{1L}, false);
    }

    public synchronized EventoDispositivoEntrada capturaDado(LayoutDisplay layoutDisplay, ConstantesApiAc.TipoCampo tipoCampo, int tamMaximoEdicao) throws ExcecaoNaoLocal {
        String[] teclasFinalizadoras = new String[]{"ENTRA", "VOLTA"};
        return this.capturaDado(layoutDisplay, tipoCampo, tamMaximoEdicao, 1, teclasFinalizadoras, 0, true, true, "", false, new long[]{1L}, false);
    }

    public synchronized EventoDispositivoEntrada capturaDado(LayoutDisplay layoutDisplay, ConstantesApiAc.TipoCampo tipoCampo, String valorDefault, boolean aceitaZerosEsquerda) throws ExcecaoNaoLocal {
        String[] teclasFinalizadoras = new String[]{"ENTRA", "VOLTA"};
        return this.capturaDado(layoutDisplay, tipoCampo, -1, 1, teclasFinalizadoras, 0, true, aceitaZerosEsquerda, valorDefault, false, new long[]{1L}, false);
    }

    public synchronized EventoDispositivoEntrada capturaDado(LayoutDisplay layoutDisplay, ConstantesApiAc.TipoCampo tipoCampo, boolean aceitaZerosEsquerda) throws ExcecaoNaoLocal {
        String[] teclasFinalizadoras = new String[]{"ENTRA", "VOLTA"};
        return this.capturaDado(layoutDisplay, tipoCampo, -1, 1, teclasFinalizadoras, 0, true, aceitaZerosEsquerda, "", false, new long[]{1L}, false);
    }

    public synchronized EventoDispositivoEntrada capturaDado(LayoutDisplay layoutDisplay, ConstantesApiAc.TipoCampo tipoCampo, boolean aceitaZerosEsquerda, boolean mascaraSenha) throws ExcecaoNaoLocal {
        String[] teclasFinalizadoras = new String[]{"ENTRA", "VOLTA"};
        return this.capturaDado(layoutDisplay, tipoCampo, -1, 1, teclasFinalizadoras, 0, true, aceitaZerosEsquerda, "", false, new long[]{1L}, mascaraSenha);
    }

    public synchronized EventoDispositivoEntrada capturaDado(LayoutDisplay layoutDisplay, ConstantesApiAc.TipoCampo tipoCampo, int modoEdicao, boolean pularLinhaEdicao, int colunaEdicao, boolean aceitaZerosEsquerda) throws ExcecaoNaoLocal {
        String[] teclasFinalizadoras = new String[]{"ENTRA", "VOLTA"};
        return this.capturaDado(layoutDisplay, tipoCampo, -1, modoEdicao, teclasFinalizadoras, colunaEdicao, pularLinhaEdicao, aceitaZerosEsquerda, "", false, new long[]{1L}, false);
    }

    public synchronized EventoDispositivoEntrada capturaDado(LayoutDisplay layoutDisplay, ConstantesApiAc.TipoCampo tipoCampo, int modoEdicao, boolean pularLinhaEdicao, int colunaEdicao, boolean aceitaZerosEsquerda, boolean mascaraSenha) throws ExcecaoNaoLocal {
        String[] teclasFinalizadoras = new String[]{"ENTRA", "VOLTA"};
        return this.capturaDado(layoutDisplay, tipoCampo, -1, modoEdicao, teclasFinalizadoras, colunaEdicao, pularLinhaEdicao, aceitaZerosEsquerda, "", false, new long[]{1L}, mascaraSenha);
    }

    public synchronized EventoDispositivoEntrada capturaDado(LayoutDisplay layoutDisplay, ConstantesApiAc.TipoCampo tipoCampo, boolean pularLinhaEdicao, int colunaEdicao, boolean aceitaZerosEsquerda) throws ExcecaoNaoLocal {
        String[] teclasFinalizadoras = new String[]{"ENTRA", "VOLTA"};
        return this.capturaDado(layoutDisplay, tipoCampo, -1, 1, teclasFinalizadoras, colunaEdicao, pularLinhaEdicao, aceitaZerosEsquerda, "", false, new long[]{1L}, false);
    }

    public synchronized EventoDispositivoEntrada capturaDado(LayoutDisplay layoutDisplay, ConstantesApiAc.TipoCampo tipoCampo, boolean aceitaZerosEsquerda, long[] perifericos) throws ExcecaoNaoLocal {
        String[] teclasFinalizadoras = new String[]{"ENTRA", "VOLTA"};
        return this.capturaDado(layoutDisplay, tipoCampo, -1, 1, teclasFinalizadoras, 0, true, aceitaZerosEsquerda, "", false, perifericos, false);
    }

    public synchronized EventoDispositivoEntrada capturaDado(LayoutDisplay layoutDisplay, ConstantesApiAc.TipoCampo tipoCampo, boolean aceitaZerosEsquerda, String valorDefault, long[] perifericos) throws ExcecaoNaoLocal {
        String[] teclasFinalizadoras = new String[]{"ENTRA", "VOLTA"};
        return this.capturaDado(layoutDisplay, tipoCampo, -1, 1, teclasFinalizadoras, 0, true, aceitaZerosEsquerda, valorDefault, false, perifericos, false);
    }

    public synchronized EventoDispositivoEntrada capturaDado(LayoutDisplay layoutDisplay, ConstantesApiAc.TipoCampo tipoCampo, boolean aceitaZerosEsquerda, int colunaEdicao, boolean pularLinhaEdicao, String valorDefault) throws ExcecaoNaoLocal {
        String[] teclasFinalizadoras = new String[]{"ENTRA", "VOLTA"};
        return this.capturaDado(layoutDisplay, tipoCampo, -1, 1, teclasFinalizadoras, colunaEdicao, pularLinhaEdicao, aceitaZerosEsquerda, valorDefault, false, new long[]{1L}, false);
    }

    private synchronized EventoDispositivoEntrada capturaDado(LayoutDisplay layoutDisplay, ConstantesApiAc.TipoCampo tipoCampo, int tamMaximoEdicao, int modoEdicao, String[] teclas, int colunaEdicao, boolean pularLinhaEdicao, boolean aceitaZerosEsquerda, String valorDefault, boolean autoSkip, long[] perifericos, boolean mascaraSenha) throws ExcecaoNaoLocal {
        try {
            if (this.integracaoTranslator) {
                return ControladorTranslator.getInstancia().capturaDado(layoutDisplay, tipoCampo, aceitaZerosEsquerda, perifericos, this.entradaDeDados);
            }
            int linhaEdicao = 0;
            if (layoutDisplay != null) {
                int linhasUtilizadas = this.imprimeDisplay(layoutDisplay);
                linhaEdicao = pularLinhaEdicao ? linhasUtilizadas : linhasUtilizadas - 1;
            }
            Teclado teclado = this.getTeclado();
            while (this.displayLocked) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {}
            }
            ParametrosEdicaoTeclado par = null;
            try {
                boolean sentidoEsquerdaDireita = true;
                if (modoEdicao == 0) {
                    sentidoEsquerdaDireita = false;
                } else if (modoEdicao == 1) {
                    sentidoEsquerdaDireita = true;
                }
                String mascaraEdicao = "";
                if (tipoCampo != null) {
                    if (tamMaximoEdicao > 0) {
                        String novaMascaraEdicao = "";
                        String valorMascara = tipoCampo.getMascaraEdicao().substring(0, 1);
                        for (int i = 0; i < tamMaximoEdicao; ++i) {
                            novaMascaraEdicao = novaMascaraEdicao + valorMascara;
                        }
                        mascaraEdicao = novaMascaraEdicao;
                    } else {
                        mascaraEdicao = tipoCampo.getMascaraEdicao();
                    }
                }
                par = teclado.getParametros();
                par.setParametros(aceitaZerosEsquerda, false, sentidoEsquerdaDireita, mascaraEdicao, linhaEdicao, colunaEdicao, this.internacionalizacao.getSeparadorDecimal(), this.internacionalizacao.getSeparadorGrupo(), autoSkip, "", 0, 0, valorDefault, teclas, false);
                if (mascaraSenha) {
                    par.ativeSenha('*');
                } else {
                    par.ativeSenha('\u00aa');
                }
                teclado.defineParametros(par, true);
            }
            catch (ExcecaoMascaraInvalida e1) {
                logger.error((Object)"mascara n\u00e3o foi v\u00e1lida.", (Throwable)e1);
            }
            return this.leDados(perifericos);
        }
        catch (ExcecaoPerifericos e) {
            throw new ExcecaoNaoLocal(e);
        }
    }

    public int imprimeMenu(LayoutMenu layoutMenu) throws ExcecaoNaoLocal {
        EventoTeclado evTeclado = this.imprimeMenu(layoutMenu, new String[0], null);
        if (evTeclado.getTeclaFinalizadora().equals("VOLTA")) {
            return -1;
        }
        return Integer.parseInt(evTeclado.getStringLida());
    }

    public EventoTeclado imprimeMenu(LayoutMenu layoutMenu, String[] mensagemCaptura, ConstantesApiAc.TipoCampo tipoCampo) throws ExcecaoNaoLocal {
        if (this.integracaoTranslator) {
            if (tipoCampo != null) {
                int i;
                LayoutDisplay layoutDisplay = new LayoutDisplay();
                if (layoutMenu.getTitulo() != null) {
                    for (i = 0; i < layoutMenu.getTitulo().length; ++i) {
                        layoutDisplay.addLinha(new Linha(layoutMenu.getTitulo()[i]));
                    }
                }
                if (layoutMenu.getItens() != null) {
                    for (i = 0; i < layoutMenu.getItens().size(); ++i) {
                        Linha linha = (Linha)layoutMenu.getItens().get(i);
                        layoutDisplay.addLinha(new Linha(linha.getTexto()));
                    }
                }
                if (mensagemCaptura != null) {
                    for (i = 0; i < mensagemCaptura.length; ++i) {
                        layoutDisplay.addLinha(new Linha(mensagemCaptura[i]));
                    }
                }
                return (EventoTeclado)ControladorTranslator.getInstancia().capturaDado(layoutDisplay, tipoCampo, false, new long[]{1L}, this.entradaDeDados);
            }
            return ControladorTranslator.getInstancia().exibeMenu(layoutMenu);
        }
        if (this.isDisplayExterno()) {
            try {
                String[] teclasFinalizadoras = new String[]{"ENTRA", "VOLTA"};
                int opcao = 0;
                int opcaoVisivel = 1;
                while (opcao == 0) {
                    String navegacao = "";
                    if (opcaoVisivel == 1) {
                        navegacao = " [->]";
                        teclasFinalizadoras = new String[]{"ENTRA", "VOLTA", "TECLA_DIREITA"};
                    } else if (opcaoVisivel == layoutMenu.getItens().size()) {
                        navegacao = " [<-]";
                        teclasFinalizadoras = new String[]{"ENTRA", "VOLTA", "TECLA_ESQUERDA"};
                    } else {
                        navegacao = " [<- / ->]";
                        teclasFinalizadoras = new String[]{"ENTRA", "VOLTA", "TECLA_ESQUERDA", "TECLA_DIREITA"};
                    }
                    LayoutDisplay layoutDisplay = new LayoutDisplay();
                    if (layoutMenu.getTitulo() != null) {
                        layoutDisplay.addLinha(new Linha(layoutMenu.getTitulo()[0] + navegacao));
                    }
                    ItemMenu itemMenu = (ItemMenu)layoutMenu.getItens().get(opcaoVisivel - 1);
                    layoutDisplay.addLinha(new Linha(itemMenu.getTexto()));
                    tipoCampo = new ConstantesApiAc.TipoCampo(ConstantesApiAc.CAP_INFORMACOES_ADICIONAIS.getCodigo(), ConstantesApiAc.CAP_INFORMACOES_ADICIONAIS.getDescricao(), "Z");
                    EventoTeclado evt = (EventoTeclado)this.capturaDadoDisplayExterno(layoutDisplay, tipoCampo, teclasFinalizadoras);
                    if (evt.getTeclaFinalizadora().equals("TECLA_ESQUERDA")) {
                        if (opcaoVisivel <= 1) continue;
                        --opcaoVisivel;
                        continue;
                    }
                    if (evt.getTeclaFinalizadora().equals("TECLA_DIREITA")) {
                        if (opcaoVisivel >= layoutMenu.getItens().size()) continue;
                        ++opcaoVisivel;
                        continue;
                    }
                    if (evt.getTeclaFinalizadora().equals("ENTRA")) {
                        opcao = opcaoVisivel;
                        EventoTeclado eventoTeclado = new EventoTeclado(opcaoVisivel + "", "ENTRA", 1);
                        return eventoTeclado;
                    }
                    return evt;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            return null;
        }
        String[] teclasFinalizadoras = null;
        if (layoutMenu.isHabilitaItemFinalizador()) {
            teclasFinalizadoras = new String[]{"VOLTA"};
        } else if (tipoCampo != null) {
            teclasFinalizadoras = new String[]{"VOLTA", "ENTRA"};
        }
        return this.imprimeMenuFisico(layoutMenu, mensagemCaptura, tipoCampo, teclasFinalizadoras);
    }

    /*
     * Exception decompiling
     */
    private EventoTeclado imprimeMenuFisico(LayoutMenu layoutMenu, String[] mensagemCaptura, ConstantesApiAc.TipoCampo tipoCampo, String[] teclasFinalizadoras) throws ExcecaoNaoLocal {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 15[FORLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public int exibeMenuCancelamento() throws ExcecaoApiAc {
        int opcao = 0;
        do {
            if (this.isDisplayExterno()) {
                LayoutDisplay layoutDisplay = new LayoutDisplay("OPERACAO CANCELADA? 1-SIM / 2-NAO");
                ConstantesApiAc.TipoCampo tipoCampo = new ConstantesApiAc.TipoCampo(ConstantesApiAc.CAP_INFORMACOES_ADICIONAIS.getCodigo(), ConstantesApiAc.CAP_INFORMACOES_ADICIONAIS.getDescricao(), "Z");
                String[] teclasFinalizadoras = new String[]{"ENTRA", "VOLTA", "1", "2"};
                EventoTeclado evt = (EventoTeclado)this.capturaDado(layoutDisplay, tipoCampo, teclasFinalizadoras);
                int num = evt.getStringLida().length() - evt.getNumCaracteresDigitados();
                String dadoDigitado = evt.getStringLida().substring(num);
                try {
                    opcao = Integer.parseInt(dadoDigitado);
                }
                catch (NumberFormatException e) {}
                continue;
            }
            LayoutMenu layoutMenu = new LayoutMenu(MSG_DISPLAY, true);
            layoutMenu.addItem(new ItemMenu("SIM", "1"));
            layoutMenu.addItem(new ItemMenu("NAO", "2"));
            EventoTeclado eventoTeclado = null;
            if (this.integracaoTranslator) {
                eventoTeclado = ControladorTranslator.getInstancia().exibeMenu(layoutMenu);
                if (eventoTeclado.getTeclaFinalizadora().equals("VOLTA")) {
                    opcao = -1;
                    continue;
                }
                opcao = Integer.parseInt(eventoTeclado.getStringLida());
                continue;
            }
            opcao = this.imprimeMenu(layoutMenu);
        } while (opcao != 1 && opcao != 2);
        return opcao;
    }

    public EventoDispositivoEntrada leDadosPOSTef() throws ExcecaoNaoLocal {
        EventoDispositivoEntrada evento = null;
        try {
            long[] perifericos = new long[]{1L};
            evento = this.entradaDeDados.leValor(perifericos);
        }
        catch (ExcecaoValorInvalido e) {
            throw new ExcecaoNaoLocal(e);
        }
        return evento;
    }

    protected EventoDispositivoEntrada leDados(long[] perifericos) throws ExcecaoNaoLocal {
        EventoDispositivoEntrada evento = null;
        try {
            evento = this.entradaDeDados.leValor(perifericos);
        }
        catch (ExcecaoValorInvalido e) {
            throw new ExcecaoNaoLocal(e);
        }
        return evento;
    }

    public void limpaDisplay() throws ExcecaoNaoLocal {
        if (this.integracaoTranslator) {
            ControladorTranslator.getInstancia().limpaDisplay();
        } else {
            while (this.displayLocked) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            this.limpaDisplayIgnorandoLock();
        }
    }

    private void limpaDisplayIgnorandoLock() throws ExcecaoNaoLocal {
        try {
            Display displayOperador = this.getDisplay();
            displayOperador.limpa();
            displayOperador.posicionaCursor(0, 0);
            if (this.isDisplayExterno()) {
                Display display = this.getDisplayOperador();
                display.limpa();
                display.posicionaCursor(0, 0);
            }
        }
        catch (ExcecaoPerifericos e) {
            throw new ExcecaoNaoLocal(e);
        }
    }

    public void liberarRecursos() throws ExcecaoPerifericos {
        this.liberarRecursos(true);
    }

    public void liberarRecursos(boolean liberaBBComp) throws ExcecaoPerifericos {
        Display display;
        if (this.configuracaoPerifericos.perifericoCarregado("com.csi.ctfclient.tools.devices.emvfull.BibliotecaPinpad")) {
            logger.debug((Object)"liberando driver pinpad");
            if (this.entradaDeDados.getPin() != null) {
                this.entradaDeDados.desabilitaPin();
                this.entradaDeDados.setPin(null);
            }
            BibliotecaPinpad pinEMV = (BibliotecaPinpad)this.configuracaoPerifericos.getPerifericoPin();
            pinEMV.liberaRecursos(liberaBBComp);
            if (liberaBBComp) {
                this.configuracaoPerifericos.liberaPeriferico("com.csi.ctfclient.tools.devices.emvfull.BibliotecaPinpad");
            }
            logger.debug((Object)"driver pinpad liberado");
        }
        if (this.configuracaoPerifericos.perifericoCarregado("com.csi.ctfclient.tools.devices.LeitorCartaoHandler")) {
            logger.debug((Object)"liberando driver leitor cart\u00e3o");
            if (this.entradaDeDados.getLeitorCartao() != null) {
                this.entradaDeDados.desabilitaLeitorCartao();
                this.entradaDeDados.setLeitorCartao(null);
            }
            ILeitorCartaoHandler cartaohandler = this.configuracaoPerifericos.getPerifericoLeitorCartao();
            cartaohandler.liberaRecursos();
            this.configuracaoPerifericos.liberaPeriferico("com.csi.ctfclient.tools.devices.LeitorCartaoHandler");
            logger.debug((Object)"driver leitor cart\u00e3o liberado");
        }
        if (this.configuracaoPerifericos.perifericoCarregado("DRIVER_LEITOR_DOCUMENTO")) {
            logger.debug((Object)"liberando driver leitor documento");
            if (this.entradaDeDados.getLeitorDocumento() != null) {
                this.entradaDeDados.desabilitaLeitorDocumento();
                this.entradaDeDados.setLeitorDocumento(null);
            }
            LeitorDocumento leitorDocumento = this.configuracaoPerifericos.getPerifericoLeitorDocumento();
            leitorDocumento.liberaRecursos();
            this.configuracaoPerifericos.liberaPeriferico("DRIVER_LEITOR_DOCUMENTO");
            logger.debug((Object)"driver leitor documento liberado");
        }
        if (this.configuracaoPerifericos.perifericoCarregado("DRIVER_SCANNER")) {
            logger.debug((Object)"liberando driver scanner");
            if (this.entradaDeDados.getScanner() != null) {
                this.entradaDeDados.desabilitaScanner();
                this.entradaDeDados.setScanner(null);
            }
            Scanner scanner = this.configuracaoPerifericos.getPerifericoScanner();
            scanner.liberaRecursos();
            this.configuracaoPerifericos.liberaPeriferico("DRIVER_SCANNER");
            logger.debug((Object)"driver leitor scanner liberado");
        }
        if (this.configuracaoPerifericos.perifericoCarregado("DRIVER_TECLADO")) {
            logger.debug((Object)"liberando driver teclado");
            if (this.entradaDeDados.getTeclado() != null) {
                this.entradaDeDados.desabilitaTeclado();
                this.entradaDeDados.setTeclado(null);
            }
            Teclado teclado = this.configuracaoPerifericos.getPerifericoTeclado();
            teclado.removeDisplayEco(this.configuracaoPerifericos.getPerifericoDisplayCliente());
            teclado.desabilita();
            teclado.liberaRecursos();
            this.configuracaoPerifericos.liberaPeriferico("DRIVER_TECLADO");
            logger.debug((Object)"driver leitor teclado liberado");
        }
        if (this.configuracaoPerifericos.perifericoCarregado("DRIVER_DISPLAY_CLIENTE")) {
            logger.debug((Object)"liberando driver display cliente");
            display = this.configuracaoPerifericos.getPerifericoDisplayCliente();
            display.liberaRecursos();
            this.configuracaoPerifericos.liberaPeriferico("DRIVER_DISPLAY_CLIENTE");
            logger.debug((Object)"driver display cliente liberado");
        }
        if (this.configuracaoPerifericos.perifericoCarregado("DRIVER_DISPLAY_OPERADOR")) {
            logger.debug((Object)"liberando driver display operador");
            display = this.configuracaoPerifericos.getPerifericoDisplayOperador();
            display.limpa();
            display.liberaRecursos();
            this.configuracaoPerifericos.liberaPeriferico("DRIVER_DISPLAY_OPERADOR");
            logger.debug((Object)"driver display operador liberado");
        }
        if (!this.integracaoTranslator) {
            this.getTelaPrincipal().setVisible(false);
        }
        if (!ControladorFusion.getInstancia().isClosed()) {
            logger.debug((Object)"liberando controlador fusion");
            ControladorFusion.getInstancia().fecharSocket();
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"CTFClient -> visible = false");
        }
    }

    public void liberarRecursosPinCartao() throws ExcecaoPerifericos {
        if (this.configuracaoPerifericos.perifericoCarregado("com.csi.ctfclient.tools.devices.emvfull.BibliotecaPinpad")) {
            if (this.entradaDeDados.getPin() != null) {
                this.entradaDeDados.desabilitaPin();
                this.entradaDeDados.setPin(null);
            }
            PinEMV pinEMV = this.configuracaoPerifericos.getPerifericoPin();
            pinEMV.liberaRecursos();
            this.configuracaoPerifericos.liberaPeriferico("com.csi.ctfclient.tools.devices.emvfull.BibliotecaPinpad");
        }
        if (this.configuracaoPerifericos.perifericoCarregado("com.csi.ctfclient.tools.devices.LeitorCartaoHandler")) {
            if (this.entradaDeDados.getLeitorCartao() != null) {
                this.entradaDeDados.desabilitaLeitorCartao();
                this.entradaDeDados.setLeitorCartao(null);
            }
            ILeitorCartaoHandler cartaoHandler = this.configuracaoPerifericos.getPerifericoLeitorCartao();
            cartaoHandler.liberaRecursos();
            this.configuracaoPerifericos.liberaPeriferico("com.csi.ctfclient.tools.devices.LeitorCartaoHandler");
        }
    }

    public boolean perifericoCarregado(String valor) {
        return this.configuracaoPerifericos.perifericoCarregado(valor);
    }
}

