/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes;

import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.info.constantes.ConstantesApiAc;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.entrada.ITransacoesSAA;
import com.csi.ctfclient.tools.devices.EventoTeclado;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;

public class MicCapturaMatriculaAssociado {
    public static final String SUCCESS = "SUCCESS";
    public static final String USER_CANCEL = "USER_CANCEL";
    public static final String FILLED = "FILLED";

    public String execute(ITransacoesSAA dados) throws ExcecaoNaoLocal {
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        if (dados.getMatriculaAssociado() != null) {
            return FILLED;
        }
        ControladorPerifericos periferico = dados.getPerifericos();
        String valor = null;
        int caracteresDigitados = 0;
        while (caracteresDigitados < 1) {
            LayoutDisplay displayModel = new LayoutDisplay(inter.getMessage("CAPMATASS_TITLE"));
            EventoTeclado eventoTeclado = (EventoTeclado)periferico.capturaDado(displayModel, ConstantesApiAc.CAP_MATRICULA_ASSOCIADO);
            if (eventoTeclado.getTeclaFinalizadora().equals("VOLTA")) {
                return USER_CANCEL;
            }
            caracteresDigitados = eventoTeclado.getNumCaracteresDigitados();
            int num = eventoTeclado.getStringLida().length() - eventoTeclado.getNumCaracteresDigitados();
            valor = eventoTeclado.getStringLida().substring(num).trim();
        }
        dados.setMatriculaAssociado(valor);
        return SUCCESS;
    }
}

