/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes;

import com.csi.ctfclient.apitef.Apitef;
import com.csi.ctfclient.operacoes.Action;
import com.csi.ctfclient.operacoes.ActionForward;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.entrada.IIntegracao;
import com.csi.ctfclient.operacoes.entrada.ISpecificUserCancel;
import com.csi.ctfclient.operacoes.model.CodigoErroIntegracao;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.util.ReflectHelp;
import com.csi.ctfclient.tools.util.logger.CTFClientLogger;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.log4j.Logger;

public class ProcessManager {
    private static Logger logger = CTFClientLogger.getProcessManager();
    private Vector processListManager = new Vector();
    private static ProcessManager processManager;
    private static final String MSG_OPEUSERCANCEL = "OPERACAO        CANCELADA";
    private static final String MSG_USERCANCEL = "OPERACAO CANCELADA";

    private ProcessManager() {
        logger.info((Object)"Inicializando ProcessManager");
    }

    public static ProcessManager getInstance() {
        if (processManager == null) {
            processManager = new ProcessManager();
        }
        return processManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ExecutableProcess findProcess(int idProcess) throws Exception {
        ExecutableProcess execProcess = null;
        Vector vector = this.processListManager;
        synchronized (vector) {
            Enumeration enumerations = this.processListManager.elements();
            while (enumerations.hasMoreElements()) {
                Process process;
                execProcess = (ExecutableProcess)enumerations.nextElement();
                if (execProcess.getProcessList() == null || execProcess.getProcessList().isEmpty()) continue;
                Enumeration enumProcess = execProcess.getProcessList().elements();
                while (enumProcess.hasMoreElements() && (process = (Process)enumProcess.nextElement()).getIdProcess() != idProcess) {
                }
            }
        }
        return execProcess;
    }

    private void registyProcess(ExecutableProcess process) {
        this.processListManager.add(process);
    }

    public void process(Process process) {
        process.setApitef(new Apitef());
        ExecutableProcess execProcess = new ExecutableProcess();
        this.registyProcess(execProcess);
        execProcess.execute(process);
        this.processListManager.remove(execProcess);
    }

    public void subProcess(int idParent, Process subProcess) throws Exception {
        ExecutableProcess execProcess = this.findProcess(idParent);
        execProcess.subProcess(idParent, subProcess);
    }

    class ExecutableProcess {
        private Vector processList = new Vector();

        public int getIdProcess() {
            return this.hashCode();
        }

        public Vector getProcessList() {
            return this.processList;
        }

        public void setProcessList(Vector processList) {
            this.processList = processList;
        }

        private Process findProcess(int id) throws Exception {
            Process process = null;
            Enumeration enumerations = this.processList.elements();
            while (enumerations.hasMoreElements() && (process = (Process)enumerations.nextElement()).getIdProcess() != id) {
            }
            return process;
        }

        public Process subProcess(int idParent, Process subProcess) throws Exception {
            logger.info((Object)("Iniciando Sub Processo - [" + subProcess.getKey() + "] - " + subProcess.getDescription()));
            Process parentProcess = this.findProcess(idParent);
            subProcess.setPerifericos(parentProcess.getPerifericos());
            subProcess.setApitef(parentProcess.getApitef());
            subProcess.setParent(parentProcess);
            try {
                this.execute(subProcess);
            }
            catch (Throwable e) {
                subProcess.setErro(e);
                if (subProcess.getParent() != null) {
                    subProcess.getParent().setErro(e);
                }
                throw new Exception(e);
            }
            return subProcess;
        }

        private void registyProcess(Process process) {
            this.processList.add(process);
        }

        public void execute(Process process) {
            this.registyProcess(process);
            if (process.getStartKeyAction() != null && !process.getStartKeyAction().equals("")) {
                logger.info((Object)("Iniciando Processo - [" + process.getKey() + "] - " + process.getDescription()));
                process.setState(2);
                this.executeAction(process.getAction(process.getStartKeyAction()), process);
                if (process.getEndKeyAction() != null) {
                    int state = process.getState();
                    this.executeAction(process.getAction(process.getEndKeyAction()), process);
                    process.setState(state);
                }
            }
            this.processList.remove(process);
        }

        private void executeAction(Action action, Process process) {
            block33: {
                try {
                    block6: while (action != null) {
                        String nameClass = action.getProcessClass().getName();
                        String simpleName = nameClass.substring(nameClass.lastIndexOf(".") + 1);
                        logger.info((Object)("action [" + action.getKey() + "] -> " + simpleName));
                        Class classe = action.getProcessClass();
                        Object instancia = classe.newInstance();
                        Method method = ReflectHelp.getMethod(classe, "execute");
                        Object[] paramentro = new Object[]{process};
                        String resultForward = "";
                        while ((resultForward = (String)method.invoke(instancia, paramentro)).equals("RERUN")) {
                        }
                        ActionForward actionForward = action.getActionForward(resultForward);
                        logger.info((Object)("action [" + action.getKey() + "] -> " + resultForward));
                        if (actionForward != null) {
                            if (actionForward.getActionKey() == null || actionForward.getActionKey().equals("")) {
                                if (actionForward.getState() == 6) {
                                    action = null;
                                    process.setState(1);
                                } else if (actionForward.getState() == 3) {
                                    if (process.getState() == 3) break;
                                    if (process.isActiveDialogUserCancel()) {
                                        int opt = process.getPerifericos().exibeMenuCancelamento();
                                        switch (opt) {
                                            case 1: {
                                                IIntegracao processIntegracao;
                                                ISpecificUserCancel processMessage;
                                                if (process instanceof ISpecificUserCancel && (processMessage = (ISpecificUserCancel)((Object)process)).getUserCancelMessage() != null && processMessage.getUserCancelMessage().length() > 0) {
                                                    LayoutDisplay layoutDisplay = new LayoutDisplay(processMessage.getUserCancelMessage(), 1500L);
                                                    process.getPerifericos().imprimeDisplay(layoutDisplay);
                                                    process.getPerifericos().limpaDisplay();
                                                }
                                                LayoutDisplay displayModel = new LayoutDisplay(ProcessManager.MSG_USERCANCEL, 1500L);
                                                boolean exibeUserCancelPinpad = true;
                                                if (process instanceof IIntegracao && (processIntegracao = (IIntegracao)((Object)process)).getEntradaIntegracao() != null && processIntegracao.getEntradaIntegracao().getCodigoOrigemTransacao() == 1) {
                                                    exibeUserCancelPinpad = false;
                                                }
                                                if (exibeUserCancelPinpad) {
                                                    if (process.getPerifericos().getPin() != null) {
                                                        process.getPerifericos().getPin().setMsgDisplay(ProcessManager.MSG_OPEUSERCANCEL);
                                                    }
                                                    process.getPerifericos().imprimeDisplay(displayModel);
                                                }
                                                process.setState(actionForward.getState());
                                                if (process instanceof IIntegracao) {
                                                    IIntegracao integracao = (IIntegracao)((Object)process);
                                                    integracao.setErroIntegracao(new CodigoErroIntegracao(5317, ProcessManager.MSG_USERCANCEL));
                                                }
                                                process.setState(3);
                                                break;
                                            }
                                            case 2: {
                                                continue block6;
                                            }
                                        }
                                    } else {
                                        process.setState(3);
                                    }
                                } else if (actionForward.getState() == 1) {
                                    process.setState(actionForward.getState());
                                } else if (actionForward.getState() == 4) {
                                    process.setState(actionForward.getState());
                                } else if (actionForward.getState() == 5) {
                                    IIntegracao processIntegracao;
                                    ISpecificUserCancel processMessage;
                                    if (process.getState() == 5) break;
                                    process.getPerifericos().limpaDisplay();
                                    if (process instanceof ISpecificUserCancel && (processMessage = (ISpecificUserCancel)((Object)process)).getUserCancelMessage() != null && processMessage.getUserCancelMessage().length() > 0) {
                                        LayoutDisplay layoutDisplay = new LayoutDisplay(processMessage.getUserCancelMessage(), 1500L);
                                        process.getPerifericos().imprimeDisplay(layoutDisplay);
                                        process.getPerifericos().limpaDisplay();
                                    }
                                    LayoutDisplay displayModel = new LayoutDisplay(ProcessManager.MSG_USERCANCEL, 1500L);
                                    boolean exibeUserCancelPinpad = true;
                                    if (process instanceof IIntegracao && (processIntegracao = (IIntegracao)((Object)process)).getEntradaIntegracao() != null && processIntegracao.getEntradaIntegracao().getCodigoOrigemTransacao() == 1) {
                                        exibeUserCancelPinpad = false;
                                    }
                                    if (exibeUserCancelPinpad) {
                                        if (process.getPerifericos().getPin() != null) {
                                            process.getPerifericos().getPin().setMsgDisplay(ProcessManager.MSG_OPEUSERCANCEL);
                                        }
                                        process.getPerifericos().imprimeDisplay(displayModel);
                                    }
                                    if (process instanceof IIntegracao) {
                                        IIntegracao integracao = (IIntegracao)((Object)process);
                                        integracao.setErroIntegracao(new CodigoErroIntegracao(5317, ProcessManager.MSG_USERCANCEL));
                                    }
                                    process.setState(5);
                                } else {
                                    actionForward.setState(0);
                                }
                                action = null;
                                continue;
                            }
                            if (!process.getActions().containsKey(actionForward.getActionKey())) {
                                throw new IllegalStateException("action [\"" + actionForward.getActionKey() + "\"] n\u00e3o encontrado");
                            }
                            action = process.getAction(actionForward.getActionKey());
                            continue;
                        }
                        action = null;
                        process.setState(1);
                    }
                }
                catch (Throwable throwable) {
                    logger.fatal((Object)("action [\"" + action.getKey() + "\"] erro -" + throwable.getClass().getName()), throwable);
                    process.setErro(throwable);
                    process.setState(1);
                    if (process.getParent() == null) break block33;
                    process.getParent().setErro(throwable);
                }
            }
        }
    }
}

