/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.apitef.IdentApiTefC;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.config.ConfCTFClient;
import com.csi.ctfclient.config.ControladorConfCTFClient;
import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.operacoes.ControladorBaixaTecnica;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.entrada.IDados1F;
import com.csi.ctfclient.operacoes.model.AbstractCartao;
import com.csi.ctfclient.operacoes.model.CMOSPinPad;
import com.csi.ctfclient.operacoes.model.Cartao;
import com.csi.ctfclient.operacoes.model.CartaoChip;
import com.csi.ctfclient.operacoes.model.CartaoDigitado;
import com.csi.ctfclient.operacoes.model.CartaoMagnetico;
import com.csi.ctfclient.operacoes.model.GetInfo;
import com.csi.ctfclient.operacoes.model.Produto;
import com.csi.ctfclient.operacoes.model.RegistroCriptografia;
import com.csi.ctfclient.operacoes.model.TabelaCriptografia;
import com.csi.ctfclient.servicos.IdentTerminal;
import com.csi.ctfclient.tools.devices.ExcecaoPerifericos;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.devices.emv.DadosGetInfoRedeEMV;
import com.csi.ctfclient.tools.devices.emv.LeitorCartaoEMV;
import com.csi.ctfclient.tools.devices.emv.PinEMV;
import com.csi.ctfclient.tools.devices.emv.SaidaGetInfoEMV;
import com.csi.ctfclient.tools.devices.emv.SaidaGetInfoRedecardEMV;
import com.csi.ctfclient.tools.devices.emvfull.BibliotecaPinpad;
import com.csi.ctfclient.tools.devices.emvfull.LeitorCartaoBibliotecaCompartilhada;
import com.csi.ctfclient.tools.devices.emvfull.ProtocoloBibliotecaCompartilhada;
import com.csi.ctfclient.tools.util.HexaUtil;
import com.csi.ctfclient.tools.util.StringUtil;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import com.csi.ctfclient.tools.util.logger.CTFClientLogger;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public abstract class MicAbstractEnvio1F {
    public static final String SUCESS = "SUCESS";
    public static final String UNECESSARY = "UNECESSARY";
    public static final String ERRO = "ERRO";
    public static final String ERRO_TRANSGENERICA = "ERRO_TRANSGENERICA";
    public static final String LEITURA_AUTTAR_EMV = "LEITURA_AUTTAR_EMV";
    public static final String REFAZER_LEITURA_CARTAO = "REFAZER_LEITURA_CARTAO";
    public static final String SOLICITA_CARGA_TABELA = "SOLICITA_CARGA_TABELA";
    private boolean multiTerminal = false;
    private boolean delivery = false;
    private Logger logger = CTFClientLogger.getCTFClient();
    private final char DELIMITADOR_TRILHA1 = (char)94;
    private final char DELIMITADOR_TRILHA2 = (char)61;
    private String codigoTransacaoRetorno;
    private ConfCTFClient confCTFClient;

    protected abstract String getCodigoTransacao(IDados1F var1) throws IllegalStateException;

    public String execute(IDados1F dados) throws ExcecaoApiAc {
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        this.confCTFClient = ControladorConfCTFClient.getInstance().getConfig();
        boolean connectedPin = false;
        EntradaApiTefC entrada = dados.getEntradaApiTef();
        if (entrada == null) {
            entrada = new EntradaApiTefC();
        }
        ControladorPerifericos periferico = dados.getPerifericos();
        if (dados.getEntradaIntegracao() != null) {
            this.multiTerminal = dados.getEntradaIntegracao().isMultiTerminal();
            this.delivery = dados.getEntradaIntegracao().getCodigoOrigemTransacao() == 1;
        } else {
            boolean bl = this.delivery = dados.getCodigoOrigemTransacao() == 1;
        }
        if (this.multiTerminal) {
            entrada.setTipoPin("**");
            entrada.setIdentificacaoTransacao(2);
            if (dados.getEntradaIntegracao() != null) {
                entrada.setCodigoAdquirenteWeb(dados.getEntradaIntegracao().getRedeAdquirente());
            }
        } else {
            LayoutDisplay displayModel = new LayoutDisplay(inter.getMessage("ENVIO1F_TITLE"));
            periferico.imprimeDisplay(displayModel);
            boolean bl = connectedPin = periferico.getPin() != null;
            if (connectedPin) {
                if (periferico.getPin().isBibliotecaEMV()) {
                    entrada.setTipoPin("16");
                    entrada.setTipoBibliotecaPinpad(ProtocoloBibliotecaCompartilhada.getTipoBibliotecaPinpad());
                    GetInfo dadosGetInfo = new GetInfo();
                    DadosGetInfoRedeEMV dadosGetInfoRedeEMV = periferico.getPin().getInfoRedeEMV(4);
                    if (dadosGetInfoRedeEMV != null) {
                        entrada.setDadosGetInfoRede4(dadosGetInfoRedeEMV.getRespostaDLL());
                        entrada.setVersaoBibliotecaRedeEMV(dadosGetInfoRedeEMV.getVersaoAplicacao());
                        entrada.setVersaoEspecificacaoRedeEMV(dadosGetInfoRedeEMV.getInformacoesProprietarias());
                        dadosGetInfo.setVersaoBibRede4(dadosGetInfoRedeEMV.getVersaoAplicacao());
                    }
                    SaidaGetInfoEMV getInfoEMV = periferico.getPin().getInfo();
                    entrada.setNumeroSeriePin(getInfoEMV.getNumSeriePinpad());
                    entrada.setRetornoGetInfo(getInfoEMV.getRetorno());
                    entrada.setFabricantePinpad(getInfoEMV.getFabricante());
                    dadosGetInfo.setCodigoRetorno(getInfoEMV.getRetorno());
                    dadosGetInfo.setFabricante(getInfoEMV.getFabricante());
                    dadosGetInfo.setModeloHardware(getInfoEMV.getModeloHardware());
                    dadosGetInfo.setNumeroSerie(getInfoEMV.getNumSeriePinpad());
                    dadosGetInfo.setVersaoEspecificao(getInfoEMV.getVersaoEspecificacao());
                    dadosGetInfo.setVersaoAplicacao(getInfoEMV.getVersaoAplBasica());
                    dadosGetInfo.setVersaoFirmware(getInfoEMV.getVersaoFirmware());
                    dados.setDadosGetInfo(dadosGetInfo);
                } else {
                    entrada.setTipoPin("14");
                }
            } else {
                entrada.setTipoPin("**");
            }
            ControladorBaixaTecnica baixaTecnica = ControladorBaixaTecnica.getInstance();
            if (connectedPin && baixaTecnica.verificaNecessidadeBaixaTecnica(dados)) {
                entrada.setFlagBaixaTecnicaVisanet('2');
            }
        }
        if (dados.getProdutoDinamico() != null) {
            Produto produto = dados.getProdutoDinamico();
            entrada.setCodigoProduto(produto.getCodigo());
            entrada.setCodigoBandeira(produto.getCodigoBandeira());
            entrada.setFluxoTef(produto.getKeyFluxo());
        } else {
            entrada.setCodigoProduto(0);
        }
        entrada.setNumeroTransacao(dados.getNumeroTransacao());
        entrada.setDataCliente(dados.getStartProcess());
        entrada.setTimeoutCtf(this.getTimeout1F());
        entrada.setOperacao("1F");
        entrada.setValorTransacao(dados.getValorTransacao());
        entrada.setOperacaoConsultada(this.getCodigoTransacao(dados));
        entrada.setRetornoBibliotecaCompartilhada(dados.getLastErrorCode());
        if (dados.getCartao() != null) {
            if (dados.getCartao() instanceof CartaoChip) {
                CartaoChip cartaoChip = (CartaoChip)dados.getCartao();
                entrada.setModoEntrada(5);
                entrada.setCodigoRedeAdquirenteChip(cartaoChip.getTipoRedeAdquirente());
                entrada.setIndiceAid(cartaoChip.getIndiceRegistroAID());
                entrada.setNumeroAplicacao(cartaoChip.getNumero());
                entrada.setTipoCartao(cartaoChip.getTipoCartao());
                entrada.setIssuerCountryCode(cartaoChip.getIssuerCountry());
                entrada.setInfo(cartaoChip.getTrilha2().trim());
                entrada.setNomeCliente(cartaoChip.getNomePortador());
                entrada.setTipoAplicacaoChip(cartaoChip.getTipoAplicacao());
                entrada.setStatusChip(cartaoChip.getStatusUltimaLeitura());
                entrada.setCardSequenceNumber(cartaoChip.getPanSequenceNumber());
                entrada.setWFlags(cartaoChip.getFlags());
                entrada.setDadosRedeAdquirente(cartaoChip.getDadosRedeAdquirente());
                entrada.setPAN(cartaoChip.getNumero());
                if (cartaoChip.getNumeroCriptografado() != null) {
                    entrada.setCartaoCriptografado(cartaoChip.getNumeroCriptografado());
                }
                entrada.setApplicationExpirationDate(cartaoChip.getApplicationExpirationDate());
                entrada.setPAN(cartaoChip.getPAN());
            } else if (dados.getCartao() instanceof CartaoMagnetico) {
                CartaoMagnetico cartaoMagnetico = (CartaoMagnetico)dados.getCartao();
                entrada.setModoEntrada(2);
                entrada.setTipoAplicacaoChip(cartaoMagnetico.getTipoAplicacao());
                entrada.setTipoCartao(cartaoMagnetico.getTipoCartao());
                entrada.setInfo(cartaoMagnetico.getTrilha2().trim());
                entrada.setTrilha1(cartaoMagnetico.getTrilha1().trim());
                entrada.setStatusChip(cartaoMagnetico.getStatusUltimaLeitura());
                entrada.setIssuerCountryCode(cartaoMagnetico.getIssuerCountry());
                entrada.setNumeroAplicacao(cartaoMagnetico.getNumero());
                entrada.setNomeCliente(cartaoMagnetico.getNomePortador());
                entrada.setWFlags(cartaoMagnetico.getFlags());
                entrada.setDadosRedeAdquirente(cartaoMagnetico.getDadosRedeAdquirente());
                entrada.setPAN(cartaoMagnetico.getNumero());
                if (cartaoMagnetico.getNumeroCriptografado() != null) {
                    entrada.setCartaoCriptografado(cartaoMagnetico.getNumeroCriptografado());
                }
            } else if (dados.getCartao() instanceof CartaoDigitado) {
                CartaoDigitado cartaoDigitado = (CartaoDigitado)dados.getCartao();
                entrada.setModoEntrada(1);
                entrada.setInfo(cartaoDigitado.getNumero());
                entrada.setFallbackDigitado(cartaoDigitado.isFallback());
                if (cartaoDigitado.getVencimento() != null) {
                    entrada.setDataVencimento(cartaoDigitado.getDateVencimento());
                }
                entrada.setPAN(cartaoDigitado.getNumero());
                if (cartaoDigitado.getNumeroCriptografado() != null) {
                    entrada.setCartaoCriptografado(cartaoDigitado.getNumeroCriptografado());
                }
            }
        }
        ConfCTFClient conf = ControladorConfCTFClient.getInstance().getConfig();
        IdentApiTefC ident = new IdentApiTefC();
        IdentTerminal identTerminal = null;
        identTerminal = this.multiTerminal || this.delivery ? (dados.getEntradaIntegracao() != null ? dados.getEntradaIntegracao().getIdentTerminal() : dados.getIdentTerminal()) : new IdentTerminal(conf.getEstabelecimento(), conf.getLoja(), conf.getTerminal());
        ident.setNumeroEstabelecimento(identTerminal.getEstabelecimento());
        ident.setNumeroLoja(identTerminal.getLoja());
        ident.setNumeroPdv(identTerminal.getTerminal());
        ident.setNumeroSites(String.valueOf(conf.getNumeroSites()));
        ident.setListaIP(conf.getIps());
        ident.setQuantidadeVias(conf.getQuantidadeVias());
        SaidaApiTefC saidaApiTefC = dados.getApitef().solicitacao(ident, entrada);
        dados.setEntradaApiTef(entrada);
        dados.setSaidaApiTef(saidaApiTefC);
        if (dados.getSaidaApiTef().getRetorno() == 0 && (saidaApiTefC.getFlagBaixaTecnica() == '1' || saidaApiTefC.getFlagBaixaTecnica() == '2')) {
            ControladorBaixaTecnica.getInstance().setBaixaTecnicaSolicitada(true);
        } else {
            ControladorBaixaTecnica.getInstance().setBaixaTecnicaSolicitada(false);
        }
        if (connectedPin) {
            if (saidaApiTefC.getRedeChip() > 0 && (saidaApiTefC.getTipoBibliotecaPinpad() == 2 || saidaApiTefC.isRefazerLeituraCartao()) && dados.getCartao() instanceof CartaoChip && periferico.getLeitorCartao() != null) {
                periferico.getLeitorCartao().setRedeAdquirente(saidaApiTefC.getRedeChip());
                if (saidaApiTefC.getTipoBibliotecaPinpad() == 1 && saidaApiTefC.getIndiceAID() != null) {
                    periferico.getLeitorCartao().setIndiceAID(saidaApiTefC.getIndiceAID());
                }
            }
            if (saidaApiTefC.getFlagCargaTabela() == '1' && dados.getCartao() instanceof CartaoChip) {
                try {
                    this.logger.info((Object)"NECESSITA REALIZAR CARGA DE TABELA");
                    if (saidaApiTefC.getTipoBibliotecaPinpad() == 2) {
                        CMOSPinPad.getInstance().solicitarCargaTabelas(saidaApiTefC.getRedeChip());
                    } else {
                        CMOSPinPad.getInstance().solicitarCargaTabelas(0);
                    }
                    if (periferico.getLeitorCartao() != null) {
                        periferico.getLeitorCartao().setSolicitaCargaTabelas(LeitorCartaoEMV.CARGA_TABELA_SOLICITADA);
                        dados.setSaidaApiTef(null);
                        dados.setCartao(null);
                    }
                    if (saidaApiTefC.getTipoBibliotecaPinpad() == 2) {
                        ProtocoloBibliotecaCompartilhada.setTipoBibliotecaPinpad(2);
                        return LEITURA_AUTTAR_EMV;
                    }
                    return SOLICITA_CARGA_TABELA;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (saidaApiTefC.getTipoBibliotecaPinpad() == 2) {
                ProtocoloBibliotecaCompartilhada.setTipoBibliotecaPinpad(2);
                return LEITURA_AUTTAR_EMV;
            }
            if (saidaApiTefC.isRefazerLeituraCartao()) {
                this.setCodigoTransacaoRetorno(saidaApiTefC.getCodigoTransacao());
                dados.setNovaLeituraCartao(true);
                dados.setCartao(null);
                dados.setSaidaApiTef(null);
                return REFAZER_LEITURA_CARTAO;
            }
        }
        if (dados.getSaidaApiTef().getRetorno() == 0) {
            this.logger.info((Object)"1F APROVADA");
            if ((saidaApiTefC.getCodigoVan() == 68 || saidaApiTefC.getCodigoVan() == 90 || saidaApiTefC.getCodigoVan() == 37) && connectedPin) {
                SaidaGetInfoRedecardEMV infoRedecardEMV = periferico.getPin().getInfoRedecard();
                dados.getDadosGetInfo().setVersaoBibliotecaCompartilhada(infoRedecardEMV.getInformacaoProprietaria());
                dados.getDadosGetInfo().setVersaoRedeAdquirente(infoRedecardEMV.getVersaoRedeAdquirente());
                dados.getDadosGetInfo().setVersaoKernelEMV(infoRedecardEMV.getVersaoKernelEMV());
            }
            dados.setCodigoVan(saidaApiTefC.getCodigoVan());
            dados.setNomeVan(saidaApiTefC.getNomeVan());
            dados.setCodigoAutorizadora(saidaApiTefC.getCodigoAutorizadora());
            dados.setNomeAutorizadora(saidaApiTefC.getNomeAutorizadora());
            dados.setCodigoInstituicaoFinanceira(saidaApiTefC.getCodigoInstituicaoFinanceira());
            dados.setNomeInstituicaoFinanceira(saidaApiTefC.getNomeInstituicaoFinanceira());
            if (connectedPin && periferico.getPin().isBibliotecaEMV()) {
                PinEMV pinEMV = periferico.getPin();
                dados.setTabelaCriptografia(saidaApiTefC.getTabelaCriptografia(pinEMV));
                if (saidaApiTefC.isCriptografiaCartao()) {
                    this.logger.log((Priority)Level.DEBUG, (Object)"Criptografar os dados do cart\u00e3o");
                    this.montaCriptografiaCartao(dados);
                }
            }
            return SUCESS;
        }
        if (connectedPin) {
            if (dados.getCartao() instanceof CartaoChip && dados.getErrorCode() == -1) {
                dados.setErrorCode(0);
            }
            ControladorBaixaTecnica.getInstance().setBaixaTecnicaSolicitada(false);
        }
        this.logger.info((Object)("1F N\u00c3O APROVADA RETORNO: " + dados.getSaidaApiTef().getRetorno() + " CODIGO DETALHE: " + dados.getSaidaApiTef().getCodigoErro() + " RESPOSTA AUTORIZADORA: " + dados.getSaidaApiTef().getCodigoRespostaAutorizadora()));
        String resposta = dados.getSaidaApiTef().getCodigoRespostaAutorizadora();
        if ("0EB".equals(resposta) || "EB".equals(resposta)) {
            if (dados.getCartao() instanceof CartaoChip) {
                dados.setNovaLeituraCartao(true);
            } else {
                dados.setCartao(null);
            }
        } else if (!(dados.getCartao() instanceof CartaoDigitado)) {
            if (!"0F0".equals(resposta) && !"F0".equals(resposta)) {
                if (dados.getCartao() instanceof CartaoChip) {
                    dados.setNovaLeituraCartao(true);
                } else {
                    dados.setCartao(null);
                }
            }
        } else {
            CartaoDigitado cartaoDigitado = (CartaoDigitado)dados.getCartao();
            if ("0EM".equals(resposta) || "EM".equals(resposta)) {
                cartaoDigitado.setVencimento(null);
            } else if ("0EH".equals(resposta) || "EH".equals(resposta)) {
                cartaoDigitado.setVencimento(null);
            } else if (!"0F0".equals(resposta) && !"F0".equals(resposta)) {
                dados.setCartao(null);
            }
        }
        if (dados.isCartaoTransacaoGenerica()) {
            return ERRO_TRANSGENERICA;
        }
        return ERRO;
    }

    private void montaCriptografiaCartao(IDados1F dados) throws ExcecaoPerifericos {
        Cartao cartao = dados.getCartao();
        if (cartao instanceof CartaoDigitado) {
            String panEB;
            CartaoDigitado cartaoDigitado = (CartaoDigitado)cartao;
            if (ProtocoloBibliotecaCompartilhada.isComunicacaoSegura() && cartaoDigitado.getNumero().length() > 12) {
                this.logger.log((Priority)Level.DEBUG, (Object)"Comunica\u00e7\u00e3o segura: utilizando o PAN 3 DES Reverso do cart\u00e3o digitado");
                panEB = cartaoDigitado.getPanCripto();
            } else {
                panEB = cartaoDigitado.getNumero();
            }
            String cartaoDigitadoCripto = this.criptografaNumeroCartaoDigitado(dados, panEB);
            cartaoDigitado.setNumeroCriptografado(cartaoDigitadoCripto);
        } else if (cartao instanceof AbstractCartao) {
            String panEB;
            String cript;
            AbstractCartao cartaoGenerico = (AbstractCartao)cartao;
            if (cartaoGenerico.getTrilha1() != null && !cartaoGenerico.getTrilha1().trim().equals("")) {
                String digitos = cartaoGenerico.getTrilha1().substring(3, 11);
                String digHexa = HexaUtil.toEBCDICHex(digitos);
                if (ProtocoloBibliotecaCompartilhada.isComunicacaoSegura()) {
                    this.logger.log((Priority)Level.DEBUG, (Object)"Comunica\u00e7\u00e3o segura: Criptografando d\u00edgito intercalado para a trilha 1");
                    digHexa = LeitorCartaoBibliotecaCompartilhada.descriptografaPAN(digHexa, false);
                }
                cript = this.criptografaDados(dados, digHexa, dados.getSaidaApiTef());
                String trilha1Cripto = cartaoGenerico.getTrilha1().substring(0, 3) + cript + cartaoGenerico.getTrilha1().substring(11);
                cartaoGenerico.setTrilha1Criptografado(trilha1Cripto);
            }
            if (cartaoGenerico.getTrilha2() != null && !cartaoGenerico.getTrilha2().trim().equals("")) {
                String panTrilha2;
                String panTrilha2Substituir = panTrilha2 = cartaoGenerico.getPAN();
                if (panTrilha2.length() < 16) {
                    panTrilha2Substituir = cartaoGenerico.getTrilha2().substring(0, 16);
                    panTrilha2 = panTrilha2Substituir.replace('=', 'D');
                } else if (panTrilha2.length() > 16) {
                    panTrilha2Substituir = panTrilha2 = panTrilha2.substring(0, 16);
                }
                if (ProtocoloBibliotecaCompartilhada.isComunicacaoSegura()) {
                    this.logger.log((Priority)Level.DEBUG, (Object)"Comunica\u00e7\u00e3o segura: Criptografando o PAN para a trilha 2");
                    panTrilha2 = LeitorCartaoBibliotecaCompartilhada.descriptografaPAN(panTrilha2, false);
                }
                cript = this.criptografaDados(dados, panTrilha2, dados.getSaidaApiTef());
                cartaoGenerico.setTrilha2Criptografado(LeitorCartaoBibliotecaCompartilhada.atualizaTrilha(cartaoGenerico.getTrilha2(), panTrilha2Substituir, cript));
            }
            if (ProtocoloBibliotecaCompartilhada.isComunicacaoSegura() && cartaoGenerico.getNumero().length() > 12) {
                this.logger.log((Priority)Level.DEBUG, (Object)"Comunica\u00e7\u00e3o segura: Criptografando o PAN");
                panEB = cartaoGenerico.getPANCripto();
            } else {
                panEB = cartaoGenerico.getNumero();
            }
            String cartaoCripto = this.criptografaNumeroCartaoDigitado(dados, panEB);
            cartaoGenerico.setNumeroCriptografado(cartaoCripto);
        }
    }

    private String criptografaDados(IDados1F dado, String value, SaidaApiTefC saida) throws ExcecaoPerifericos {
        ControladorPerifericos periferico = dado.getPerifericos();
        PinEMV pin = periferico.getPin();
        if (pin instanceof BibliotecaPinpad) {
            BibliotecaPinpad pinCompartilhado = (BibliotecaPinpad)pin;
            TabelaCriptografia tabelaCriptografia = dado.getTabelaCriptografia();
            RegistroCriptografia registroCriptografia = tabelaCriptografia.getCriptografiaDadosPrincipal();
            int modoCriptografia = registroCriptografia.getAlgoritmo();
            String workingKey = StringUtil.completaString(registroCriptografia.getWorkingKey().trim(), 32, '0', false);
            int indiceCriptografia = registroCriptografia.getIndiceMasterKey() == 42 ? 0 : registroCriptografia.getIndiceMasterKey();
            this.logger.log((Priority)Level.DEBUG, (Object)("Criptografia: Indice: " + indiceCriptografia + ", Modo: " + modoCriptografia + ", Working Key: " + workingKey));
            if (modoCriptografia == 0) {
                workingKey = StringUtil.completaString(workingKey, 32, '0', 4);
            }
            if (ProtocoloBibliotecaCompartilhada.isComunicacaoSegura()) {
                // empty if block
            }
            return pinCompartilhado.encryptBuffer(modoCriptografia, indiceCriptografia, workingKey, value);
        }
        throw new ExcecaoPerifericos(null, "Erro na criptografia do cart\u00e3o");
    }

    private String criptografaNumeroCartaoDigitado(IDados1F dados, String cartaoDigitado) throws ExcecaoPerifericos {
        String cartaoCripto;
        if (cartaoDigitado.length() < 16) {
            cartaoCripto = StringUtil.completaString(cartaoDigitado, 16, 'F', 4);
            cartaoCripto = this.criptografaDados(dados, cartaoCripto, dados.getSaidaApiTef());
        } else {
            cartaoCripto = this.criptografaDados(dados, cartaoDigitado.substring(0, 16), dados.getSaidaApiTef());
            cartaoCripto = cartaoCripto + cartaoDigitado.substring(16);
        }
        return cartaoCripto;
    }

    private boolean isTrilha1PermiteComunicacaoSegura(String trilha1) {
        int i = 0;
        int tamanhoPan = 0;
        boolean encontrouDelimitador = false;
        if (trilha1.charAt(0) != '^') {
            ++i;
        }
        while (i < trilha1.length()) {
            if (trilha1.charAt(i) != '^') {
                ++tamanhoPan;
            } else {
                encontrouDelimitador = true;
                break;
            }
            ++i;
        }
        return encontrouDelimitador ? tamanhoPan > 12 : trilha1.length() > 12;
    }

    private boolean isTrilha2PermiteComunicacaoSegura(String trilha2) {
        int tamanhoPan = 0;
        boolean encontrouDelimitador = false;
        for (int i = 0; i < trilha2.length(); ++i) {
            if (trilha2.charAt(i) != '=') {
                ++tamanhoPan;
                continue;
            }
            encontrouDelimitador = true;
            break;
        }
        return encontrouDelimitador ? tamanhoPan > 12 : trilha2.length() > 12;
    }

    private boolean isPanPermiteComunicacaoSegura(String pan) {
        return pan != null && pan.length() > 12;
    }

    private void setCodigoTransacaoRetorno(String codigoTransacaoRetorno) {
        this.codigoTransacaoRetorno = codigoTransacaoRetorno;
    }

    protected String getCodigoTransacaoRetorno() {
        return this.codigoTransacaoRetorno;
    }

    protected int getTimeout1F() {
        if (this.confCTFClient.getTimeOutDefault() > 0) {
            return this.confCTFClient.getTimeOutDefault();
        }
        return 15;
    }
}

