/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.apitef.IdentApiTefC;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.config.ConfCTFClient;
import com.csi.ctfclient.config.ControladorConfCTFClient;
import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.entrada.IDadosConsulta;
import com.csi.ctfclient.servicos.IdentTerminal;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import com.csi.ctfclient.tools.util.logger.CTFClientLogger;
import org.apache.log4j.Logger;

public abstract class MicAbstractEnvioConsulta {
    public static final String SUCESS = "SUCESS";
    public static final String UNECESSARY = "UNECESSARY";
    public static final String ERROR = "ERROR";
    private Logger logger = CTFClientLogger.getCTFClient();

    protected abstract String getCodigoTransacao(IDadosConsulta var1) throws IllegalStateException;

    protected abstract String getOperacao() throws IllegalStateException;

    public String execute(IDadosConsulta dados) throws ExcecaoApiAc {
        ConfCTFClient conf;
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        EntradaApiTefC entrada = dados.getEntradaApiTef();
        if (entrada == null) {
            entrada = new EntradaApiTefC();
        }
        if (!(conf = ControladorConfCTFClient.getInstance().getConfig()).isIntegracaoWeb()) {
            ControladorPerifericos perifericos = dados.getPerifericos();
            LayoutDisplay displayModel = new LayoutDisplay(inter.getMessage("ENVIO1G_TITLE"));
            perifericos.imprimeDisplay(displayModel);
        }
        boolean delivery = false;
        if (dados.getEntradaIntegracao() != null) {
            delivery = dados.getEntradaIntegracao().getCodigoOrigemTransacao() == 1;
        }
        entrada.setDataCliente(dados.getStartProcess());
        entrada.setTimeoutCtf(15);
        entrada.setOperacao(this.getOperacao());
        entrada.setValorTransacao(dados.getValorTransacao());
        if (this.getCodigoTransacao(dados) != null) {
            entrada.setOperacaoConsultada(this.getCodigoTransacao(dados));
        }
        IdentApiTefC ident = new IdentApiTefC();
        IdentTerminal identTerminal = null;
        identTerminal = dados.getEntradaIntegracao() != null && dados.getEntradaIntegracao().isMultiTerminal() || delivery ? dados.getEntradaIntegracao().getIdentTerminal() : new IdentTerminal(conf.getEstabelecimento(), conf.getLoja(), conf.getTerminal());
        ident.setNumeroEstabelecimento(identTerminal.getEstabelecimento());
        ident.setNumeroLoja(identTerminal.getLoja());
        ident.setNumeroPdv(identTerminal.getTerminal());
        ident.setNumeroSites(String.valueOf(conf.getNumeroSites()));
        ident.setListaIP(conf.getIps());
        ident.setQuantidadeVias(conf.getQuantidadeVias());
        SaidaApiTefC saidaApiTefC = dados.getApitef().solicitacao(ident, entrada);
        dados.setSaida1G(saidaApiTefC);
        if (dados.getSaida1G().getRetorno() == 0) {
            this.logger.info((Object)(this.getOperacao() + " APROVADA"));
            return SUCESS;
        }
        this.logger.info((Object)(this.getOperacao() + " N\u00c3O APROVADA RETORNO :" + dados.getSaida1G().getRetorno() + " CODIGO DETALHE " + dados.getSaida1G().getCodigoErro()));
        dados.setSaidaApiTef(saidaApiTefC);
        return ERROR;
    }
}

