/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.config.ControladorConfCTFClient;
import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.operacoes.ControladorBaixaTecnica;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.entrada.ICodigoSeguranca;
import com.csi.ctfclient.operacoes.entrada.IConfirmacaoPositiva;
import com.csi.ctfclient.operacoes.entrada.IDadoCartao;
import com.csi.ctfclient.operacoes.entrada.IDadoGetInfo;
import com.csi.ctfclient.operacoes.entrada.IDadoPin;
import com.csi.ctfclient.operacoes.entrada.IDevices;
import com.csi.ctfclient.operacoes.entrada.IEntradaApiTef;
import com.csi.ctfclient.operacoes.entrada.IFinishChip;
import com.csi.ctfclient.operacoes.entrada.IInformacoesAdicionais;
import com.csi.ctfclient.operacoes.entrada.IIntegracao;
import com.csi.ctfclient.operacoes.entrada.IOrigemTransacao;
import com.csi.ctfclient.operacoes.entrada.IPinpadError;
import com.csi.ctfclient.operacoes.entrada.ISaidaApiTef;
import com.csi.ctfclient.operacoes.microoperacoes.MicAbstractSolicitacaoTEF;
import com.csi.ctfclient.operacoes.model.AbstractCartao;
import com.csi.ctfclient.operacoes.model.Cartao;
import com.csi.ctfclient.operacoes.model.CartaoChip;
import com.csi.ctfclient.operacoes.model.CartaoDigitado;
import com.csi.ctfclient.operacoes.model.CartaoMagnetico;
import com.csi.ctfclient.operacoes.model.CodigoSeguranca;
import com.csi.ctfclient.operacoes.model.GetInfo;
import com.csi.ctfclient.operacoes.model.PinInfo;
import com.csi.ctfclient.servicos.EntradaCTFClientCtrl;
import com.csi.ctfclient.tools.devices.emvfull.ProtocoloBibliotecaCompartilhada;
import com.csi.ctfclient.tools.util.StringUtil;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import com.csi.ctfclient.tools.util.logger.CTFClientLogger;
import org.apache.log4j.Logger;

public abstract class MicAbstractSolicitacaoCartaoTEF
extends MicAbstractSolicitacaoTEF {
    public static final String ERRO_REJEITADO_AUTORIZADORA = "ERRO_REJEITADO_AUTORIZADORA";
    public static final String ERRO_TRANS_JA_EFETUADA = "ERRO_TRANS_JA_EFETUADA";
    public static final String ERRO_NAO_AUT_CARTAO = "ERRO_NAO_AUT_CARTAO";
    public static final String CREDITO_REFERIDO = "CREDITO_REFERIDO";
    private Logger logger = CTFClientLogger.getCTFClient();

    protected void initEntradaApiTefC(EntradaApiTefC entradaApiTefC, Process dados) throws ExcecaoApiAc {
        IDadoPin dadosPin;
        PinInfo pinInfo;
        IDadoCartao dadosCartao;
        ICodigoSeguranca dadosCodigoSeguranca;
        CodigoSeguranca codigoSeguranca;
        super.initEntradaApiTefC(entradaApiTefC, dados);
        ControladorBaixaTecnica conBaixaTecnica = ControladorBaixaTecnica.getInstance();
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        Cartao cartao = null;
        EntradaCTFClientCtrl entradaIntegracao = null;
        boolean connectedPin = false;
        boolean delivery = false;
        if (dados instanceof IIntegracao) {
            IIntegracao dadosIntegracao = (IIntegracao)((Object)dados);
            entradaIntegracao = dadosIntegracao.getEntradaIntegracao();
        }
        if (entradaIntegracao != null) {
            delivery = entradaIntegracao.getCodigoOrigemTransacao() == 1;
        } else if (dados instanceof IOrigemTransacao) {
            IOrigemTransacao origemTransacao = (IOrigemTransacao)((Object)dados);
            boolean bl = delivery = origemTransacao.getCodigoOrigemTransacao() == 1;
        }
        if (dados instanceof ICodigoSeguranca && (codigoSeguranca = (dadosCodigoSeguranca = (ICodigoSeguranca)((Object)dados)).getCodigoSeguranca()) != null) {
            entradaApiTefC.setCvv2(codigoSeguranca.getCodigo());
            this.logger.debug((Object)"initEntradaApiTefC:c\u00f3digo seguran\u00e7a=***");
            if (codigoSeguranca.getCodigo().length() == 0) {
                if (codigoSeguranca.getMotivo() == 0) {
                    entradaApiTefC.setMotivoCVV2('2');
                    this.logger.debug((Object)"initEntradaApiTefC:motivo do c\u00f3digo de seguran\u00e7a=2");
                } else {
                    entradaApiTefC.setMotivoCVV2('9');
                    this.logger.debug((Object)"initEntradaApiTefC:motivo do c\u00f3digo de seguran\u00e7a=9");
                }
            } else {
                entradaApiTefC.setCvv2(codigoSeguranca.getCodigo());
                this.logger.debug((Object)"initEntradaApiTefC:c\u00f3digo seguran\u00e7a=***");
            }
        }
        if (dados instanceof IDadoCartao && (cartao = (dadosCartao = (IDadoCartao)((Object)dados)).getCartao()) != null) {
            if (!(cartao instanceof CartaoDigitado)) {
                AbstractCartao abstractCartao = (AbstractCartao)cartao;
                if (abstractCartao.getNomePortador() != null && !abstractCartao.getNomePortador().equals("")) {
                    entradaApiTefC.setNomeCliente(abstractCartao.getNomePortador());
                    this.logger.debug((Object)"initEntradaApiTefC:nome do cliente=******");
                }
                entradaApiTefC.setStatusChip(abstractCartao.getStatusUltimaLeitura());
                this.logger.debug((Object)("initEntradaApiTefC:status da \u00faltima leitura=" + abstractCartao.getStatusUltimaLeitura()));
                entradaApiTefC.setTipoCartao(abstractCartao.getTipoCartao());
                this.logger.debug((Object)("initEntradaApiTefC:tipo do cart\u00e3o=" + abstractCartao.getTipoCartao()));
                entradaApiTefC.setIssuerCountryCode(abstractCartao.getIssuerCountry());
                this.logger.debug((Object)("initEntradaApiTefC:issuer country code=" + abstractCartao.getIssuerCountry()));
                entradaApiTefC.setWFlags(abstractCartao.getFlags());
                this.logger.debug((Object)"initEntradaApiTefC:wflags=******");
                if (abstractCartao.getTrilha1() != null) {
                    entradaApiTefC.setTrilha1(abstractCartao.getTrilha1());
                    this.logger.debug((Object)"initEntradaApiTefC:trilha 1=*****");
                }
                if (abstractCartao.getTrilha2() != null) {
                    entradaApiTefC.setInfo(abstractCartao.getTrilha2());
                    this.logger.debug((Object)"initEntradaApiTefC:info (trilha 2)=*****");
                }
                if (abstractCartao.getTrilha1Criptografado() != null) {
                    entradaApiTefC.setTrilha1Criptografada(abstractCartao.getTrilha1Criptografado());
                    this.logger.debug((Object)"initEntradaApiTefC:trilha 1 criptografada=*****");
                }
                if (abstractCartao.getTrilha2Criptografado() != null) {
                    entradaApiTefC.setTrilha2Criptografada(abstractCartao.getTrilha2Criptografado());
                    this.logger.debug((Object)"initEntradaApiTefC:trilha 2 criptografada=******");
                }
                StringUtil.completaString("", abstractCartao.getNumero().length(), '*', 3);
                entradaApiTefC.setPAN(abstractCartao.getNumero());
                if (abstractCartao.getNumeroCriptografado() != null) {
                    entradaApiTefC.setCartaoCriptografado(abstractCartao.getNumeroCriptografado());
                }
            }
            if (cartao instanceof CartaoMagnetico) {
                entradaApiTefC.setModoEntrada(2);
                this.logger.debug((Object)"initEntradaApiTefC:modo de entrada=2");
            } else if (cartao instanceof CartaoChip) {
                CartaoChip cartaoChip = (CartaoChip)cartao;
                entradaApiTefC.setModoEntrada(5);
                this.logger.debug((Object)"initEntradaApiTefC:modo de entrada=5");
                entradaApiTefC.setNumeroAplicacao(cartaoChip.getNumero());
                this.logger.debug((Object)"initEntradaApiTefC:n\u00famero da aplica\u00e7\u00e3o=*****");
                entradaApiTefC.setIndiceAid(cartaoChip.getIndiceRegistroAID());
                this.logger.debug((Object)"initEntradaApiTefC:indice de registro AID=****");
                entradaApiTefC.setCodigoRedeAdquirenteChip(cartaoChip.getTipoRedeAdquirente());
                this.logger.debug((Object)("initEntradaApiTefC:tipo rede adquirente=" + cartaoChip.getTipoRedeAdquirente()));
                entradaApiTefC.setCardSequenceNumber(cartaoChip.getPanSequenceNumber());
                this.logger.debug((Object)"initEntradaApiTefC:pan seuquence number=*****");
                entradaApiTefC.setTipoAplicacaoChip(cartaoChip.getTipoAplicacao());
                this.logger.debug((Object)("initEntradaApiTefC:tipo de aplica\u00e7\u00e3o=" + cartaoChip.getTipoAplicacao()));
                entradaApiTefC.setApplicationExpirationDate(cartaoChip.getApplicationExpirationDate());
                this.logger.debug((Object)("initEntradaApiTefC:Application Expiration Date=" + cartaoChip.getApplicationExpirationDate()));
            } else if (cartao instanceof CartaoDigitado) {
                CartaoDigitado cartaoDigitado = (CartaoDigitado)cartao;
                entradaApiTefC.setModoEntrada(1);
                this.logger.debug((Object)"initEntradaApiTefC:modo de entrada=1");
                entradaApiTefC.setInfo(cartaoDigitado.getNumero());
                this.logger.debug((Object)"initEntradaApiTefC:info=*****");
                if (cartaoDigitado.getNumeroCriptografado() != null) {
                    entradaApiTefC.setCartaoCriptografado(cartaoDigitado.getNumeroCriptografado());
                    this.logger.debug((Object)"initEntradaApiTefC:cart\u00e3o criptografado=*****");
                }
                if (cartaoDigitado.getVencimento() != null) {
                    entradaApiTefC.setDataVencimento(cartaoDigitado.getDateVencimento());
                    this.logger.debug((Object)"initEntradaApiTefC:data de vencimento do cart\u00e3o=****");
                }
                entradaApiTefC.setPAN(cartaoDigitado.getNumero());
                if (cartaoDigitado.getNumeroCriptografado() != null) {
                    entradaApiTefC.setCartaoCriptografado(cartaoDigitado.getNumeroCriptografado());
                }
                if (dados instanceof IOrigemTransacao) {
                    IOrigemTransacao origemTransacao = (IOrigemTransacao)((Object)dados);
                    entradaApiTefC.setIdentificacaoTransacao(origemTransacao.getCodigoOrigemTransacao());
                }
            }
        }
        if (dados instanceof IDadoPin && (pinInfo = (dadosPin = (IDadoPin)((Object)dados)).getPinInfo()) != null) {
            entradaApiTefC.setSenhaOfflineChip(pinInfo.isVerificadoOffline());
            this.logger.debug((Object)("initEntradaApiTefC:senha off-line chip=" + pinInfo.isVerificadoOffline()));
            entradaApiTefC.setAssinaturaChip(pinInfo.isRequerAssinatura());
            this.logger.debug((Object)("initEntradaApiTefC:assinatura chip=" + pinInfo.isRequerAssinatura()));
            entradaApiTefC.setChipBloqueadoOffline(pinInfo.isOfflineBloqueado());
            this.logger.debug((Object)("initEntradaApiTefC:off-line bloqueado=" + pinInfo.isOfflineBloqueado()));
            if (dados instanceof IFinishChip) {
                IFinishChip dadosFinishChip = (IFinishChip)((Object)dados);
                if (dadosFinishChip.getStatusComunicacaoHost() != null && dadosFinishChip.getStatusComunicacaoHost() == 1) {
                    String decisaoChip = StringUtil.completaString(pinInfo.getDecisaoFinishChip() + "", 1, ' ', 3);
                    entradaApiTefC.setDecisaoChip(decisaoChip.toCharArray()[0]);
                    this.logger.debug((Object)("initEntradaApiTefC:decisao chip:finishchip=" + decisaoChip.toCharArray()[0]));
                    entradaApiTefC.setStatusComunicacaoHost(dadosFinishChip.getStatusComunicacaoHost());
                    this.logger.debug((Object)("initEntradaApiTefC:status cominica\u00e7\u00e3o do host=" + dadosFinishChip.getStatusComunicacaoHost()));
                } else {
                    entradaApiTefC.setDecisaoChip(pinInfo.getDecisaoTomada());
                    this.logger.debug((Object)("initEntradaApiTefC:decisao chip:goonchip=" + pinInfo.getDecisaoTomada()));
                }
            }
            if (!(cartao instanceof CartaoChip) || cartao instanceof CartaoChip && pinInfo.isCapturadoVerificacaoOnline() || !ProtocoloBibliotecaCompartilhada.isBibliotecaEMV()) {
                entradaApiTefC.setSenha(pinInfo.getPinCriptografado());
                this.logger.debug((Object)"initEntradaApiTefC:pin criptografado=*****");
                if (dadosPin.getNumeroSerieChaveDUKPTSenha() != null) {
                    entradaApiTefC.setNumeroSerieChaveSenha(dadosPin.getNumeroSerieChaveDUKPTSenha());
                    this.logger.debug((Object)"initEntradaApiTefC:n\u00famero de serie da chave DUKPT=*****");
                }
            }
            if (dados instanceof IFinishChip && ((IFinishChip)((Object)dados)).getStatusComunicacaoHost() != null && ((IFinishChip)((Object)dados)).getStatusComunicacaoHost() == 1 && dados instanceof IEntradaApiTef) {
                EntradaApiTefC entradaFinishChip = ((IEntradaApiTef)((Object)dados)).getEntradaApiTef();
                entradaApiTefC.setDadosChip(entradaFinishChip.getDadosChip());
                this.logger.debug((Object)"initEntradaApiTefC:dados do campo 55 da FinishChip=*****");
            } else if (pinInfo.getDadosCampo55() != null) {
                entradaApiTefC.setDadosChip(pinInfo.getDadosCampo55());
                this.logger.debug((Object)"initEntradaApiTefC:dados do campo 55=*****");
            }
        }
        if (dados instanceof IPinpadError) {
            IPinpadError dadosPinpadError = (IPinpadError)((Object)dados);
            entradaApiTefC.setRetornoBibliotecaCompartilhada(dadosPinpadError.getLastErrorCode());
            this.logger.debug((Object)("initEntradaApiTefC:retorno bib. compartilhada=" + dadosPinpadError.getLastErrorCode()));
        }
        if (dados instanceof IDevices) {
            Process dadoDevices = dados;
            ControladorPerifericos perifericos = dadoDevices.getPerifericos();
            boolean bl = connectedPin = perifericos.getPin() != null;
            if (!delivery && connectedPin) {
                if (perifericos.getPin().isBibliotecaEMV()) {
                    IDadoGetInfo dadoGetInfo;
                    GetInfo getInfo;
                    if (dados instanceof IDadoGetInfo && (getInfo = (dadoGetInfo = (IDadoGetInfo)((Object)dados)).getDadosGetInfo()) != null) {
                        entradaApiTefC.setNumeroSeriePin(getInfo.getNumeroSerie());
                        this.logger.debug((Object)("initEntradaApiTefC:n\u00famero de serire do pin=" + getInfo.getNumeroSerie()));
                        entradaApiTefC.setRetornoGetInfo(getInfo.getCodigoRetorno());
                        this.logger.debug((Object)("initEntradaApiTefC:retornoGetInfo=" + getInfo.getCodigoRetorno()));
                        entradaApiTefC.setVersaoBibliotecaCompartilhada(getInfo.getVersaoBibliotecaCompartilhada());
                        this.logger.debug((Object)("initEntradaApiTefC:vers\u00e3o da bib. comparpartilhada=" + getInfo.getVersaoBibliotecaCompartilhada()));
                        entradaApiTefC.setVersaoEspecificacao(getInfo.getVersaoEspecificao());
                        this.logger.debug((Object)("initEntradaApiTefC:vers\u00e3o especifica\u00e7\u00e3o=" + getInfo.getVersaoEspecificao()));
                        entradaApiTefC.setVersaoAplicacaoBasica(getInfo.getVersaoAplicacao());
                        this.logger.debug((Object)("initEntradaApiTefC:vers\u00e3o aplica\u00e7\u00e3o b\u00e1sica=" + getInfo.getVersaoAplicacao()));
                        entradaApiTefC.setVersaoBibliotecaRedeEMV(getInfo.getVersaoBibRede4());
                        this.logger.debug((Object)("initEntradaApiTefC:vers\u00e3o bib. rede 4=" + getInfo.getVersaoBibRede4()));
                    }
                    if (conBaixaTecnica.isBaixaTecnicaSolicitada()) {
                        entradaApiTefC.setFlagBaixaTecnicaVisanet('1');
                        this.logger.debug((Object)"initEntradaApiTefC:flag baixa tecnica visanet=1");
                        entradaApiTefC.setDadosGeraisPin(conBaixaTecnica.montaDadosGeraisPin());
                        this.logger.debug((Object)"initEntradaApiTefC:dados gerais do pin=*****");
                        entradaApiTefC.setVersaoAc(ControladorConfCTFClient.getInstance().getConfig().getVersaoAC());
                        this.logger.debug((Object)("initEntradaApiTefC:vers\u00e3o AC=" + ControladorConfCTFClient.getInstance().getConfig().getVersaoAC()));
                        conBaixaTecnica.persisteBaixaTecnica();
                    }
                    entradaApiTefC.setDadosVisanetPin(conBaixaTecnica.montaDadosVisaNetPin());
                    this.logger.debug((Object)"initEntradaApiTefC:dados visanet pin=*****");
                    entradaApiTefC.setTipoPin("16");
                    this.logger.debug((Object)"initEntradaApiTefC:tipo pin=16");
                } else {
                    entradaApiTefC.setTipoPin("14");
                    this.logger.debug((Object)"initEntradaApiTefC:tipo pin=14");
                }
                perifericos.getPin().setMsgDisplay(inter.getMessage("ENVIO_TITLE"));
            } else {
                entradaApiTefC.setTipoPin("**");
                this.logger.debug((Object)"initEntradaApiTefC:tipo pin=**");
            }
        }
        if (dados instanceof IInformacoesAdicionais) {
            IInformacoesAdicionais dadosAdicionais = (IInformacoesAdicionais)((Object)dados);
            entradaApiTefC.setInformacoesAdicionais(dadosAdicionais.getListInformacoesAdicionais());
            this.logger.debug((Object)"initEntradaApiTefC:informa\u00e7\u00f5es adicionais=*****");
        }
        if (dados instanceof IConfirmacaoPositiva) {
            IConfirmacaoPositiva dadosConfPositiva = (IConfirmacaoPositiva)((Object)dados);
            entradaApiTefC.setConfirmacaoPositiva(dadosConfPositiva.getDadosConfirmacaoPositiva());
            this.logger.debug((Object)"initEntradaApiTefC:confirma\u00e7\u00e3o positiva=*****");
        }
        if (dados instanceof ISaidaApiTef) {
            IEntradaApiTef entradaApiTef;
            ISaidaApiTef dadosSaidaApiTef = (ISaidaApiTef)((Object)dados);
            SaidaApiTefC saidaApiTefC = dadosSaidaApiTef.getSaidaApiTef();
            entradaApiTefC.setIndiceMasterKey(saidaApiTefC.getIndiceMasterKey());
            this.logger.debug((Object)"initEntradaApiTefC:indice master key=*****");
            if (saidaApiTefC.isReenvioNegadaHost() && dados instanceof IEntradaApiTef && (entradaApiTef = (IEntradaApiTef)((Object)dados)).getEntradaApiTef() != null) {
                if (entradaApiTef.getEntradaApiTef().getDadosFinaisChip() != null) {
                    entradaApiTefC.setDadosFinaisChip(entradaApiTef.getEntradaApiTef().getDadosFinaisChip());
                }
                if (entradaApiTef.getEntradaApiTef().getIssuerScriptResult() != null) {
                    entradaApiTefC.setIssuerScriptResult(entradaApiTef.getEntradaApiTef().getIssuerScriptResult());
                }
            }
        }
    }

    protected String testaRetorno(SaidaApiTefC saidaApiTefC, Process dados) {
        String retorno = super.testaRetorno(saidaApiTefC, dados);
        if (saidaApiTefC != null && saidaApiTefC.getRetorno() != 0) {
            if (saidaApiTefC.getCodigoRespostaAutorizadora().equals("0ER")) {
                return ERRO_TRANS_JA_EFETUADA;
            }
            if (saidaApiTefC.getCodigoRespostaAutorizadora().equals("0F5")) {
                return ERRO_NAO_AUT_CARTAO;
            }
            if (saidaApiTefC.getCodigoRespostaAutorizadora().equals("077") && saidaApiTefC.isConfirnacaoPositiva()) {
                return CREDITO_REFERIDO;
            }
        }
        return retorno;
    }
}

